/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.mib.table.AlarmEntry;
import com.tridium.snmp.services.BSnmpRecipient;
import com.tridium.snmp.snmptypes.SnmpTrap;

public class AlarmTrap
extends SnmpTrap {
    public AlarmTrap(BSnmpNetwork bSnmpNetwork, AlarmEntry alarmEntry) {
        super(bSnmpNetwork, 6, 1);
        this.init(alarmEntry, bSnmpNetwork.getDefaultNetworkManagerSnmpVersion());
    }

    public AlarmTrap(BSnmpRecipient bSnmpRecipient, AlarmEntry alarmEntry) {
        super(bSnmpRecipient, 6, 1);
        this.init(alarmEntry, bSnmpRecipient.getNetworkManagerConfig().getNetworkManagerSnmpVersion());
    }

    private void init(AlarmEntry alarmEntry, int n) {
        if (n == 2) {
            this.addStringVariable("1.3.6.1.2.1.1.3.0", "" + this.snmp.getTimeTick());
            this.addStringVariable("1.3.6.1.6.3.1.1.4.1.0", "1.3.6.1.4.1.4131.1.8.1");
        }
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.1", alarmEntry.getTimestampString());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.2", alarmEntry.getUuid());
        this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.3", alarmEntry.getSourceState());
        this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.4", alarmEntry.getAckState());
        this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.5", alarmEntry.getAckRequired());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.6", alarmEntry.getSource());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.7", alarmEntry.getAlarmClass());
        this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.8", alarmEntry.getPriority());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.9", alarmEntry.getNormalTime());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.10", alarmEntry.getAckTime());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.11", alarmEntry.getUser());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.12", alarmEntry.getAlarmData());
        this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.13", alarmEntry.getAlarmTransition());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.14", alarmEntry.getLastUpdate());
    }

    public static void sendAlarmTrap(BSnmpNetwork bSnmpNetwork, AlarmEntry alarmEntry) {
        AlarmTrap alarmTrap = new AlarmTrap(bSnmpNetwork, alarmEntry);
        alarmTrap.send();
    }

    public static void sendAlarmTrap(BSnmpRecipient bSnmpRecipient, AlarmEntry alarmEntry) {
        AlarmTrap alarmTrap = new AlarmTrap(bSnmpRecipient, alarmEntry);
        alarmTrap.send();
    }
}

