/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.services;

import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.alarm.BTrapType;
import com.tridium.snmp.services.ComUtil;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import com.tridium.snmp.util.SnmpUtil;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;

public class SnmpReceiveTraps
implements Runnable {
    private boolean done = true;
    private BSnmpNetwork host;
    private DatagramSocket sock;
    private Thread myThread;

    public SnmpReceiveTraps(BSnmpNetwork bSnmpNetwork) {
        this.host = bSnmpNetwork;
    }

    public final void start() {
        try {
            this.sock = new DatagramSocket(this.host.getSnmpReceiveTrapsPort());
        }
        catch (Exception exception) {
            if (this.host != null) {
                this.host.getSnmpLog().error("SnmpReceiveTraps: unable to create socket on port " + this.host.getSnmpReceiveTrapsPort(), (Throwable)exception);
            }
            return;
        }
        if (this.host.getSnmpLog().isTraceOn()) {
            this.host.getSnmpLog().trace("*** Starting SnmpReceiveTraps Service");
        }
        this.done = false;
        this.myThread = new Thread((Runnable)this, "Snmp:RcvTraps");
        this.myThread.start();
    }

    public final void stop() {
        if (this.host.getSnmpLog().isTraceOn()) {
            this.host.getSnmpLog().trace("*** Stopping SnmpReceiveTraps Service");
        }
        this.done = true;
        if (this.sock != null) {
            this.sock.close();
        }
    }

    public void run() {
        if (this.host.getSnmpLog().isTraceOn()) {
            this.host.getSnmpLog().trace("SnmpReceiveTraps thread is running.");
        }
        DatagramPacket datagramPacket = new DatagramPacket(new byte[1500], 1500);
        while (!this.done) {
            datagramPacket.setLength(1500);
            SnmpPDU snmpPDU = ComUtil.receive(this.host, this.sock, datagramPacket);
            if (snmpPDU != null && snmpPDU.getVersion() > 2 || snmpPDU == null || snmpPDU.isFull()) continue;
            try {
                int n = snmpPDU.getCommand() & 0xFF;
                if (n == 164) {
                    this.processTrap(snmpPDU, 1);
                    continue;
                }
                if (n == 167) {
                    this.processTrap(snmpPDU, 2);
                    continue;
                }
                if (!this.host.getSnmpLog().isTraceOn()) continue;
                this.host.getSnmpLog().trace("Received Unprocessable SNMP trap (Command: " + snmpPDU.getCommand() + ")");
            }
            catch (Exception exception) {
                if (this.host == null || !this.host.getSnmpLog().isTraceOn()) continue;
                this.host.getSnmpLog().trace("Caught exception in SnmpReceiveTraps: ", (Throwable)exception);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processTrap(SnmpPDU snmpPDU, int n) {
        TrapData trapData = new TrapData();
        StringBuffer stringBuffer = new StringBuffer();
        SnmpVarBind[] snmpVarBindArray = snmpPDU.getVaribleBindingArray();
        BSnmpDevice bSnmpDevice = null;
        if (n == 1) {
            bSnmpDevice = this.host.findDevice(snmpPDU.getSourceIp());
            if (bSnmpDevice == null) return;
            BTrapType bTrapType = bSnmpDevice.getTraps().getTrapTypeByGenericSpecific(snmpPDU.getTrapEnterprise(), snmpPDU.getGenericTrapAsInt(), snmpPDU.getSpecificTrapAsInt());
            if (bTrapType != null) {
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV1") + " " + bSnmpDevice.getName() + "(" + snmpPDU.getSourceIp() + ")")));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.name")), (BObject)BString.make((String)ComUtil.insertLineFeeds(bTrapType.getTrapName())));
                stringBuffer.append(ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV1") + " " + bSnmpDevice.getName() + "(" + snmpPDU.getSourceIp() + "): ") + "\n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.name") + "= " + ComUtil.insertLineFeeds(bTrapType.getTrapName()) + "; \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.variables") + "= \n");
                String[] stringArray = bTrapType.getVariables();
                for (int i = 0; i < snmpVarBindArray.length; ++i) {
                    if (this.host.getSnmpLog().isTraceOn()) {
                        this.host.getSnmpLog().trace("trap var " + snmpVarBindArray[i].toString());
                    }
                    if (i > 0) {
                        stringBuffer.append(", \n");
                    }
                    SnmpOID snmpOID = snmpVarBindArray[i].getObjectID();
                    SnmpVar snmpVar = snmpVarBindArray[i].getVariable();
                    if (i < stringArray.length) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(ComUtil.insertLineFeeds("= " + snmpVar.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + snmpOID.toString() + ")"));
                        trapData.put(SnmpReceiveTraps.makeValidName(stringArray[i]), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpVar.toStringValue())));
                        continue;
                    }
                    stringBuffer.append(this.localizeText("rcvTraps.strings.variables") + "_" + i);
                    stringBuffer.append(ComUtil.insertLineFeeds("= " + snmpVar.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + snmpOID.toString() + ")"));
                    trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.variables") + "_" + i), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpVar.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + snmpOID.toString() + ")")));
                }
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.description")), (BObject)BString.make((String)ComUtil.insertLineFeeds(bTrapType.getDescription())));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.reference")), (BObject)BString.make((String)ComUtil.insertLineFeeds(bTrapType.getReference())));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.enterprise")), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpPDU.getTrapEnterprise())));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.agentAddr")), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpPDU.getAgentAddr())));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.generic")), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpPDU.getGenericTrap())));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.specific")), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpPDU.getSpecificTrap())));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.timestamp")), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpPDU.getTrapTimeStamp())));
                stringBuffer.append("; \n" + this.localizeText("rcvTraps.strings.description") + "= " + ComUtil.insertLineFeeds(bTrapType.getDescription()) + "; \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.reference") + "=" + ComUtil.insertLineFeeds(bTrapType.getReference()) + "; \n");
                stringBuffer.append("[" + this.localizeText("rcvTraps.strings.details") + "= \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.enterprise") + ": " + ComUtil.insertLineFeeds(snmpPDU.getTrapEnterprise()) + "; \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.agentAddr") + ": " + ComUtil.insertLineFeeds(snmpPDU.getAgentAddr()) + "; \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.generic") + ": " + ComUtil.insertLineFeeds(snmpPDU.getGenericTrap()) + "; \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.specific") + ": " + ComUtil.insertLineFeeds(snmpPDU.getSpecificTrap()) + "; \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.timestamp") + ": " + ComUtil.insertLineFeeds(snmpPDU.getTrapTimeStamp()) + "]");
            } else {
                if (bSnmpDevice.getTraps().getIgnoreUnrecognizedTraps()) {
                    return;
                }
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV1") + " " + bSnmpDevice.getName() + "(" + snmpPDU.getSourceIp() + ")")));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.enterprise")), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpPDU.getTrapEnterprise())));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.agentAddr")), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpPDU.getAgentAddr())));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.generic")), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpPDU.getGenericTrap())));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.specific")), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpPDU.getSpecificTrap())));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.timestamp")), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpPDU.getTrapTimeStamp())));
                stringBuffer.append(ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV1") + " " + bSnmpDevice.getName() + "(" + snmpPDU.getSourceIp() + "): ") + "\n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.details") + "= \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.enterprise") + ": " + ComUtil.insertLineFeeds(snmpPDU.getTrapEnterprise()) + "; \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.agentAddr") + ": " + ComUtil.insertLineFeeds(snmpPDU.getAgentAddr()) + "; \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.generic") + ": " + ComUtil.insertLineFeeds(snmpPDU.getGenericTrap()) + "; \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.specific") + ": " + ComUtil.insertLineFeeds(snmpPDU.getSpecificTrap()) + "; \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.timestamp") + ": " + ComUtil.insertLineFeeds(snmpPDU.getTrapTimeStamp()) + "; \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.varbinds") + ": \n");
                for (int i = 0; i < snmpVarBindArray.length; ++i) {
                    if (this.host.getSnmpLog().isTraceOn()) {
                        this.host.getSnmpLog().trace("trap var " + snmpVarBindArray[i].toString());
                    }
                    if (i > 0) {
                        stringBuffer.append(", \n");
                    }
                    SnmpOID snmpOID = snmpVarBindArray[i].getObjectID();
                    SnmpVar snmpVar = snmpVarBindArray[i].getVariable();
                    stringBuffer.append(this.localizeText("rcvTraps.strings.varbinds") + "_" + i);
                    stringBuffer.append(ComUtil.insertLineFeeds("= " + snmpVar.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + snmpOID.toString() + ")"));
                    trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.varbinds") + "_" + i), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpVar.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + snmpOID.toString() + ")")));
                }
            }
        } else {
            int n2;
            bSnmpDevice = this.host.findDevice(snmpPDU.getSourceIp());
            if (bSnmpDevice == null) return;
            BTrapType bTrapType = null;
            for (n2 = 0; n2 < snmpVarBindArray.length; ++n2) {
                if (!snmpVarBindArray[n2].getObjectID().equals(new SnmpOID("1.3.6.1.6.3.1.1.4.1.0")) || !(snmpVarBindArray[n2].getVariable() instanceof SnmpOID)) continue;
                bTrapType = bSnmpDevice.getTraps().getTrapTypeByOID((SnmpOID)snmpVarBindArray[n2].getVariable());
            }
            if (bTrapType != null) {
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV2") + " " + bSnmpDevice.getName() + "(" + snmpPDU.getSourceIp() + ")")));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.name")), (BObject)BString.make((String)ComUtil.insertLineFeeds(bTrapType.getTrapName() + "(" + SnmpUtil.longArrayToString(bTrapType.getOid()) + ")")));
                stringBuffer.append(ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV2") + " " + bSnmpDevice.getName() + "(" + snmpPDU.getSourceIp() + "): ") + "\n");
                stringBuffer.append(ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.name") + "= " + bTrapType.getTrapName() + "(" + SnmpUtil.longArrayToString(bTrapType.getOid()) + "); ") + "\n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.objects") + "= \n");
                String[] stringArray = bTrapType.getVariables();
                int n3 = 0;
                for (int i = 0; i < snmpVarBindArray.length; ++i) {
                    SnmpVar snmpVar;
                    SnmpOID snmpOID;
                    if (this.host.getSnmpLog().isTraceOn()) {
                        this.host.getSnmpLog().trace("trap var " + snmpVarBindArray[i].toString());
                    }
                    if (snmpVarBindArray[i].getObjectID().equals(new SnmpOID("1.3.6.1.6.3.1.1.4.1.0")) && snmpVarBindArray[i].getVariable() instanceof SnmpOID) continue;
                    if (i > 0) {
                        stringBuffer.append(", \n");
                    }
                    if (snmpVarBindArray[i].getObjectID().equals(new SnmpOID("1.3.6.1.2.1.1.3.0"))) {
                        snmpOID = snmpVarBindArray[i].getObjectID();
                        snmpVar = snmpVarBindArray[i].getVariable();
                        stringBuffer.append(ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.sysUpTime") + "= " + snmpVar.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + snmpOID.toString() + ")"));
                        trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.sysUpTime")), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpVar.toStringValue())));
                        ++n3;
                        continue;
                    }
                    snmpOID = snmpVarBindArray[i].getObjectID();
                    snmpVar = snmpVarBindArray[i].getVariable();
                    if (n3 < stringArray.length) {
                        stringBuffer.append(stringArray[n3]);
                        stringBuffer.append(ComUtil.insertLineFeeds("= " + snmpVar.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + snmpOID.toString() + ")"));
                        trapData.put(SnmpReceiveTraps.makeValidName(stringArray[++n3 - 1]), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpVar.toStringValue())));
                        continue;
                    }
                    stringBuffer.append(this.localizeText("rcvTraps.strings.objects") + "_" + i);
                    stringBuffer.append(ComUtil.insertLineFeeds("= " + snmpVar.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + snmpOID.toString() + ")"));
                    trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.objects") + "_" + i), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpVar.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + snmpOID.toString() + ")")));
                }
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.description")), (BObject)BString.make((String)ComUtil.insertLineFeeds(bTrapType.getDescription())));
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.reference")), (BObject)BString.make((String)ComUtil.insertLineFeeds(bTrapType.getReference())));
                stringBuffer.append("; \n" + this.localizeText("rcvTraps.strings.description") + "= " + ComUtil.insertLineFeeds(bTrapType.getDescription()) + "; \n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.reference") + "= " + ComUtil.insertLineFeeds(bTrapType.getReference()));
            } else {
                if (bSnmpDevice.getTraps().getIgnoreUnrecognizedTraps()) {
                    return;
                }
                trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV2") + " " + bSnmpDevice.getName() + "(" + snmpPDU.getSourceIp() + ")")));
                stringBuffer.append(ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV2") + " " + bSnmpDevice.getName() + "(" + snmpPDU.getSourceIp() + "): ") + "\n");
                stringBuffer.append(this.localizeText("rcvTraps.strings.objects") + "= \n");
                for (n2 = 0; n2 < snmpVarBindArray.length; ++n2) {
                    if (this.host.getSnmpLog().isTraceOn()) {
                        this.host.getSnmpLog().trace("trap var " + snmpVarBindArray[n2].toString());
                    }
                    if (n2 > 0) {
                        stringBuffer.append(", \n");
                    }
                    SnmpOID snmpOID = snmpVarBindArray[n2].getObjectID();
                    SnmpVar snmpVar = snmpVarBindArray[n2].getVariable();
                    stringBuffer.append(this.localizeText("rcvTraps.strings.objects") + "_" + n2);
                    stringBuffer.append(ComUtil.insertLineFeeds("= " + snmpVar.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + snmpOID.toString() + ")"));
                    trapData.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.objects") + "_" + n2), (BObject)BString.make((String)ComUtil.insertLineFeeds(snmpVar.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + snmpOID.toString() + ")")));
                }
            }
        }
        bSnmpDevice.getTraps().issueTrapAlert(BFacets.make((String[])trapData.getKeys(), (BIDataValue[])trapData.getValues()), stringBuffer.toString());
    }

    private static String makeValidName(String string) {
        if (!SlotPath.isValidName((String)string)) {
            string = SlotPath.escape((String)string);
        }
        return string;
    }

    public DatagramSocket getSocket() {
        return this.sock;
    }

    private String localizeText(String string) {
        return this.host.getLexicon().getText(string);
    }

    private class TrapData {
        private String[] keys = null;
        private BIDataValue[] values = null;

        public void put(String string, BObject bObject) {
            int n = 0;
            if (this.keys == null || this.values == null) {
                this.keys = new String[1];
                this.values = new BIDataValue[1];
                this.keys[n] = string;
                this.values[n] = (BIDataValue)bObject;
                return;
            }
            n = this.keys.length;
            String[] stringArray = new String[n + 1];
            System.arraycopy(this.keys, 0, stringArray, 0, n);
            stringArray[n] = string;
            this.keys = stringArray;
            BIDataValue[] bIDataValueArray = new BIDataValue[n + 1];
            System.arraycopy(this.values, 0, bIDataValueArray, 0, n);
            bIDataValueArray[n] = (BIDataValue)bObject;
            this.values = bIDataValueArray;
        }

        public String[] getKeys() {
            return this.keys;
        }

        public BIDataValue[] getValues() {
            return this.values;
        }
    }
}

