/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.services;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.services.ComUtil;
import com.tridium.snmp.snmptypes.SnmpPDU;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class SnmpDriver {
    protected DatagramSocket sock = null;
    private ResponseReceive rec;
    private Thread recThread;
    private BSnmpNetwork snmp;

    public SnmpDriver(BSnmpNetwork bSnmpNetwork) {
        this.snmp = bSnmpNetwork;
    }

    public void start() {
        try {
            this.sock = new DatagramSocket();
            this.rec = new ResponseReceive();
            this.recThread = new Thread((Runnable)this.rec, "Snmp:SchedulerRcv");
            this.recThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.rec != null) {
            this.rec.done = true;
            if (this.sock != null) {
                this.sock.close();
            }
            if (this.recThread != null) {
                this.recThread.interrupt();
            }
        }
    }

    public synchronized SnmpPDU sendRequest(SnmpPDU snmpPDU, int n, int n2) {
        SnmpPDU snmpPDU2 = null;
        for (int i = 0; i <= n2; ++i) {
            this.rec.reset(snmpPDU.getReqid());
            ComUtil.send(this.snmp, snmpPDU, this.sock);
            snmpPDU2 = this.rec.getResponse(n);
            if (snmpPDU2 == null) continue;
            return snmpPDU2;
        }
        return null;
    }

    public synchronized void send(SnmpPDU snmpPDU) {
        ComUtil.send(this.snmp, snmpPDU, this.sock);
    }

    private class ResponseReceive
    implements Runnable {
        boolean done = false;
        SnmpPDU msg = null;
        Object sync = new Object();
        int reqId;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] byArray = new byte[1500];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            while (!this.done) {
                if (SnmpDriver.this.sock == null) {
                    try {
                        SnmpDriver.this.sock = new DatagramSocket();
                    }
                    catch (Exception exception) {
                        if (SnmpDriver.this.snmp == null || !SnmpDriver.this.snmp.getSnmpLog().isTraceOn()) continue;
                        SnmpDriver.this.snmp.getSnmpLog().trace("SnmpDriver could not initialize socket connection");
                        continue;
                    }
                }
                datagramPacket.setLength(byArray.length);
                SnmpPDU snmpPDU = ComUtil.receive(SnmpDriver.this.snmp, SnmpDriver.this.sock, datagramPacket);
                if (snmpPDU == null) {
                    if (this.done) {
                        return;
                    }
                    if (SnmpDriver.this.snmp.getSnmpLog().isTraceOn()) {
                        SnmpDriver.this.snmp.getSnmpLog().trace("SnmpDriver reinitializing socket connection");
                    }
                    try {
                        if (SnmpDriver.this.sock != null) {
                            SnmpDriver.this.sock.close();
                        }
                        SnmpDriver.this.sock = new DatagramSocket();
                    }
                    catch (Exception exception) {
                        if (SnmpDriver.this.snmp == null || !SnmpDriver.this.snmp.getSnmpLog().isTraceOn()) continue;
                        SnmpDriver.this.snmp.getSnmpLog().trace("SnmpDriver could not reinitialize socket connection");
                    }
                    continue;
                }
                if (snmpPDU.getCommand() != 162) continue;
                Object object = this.sync;
                synchronized (object) {
                    if (snmpPDU.getReqid() == this.reqId) {
                        this.msg = snmpPDU;
                        this.sync.notify();
                    }
                }
            }
        }

        public void reset(int n) {
            this.reqId = n;
            this.msg = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SnmpPDU getResponse(int n) {
            Object object = this.sync;
            synchronized (object) {
                if (this.msg == null) {
                    try {
                        this.sync.wait(n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return this.msg;
        }
    }
}

