/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib.table;

import com.tridium.snmp.mib.table.TableEntry;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.sys.BObject;

public class AlarmEntry
implements TableEntry {
    int lastHash = -1;
    private static final int REQUIRED = 1;
    private static final int NOT_REQUIRED = 0;
    int index = 1;
    BAlarmRecord alarmRecord;

    public AlarmEntry(BAlarmRecord bAlarmRecord, int n) {
        this.index = n;
        this.alarmRecord = bAlarmRecord;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public String getPointName() {
        return "";
    }

    public int getLastHash() {
        return this.lastHash;
    }

    public void setLastHash(int n) {
        this.lastHash = n;
    }

    public boolean isAcked() {
        return this.alarmRecord.isAcknowledged();
    }

    public BAlarmRecord getAlarmRecord() {
        return this.alarmRecord;
    }

    public String getAlarmData() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = this.alarmRecord.getAlarmData().list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append("; ");
                }
                BObject bObject = this.alarmRecord.getAlarmData().getFacet(stringArray[i]);
                stringBuffer.append(stringArray[i]).append('=').append(bObject.toString());
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public long getTimestamp() {
        try {
            return this.alarmRecord.getTimestamp().getMillis();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public String getTimestampString() {
        try {
            return this.alarmRecord.getTimestamp().toString(null);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getSource() {
        try {
            return this.alarmRecord.getSource().toArray()[0].toString(null);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getSourceState() {
        return this.alarmRecord.getSourceState().getOrdinal();
    }

    public int getAckState() {
        return this.alarmRecord.getAckState().getOrdinal();
    }

    public String getUuid() {
        try {
            return this.alarmRecord.getUuid().encodeToString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getAlarmClass() {
        try {
            return this.alarmRecord.getAlarmClass();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getPriority() {
        return this.alarmRecord.getPriority();
    }

    public String getAckTime() {
        try {
            return this.alarmRecord.getAckTime().toString(null);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getNormalTime() {
        try {
            return this.alarmRecord.getNormalTime().toString(null);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getUser() {
        try {
            return this.alarmRecord.getUser();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getAckRequired() {
        return this.alarmRecord.getAckRequired() ? 1 : 0;
    }

    public int getAlarmTransition() {
        return this.alarmRecord.getAlarmTransition().getOrdinal();
    }

    public int getAlarmId() {
        return this.getIndex();
    }

    public String getLastUpdate() {
        try {
            return this.alarmRecord.getLastUpdate().toString(null);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String toString() {
        return "Index = " + this.index + ", Alarm = " + this.alarmRecord;
    }
}

