/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.mib.MibObject;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpNull;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;

public class TridiumStation
implements MibObject,
SnmpConst {
    private BSnmpNetwork snmp;
    public static final int LEVEL = 8;
    public static final int VERSION = 1;
    public static final int ACTION = 2;
    public static final int ALARM_TABLE = 3;
    public static final int INPUT = 4;
    public static final int NO_ACTION = 0;
    public static final int ACK_ALL = 1;
    static /* synthetic */ Class class$com$tridium$snmp$BSnmpNetwork;

    public TridiumStation(BSnmpNetwork bSnmpNetwork) {
        this.snmp = bSnmpNetwork;
    }

    public SnmpVar getValue(SnmpOID snmpOID) {
        long[] lArray = snmpOID.toLongArray();
        switch ((int)lArray[8]) {
            case 1: {
                BModule bModule = Sys.getBajaModule();
                BModule bModule2 = Sys.getModuleForClass((Class)(class$com$tridium$snmp$BSnmpNetwork == null ? (class$com$tridium$snmp$BSnmpNetwork = TridiumStation.class$("com.tridium.snmp.BSnmpNetwork")) : class$com$tridium$snmp$BSnmpNetwork));
                String string = bModule.getModuleName() + " [" + bModule.getVendor() + " " + bModule.getVendorVersion() + "]; " + bModule2.getModuleName() + " [" + bModule2.getVendor() + " " + bModule2.getVendorVersion() + "]";
                return new SnmpString(string);
            }
            case 2: {
                return new SnmpInt(0);
            }
        }
        return new SnmpNull();
    }

    public SnmpOID getNextOid(SnmpOID snmpOID) {
        long[] lArray = snmpOID.toLongArray();
        if (lArray.length <= 9) {
            return new SnmpOID("1.3.6.1.4.1.4131.1.1.0.0");
        }
        switch ((int)lArray[8]) {
            case 1: 
            case 2: {
                lArray[8] = lArray[8] + 1L;
                break;
            }
            default: {
                return null;
            }
        }
        return new SnmpOID(lArray);
    }

    public int validateForSet(SnmpVarBind snmpVarBind) {
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        long[] lArray = snmpOID.toLongArray();
        if (lArray.length <= 8) {
            return 6;
        }
        switch ((int)lArray[8]) {
            case 2: {
                try {
                    ((SnmpInt)snmpVarBind.getVariable()).intValue();
                    break;
                }
                catch (Exception exception) {
                    return 7;
                }
            }
            default: {
                return 6;
            }
        }
        return 0;
    }

    public int setValue(SnmpVarBind snmpVarBind, SnmpPDU snmpPDU) {
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        long[] lArray = snmpOID.toLongArray();
        switch ((int)lArray[8]) {
            case 2: {
                int n;
                try {
                    n = ((SnmpInt)snmpVarBind.getVariable()).intValue();
                }
                catch (Exception exception) {
                    return 3;
                }
                switch (n) {
                    case 1: {
                        this.snmp.alarms().acknowledgeAll();
                    }
                }
                snmpPDU.addVariableBinding(new SnmpVarBind(snmpOID, new SnmpInt(n)));
                break;
            }
            default: {
                return 2;
            }
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

