/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.enums.BSnmpAccessEnum;
import com.tridium.snmp.enums.BSnmpMipEntryTypeEnum;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.mib.MibConst;
import com.tridium.snmp.mib.MibIISystem;
import com.tridium.snmp.mib.MibObject;
import com.tridium.snmp.mib.OidElement;
import com.tridium.snmp.mib.OidEntry;
import com.tridium.snmp.util.SnmpUtil;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BEnumRange;
import javax.baja.util.Array;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpNotificationType;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpTrapType;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.type.SizeConstraint;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.type.ValueRangeConstraint;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class OidUtil
implements MibConst {
    static /* synthetic */ Class class$net$percederberg$mibble$MibValueSymbol;

    public static OidElement createOidEntries(Mib mib, BSnmpNetwork bSnmpNetwork) {
        OidElement oidElement = new OidElement(1L);
        Object[] objectArray = mib.getAllSymbols().toArray();
        Array array = new Array(class$net$percederberg$mibble$MibValueSymbol == null ? (class$net$percederberg$mibble$MibValueSymbol = OidUtil.class$("net.percederberg.mibble.MibValueSymbol")) : class$net$percederberg$mibble$MibValueSymbol);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof MibValueSymbol)) continue;
            MibValueSymbol mibValueSymbol = (MibValueSymbol)objectArray[i];
            array.add((Object)mibValueSymbol);
        }
        MibValueSymbol[] mibValueSymbolArray = (MibValueSymbol[])array.trim();
        OidUtil.createOidEntries(mibValueSymbolArray, oidElement, bSnmpNetwork, false);
        OidUtil.createTrapTypes(mib, oidElement, bSnmpNetwork);
        return oidElement;
    }

    public static void createOidEntries(MibValueSymbol[] mibValueSymbolArray, OidElement oidElement, BSnmpNetwork bSnmpNetwork, boolean bl) {
        if (mibValueSymbolArray == null) {
            return;
        }
        for (int i = 0; i < mibValueSymbolArray.length; ++i) {
            MibValueSymbol mibValueSymbol = mibValueSymbolArray[i];
            if (mibValueSymbol == null) continue;
            MibType mibType = mibValueSymbol.getType();
            boolean bl2 = false;
            if (mibType instanceof SnmpObjectType) {
                SnmpObjectType snmpObjectType = (SnmpObjectType)mibType;
                MibType mibType2 = snmpObjectType.getSyntax();
                BSnmpMipEntryTypeEnum bSnmpMipEntryTypeEnum = BSnmpMipEntryTypeEnum.nonsequence;
                if (bl) {
                    bSnmpMipEntryTypeEnum = BSnmpMipEntryTypeEnum.sequenceElement;
                } else if (mibType2 instanceof SequenceOfType) {
                    bSnmpMipEntryTypeEnum = BSnmpMipEntryTypeEnum.sequence;
                } else if (mibType2 instanceof SequenceType) {
                    bSnmpMipEntryTypeEnum = BSnmpMipEntryTypeEnum.sequenceEntry;
                    bl2 = true;
                }
                OidUtil.createOidEntry(mibValueSymbol, snmpObjectType, bSnmpMipEntryTypeEnum, oidElement, bSnmpNetwork);
            } else if (mibType instanceof SnmpNotificationType) {
                OidUtil.createOidEntry(mibValueSymbol, (SnmpType)mibType, BSnmpMipEntryTypeEnum.notification, oidElement, bSnmpNetwork);
            }
            OidUtil.createOidEntries(mibValueSymbol.getChildren(), oidElement, bSnmpNetwork, bl2);
        }
    }

    private static void createTrapTypes(Mib mib, OidElement oidElement, BSnmpNetwork bSnmpNetwork) {
        Object[] objectArray = mib.getAllSymbols().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            MibValueSymbol mibValueSymbol;
            if (!(objectArray[i] instanceof MibValueSymbol) || !((mibValueSymbol = (MibValueSymbol)objectArray[i]).getType() instanceof SnmpTrapType)) continue;
            OidUtil.createOidEntry(mibValueSymbol, (SnmpType)mibValueSymbol.getType(), BSnmpMipEntryTypeEnum.trap, oidElement, bSnmpNetwork);
        }
    }

    private static void createOidEntry(MibValueSymbol mibValueSymbol, SnmpType snmpType, BSnmpMipEntryTypeEnum bSnmpMipEntryTypeEnum, OidElement oidElement, BSnmpNetwork bSnmpNetwork) {
        Object object;
        Object object2;
        String string = mibValueSymbol.getValue().toString();
        String string2 = mibValueSymbol.getName();
        String string3 = " ";
        String string4 = " ";
        String string5 = " ";
        BSnmpAccessEnum bSnmpAccessEnum = BSnmpAccessEnum.notAccessible;
        BSnmpVariableTypeEnum bSnmpVariableTypeEnum = null;
        if (snmpType instanceof SnmpObjectType) {
            object2 = (SnmpObjectType)snmpType;
            object = ((SnmpObjectType)object2).getStatus();
            if (object != null) {
                string3 = ((SnmpStatus)object).toString();
            }
            string5 = OidUtil.getSyntax(((SnmpObjectType)object2).getSyntax());
            string4 = snmpType.getDescription();
            bSnmpAccessEnum = OidUtil.getAccess(((SnmpObjectType)object2).getAccess());
            MibTypeTag mibTypeTag = ((SnmpObjectType)object2).getSyntax().getTag();
            if (mibTypeTag != null) {
                try {
                    bSnmpVariableTypeEnum = BSnmpVariableTypeEnum.getVariableTypeFromTag(mibTypeTag);
                }
                catch (Throwable throwable) {}
            }
        } else if (snmpType instanceof SnmpNotificationType) {
            object2 = (SnmpNotificationType)snmpType;
            object = ((SnmpNotificationType)object2).getStatus();
            if (object != null) {
                string3 = ((SnmpStatus)object).toString();
            }
            string5 = "notification-type";
            string4 = OidUtil.getNotificationDesc(mibValueSymbol, (SnmpNotificationType)object2);
        } else if (snmpType instanceof SnmpTrapType) {
            object2 = (SnmpTrapType)snmpType;
            string4 = OidUtil.getTrapDesc(mibValueSymbol, (SnmpTrapType)object2);
            string = ((SnmpTrapType)object2).getEnterprise().toString() + "." + string;
            string5 = "trap-type";
        } else {
            return;
        }
        object2 = new MibIISystem(bSnmpNetwork);
        if (mibValueSymbol.isScalar()) {
            string = string + ".0";
        }
        object = SnmpUtil.getLongArray(string);
        Object object3 = object[((Object)object).length - 1];
        OidEntry oidEntry = new OidEntry(string, 1, string2, string3, string4, (MibObject)object2, (long)object3, bSnmpAccessEnum, string5, bSnmpMipEntryTypeEnum, bSnmpVariableTypeEnum);
        if (snmpType instanceof SnmpObjectType) {
            OidUtil.getConstraints(((SnmpObjectType)snmpType).getSyntax(), oidEntry);
        }
        OidElement oidElement2 = oidElement;
        for (int i = 0; i < ((Object)object).length - 1; ++i) {
            OidElement oidElement3 = oidElement2.getChild((long)object[i]);
            if (oidElement3 == null) {
                oidElement3 = new OidElement((long)object[i]);
                oidElement2.addChild(oidElement3);
            }
            oidElement2 = oidElement3;
        }
        oidElement2.addChild(oidEntry);
    }

    public static BSnmpAccessEnum getAccess(SnmpAccess snmpAccess) {
        if (snmpAccess == SnmpAccess.READ_ONLY) {
            return BSnmpAccessEnum.readOnly;
        }
        if (snmpAccess == SnmpAccess.READ_WRITE) {
            return BSnmpAccessEnum.readWrite;
        }
        if (snmpAccess == SnmpAccess.NOT_ACCESSIBLE) {
            return BSnmpAccessEnum.notAccessible;
        }
        if (snmpAccess == SnmpAccess.WRITE_ONLY) {
            return BSnmpAccessEnum.writeOnly;
        }
        if (snmpAccess == SnmpAccess.READ_CREATE) {
            return BSnmpAccessEnum.readCreate;
        }
        return BSnmpAccessEnum.notAccessible;
    }

    private static String getSyntax(MibType mibType) {
        if (mibType.isPrimitive()) {
            return mibType.getName();
        }
        return mibType.getReferenceSymbol().getName();
    }

    private static String getNotificationDesc(MibValueSymbol mibValueSymbol, SnmpNotificationType snmpNotificationType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GENERIC=6");
        stringBuffer.append("; SPECIFIC=").append(((ObjectIdentifierValue)mibValueSymbol.getValue()).getValue());
        Object[] objectArray = snmpNotificationType.getObjects().toArray();
        stringBuffer.append("; OBJECTS=");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(((MibValue)objectArray[i]).getName());
        }
        stringBuffer.append("; DESCRIPTION=").append(snmpNotificationType.getDescription());
        stringBuffer.append("; REFERENCE=").append(snmpNotificationType.getReference());
        return stringBuffer.toString();
    }

    private static String getTrapDesc(MibValueSymbol mibValueSymbol, SnmpTrapType snmpTrapType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GENERIC=6");
        stringBuffer.append("; SPECIFIC=").append(((Number)((NumberValue)mibValueSymbol.getValue()).toObject()).intValue());
        stringBuffer.append("; VARIABLES=");
        Object[] objectArray = snmpTrapType.getVariables().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(((ObjectIdentifierValue)objectArray[i]).getName());
        }
        stringBuffer.append("; DESCRIPTION=").append(snmpTrapType.getDescription());
        stringBuffer.append("; REFERENCE=").append(snmpTrapType.getReference());
        return stringBuffer.toString();
    }

    private static void getConstraints(MibType mibType, OidEntry oidEntry) {
        if (mibType instanceof IntegerType) {
            IntegerType integerType = (IntegerType)mibType;
            if (integerType.hasSymbols()) {
                oidEntry.enumRange = OidUtil.getEnumRange(integerType);
            }
            if (!integerType.hasConstraint()) {
                return;
            }
            Constraint constraint = integerType.getConstraint();
            if (constraint instanceof ValueRangeConstraint) {
                oidEntry.range = OidUtil.getRange((ValueRangeConstraint)constraint);
            }
        } else if (mibType instanceof StringType) {
            StringType stringType = (StringType)mibType;
            if (!stringType.hasConstraint()) {
                return;
            }
            SizeConstraint sizeConstraint = (SizeConstraint)stringType.getConstraint();
            Constraint constraint = (Constraint)sizeConstraint.getValues().toArray()[0];
            if (constraint instanceof ValueRangeConstraint) {
                oidEntry.size = OidUtil.getRange((ValueRangeConstraint)constraint);
            }
            if (constraint instanceof ValueConstraint) {
                oidEntry.size = OidUtil.getRange((ValueConstraint)constraint);
            }
        }
    }

    public static BEnumRange getEnumRange(IntegerType integerType) {
        if (!integerType.hasSymbols()) {
            return null;
        }
        MibValueSymbol[] mibValueSymbolArray = integerType.getAllSymbols();
        int[] nArray = new int[mibValueSymbolArray.length];
        String[] stringArray = new String[mibValueSymbolArray.length];
        for (int i = 0; i < mibValueSymbolArray.length; ++i) {
            NumberValue numberValue = (NumberValue)mibValueSymbolArray[i].getValue();
            nArray[i] = ((Number)numberValue.toObject()).intValue();
            stringArray[i] = SlotPath.escape((String)mibValueSymbolArray[i].getName());
        }
        return BEnumRange.make((int[])nArray, (String[])stringArray);
    }

    private static OidEntry.Range getRange(ValueRangeConstraint valueRangeConstraint) {
        OidEntry.Range range = new OidEntry.Range();
        range.min = ((Number)valueRangeConstraint.getLowerBound().toObject()).doubleValue();
        range.max = ((Number)valueRangeConstraint.getUpperBound().toObject()).doubleValue();
        return range;
    }

    private static OidEntry.Range getRange(ValueConstraint valueConstraint) {
        OidEntry.Range range = new OidEntry.Range();
        range.min = 0.0;
        range.max = ((Number)valueConstraint.getValue().toObject()).intValue();
        return range;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

