/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.mib.MibTable;
import com.tridium.snmp.mib.table.PointContainer;
import com.tridium.snmp.mib.table.PointEntry;
import com.tridium.snmp.mib.table.TableEntry;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import com.tridium.snmp.util.SnmpUtil;

public class MibPointTable
extends MibTable
implements SnmpConst {
    public static final int INDEX = 1;
    public static final int NAME = 2;
    public static final int VALUE = 3;
    public static final int LAST_ID = 3;
    private String firstOid;
    private boolean input;
    private int level;
    PointContainer cntr;

    public MibPointTable(PointContainer pointContainer, String string, boolean bl) {
        this.cntr = pointContainer;
        this.firstOid = string + ".1.1";
        this.input = bl;
        this.level = SnmpUtil.getLongArray(this.firstOid).length - 1;
    }

    public SnmpVar getValue(SnmpOID snmpOID) {
        long[] lArray = snmpOID.toLongArray();
        PointEntry pointEntry = this.getEntry(lArray);
        if (pointEntry == null) {
            return null;
        }
        SnmpVar snmpVar = null;
        try {
            switch ((int)lArray[this.level]) {
                case 1: {
                    snmpVar = new SnmpInt(pointEntry.getIndex());
                    break;
                }
                case 2: {
                    snmpVar = new SnmpString(pointEntry.getPointName());
                    break;
                }
                case 3: {
                    snmpVar = pointEntry.getValue();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return snmpVar;
    }

    private PointEntry getEntry(long[] lArray) {
        if (lArray.length <= this.level + 1) {
            return null;
        }
        return (PointEntry)this.cntr.getTable(this.input).getObject((int)lArray[this.level + 1]);
    }

    public int validateForSet(SnmpVarBind snmpVarBind) {
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        long[] lArray = snmpOID.toLongArray();
        switch ((int)lArray[this.level]) {
            case 1: 
            case 2: {
                return 17;
            }
            case 3: {
                PointEntry pointEntry = this.getEntry(lArray);
                if (pointEntry == null) {
                    return 6;
                }
                if (!pointEntry.isSettablePoint()) {
                    return 17;
                }
                try {
                    pointEntry.tryDecodeForSet(snmpVarBind.getVariable());
                    break;
                }
                catch (Throwable throwable) {
                    return 7;
                }
            }
            default: {
                return 6;
            }
        }
        return 0;
    }

    public int setValue(SnmpVarBind snmpVarBind, SnmpPDU snmpPDU) {
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        long[] lArray = snmpOID.toLongArray();
        switch ((int)lArray[this.level]) {
            case 1: 
            case 2: {
                return 4;
            }
            case 3: {
                PointEntry pointEntry = this.getEntry(lArray);
                if (pointEntry == null) {
                    return 2;
                }
                if (!pointEntry.isSettablePoint()) {
                    return 4;
                }
                SnmpVar snmpVar = pointEntry.setValue(snmpVarBind.getVariable());
                if (snmpVar == null) {
                    return 3;
                }
                snmpPDU.addVariableBinding(new SnmpVarBind(snmpOID, snmpVar));
                break;
            }
            default: {
                return 2;
            }
        }
        return 0;
    }

    public int getObjectLevel() {
        return this.level;
    }

    public int getLastId() {
        return 3;
    }

    public TableEntry getNextEntry(int n) {
        return this.cntr.getTable(this.input).getNextEntry(n);
    }

    public String getFirstOid() {
        return this.firstOid;
    }
}

