/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.mib.MibConst;
import com.tridium.snmp.mib.MibTable;
import com.tridium.snmp.mib.table.AlarmEntry;
import com.tridium.snmp.mib.table.TableEntry;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;

public class MibAlarmTable
extends MibTable
implements MibConst,
SnmpConst {
    public static final int LEVEL = 10;
    public static final int TIME_STAMP = 1;
    public static final int UUID = 2;
    public static final int SOURCE_STATE = 3;
    public static final int ACK_STATE = 4;
    public static final int ACK_REQUIRED = 5;
    public static final int SOURCE = 6;
    public static final int ALARM_CLASS = 7;
    public static final int PRIORITY = 8;
    public static final int NORMAL_TIME = 9;
    public static final int ACK_TIME = 10;
    public static final int USER = 11;
    public static final int ALARM_DATA = 12;
    public static final int ALARM_TRANSITION = 13;
    public static final int LAST_UPDATE = 14;
    public static final int ALARM_ID = 15;
    public static final int LAST_ID = 15;
    public static final int UNACKED = 1;
    public static final int ACKED = 0;
    public static final int ACK_PENDING = 2;
    private BSnmpNetwork snmp;

    public MibAlarmTable(BSnmpNetwork bSnmpNetwork) {
        this.snmp = bSnmpNetwork;
    }

    public SnmpVar getValue(SnmpOID snmpOID) {
        long[] lArray = snmpOID.toLongArray();
        AlarmEntry alarmEntry = this.getEntry(lArray);
        if (alarmEntry == null) {
            return null;
        }
        SnmpVar snmpVar = null;
        try {
            switch ((int)lArray[10]) {
                case 1: {
                    snmpVar = new SnmpString(alarmEntry.getTimestampString());
                    break;
                }
                case 2: {
                    snmpVar = new SnmpString(alarmEntry.getUuid());
                    break;
                }
                case 3: {
                    snmpVar = new SnmpInt(alarmEntry.getSourceState());
                    break;
                }
                case 4: {
                    snmpVar = new SnmpInt(alarmEntry.getAckState());
                    break;
                }
                case 5: {
                    snmpVar = new SnmpInt(alarmEntry.getAckRequired());
                    break;
                }
                case 6: {
                    snmpVar = new SnmpString(alarmEntry.getSource());
                    break;
                }
                case 7: {
                    snmpVar = new SnmpString(alarmEntry.getAlarmClass());
                    break;
                }
                case 8: {
                    snmpVar = new SnmpInt(alarmEntry.getPriority());
                    break;
                }
                case 9: {
                    snmpVar = new SnmpString(alarmEntry.getNormalTime());
                    break;
                }
                case 10: {
                    snmpVar = new SnmpString(alarmEntry.getAckTime());
                    break;
                }
                case 11: {
                    snmpVar = new SnmpString(alarmEntry.getUser());
                    break;
                }
                case 12: {
                    snmpVar = new SnmpString(alarmEntry.getAlarmData());
                    break;
                }
                case 13: {
                    snmpVar = new SnmpInt(alarmEntry.getAlarmTransition());
                    break;
                }
                case 14: {
                    snmpVar = new SnmpString(alarmEntry.getLastUpdate());
                    break;
                }
                case 15: {
                    snmpVar = new SnmpInt(alarmEntry.getAlarmId());
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return snmpVar;
    }

    private AlarmEntry getEntry(long[] lArray) {
        if (lArray.length <= 11) {
            return null;
        }
        return this.snmp.alarms().getAlarm((int)lArray[11]);
    }

    public int validateForSet(SnmpVarBind snmpVarBind) {
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        long[] lArray = snmpOID.toLongArray();
        switch ((int)lArray[10]) {
            case 4: {
                try {
                    ((SnmpInt)snmpVarBind.getVariable()).intValue();
                }
                catch (Exception exception) {
                    return 3;
                }
                if (this.getEntry(lArray) != null) break;
                return 6;
            }
            default: {
                return 6;
            }
        }
        return 0;
    }

    public int setValue(SnmpVarBind snmpVarBind, SnmpPDU snmpPDU) {
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        long[] lArray = snmpOID.toLongArray();
        switch ((int)lArray[10]) {
            case 4: {
                int n;
                try {
                    n = ((SnmpInt)snmpVarBind.getVariable()).intValue();
                }
                catch (Exception exception) {
                    return 3;
                }
                AlarmEntry alarmEntry = this.getEntry(lArray);
                if (alarmEntry == null) {
                    return 2;
                }
                if (!(n != 0 && n != 2 || alarmEntry.isAcked())) {
                    this.snmp.alarms().acknowledge(alarmEntry);
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                snmpPDU.addVariableBinding(new SnmpVarBind(snmpOID, new SnmpInt(alarmEntry.getAckState())));
                break;
            }
            default: {
                return 2;
            }
        }
        return 0;
    }

    public int getObjectLevel() {
        return 10;
    }

    public int getLastId() {
        return 15;
    }

    public TableEntry getNextEntry(int n) {
        return this.snmp.alarms().getNextEntry(n);
    }

    public String getFirstOid() {
        return "1.3.6.1.4.1.4131.1.3.1.1";
    }
}

