/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.export;

import com.tridium.snmp.BSnmpAgent;
import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.export.BISnmpExportFolder;
import com.tridium.snmp.export.BSnmpExportTable;
import com.tridium.snmp.mib.table.PointContainer;
import com.tridium.snmp.mib.table.PointEntry;
import com.tridium.snmp.util.SnmpUtil;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BSnmpExportObject
extends BComponent
implements PointEntry,
BIStatus {
    public static final Property status = BSnmpExportObject.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property faultCause = BSnmpExportObject.newProperty((int)3, (String)"", null);
    public static final Property objectOrd = BSnmpExportObject.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Property objectIdentifier = BSnmpExportObject.newProperty((int)65, (String)"", null);
    public static final Property deviceFacets = BSnmpExportObject.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$export$BSnmpExportObject == null ? (class$com$tridium$snmp$export$BSnmpExportObject = BSnmpExportObject.class$("com.tridium.snmp.export.BSnmpExportObject")) : class$com$tridium$snmp$export$BSnmpExportObject));
    int lastHash = -1;
    static /* synthetic */ Class class$com$tridium$snmp$export$BSnmpExportObject;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BOrd getObjectOrd() {
        return (BOrd)this.get(objectOrd);
    }

    public void setObjectOrd(BOrd bOrd) {
        this.set(objectOrd, (BValue)bOrd, null);
    }

    public String getObjectIdentifier() {
        return this.getString(objectIdentifier);
    }

    public void setObjectIdentifier(String string) {
        this.setString(objectIdentifier, string, null);
    }

    public BFacets getDeviceFacets() {
        return (BFacets)this.get(deviceFacets);
    }

    public void setDeviceFacets(BFacets bFacets) {
        this.set(deviceFacets, (BValue)bFacets, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSnmpVariableTypeEnum getVariableType() {
        return BSnmpVariableTypeEnum.stringType;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == objectOrd) {
            try {
                PointContainer pointContainer = this.getPointContainer();
                this.faultCheck();
                this.getObject();
                if (this.getStatus().isFault()) {
                    pointContainer.unregisterIoObject(this);
                    return;
                }
                if (!this.isValidObjId(pointContainer)) {
                    pointContainer.unregisterIoObject(this);
                    this.initObjId(pointContainer);
                }
                pointContainer.registerIoObject(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void started() throws Exception {
        super.started();
        this.faultCheck();
        this.getObject();
        if (this.getStatus().isFault()) {
            return;
        }
        PointContainer pointContainer = this.getPointContainer();
        if (!this.isValidObjId(pointContainer)) {
            this.initObjId(pointContainer);
        }
        pointContainer.registerIoObject(this);
    }

    private void initObjId(PointContainer pointContainer) {
        String string = pointContainer.getObjectIdentifier() + (this.isSettablePoint() ? ".1.1.3.0" : ".2.1.3.0");
        this.setObjectIdentifier(string);
    }

    private boolean isValidObjId(PointContainer pointContainer) {
        if (this.isSettablePoint()) {
            return this.getObjectIdentifier().indexOf(pointContainer.getObjectIdentifier() + ".1.1.3") == 0;
        }
        return this.getObjectIdentifier().indexOf(pointContainer.getObjectIdentifier() + ".2.1.3") == 0;
    }

    public void stopped() throws Exception {
        try {
            this.getPointContainer().unregisterIoObject(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopped();
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BISnmpExportFolder;
    }

    public BControlPoint getObject() {
        try {
            return (BControlPoint)this.getObjectOrd().get((BObject)this.getComponentSpace());
        }
        catch (Exception exception) {
            this.setFail("Unable to resolve objectOrd.");
            return null;
        }
    }

    private void faultCheck() {
        BSnmpExportTable bSnmpExportTable = null;
        BSnmpAgent bSnmpAgent = null;
        BSnmpNetwork bSnmpNetwork = null;
        for (BComplex bComplex = this.getParent(); bComplex != null; bComplex = bComplex.getParent()) {
            if (bComplex instanceof BSnmpExportTable) {
                bSnmpExportTable = (BSnmpExportTable)bComplex;
                continue;
            }
            if (!(bComplex instanceof BSnmpAgent)) continue;
            bSnmpAgent = (BSnmpAgent)bComplex;
            break;
        }
        if (bSnmpExportTable == null || bSnmpAgent == null) {
            this.setFail("Not under Snmp Export Table");
            return;
        }
        if (bSnmpAgent.isFatalFault()) {
            this.setFail("LocalDevice fault: " + bSnmpAgent.getFaultCause());
            return;
        }
        bSnmpNetwork = (BSnmpNetwork)bSnmpAgent.getParent();
        if (bSnmpNetwork == null) {
            this.setFail("Not under SnmpNetwork");
            return;
        }
        if (bSnmpNetwork.isFatalFault()) {
            this.setFail("Network fault: " + bSnmpNetwork.getFaultCause());
            return;
        }
        this.setOk();
    }

    public BISnmpExportFolder getFolder() {
        return (BISnmpExportFolder)this.getParent();
    }

    public PointContainer getPointContainer() {
        return (PointContainer)this.getParent();
    }

    public int getIndex() {
        return SnmpUtil.getIndex(this.getObjectIdentifier());
    }

    public void setIndex(int n) {
        this.setObjectIdentifier(SnmpUtil.replaceIndex(this.getObjectIdentifier(), n));
    }

    public String getPointName() {
        return this.getName();
    }

    public int getLastHash() {
        return this.lastHash;
    }

    public void setLastHash(int n) {
        this.lastHash = n;
    }

    public boolean isSettablePoint() {
        return this.getObject().isWritablePoint();
    }

    public String toString(Context context) {
        return this.getName() + " (" + this.getObjectIdentifier() + ")";
    }

    protected void setOk() {
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
    }

    protected void setFail(String string) {
        this.setStatus(BStatus.fault);
        this.setFaultCause(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

