/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.alarm;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.alarm.BTrapType;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.util.SnmpUtil;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BSnmpAlarmDeviceExt
extends BAlarmDeviceExt {
    private static long[] coldStartOid = new long[]{1L, 3L, 6L, 1L, 6L, 3L, 1L, 1L, 5L, 1L};
    private static long[] warmStartOid = new long[]{1L, 3L, 6L, 1L, 6L, 3L, 1L, 1L, 5L, 2L};
    private static long[] linkDownOid = new long[]{1L, 3L, 6L, 1L, 6L, 3L, 1L, 1L, 5L, 3L};
    private static long[] linkUpOid = new long[]{1L, 3L, 6L, 1L, 6L, 3L, 1L, 1L, 5L, 4L};
    private static long[] authenticationFailureOid = new long[]{1L, 3L, 6L, 1L, 6L, 3L, 1L, 1L, 5L, 5L};
    private static long[] egpNeighborLossOid = new long[]{1L, 3L, 6L, 1L, 6L, 3L, 1L, 1L, 5L, 6L};
    private static Lexicon lex = Lexicon.make((String)"snmp");
    public static final Property lastReceivedTrap = BSnmpAlarmDeviceExt.newProperty((int)267, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property ignoreUnrecognizedTraps = BSnmpAlarmDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property coldStart = BSnmpAlarmDeviceExt.newProperty((int)0, (BValue)new BTrapType(lex.getText("traps.strings.coldStart"), "", "null", new String[0], coldStartOid, 0, 0), null);
    public static final Property warmStart = BSnmpAlarmDeviceExt.newProperty((int)0, (BValue)new BTrapType(lex.getText("traps.strings.warmStart"), "", "null", new String[0], warmStartOid, 1, 0), null);
    public static final Property linkDown = BSnmpAlarmDeviceExt.newProperty((int)0, (BValue)new BTrapType(lex.getText("traps.strings.linkDown"), "", "null", new String[0], linkDownOid, 2, 0), null);
    public static final Property linkUp = BSnmpAlarmDeviceExt.newProperty((int)0, (BValue)new BTrapType(lex.getText("traps.strings.linkUp"), "", "null", new String[0], linkUpOid, 3, 0), null);
    public static final Property authenticationFailure = BSnmpAlarmDeviceExt.newProperty((int)0, (BValue)new BTrapType(lex.getText("traps.strings.authenticationFailure"), "", "null", new String[0], authenticationFailureOid, 4, 0), null);
    public static final Property egpNeighborLoss = BSnmpAlarmDeviceExt.newProperty((int)0, (BValue)new BTrapType(lex.getText("traps.strings.egpNeighborLoss"), "", "null", new String[0], egpNeighborLossOid, 5, 0), null);
    public static final Action clear = BSnmpAlarmDeviceExt.newAction((int)128, null);
    public static final Topic receivedTrap = BSnmpAlarmDeviceExt.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$alarm$BSnmpAlarmDeviceExt == null ? (class$com$tridium$snmp$alarm$BSnmpAlarmDeviceExt = BSnmpAlarmDeviceExt.class$("com.tridium.snmp.alarm.BSnmpAlarmDeviceExt")) : class$com$tridium$snmp$alarm$BSnmpAlarmDeviceExt));
    private AlarmSupport alarmSupport = new AlarmSupport((BIAlarmSource)this, "");
    private static BTrapType[] genericTrapList = new BTrapType[]{new BTrapType(lex.getText("traps.strings.coldStart"), "", "null", new String[0], coldStartOid, 0, 0), new BTrapType(lex.getText("traps.strings.warmStart"), "", "null", new String[0], warmStartOid, 1, 0), new BTrapType(lex.getText("traps.strings.linkDown"), "", "null", new String[0], linkDownOid, 2, 0), new BTrapType(lex.getText("traps.strings.linkUp"), "", "null", new String[0], linkUpOid, 3, 0), new BTrapType(lex.getText("traps.strings.authenticationFailure"), "", "null", new String[0], authenticationFailureOid, 4, 0), new BTrapType(lex.getText("traps.strings.egpNeighborLoss"), "", "null", new String[0], egpNeighborLossOid, 5, 0)};
    static /* synthetic */ Class class$com$tridium$snmp$alarm$BSnmpAlarmDeviceExt;
    static /* synthetic */ Class class$com$tridium$snmp$alarm$BTrapType;

    public String getLastReceivedTrap() {
        return this.getString(lastReceivedTrap);
    }

    public void setLastReceivedTrap(String string) {
        this.setString(lastReceivedTrap, string, null);
    }

    public boolean getIgnoreUnrecognizedTraps() {
        return this.getBoolean(ignoreUnrecognizedTraps);
    }

    public void setIgnoreUnrecognizedTraps(boolean bl) {
        this.setBoolean(ignoreUnrecognizedTraps, bl, null);
    }

    public BTrapType getColdStart() {
        return (BTrapType)this.get(coldStart);
    }

    public void setColdStart(BTrapType bTrapType) {
        this.set(coldStart, (BValue)bTrapType, null);
    }

    public BTrapType getWarmStart() {
        return (BTrapType)this.get(warmStart);
    }

    public void setWarmStart(BTrapType bTrapType) {
        this.set(warmStart, (BValue)bTrapType, null);
    }

    public BTrapType getLinkDown() {
        return (BTrapType)this.get(linkDown);
    }

    public void setLinkDown(BTrapType bTrapType) {
        this.set(linkDown, (BValue)bTrapType, null);
    }

    public BTrapType getLinkUp() {
        return (BTrapType)this.get(linkUp);
    }

    public void setLinkUp(BTrapType bTrapType) {
        this.set(linkUp, (BValue)bTrapType, null);
    }

    public BTrapType getAuthenticationFailure() {
        return (BTrapType)this.get(authenticationFailure);
    }

    public void setAuthenticationFailure(BTrapType bTrapType) {
        this.set(authenticationFailure, (BValue)bTrapType, null);
    }

    public BTrapType getEgpNeighborLoss() {
        return (BTrapType)this.get(egpNeighborLoss);
    }

    public void setEgpNeighborLoss(BTrapType bTrapType) {
        this.set(egpNeighborLoss, (BValue)bTrapType, null);
    }

    public void clear() {
        this.invoke(clear, null, null);
    }

    public void fireReceivedTrap(BAlarmRecord bAlarmRecord) {
        this.fire(receivedTrap, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doRouteAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        System.out.println("To doRouteAlarm");
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            bAlarmRecord.setAckTime(Clock.time());
            bAlarmRecord.setAckState(BAckState.acked);
            bAlarmRecord.setAckRequired(false);
            bAlarmService.routeAlarm(bAlarmRecord);
        }
        catch (Exception exception) {
            if (this.getNetwork() != null) {
                ((BSnmpNetwork)this.getNetwork()).getSnmpLog().error("Could not route acknowledgement to alarm class: ", (Throwable)exception);
            }
            return BBoolean.make((boolean)false);
        }
        return BBoolean.make((boolean)true);
    }

    public boolean isChildLegal(BComponent bComponent) {
        return bComponent instanceof BTrapType;
    }

    public void issueTrapAlert(BFacets bFacets, String string) {
        BAlarmRecord bAlarmRecord;
        block3: {
            this.alarmSupport.setAlarmClass(this.getAlarmClass());
            bAlarmRecord = null;
            try {
                bAlarmRecord = this.alarmSupport.newAlert(bFacets);
            }
            catch (Exception exception) {
                if (this.getNetwork() == null) break block3;
                ((BSnmpNetwork)this.getNetwork()).getSnmpLog().error("Could not generate SNMP trap alert for " + this.getDevice().getName(), (Throwable)exception);
            }
        }
        if (bAlarmRecord != null) {
            this.setLastReceivedTime(BAbsTime.make());
            this.setLastReceivedTrap(string);
            this.fireReceivedTrap(bAlarmRecord);
        }
    }

    public synchronized BTrapType[] getTrapList() {
        BTrapType[] bTrapTypeArray;
        BTrapType[] bTrapTypeArray2 = new BTrapType[this.getSlotCount()];
        int n = 0;
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next(class$com$tridium$snmp$alarm$BTrapType == null ? BSnmpAlarmDeviceExt.class$("com.tridium.snmp.alarm.BTrapType") : class$com$tridium$snmp$alarm$BTrapType)) {
            bTrapTypeArray = slotCursor.get();
            bTrapTypeArray2[n] = (BTrapType)bTrapTypeArray;
            ++n;
        }
        bTrapTypeArray = new BTrapType[n];
        System.arraycopy(bTrapTypeArray2, 0, bTrapTypeArray, 0, n);
        return bTrapTypeArray;
    }

    public void addEntry(BTrapType bTrapType) {
        String string = bTrapType.getTrapName();
        if (!SlotPath.isValidName((String)string)) {
            string = SlotPath.escape((String)string);
        }
        int n = 2;
        boolean bl = true;
        while (this.getSlot(string) != null) {
            if (bl) {
                string = string + "_" + n;
                bl = false;
            } else {
                string = string.substring(0, string.lastIndexOf(95)) + "_" + n;
            }
            ++n;
        }
        this.add(string, (BValue)bTrapType);
    }

    public void clearEntries() {
        this.removeAll(null);
    }

    public void doClear() {
        this.clearEntries();
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace != null) {
            bComponentSpace.update((BComponent)this, 0);
        }
    }

    public void setTrapList(BTrapType[] bTrapTypeArray) {
        this.clearEntries();
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace != null) {
            bComponentSpace.update((BComponent)this, 0);
        }
        if (bTrapTypeArray != null) {
            for (int i = 0; i < bTrapTypeArray.length; ++i) {
                this.addEntry(bTrapTypeArray[i]);
            }
        }
        if (bComponentSpace != null) {
            bComponentSpace.update((BComponent)this, 0);
        }
    }

    public void addTrapsToList(BTrapType[] bTrapTypeArray) {
        int n;
        BTrapType[] bTrapTypeArray2 = this.getTrapList();
        int n2 = 0;
        for (int i = 0; i < bTrapTypeArray.length; ++i) {
            if (!BSnmpAlarmDeviceExt.listContainsTrap(bTrapTypeArray2, bTrapTypeArray[i])) continue;
            ++n2;
        }
        BTrapType[] bTrapTypeArray3 = new BTrapType[bTrapTypeArray.length - n2];
        int n3 = 0;
        for (int i = 0; i < bTrapTypeArray.length; ++i) {
            if (BSnmpAlarmDeviceExt.listContainsTrap(bTrapTypeArray2, bTrapTypeArray[i])) continue;
            bTrapTypeArray3[n3] = (BTrapType)bTrapTypeArray[i].newCopy();
            ++n3;
        }
        BTrapType[] bTrapTypeArray4 = new BTrapType[bTrapTypeArray2.length + bTrapTypeArray3.length];
        for (n = 0; n < bTrapTypeArray2.length; ++n) {
            bTrapTypeArray4[n] = (BTrapType)bTrapTypeArray2[n].newCopy();
        }
        for (n = bTrapTypeArray2.length; n < bTrapTypeArray2.length + bTrapTypeArray3.length; ++n) {
            bTrapTypeArray4[n] = (BTrapType)bTrapTypeArray3[n - bTrapTypeArray2.length].newCopy();
        }
        this.setTrapList(bTrapTypeArray4);
    }

    public void removeTrapsFromList(BTrapType[] bTrapTypeArray) {
        int n;
        BTrapType[] bTrapTypeArray2 = this.getTrapList();
        int n2 = 0;
        for (int i = 0; i < bTrapTypeArray.length; ++i) {
            if (!BSnmpAlarmDeviceExt.listContainsTrap(bTrapTypeArray2, bTrapTypeArray[i])) continue;
            ++n2;
            for (n = i + 1; n < bTrapTypeArray.length; ++n) {
                if (!bTrapTypeArray[i].compareTraps(bTrapTypeArray[n])) continue;
                --n2;
            }
        }
        BTrapType[] bTrapTypeArray3 = new BTrapType[bTrapTypeArray2.length - n2];
        n = 0;
        for (int i = 0; i < bTrapTypeArray2.length; ++i) {
            if (BSnmpAlarmDeviceExt.listContainsTrap(bTrapTypeArray, bTrapTypeArray2[i])) continue;
            bTrapTypeArray3[n] = (BTrapType)bTrapTypeArray2[i].newCopy();
            ++n;
        }
        this.setTrapList(bTrapTypeArray3);
    }

    private static boolean listContainsTrap(BTrapType[] bTrapTypeArray, BTrapType bTrapType) {
        for (int i = 0; i < bTrapTypeArray.length; ++i) {
            if (!bTrapType.compareTraps(bTrapTypeArray[i])) continue;
            return true;
        }
        return false;
    }

    public BTrapType getTrapTypeByOID(SnmpOID snmpOID) {
        BTrapType[] bTrapTypeArray = this.getTrapList();
        long[] lArray = snmpOID.toValue();
        if (lArray == null) {
            return null;
        }
        for (int i = 0; i < bTrapTypeArray.length; ++i) {
            long[] lArray2 = bTrapTypeArray[i].getOid();
            if (lArray.length != lArray2.length) continue;
            boolean bl = true;
            for (int j = 0; j < lArray.length; ++j) {
                if (lArray[j] == lArray2[j]) continue;
                bl = false;
            }
            if (!bl) continue;
            return bTrapTypeArray[i];
        }
        return null;
    }

    public BTrapType getTrapTypeByGenericSpecific(String string, int n, int n2) {
        BTrapType[] bTrapTypeArray = this.getTrapList();
        for (int i = 0; i < bTrapTypeArray.length; ++i) {
            if (bTrapTypeArray[i].getGenericType() != n || bTrapTypeArray[i].getSpecificType() != n2 || !SnmpUtil.longArrayToString(bTrapTypeArray[i].getOid()).equals(string) && !"1.3.6.1.2.1.11".equals(string)) continue;
            return bTrapTypeArray[i];
        }
        return null;
    }

    public static final BTrapType getGenericTrapType(int n, int n2) {
        for (int i = 0; i < genericTrapList.length; ++i) {
            if (genericTrapList[i].getGenericType() != n || genericTrapList[i].getSpecificType() != n2) continue;
            return genericTrapList[i];
        }
        return null;
    }

    public static final BTrapType getGenericTrapType(SnmpOID snmpOID) {
        long[] lArray = snmpOID.toValue();
        if (lArray == null) {
            return null;
        }
        for (int i = 0; i < genericTrapList.length; ++i) {
            long[] lArray2 = genericTrapList[i].getOid();
            if (lArray.length != lArray2.length) continue;
            boolean bl = true;
            for (int j = 0; j < lArray.length; ++j) {
                if (lArray[j] == lArray2[j]) continue;
                bl = false;
            }
            if (!bl) continue;
            return genericTrapList[i];
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

