/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp;

import com.tridium.basicdriver.util.BBasicCoalescingWorker;
import com.tridium.basicdriver.util.BBasicWorker;
import com.tridium.snmp.BSnmpAgent;
import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.BSnmpDeviceFolder;
import com.tridium.snmp.BSnmpPollScheduler;
import com.tridium.snmp.datatypes.BNetworkManagerList;
import com.tridium.snmp.messages.SnmpRequest;
import com.tridium.snmp.messages.SnmpStopRequest;
import com.tridium.snmp.mib.TridiumMib;
import com.tridium.snmp.mib.table.AlarmTable;
import com.tridium.snmp.mib.table.PointContainer;
import com.tridium.snmp.mib.table.PointEntry;
import com.tridium.snmp.mib.table.PointTable;
import com.tridium.snmp.services.SnmpDriver;
import com.tridium.snmp.services.SnmpReceive;
import com.tridium.snmp.services.SnmpReceiveTraps;
import com.tridium.snmp.snmptypes.GenericTrap;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.util.SnmpUtil;
import java.net.DatagramSocket;
import java.net.InetAddress;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.nav.BINavNode;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.Array;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;

public class BSnmpNetwork
extends BDeviceNetwork
implements BIService,
PointContainer {
    public static final Lexicon lex = Lexicon.make((String)"snmp");
    public static final Property tuningPolicies = BSnmpNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    public static final Property dispatcher = BSnmpNetwork.newProperty((int)4, (BValue)new BBasicWorker(), null);
    public static final Property worker = BSnmpNetwork.newProperty((int)4, (BValue)new BBasicCoalescingWorker(), null);
    public static final Property writeWorker = BSnmpNetwork.newProperty((int)4, (BValue)new BBasicCoalescingWorker(), null);
    public static final Property pollScheduler = BSnmpNetwork.newProperty((int)0, (BValue)new BSnmpPollScheduler(), null);
    public static final Property enterprise = BSnmpNetwork.newProperty((int)1, (String)"1.3.6.1.4.1.4131", null);
    public static final Property contact = BSnmpNetwork.newProperty((int)0, (String)lex.getText("network.strings.contact"), null);
    public static final Property systemName = BSnmpNetwork.newProperty((int)0, (String)lex.getText("network.strings.name"), null);
    public static final Property location = BSnmpNetwork.newProperty((int)0, (String)lex.getText("network.strings.location"), null);
    public static final Property snmpReceiveRequests = BSnmpNetwork.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)lex.getText("network.enableReceive"), (String)lex.getText("network.disableReceive")));
    public static final Property snmpReceivePort = BSnmpNetwork.newProperty((int)0, (int)161, (BFacets)BFacets.makeInt(null, (int)0, (int)4999));
    public static final Property ignoreRequestsFromUnrecognizedSources = BSnmpNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property recognizedSources = BSnmpNetwork.newProperty((int)0, (BValue)new BNetworkManagerList(), null);
    public static final Property checkCommunityOnRequests = BSnmpNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property readOnlyCommunity = BSnmpNetwork.newProperty((int)0, (String)"public", null);
    public static final Property readWriteCommunity = BSnmpNetwork.newProperty((int)0, (String)"public", null);
    public static final Property snmpReceiveTraps = BSnmpNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property snmpReceiveTrapsPort = BSnmpNetwork.newProperty((int)0, (int)162, (BFacets)BFacets.makeInt(null, (int)0, (int)4999));
    public static final Property defaultNetworkManagerIpAddress = BSnmpNetwork.newProperty((int)0, (String)"", null);
    public static final Property defaultNetworkManagerTrapsPort = BSnmpNetwork.newProperty((int)0, (int)162, (BFacets)BFacets.makeInt(null, (int)0, (int)4999));
    public static final Property defaultNetworkManagerSnmpVersion = BSnmpNetwork.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)2));
    public static final Property defaultNetworkManagerTrapsCommunity = BSnmpNetwork.newProperty((int)0, (String)"public", null);
    public static final Property snmpAlarmTableCapacity = BSnmpNetwork.newProperty((int)0, (int)500, (BFacets)BFacets.makeInt((BUnit)BUnit.make((String)"records", (BDimension)BDimension.DEFAULT), (int)0, (int)250000));
    public static final Property localDevice = BSnmpNetwork.newProperty((int)0, (BValue)new BSnmpAgent(), null);
    public static final Action clearSnmpAlarmTable = BSnmpNetwork.newAction((int)144, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$BSnmpNetwork == null ? (class$com$tridium$snmp$BSnmpNetwork = BSnmpNetwork.class$("com.tridium.snmp.BSnmpNetwork")) : class$com$tridium$snmp$BSnmpNetwork));
    private static Type[] serviceTypes = new Type[]{TYPE};
    private int reqId = 0;
    private AlarmTable alarms;
    private PointTable inputs;
    private PointTable outputs;
    private PointTable objects;
    private SnmpReceiveTraps unsolicitedReceive = null;
    private SnmpDriver snmpDriver = null;
    private boolean networkInitComplete = false;
    private boolean networkStartComplete = false;
    private Object reqIdSync = new Object();
    private long startupTime = 0L;
    private static TridiumMib mib = null;
    private static SnmpReceive snmpReceive;
    public static final Log log;
    static /* synthetic */ Class class$com$tridium$snmp$BSnmpNetwork;
    static /* synthetic */ Class class$javax$baja$nav$BINavNode;
    static /* synthetic */ Class class$com$tridium$snmp$mib$table$PointContainer;

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap bTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bTuningPolicyMap, null);
    }

    public BBasicWorker getDispatcher() {
        return (BBasicWorker)this.get(dispatcher);
    }

    public void setDispatcher(BBasicWorker bBasicWorker) {
        this.set(dispatcher, (BValue)bBasicWorker, null);
    }

    public BBasicCoalescingWorker getWorker() {
        return (BBasicCoalescingWorker)this.get(worker);
    }

    public void setWorker(BBasicCoalescingWorker bBasicCoalescingWorker) {
        this.set(worker, (BValue)bBasicCoalescingWorker, null);
    }

    public BBasicCoalescingWorker getWriteWorker() {
        return (BBasicCoalescingWorker)this.get(writeWorker);
    }

    public void setWriteWorker(BBasicCoalescingWorker bBasicCoalescingWorker) {
        this.set(writeWorker, (BValue)bBasicCoalescingWorker, null);
    }

    public BSnmpPollScheduler getPollScheduler() {
        return (BSnmpPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BSnmpPollScheduler bSnmpPollScheduler) {
        this.set(pollScheduler, (BValue)bSnmpPollScheduler, null);
    }

    public String getEnterprise() {
        return this.getString(enterprise);
    }

    public void setEnterprise(String string) {
        this.setString(enterprise, string, null);
    }

    public String getContact() {
        return this.getString(contact);
    }

    public void setContact(String string) {
        this.setString(contact, string, null);
    }

    public String getSystemName() {
        return this.getString(systemName);
    }

    public void setSystemName(String string) {
        this.setString(systemName, string, null);
    }

    public String getLocation() {
        return this.getString(location);
    }

    public void setLocation(String string) {
        this.setString(location, string, null);
    }

    public boolean getSnmpReceiveRequests() {
        return this.getBoolean(snmpReceiveRequests);
    }

    public void setSnmpReceiveRequests(boolean bl) {
        this.setBoolean(snmpReceiveRequests, bl, null);
    }

    public int getSnmpReceivePort() {
        return this.getInt(snmpReceivePort);
    }

    public void setSnmpReceivePort(int n) {
        this.setInt(snmpReceivePort, n, null);
    }

    public boolean getIgnoreRequestsFromUnrecognizedSources() {
        return this.getBoolean(ignoreRequestsFromUnrecognizedSources);
    }

    public void setIgnoreRequestsFromUnrecognizedSources(boolean bl) {
        this.setBoolean(ignoreRequestsFromUnrecognizedSources, bl, null);
    }

    public BNetworkManagerList getRecognizedSources() {
        return (BNetworkManagerList)this.get(recognizedSources);
    }

    public void setRecognizedSources(BNetworkManagerList bNetworkManagerList) {
        this.set(recognizedSources, (BValue)bNetworkManagerList, null);
    }

    public boolean getCheckCommunityOnRequests() {
        return this.getBoolean(checkCommunityOnRequests);
    }

    public void setCheckCommunityOnRequests(boolean bl) {
        this.setBoolean(checkCommunityOnRequests, bl, null);
    }

    public String getReadOnlyCommunity() {
        return this.getString(readOnlyCommunity);
    }

    public void setReadOnlyCommunity(String string) {
        this.setString(readOnlyCommunity, string, null);
    }

    public String getReadWriteCommunity() {
        return this.getString(readWriteCommunity);
    }

    public void setReadWriteCommunity(String string) {
        this.setString(readWriteCommunity, string, null);
    }

    public boolean getSnmpReceiveTraps() {
        return this.getBoolean(snmpReceiveTraps);
    }

    public void setSnmpReceiveTraps(boolean bl) {
        this.setBoolean(snmpReceiveTraps, bl, null);
    }

    public int getSnmpReceiveTrapsPort() {
        return this.getInt(snmpReceiveTrapsPort);
    }

    public void setSnmpReceiveTrapsPort(int n) {
        this.setInt(snmpReceiveTrapsPort, n, null);
    }

    public String getDefaultNetworkManagerIpAddress() {
        return this.getString(defaultNetworkManagerIpAddress);
    }

    public void setDefaultNetworkManagerIpAddress(String string) {
        this.setString(defaultNetworkManagerIpAddress, string, null);
    }

    public int getDefaultNetworkManagerTrapsPort() {
        return this.getInt(defaultNetworkManagerTrapsPort);
    }

    public void setDefaultNetworkManagerTrapsPort(int n) {
        this.setInt(defaultNetworkManagerTrapsPort, n, null);
    }

    public int getDefaultNetworkManagerSnmpVersion() {
        return this.getInt(defaultNetworkManagerSnmpVersion);
    }

    public void setDefaultNetworkManagerSnmpVersion(int n) {
        this.setInt(defaultNetworkManagerSnmpVersion, n, null);
    }

    public String getDefaultNetworkManagerTrapsCommunity() {
        return this.getString(defaultNetworkManagerTrapsCommunity);
    }

    public void setDefaultNetworkManagerTrapsCommunity(String string) {
        this.setString(defaultNetworkManagerTrapsCommunity, string, null);
    }

    public int getSnmpAlarmTableCapacity() {
        return this.getInt(snmpAlarmTableCapacity);
    }

    public void setSnmpAlarmTableCapacity(int n) {
        this.setInt(snmpAlarmTableCapacity, n, null);
    }

    public BSnmpAgent getLocalDevice() {
        return (BSnmpAgent)this.get(localDevice);
    }

    public void setLocalDevice(BSnmpAgent bSnmpAgent) {
        this.set(localDevice, (BValue)bSnmpAgent, null);
    }

    public void clearSnmpAlarmTable() {
        this.invoke(clearSnmpAlarmTable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public Type getDeviceType() {
        return BSnmpDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BSnmpDeviceFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "snmp");
    }

    public void serviceStarted() throws Exception {
        this.alarms = new AlarmTable(this);
        this.inputs = new PointTable();
        this.outputs = new PointTable();
        this.objects = new PointTable();
        this.unsolicitedReceive = new SnmpReceiveTraps(this);
        snmpReceive = new SnmpReceive(this);
        this.snmpDriver = new SnmpDriver(this);
        this.networkInitComplete = true;
    }

    public void serviceStopped() {
    }

    public void checkAdd(String string, BValue bValue, int n, BFacets bFacets, Context context) {
        if (bValue instanceof BSnmpAgent) {
            throw new LocalizableRuntimeException("snmp", "addLocalDeviceError");
        }
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] bINavNodeArray = super.getNavChildren();
        Array array = new Array(class$javax$baja$nav$BINavNode == null ? (class$javax$baja$nav$BINavNode = BSnmpNetwork.class$("javax.baja.nav.BINavNode")) : class$javax$baja$nav$BINavNode);
        array.add((Object)this.getLocalDevice());
        for (int i = 0; i < bINavNodeArray.length; ++i) {
            array.add((Object)bINavNodeArray[i]);
        }
        return (BINavNode[])array.trim();
    }

    public void started() throws Exception {
        super.started();
        BComponent[] bComponentArray = Sys.getServices((Type)TYPE);
        if (bComponentArray.length > 1) {
            for (int i = 0; i < bComponentArray.length; ++i) {
                ((BSnmpNetwork)bComponentArray[i]).configFatal("Only one SNMP Network is allowed per station. Remove duplicate SNMP network(s) and restart station.");
            }
        }
        if (!(this.isDisabled() || this.isDown() || this.isFatalFault())) {
            if (this.getSnmpLog().isTraceOn()) {
                this.getSnmpLog().trace(this + " *** Starting SNMP communication ***");
            }
            this.inputs.start();
            this.outputs.start();
            this.objects.start();
            this.snmpDriver.start();
            if (this.getSnmpReceiveRequests()) {
                snmpReceive.start();
            }
            if (this.getSnmpReceiveTraps()) {
                this.unsolicitedReceive.start();
            }
            this.networkStartComplete = true;
        }
    }

    public void stopped() throws Exception {
        if (this.getSnmpLog().isTraceOn()) {
            this.getSnmpLog().trace(this + " *** Stopping SNMP communication ***");
        }
        SnmpStopRequest snmpStopRequest = new SnmpStopRequest();
        this.postRequest(snmpStopRequest);
        snmpStopRequest.stop();
        this.snmpDriver.stop();
        snmpReceive.stop();
        this.unsolicitedReceive.stop();
        this.networkStartComplete = false;
        super.stopped();
    }

    public void atSteadyState() {
        this.startupTime = Clock.ticks();
        if (this.isCommActive() && this.getDefaultNetworkManagerIpAddress().length() > 0) {
            GenericTrap.sendColdStart(this);
        }
    }

    public Log getSnmpLog() {
        return log;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == status && this.networkInitComplete) {
            if (!(this.isDisabled() || this.isDown() || this.isFatalFault() || this.networkStartComplete)) {
                if (this.getSnmpLog().isTraceOn()) {
                    this.getSnmpLog().trace(this + " *** Starting SNMP communication ***");
                }
                this.snmpDriver.start();
                if (this.getSnmpReceiveRequests()) {
                    snmpReceive.start();
                }
                this.inputs.start();
                this.outputs.start();
                this.objects.start();
                if (this.getSnmpReceiveTraps()) {
                    this.unsolicitedReceive.start();
                }
                this.networkStartComplete = true;
            } else if (this.networkStartComplete) {
                if (this.getSnmpLog().isTraceOn()) {
                    this.getSnmpLog().trace(this + " *** Stopping SNMP communication ***");
                }
                SnmpStopRequest snmpStopRequest = new SnmpStopRequest();
                this.postRequest(snmpStopRequest);
                snmpStopRequest.stop();
                this.snmpDriver.stop();
                snmpReceive.stop();
                this.unsolicitedReceive.stop();
                this.networkStartComplete = false;
            }
        } else if (property.equals(snmpReceiveTraps) && this.networkInitComplete && this.networkStartComplete) {
            if (this.getSnmpReceiveTraps()) {
                this.unsolicitedReceive.start();
            } else {
                this.unsolicitedReceive.stop();
            }
        } else if (property.equals(snmpReceiveRequests) && this.networkInitComplete && this.networkStartComplete) {
            if (this.getSnmpReceiveRequests()) {
                snmpReceive.start();
            } else {
                snmpReceive.stop();
            }
        } else if (property.equals(snmpReceiveTrapsPort) && this.getSnmpReceiveTraps() && this.networkInitComplete && this.networkStartComplete) {
            this.unsolicitedReceive.stop();
            this.unsolicitedReceive.start();
        } else if (property.equals(snmpReceivePort) && this.getSnmpReceiveRequests() && this.networkInitComplete && this.networkStartComplete) {
            snmpReceive.stop();
            snmpReceive.start();
        } else if (property.equals(snmpAlarmTableCapacity) && this.networkInitComplete) {
            this.alarms.setCapacity(this.getSnmpAlarmTableCapacity());
        }
    }

    public boolean isCommActive() {
        return this.networkStartComplete;
    }

    public void doClearSnmpAlarmTable() {
        if (this.alarms != null) {
            this.alarms.clearAlarmTable();
        }
    }

    public IFuture postSync(Runnable runnable) {
        return this.getDispatcher().post(runnable);
    }

    public IFuture postRequest(Runnable runnable) {
        return this.getWorker().post(runnable);
    }

    public IFuture postCoalescingRequest(Runnable runnable) {
        return this.getWriteWorker().post(runnable);
    }

    public SnmpPDU sendAsyncRequest(SnmpPDU snmpPDU, int n, int n2) {
        return this.send(snmpPDU, n, n2, true, true);
    }

    public SnmpPDU sendAsyncRequest(SnmpPDU snmpPDU, int n, int n2, boolean bl) {
        return this.send(snmpPDU, n, n2, true, bl);
    }

    public SnmpPDU sendRequest(SnmpPDU snmpPDU, int n, int n2) {
        return this.send(snmpPDU, n, n2, false, true);
    }

    public SnmpPDU sendRequest(SnmpPDU snmpPDU, int n, int n2, boolean bl) {
        return this.send(snmpPDU, n, n2, false, bl);
    }

    protected SnmpPDU send(SnmpPDU snmpPDU, int n, int n2, boolean bl, boolean bl2) {
        if (!this.isCommActive()) {
            return null;
        }
        SnmpRequest snmpRequest = new SnmpRequest(this, snmpPDU, n, n2, bl2);
        if (bl2) {
            if (bl) {
                this.postSync(snmpRequest);
            } else {
                snmpRequest.execute();
            }
            SnmpPDU snmpPDU2 = snmpRequest.getResponse(n * n2);
            if (snmpPDU2 != null) {
                try {
                    BSnmpDevice bSnmpDevice = this.findDevice(snmpPDU.getDestinationIp());
                    if (bSnmpDevice != null) {
                        bSnmpDevice.pingOk();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return snmpPDU2;
        }
        if (bl) {
            this.postSync(snmpRequest);
        } else {
            snmpRequest.execute();
        }
        return null;
    }

    public BSnmpDevice findDevice(InetAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        BDevice[] bDeviceArray = this.getDevices();
        if (bDeviceArray == null) {
            return null;
        }
        for (int i = 0; i < bDeviceArray.length; ++i) {
            InetAddress inetAddress2;
            if (bDeviceArray[i] == null || !(bDeviceArray[i] instanceof BSnmpDevice) || (inetAddress2 = ((BSnmpDevice)bDeviceArray[i]).getInetAddress()) == null || !inetAddress2.equals(inetAddress)) continue;
            return (BSnmpDevice)bDeviceArray[i];
        }
        return null;
    }

    public AlarmTable alarms() {
        return this.alarms;
    }

    public PointTable inputs() {
        return this.inputs;
    }

    public PointTable outputs() {
        return this.outputs;
    }

    public PointTable objects() {
        return this.objects;
    }

    public synchronized TridiumMib getMib() {
        if (mib == null) {
            mib = new TridiumMib(this);
        }
        return mib;
    }

    public synchronized void mibChanged() {
        mib = null;
    }

    public PointTable getTable(boolean bl) {
        return bl ? this.inputs() : this.outputs();
    }

    public String getObjectIdentifier() {
        return "1.3.6.1.4.1.4131.1";
    }

    public InetAddress getManagerIp() {
        try {
            return InetAddress.getByName(this.getDefaultNetworkManagerIpAddress());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DatagramSocket getSocket() {
        if (this.getSnmpReceiveRequests()) {
            return snmpReceive.getSocket();
        }
        return null;
    }

    public void registerIoObject(PointEntry pointEntry) {
        if (pointEntry.isSettablePoint()) {
            this.inputs.registerIoObject(pointEntry);
        } else {
            this.outputs.registerIoObject(pointEntry);
        }
    }

    public void unregisterIoObject(PointEntry pointEntry) {
        if (pointEntry.isSettablePoint()) {
            this.inputs.unregisterIoObject(pointEntry);
        } else {
            this.outputs.unregisterIoObject(pointEntry);
        }
    }

    public long getTimeTick() {
        long l = (Clock.ticks() - this.startupTime) / 10L;
        if (l < 0L) {
            l = Clock.ticks();
        }
        while (l > 0xFFFFFFFFL) {
            l -= 0xFFFFFFFFL;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextReqid() {
        Object object = this.reqIdSync;
        synchronized (object) {
            return this.reqId++;
        }
    }

    public SnmpDriver snmpDriver() {
        return this.snmpDriver;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        if (!this.isRunning()) {
            return;
        }
        spyWriter.startProps();
        spyWriter.trTitle((Object)("Snmp Alarm Table " + this.getEnterprise() + ".1.3"), 2);
        spyWriter.endProps();
        this.alarms.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)("Snmp Input Table" + this.getEnterprise() + ".1.4"), 2);
        spyWriter.endProps();
        this.inputs.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)("Snmp Output Table" + this.getEnterprise() + ".1.5"), 2);
        spyWriter.endProps();
        this.outputs.spy(spyWriter);
        PointContainer[] pointContainerArray = (PointContainer[])SnmpUtil.getDecendantsByClass((BComponent)this, class$com$tridium$snmp$mib$table$PointContainer == null ? (class$com$tridium$snmp$mib$table$PointContainer = BSnmpNetwork.class$("com.tridium.snmp.mib.table.PointContainer")) : class$com$tridium$snmp$mib$table$PointContainer);
        for (int i = 0; i < pointContainerArray.length; ++i) {
            this.spyExport(spyWriter, pointContainerArray[i]);
        }
        if (this.objects.getArray().length > 0) {
            spyWriter.startProps();
            spyWriter.trTitle((Object)"Snmp Objects 1.3.6.1.4.1.4131.1.7", 2);
            spyWriter.endProps();
            this.objects.spy(spyWriter);
        }
        spyWriter.startProps();
        spyWriter.trTitle((Object)"Current Mib representation for this station", 4);
        spyWriter.endProps();
        this.getMib().spy(spyWriter);
    }

    public void spyExport(SpyWriter spyWriter, PointContainer pointContainer) throws Exception {
        String string = ((BComponent)pointContainer).getName();
        spyWriter.startProps();
        spyWriter.trTitle((Object)(string + " Input Table " + pointContainer.getObjectIdentifier() + ".1"), 2);
        spyWriter.endProps();
        pointContainer.getTable(true).spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)(string + " Output Table" + pointContainer.getObjectIdentifier() + ".2"), 2);
        spyWriter.endProps();
        pointContainer.getTable(false).spy(spyWriter);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = Log.getLog((String)"snmp");
    }
}

