/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitIo.conv;

import com.tridium.util.EscUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitException;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BTabularConversion
extends BProxyConversion {
    private static final String DEFAULT_ENCODING = "Linear|0.0,0.0;100.0,100.0;";
    public static final BTabularConversion NULL = BTabularConversion.make();
    public static final BTabularConversion DEFAULT = BTabularConversion.make("Linear|0.0,0.0;100.0,100.0;");
    public static final Type TYPE;
    private Array points;
    private double[] srcArray;
    private double[] destArray;
    private String description;
    private int hashCode;
    static /* synthetic */ Class class$com$tridium$kitIo$conv$BTabularConversion;
    static /* synthetic */ Class class$com$tridium$kitIo$conv$BTabularConversion$XYPoint;

    public static final BTabularConversion make() {
        return new BTabularConversion();
    }

    public static final BTabularConversion make(String string, Array array) {
        return new BTabularConversion(string, array);
    }

    public static final BTabularConversion make(String string) {
        try {
            return (BTabularConversion)NULL.decodeFromString(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Array getPoints() {
        return this.points.copy();
    }

    public final String getDescription() {
        return this.description;
    }

    public final void convertDeviceToProxy(BProxyExt bProxyExt, BStatusValue bStatusValue, BStatusValue bStatusValue2) throws Exception {
        if (bStatusValue instanceof BStatusNumeric) {
            if (this.srcArray == null) {
                bStatusValue.copyFrom((BComplex)bStatusValue2);
                throw new UnitException("Not convertible: invalid points table");
            }
            double d = ((BStatusNumeric)bStatusValue).getValue();
            double d2 = this.convertTo(d, this.srcArray, this.destArray);
            bStatusValue2.setStatus(bStatusValue.getStatus());
            ((BStatusNumeric)bStatusValue2).setValue(d2);
            return;
        }
        bStatusValue2.copyFrom((BComplex)bStatusValue);
        throw new UnitException("Not convertible: invalid point type");
    }

    public final void convertProxyToDevice(BProxyExt bProxyExt, BStatusValue bStatusValue, BStatusValue bStatusValue2) throws Exception {
        if (bStatusValue instanceof BStatusNumeric) {
            if (this.srcArray == null) {
                bStatusValue2.copyFrom((BComplex)bStatusValue);
                throw new UnitException("Not convertible: invalid points table");
            }
            double d = ((BStatusNumeric)bStatusValue).getValue();
            double d2 = this.convertTo(d, this.destArray, this.srcArray);
            bStatusValue2.setStatus(bStatusValue.getStatus());
            ((BStatusNumeric)bStatusValue2).setValue(d2);
            return;
        }
        bStatusValue2.copyFrom((BComplex)bStatusValue);
        throw new UnitException("Not convertible: invalid point type");
    }

    private final double convertTo(double d, double[] dArray, double[] dArray2) {
        int n = 0;
        int n2 = dArray.length;
        if (d < dArray[0]) {
            return dArray2[0];
        }
        if (d > dArray[n2 - 1]) {
            return dArray2[n2 - 1];
        }
        if (d == dArray[n2 - 1]) {
            return dArray2[n2 - 1];
        }
        int n3 = 0;
        while (n3 < n2 - 1) {
            if (d >= dArray[n3] && d < dArray[n3 + 1]) {
                n = n3;
                break;
            }
            ++n3;
        }
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        double d4 = dArray2[n];
        double d5 = dArray2[n + 1];
        return d4 - (d2 - d) * (d4 - d5) / (d2 - d3);
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.encodeToString().hashCode();
        }
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        BTabularConversion bTabularConversion;
        return object instanceof BTabularConversion && (bTabularConversion = (BTabularConversion)((Object)object)).hashCode() == this.hashCode();
    }

    public final String toString(Context context) {
        return this.encodeToString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = EscUtil.slot.escape(this.description);
        stringBuffer.append(string).append("|");
        int n = 0;
        while (n < this.points.size()) {
            XYPoint xYPoint = (XYPoint)this.points.get(n);
            stringBuffer.append(xYPoint.x()).append(',').append(xYPoint.y()).append(';');
            ++n;
        }
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        Class clazz = class$com$tridium$kitIo$conv$BTabularConversion$XYPoint;
        if (clazz == null) {
            clazz = class$com$tridium$kitIo$conv$BTabularConversion$XYPoint = BTabularConversion.class("[Lcom.tridium.kitIo.conv.BTabularConversion$XYPoint;", false);
        }
        Array array = new Array(clazz);
        int n = -1;
        int n2 = string.indexOf(124);
        String string2 = EscUtil.slot.unescape(string.substring(0, n2));
        n = n2;
        n2 = string.indexOf(59);
        while (true) {
            if (n2 == -1) break;
            this.decodePoint(string.substring(n + 1, n2), array);
            n = n2;
            n2 = string.indexOf(59, n + 1);
        }
        this.decodePoint(string.substring(n + 1), array);
        BTabularConversion bTabularConversion = BTabularConversion.make(string2, array);
        return bTabularConversion;
    }

    private final void decodePoint(String string, Array array) {
        int n = string.indexOf(44);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        if (string2.length() > 0 && string3.length() > 0) {
            try {
                double d = Double.parseDouble(string2);
                double d2 = Double.parseDouble(string3);
                array.add((Object)new XYPoint(d, d2));
            }
            catch (Exception exception) {}
        }
    }

    private final void refreshArrays() {
        if (this.points.size() >= 2) {
            this.srcArray = new double[this.points.size()];
            this.destArray = new double[this.points.size()];
            int n = 0;
            while (n < this.points.size()) {
                XYPoint xYPoint = (XYPoint)this.points.get(n);
                this.srcArray[n] = xYPoint.x();
                this.destArray[n] = xYPoint.y();
                ++n;
            }
        } else {
            this.destArray = null;
            this.srcArray = null;
        }
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$kitIo$conv$BTabularConversion$XYPoint;
        if (clazz == null) {
            clazz = class$com$tridium$kitIo$conv$BTabularConversion$XYPoint = BTabularConversion.class("[Lcom.tridium.kitIo.conv.BTabularConversion$XYPoint;", false);
        }
        this.points = new Array(clazz);
        this.srcArray = null;
        this.destArray = null;
        this.description = "";
        this.hashCode = -1;
    }

    private BTabularConversion(String string, Array array) {
        this.this();
        this.description = string == null ? "" : string;
        this.points = array;
        this.points.sort();
        this.refreshArrays();
    }

    private BTabularConversion() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$kitIo$conv$BTabularConversion;
        if (clazz == null) {
            clazz = class$com$tridium$kitIo$conv$BTabularConversion = BTabularConversion.class("[Lcom.tridium.kitIo.conv.BTabularConversion;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    public static class XYPoint
    implements Comparable {
        private double x;
        private double y;

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        public int compareTo(Object object) {
            if (object instanceof XYPoint) {
                XYPoint xYPoint = (XYPoint)object;
                if (xYPoint.x > this.x) {
                    return -1;
                }
                if (xYPoint.x < this.x) {
                    return 1;
                }
                return 0;
            }
            throw new ClassCastException("object not of type XYPoint.class");
        }

        public boolean equals(Object object) {
            if (object instanceof XYPoint) {
                XYPoint xYPoint = (XYPoint)object;
                boolean bl = false;
                if (this.x == xYPoint.x && this.y == xYPoint.y) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public XYPoint(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }
}

