/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.svg.batik;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import org.apache.batik.util.ParsedURLData;

public class OrdParsedURLData
extends ParsedURLData {
    public static final String PROTOCOL = "ord";
    private BOrd ord;

    public OrdParsedURLData(BOrd bOrd, String string) {
        if (bOrd == null) {
            throw new IllegalArgumentException("ORD required");
        }
        this.protocol = PROTOCOL;
        String string2 = bOrd.toString();
        if (string2.indexOf(35) >= 0) {
            throw new IllegalArgumentException("ORD cannot contain a '#' character");
        }
        if (string != null && string.indexOf(35) >= 0) {
            throw new IllegalArgumentException("ref cannot contain a '#' character");
        }
        this.path = string2;
        this.ord = bOrd;
        this.ref = string;
    }

    public InputStream openStream(String string, Iterator iterator) throws IOException {
        BIFile bIFile = (BIFile)this.ord.get();
        return new ByteArrayInputStream(bIFile.read());
    }

    public InputStream openStreamRaw(String string, Iterator iterator) throws IOException {
        return this.openStream(string, iterator);
    }

    public String toString() {
        return "ord://" + this.ord + (this.ref == null ? "" : "#" + this.ref);
    }

    public boolean complete() {
        return true;
    }

    public int hashCode() {
        return this.ord.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof OrdParsedURLData)) {
            return false;
        }
        OrdParsedURLData ordParsedURLData = (OrdParsedURLData)object;
        if (!this.ord.equals((Object)ordParsedURLData.ord)) {
            return false;
        }
        if (this.ref == null) {
            return ordParsedURLData.ref == null;
        }
        return this.ref.equals(ordParsedURLData.ref);
    }

    protected boolean sameFile(ParsedURLData parsedURLData) {
        if (!(parsedURLData instanceof OrdParsedURLData)) {
            return false;
        }
        OrdParsedURLData ordParsedURLData = (OrdParsedURLData)parsedURLData;
        return this.ord.equals((Object)ordParsedURLData.ord);
    }
}

