/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.touchscreen.hx.alarm;

import com.tridium.alarm.hx.BHxAlarmConsole;
import com.tridium.hx.fieldeditors.BHxDefaultFE;
import com.tridium.hx.fieldeditors.BHxStringFE;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.queryTable.QueryUtil;
import com.tridium.queryTable.hx.BHxQueryTableView;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.ToggleCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridium.touchscreen.hx.TouchUtil;
import com.tridium.touchscreen.hx.alarm.BHxTouchAlarmDataFE;
import com.tridium.touchscreen.hx.alarm.BOpenAlarmsExtent;
import com.tridium.touchscreen.hx.alarm.BTouchAlarmConsoleProvider;
import java.util.LinkedHashMap;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.query.BExtent;
import javax.baja.query.BPredicate;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHxTouchAlarmConsoleView
extends BHxQueryTableView {
    public static final BHxTouchAlarmConsoleView INSTANCE = new BHxTouchAlarmConsoleView();
    public static final Type TYPE;
    private static BImage yellowAlarmImg;
    private static BImage redAlarmImg;
    private static BImage greenAlarmImg;
    private static BImage orangeAlarmImg;
    private static BImage whiteAlarmImg;
    protected ToggleCommand selectionType;
    protected SmartCommand detailsCommand;
    protected SmartCommand acknowledgeCommand = new AcknowledgeCommand((BHxView)this);
    protected SmartCommand forceClearCommand;
    protected SmartCommand showRecurring;
    protected SmartCommand showAll;
    static /* synthetic */ Class class$com$tridium$touchscreen$hx$alarm$BHxTouchAlarmConsoleView;
    static /* synthetic */ Class class$com$tridium$smartTableHx$SmartCommand;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

    public Type getType() {
        return TYPE;
    }

    public SmartCommand[] getButtonCommands(HxOp hxOp) {
        Class clazz = class$com$tridium$smartTableHx$SmartCommand;
        if (clazz == null) {
            clazz = class$com$tridium$smartTableHx$SmartCommand = BHxTouchAlarmConsoleView.class("[Lcom.tridium.smartTableHx.SmartCommand;", false);
        }
        Array array = new Array(clazz);
        array.addAll((Object[])new SmartCommand[]{this.acknowledgeCommand, this.detailsCommand, this.forceClearCommand, this.filterCommand, this.refreshCommand});
        if (this.getSourceOrdList(hxOp) == null) {
            array.add((Object)this.showRecurring);
        } else {
            array.add((Object)this.showAll);
        }
        array.add((Object)this.selectionType);
        return (SmartCommand[])array.trim();
    }

    public String getPageTitle(HxOp hxOp) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.getPageTitle(hxOp));
        BOrdList bOrdList = this.getSourceOrdList(hxOp);
        if (bOrdList != null) {
            stringBuffer.append(" - ");
            stringBuffer.append(Lexicon.make((String)BHxAlarmConsole.TYPE.getModule().getModuleName(), (Context)hxOp).getText("hx.showRecurring"));
        }
        return stringBuffer.toString();
    }

    public int minimumPageSize(HxOp hxOp) {
        if (TouchUtil.isUserAgentMobile(hxOp)) {
            return 6;
        }
        return 12;
    }

    public int defaultPageSize(HxOp hxOp) {
        if (TouchUtil.isUserAgentMobile(hxOp)) {
            return 6;
        }
        return 12;
    }

    public BQuery getQuery(HxOp hxOp) {
        BQuery bQuery = new BQuery();
        bQuery.from((BExtent)new BOpenAlarmsExtent(BAlarmRecord.TYPE.getTypeSpec()));
        bQuery.add("base", (BValue)BOrd.make((String)"alarm:"));
        bQuery.add(null, (BValue)new BTouchAlarmConsoleProvider());
        BOrdList bOrdList = this.getSourceOrdList(hxOp);
        if (bOrdList != null) {
            BPredicate bPredicate = new BPredicate(Predicates.eq((String)"source", (BSimple)bOrdList));
            bQuery.where(bPredicate);
        }
        BTouchAlarmConsoleProvider.addInitialAlarmQuery(bQuery, hxOp);
        return QueryUtil.getWorkingCopy((BQuery)bQuery, (Context)hxOp);
    }

    public String getRowKey(Type type, TableCursor tableCursor, HxOp hxOp) {
        BITable bITable = tableCursor.getTable();
        String string = "";
        Column column = bITable.getColumns().get("uuid");
        string = string + tableCursor.getString(column);
        column = bITable.getColumns().get("source");
        String string2 = tableCursor.getString(column);
        string2 = SlotPath.escape((String)string2);
        string = string + '.' + string2;
        return string;
    }

    public BImage getRowIcon(TableCursor tableCursor, HxOp hxOp) {
        try {
            Column column = tableCursor.getTable().getColumns().get("ackState");
            BAckState bAckState = BAckState.acked;
            BEnumRange bEnumRange = bAckState.getRange();
            int[] nArray = bEnumRange.getOrdinals();
            String string = tableCursor.getString(column);
            int n = 0;
            while (n < nArray.length) {
                if (bEnumRange.getDisplayTag(nArray[n], (Context)hxOp).equals(string)) {
                    bAckState = BAckState.make((int)nArray[n]);
                }
                ++n;
            }
            column = tableCursor.getTable().getColumns().get("sourceState");
            BSourceState bSourceState = BSourceState.alert;
            bEnumRange = bSourceState.getRange();
            nArray = bEnumRange.getOrdinals();
            string = tableCursor.getString(column);
            int n2 = 0;
            while (n2 < nArray.length) {
                if (bEnumRange.getDisplayTag(nArray[n2], (Context)hxOp).equals(string)) {
                    bSourceState = BSourceState.make((int)nArray[n2]);
                }
                ++n2;
            }
            if (bSourceState == BSourceState.alert) {
                return orangeAlarmImg;
            }
            if (bAckState == BAckState.acked && bSourceState != BSourceState.normal) {
                return yellowAlarmImg;
            }
            if (bAckState != BAckState.acked && bSourceState != BSourceState.normal) {
                return redAlarmImg;
            }
            if (bAckState != BAckState.acked && bSourceState == BSourceState.normal) {
                return greenAlarmImg;
            }
            return whiteAlarmImg;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public TableContents writeRows(BITable bITable, BQuery bQuery, HxOp hxOp) {
        TableContents.Td td;
        TableContents tableContents = super.writeRows(bITable, bQuery, hxOp);
        tableContents.addOnload("touchscreen.fixHeight();");
        if (this.selectionType.isSelected(hxOp)) {
            tableContents.className = "check";
        }
        if (this.getSourceOrdList(hxOp) != null) {
            return tableContents;
        }
        LinkedHashMap<String, TableContents.Td> linkedHashMap = new LinkedHashMap<String, TableContents.Td>();
        BPredicate bPredicate = bQuery.getPredicate();
        int n = -1;
        int n2 = 0;
        while (n2 < tableContents.columns.td.size()) {
            td = (TableContents.Td)tableContents.columns.td.get(n2);
            if (td.text.equals(BAlarmRecord.ackState.getDefaultDisplayName((Context)hxOp)) || td.text.equals(BAlarmRecord.ackState.getDefaultDisplayName(null))) {
                n = n2;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < tableContents.tr.size()) {
            TableContents.Td td2;
            td = (TableContents.Tr)tableContents.tr.get(n2);
            String string = TextUtil.split((String)td.id, (char)'.')[1];
            TableContents.Tr tr = (TableContents.Tr)linkedHashMap.get(string);
            if (tr == null) {
                td2 = (TableContents.Td)td.td.get(n);
                td2 = td2.text.equals(BAckState.unacked.getDisplayTag((Context)hxOp)) || td2.text.equals(BAckState.unacked.getDisplayTag(null)) ? new AlarmTd(0, 1, 0, hxOp) : (td2.text.equals(BAckState.acked.getDisplayTag((Context)hxOp)) || td2.text.equals(BAckState.acked.getDisplayTag(null)) ? new AlarmTd(1, 0, 0, hxOp) : new AlarmTd(0, 0, 1, hxOp));
                td.td.set(n, (Object)td2);
                linkedHashMap.put(string, td);
            } else {
                td2 = (TableContents.Td)td.td.get(n);
                AlarmTd alarmTd = (AlarmTd)((Object)tr.td.get(n));
                if (td2.text.equals(BAckState.unacked.getDisplayTag((Context)hxOp)) || td2.text.equals(BAckState.unacked.getDisplayTag(null))) {
                    ++alarmTd.unacked;
                } else if (td2.text.equals(BAckState.acked.getDisplayTag((Context)hxOp)) || td2.text.equals(BAckState.acked.getDisplayTag(null))) {
                    ++alarmTd.acked;
                } else {
                    ++alarmTd.ackPending;
                }
                alarmTd.setText(hxOp);
            }
            ++n2;
        }
        Object[] objectArray = linkedHashMap.values().toArray();
        tableContents.tr.clear();
        tableContents.tr.addAll(objectArray);
        return tableContents;
    }

    public BOrdList getSourceOrdList(HxOp hxOp) {
        String string = (String)hxOp.getRequest().getSession().getAttribute("source");
        if (string == null) {
            return null;
        }
        try {
            string = SlotPath.unescape((String)string);
            return BOrdList.make((String)string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public BAlarmRecord[] getRecords(HxOp hxOp) throws Exception {
        String[] stringArray = SmartCommand.getSelectionList((HxOp)hxOp);
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BHxTouchAlarmConsoleView.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < stringArray.length) {
            Cursor cursor;
            BICollection bICollection;
            BOrd bOrd;
            BUuid bUuid;
            String string = stringArray[n];
            if (this.scopeRowIds(hxOp)) {
                string = TextUtil.split((String)string, (char)'~')[1];
            }
            String[] stringArray2 = TextUtil.split((String)string, (char)'.');
            BOrdList bOrdList = this.getSourceOrdList(hxOp);
            if (bOrdList != null) {
                bUuid = BUuid.make((String)stringArray2[0]);
                bOrd = BOrd.make((String)("alarm:|bql:select * from openAlarms where uuid = Uuid '" + bUuid + '\''));
                bICollection = (BICollection)bOrd.resolve(hxOp.get()).get();
                cursor = bICollection.cursor();
                while (cursor.next()) {
                    BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
                    bAlarmRecord = (BAlarmRecord)bAlarmRecord.newCopy();
                    array.add((Object)bAlarmRecord);
                }
            } else {
                bOrdList = BOrdList.make((String)SlotPath.unescape((String)stringArray2[1]));
                bUuid = BOrd.make((String)("alarm:|bql:select * from openAlarms where source = OrdList '" + SlotPath.escape((String)bOrdList.encodeToString()) + '\''));
                bOrd = (BICollection)bUuid.resolve(hxOp.get()).get();
                bICollection = bOrd.cursor();
                while (bICollection.next()) {
                    cursor = (BAlarmRecord)bICollection.get();
                    cursor = (BAlarmRecord)cursor.newCopy();
                    array.add((Object)cursor);
                }
            }
            ++n;
        }
        return (BAlarmRecord[])array.trim();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BHxTouchAlarmConsoleView() {
        this.registerEvent((Event)this.acknowledgeCommand);
        this.detailsCommand = new DetailsCommand((BHxView)this);
        this.registerEvent((Event)this.detailsCommand);
        this.forceClearCommand = new ForceClearCommand((BHxView)this);
        this.registerEvent((Event)this.forceClearCommand);
        this.showRecurring = new ShowRecurring((BHxView)this);
        this.registerEvent((Event)this.showRecurring);
        this.showAll = new ShowAll((BHxView)this);
        this.registerEvent((Event)this.showAll);
        this.selectionType = new SelectionType((BHxView)this);
        this.registerEvent((Event)this.selectionType);
    }

    static {
        Class clazz = class$com$tridium$touchscreen$hx$alarm$BHxTouchAlarmConsoleView;
        if (clazz == null) {
            clazz = class$com$tridium$touchscreen$hx$alarm$BHxTouchAlarmConsoleView = BHxTouchAlarmConsoleView.class("[Lcom.tridium.touchscreen.hx.alarm.BHxTouchAlarmConsoleView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        yellowAlarmImg = BImage.make((String)"module://icons/x16/alarm.png");
        redAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmRed.png");
        greenAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmGreen.png");
        orangeAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmOrange.png");
        whiteAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmWhite.png");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class AlarmTd
    extends TableContents.Td {
        public int acked;
        public int unacked;
        public int ackPending;

        public void setText(HxOp hxOp) {
            this.text = this.ackPending == 0 ? "" + this.acked + ' ' + BAckState.acked.getDisplayTag((Context)hxOp) + " / " + this.unacked + ' ' + BAckState.unacked.getDisplayTag((Context)hxOp) : "" + this.acked + ' ' + BAckState.acked.getDisplayTag((Context)hxOp) + " / " + this.unacked + ' ' + BAckState.unacked.getDisplayTag((Context)hxOp) + " / " + this.ackPending + ' ' + BAckState.ackPending.getDisplayTag((Context)hxOp);
        }

        private final /* synthetic */ void this() {
            this.acked = 0;
            this.unacked = 0;
            this.ackPending = 0;
        }

        public AlarmTd() {
            this.this();
        }

        public AlarmTd(String string) {
            super(string);
            this.this();
        }

        public AlarmTd(int n, int n2, int n3, HxOp hxOp) {
            super("");
            this.this();
            this.acked = n;
            this.unacked = n2;
            this.ackPending = n3;
            this.setText(hxOp);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class AcknowledgeCommand
    extends SmartCommand {
        NotesDialog dialog = new NotesDialog("Notes", (Command)this);

        public String getName(HxOp hxOp) {
            return "ackAlarm";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean isDefaultAction() {
            return true;
        }

        public void handle(HxOp hxOp) throws Exception {
            boolean bl = false;
            if (!this.dialog.isSubmit(hxOp) && bl) {
                this.dialog.open(hxOp);
                return;
            }
            BString bString = BString.DEFAULT;
            if (bl) {
                bString = (BString)this.getNotesTab(hxOp).save();
            }
            BAlarmRecord[] bAlarmRecordArray = BHxTouchAlarmConsoleView.this.getRecords(hxOp);
            int n = 0;
            while (n < bAlarmRecordArray.length) {
                BHxAlarmConsole.INSTANCE.ackAlarm(bAlarmRecordArray[n], bString.toString(), hxOp);
                ++n;
            }
            BHxTouchAlarmConsoleView.this.reloadTable(hxOp);
        }

        public Tab getNotesTab(HxOp hxOp) {
            HxOp hxOp2 = hxOp.make("notes", (BObject)BString.DEFAULT, BFacets.make((String)"multiLine", (boolean)true));
            return new Tab((BHxView)BHxStringFE.INSTANCE, hxOp2, hxOp);
        }

        public AcknowledgeCommand(BHxView bHxView) {
            super(bHxView);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class NotesDialog
        extends Dialog {
            protected void writeContent(HxOp hxOp) throws Exception {
                AcknowledgeCommand.this.getNotesTab(hxOp).write();
            }

            public NotesDialog(String string, Command command) {
                super(string, command);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DetailsCommand
    extends SmartCommand {
        DetailsDialog dialog = new DetailsDialog("Alarm Details", (Command)this);

        public String getName(HxOp hxOp) {
            return "showAlarmDetails";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp hxOp) {
            return true;
        }

        public void handle(HxOp hxOp) throws Exception {
            if (!this.dialog.isSubmit(hxOp)) {
                this.dialog.open(hxOp);
                return;
            }
        }

        public boolean process(HxOp hxOp) throws Exception {
            if (!this.matchesScope(hxOp)) {
                return false;
            }
            return this.getTab(hxOp).process();
        }

        public Tab getTab(HxOp hxOp) throws Exception {
            BAlarmRecord bAlarmRecord = BHxTouchAlarmConsoleView.this.getRecords(hxOp)[0];
            bAlarmRecord = (BAlarmRecord)bAlarmRecord.newCopy();
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            String string = bAlarmService.getAlarmClassDisplayName((Object)BString.make((String)bAlarmRecord.getAlarmClass()), (Context)hxOp).toString();
            bAlarmRecord.setAlarmClass(string);
            String string2 = BHxDefaultFE.TYPE.toString();
            String[] stringArray = new String[]{"timestamp", "uuid", "sourceState", "ackState", "ackRequired", "source", "alarmClass", "priority", "normalTime", "ackTime", "user", "alarmData", "alarmTransition", "lastUpdate"};
            String[] stringArray2 = new String[]{string2, string2, string2, string2, string2, string2, string2, string2, string2, string2, string2, BHxTouchAlarmDataFE.TYPE.toString(), string2, string2};
            BFacets bFacets = BFacets.make((BFacets)BHxFieldSheet.getFieldsProvidedFacets((String[])stringArray), (BFacets)BHxFieldSheet.getFieldEditorsProvidedFacets((String[])stringArray2));
            HxOp hxOp2 = hxOp.make("showAlarmDetails", (BObject)bAlarmRecord, bFacets);
            return new Tab((BHxView)BHxFieldSheet.INSTANCE, hxOp2);
        }

        public DetailsCommand(BHxView bHxView) {
            super(bHxView);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class DetailsDialog
        extends Dialog {
            protected void writeContent(HxOp hxOp) throws Exception {
                DetailsCommand.this.getTab(hxOp).write();
            }

            public Command[] getCommands() {
                return new Command[]{this.makeSubmitCommand()};
            }

            public DetailsDialog(String string, Command command) {
                super(string, command);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ForceClearCommand
    extends SmartCommand {
        public String getName(HxOp hxOp) {
            return "forceClear";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp hxOp) throws Exception {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmRecord[] bAlarmRecordArray = BHxTouchAlarmConsoleView.this.getRecords(hxOp);
            int n = 0;
            while (n < bAlarmRecordArray.length) {
                BAlarmRecord bAlarmRecord = bAlarmRecordArray[n];
                BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
                hxOp.getUser().check((BIProtected)bAlarmClass, BPermissions.adminWrite);
                bAlarmRecord.setUser(hxOp.getUser().getUsername());
                bAlarmRecord.setAckTime(BAbsTime.now());
                bAlarmRecord.setAckState(BAckState.acked);
                bAlarmRecord.setSourceState(BSourceState.normal);
                bAlarmRecord.addAlarmFacet("forceCleared", (BIDataValue)BString.make((String)hxOp.getUser().getUsername()));
                try {
                    bAlarmService.getAlarmDb().update(bAlarmRecord);
                    bAlarmService.invoke(BAlarmService.auditForceClear, (BValue)bAlarmRecord, (Context)hxOp);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
            BHxTouchAlarmConsoleView.this.reloadTable(hxOp);
        }

        public ForceClearCommand(BHxView bHxView) {
            super(bHxView);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ShowRecurring
    extends SmartCommand {
        public String getName(HxOp hxOp) {
            return "showRecurring";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp hxOp) throws Exception {
            String[] stringArray = SmartCommand.getSelectionList((HxOp)hxOp);
            Class clazz = class$javax$baja$alarm$BAlarmRecord;
            if (clazz == null) {
                clazz = class$javax$baja$alarm$BAlarmRecord = BHxTouchAlarmConsoleView.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
            }
            Array array = new Array(clazz);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (BHxTouchAlarmConsoleView.this.scopeRowIds(hxOp)) {
                    string = TextUtil.split((String)string, (char)'~')[1];
                }
                String[] stringArray2 = TextUtil.split((String)string, (char)'.');
                string = TextUtil.replace((String)stringArray2[1], (String)" ", (String)"|");
                hxOp.getRequest().getSession().setAttribute("source", (Object)string);
                this.refresh(hxOp);
                ++n;
            }
        }

        public ShowRecurring(BHxView bHxView) {
            super(bHxView);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ShowAll
    extends SmartCommand {
        public String getName(HxOp hxOp) {
            return "showAll";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp hxOp) throws Exception {
            hxOp.getRequest().getSession().setAttribute("source", null);
            this.refresh(hxOp);
        }

        public ShowAll(BHxView bHxView) {
            super(bHxView);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SelectionType
    extends ToggleCommand {
        public String getName(HxOp hxOp) {
            return "selectionType";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean isSelected(HxOp hxOp) {
            BBoolean bBoolean = (BBoolean)hxOp.getRequest().getSession().getAttribute("selectionType");
            boolean bl = false;
            if (bBoolean != null && bBoolean == BBoolean.TRUE) {
                bl = true;
            }
            return bl;
        }

        public boolean handle(boolean bl, HxOp hxOp) throws Exception {
            hxOp.getRequest().getSession().setAttribute("selectionType", (Object)BBoolean.make((boolean)(bl ^= true)));
            HtmlWriter htmlWriter = hxOp.getHtmlWriter();
            if (bl) {
                htmlWriter.w((Object)"$('").w((Object)hxOp.scope("records")).w((Object)"').className = 'check loaded';");
            } else {
                htmlWriter.w((Object)"$('").w((Object)hxOp.scope("records")).w((Object)"').className = 'loaded';");
            }
            return bl;
        }

        public SelectionType(BHxView bHxView) {
            super(bHxView);
        }
    }
}

