/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.touchscreen.hx;

import com.tridium.alarm.hx.BHxAlarmConsole;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.touchscreen.hx.chart.BHxPxFlashChartDataView;
import com.tridium.touchscreen.hx.chart.BHxPxFlashChartPane;
import com.tridium.touchscreen.hx.chart.BHxTouchHistoryChart;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.util.BTypeSpec;
import javax.baja.util.TextUtil;
import javax.baja.workbench.view.BWbView;

public abstract class TouchUtil {
    public static TouchAgentFilter touchAgentFilter = new TouchAgentFilter();
    public static String[] notTouchscreenFriendly = new String[]{BHxAlarmConsole.TYPE.toString(), BAlarmConsole.TYPE.toString(), "chart:HxPxChartPane", "history:HistoryChartBuilder", "history:HxHistoryChartBuilder", "pxEditor:PxEditor", "hx:HxPxChartPane", "hx:HxPxCheckbox", "hx:HxPxValueBinding"};
    private static final String IESIMPLE = "MISE 6.0 SIMPLE";
    private static final String IESIMPLE_COMMENT = "Windows CE";

    public static void registerKeyboard(HxOp hxOp) throws Exception {
        TouchUtil.addTouchStyle(hxOp);
        hxOp.addJavaScript("module://touchscreen/rc/touchscreen.js");
        hxOp.addJavaScript("module://touchscreen/rc/keypad.js");
        hxOp.addJavaScript("module://touchscreen/rc/selectKeypad.js");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("touchscreen.attachKeyboard(document.body);");
        stringBuffer.append("hx.dialogOnload=&quot;touchscreen.attachKeyboard(document.body);&quot;;");
        stringBuffer.append("try{ save.skipConfirm=true; }catch(err){}");
        stringBuffer.append("touchscreen.init();");
        hxOp.addOnload(stringBuffer.toString());
        TouchUtil.preloadImages(false, hxOp.getHtmlWriter());
    }

    public static void registerLoginKeyboard(HtmlWriter htmlWriter) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("touchscreen.login=true;");
        stringBuffer.append("touchscreen.attachKeyboard(document.body);");
        stringBuffer.append("hx.dialogOnload='touchscreen.attachKeyboard(document.body);';");
        stringBuffer.append("try{ save.skipConfirm=true; }catch(err){}");
        stringBuffer.append("touchscreen.init();");
        htmlWriter.println("<script type='text/javascript'> \n" + stringBuffer.toString() + " \n</script>");
        TouchUtil.preloadImages(true, htmlWriter);
    }

    public static void preloadImages(boolean bl, HtmlWriter htmlWriter) throws Exception {
        htmlWriter.w((Object)"<div id='preload' style='position:absolute;left:-10000px;top:0px;width:3500px;height:50px;'>");
        BINavNode bINavNode = (BINavNode)BOrd.make((String)"module://touchscreen/rc/images").get();
        BINavNode[] bINavNodeArray = bINavNode.getNavChildren();
        int n = 0;
        while (n < bINavNodeArray.length) {
            block4: {
                String string;
                block3: {
                    string = bINavNodeArray[n].getNavOrd().toString();
                    if (!bl) break block3;
                    if (!TextUtil.toLowerCase((String)bINavNodeArray[n].getNavName()).equals(bINavNodeArray[n].getNavName())) break block4;
                    string = "login/touch/images/" + bINavNodeArray[n].getNavName();
                }
                htmlWriter.w((Object)"<img src='").w((Object)string).w((Object)"' alt='loader image' />");
            }
            ++n;
        }
        htmlWriter.w((Object)"</div>");
    }

    public static void addTouchStyle(HxOp hxOp) {
        hxOp.addStyleSheet("module://touchscreen/rc/keyboard.css");
        hxOp.addStyleSheet("module://touchscreen/rc/touchscreen.css");
    }

    public static void updateKeyboard(HxOp hxOp) throws Exception {
        hxOp.getHtmlWriter().w((Object)"touchscreen.attachKeyboard(document.body); touchscreen.reconnect();");
    }

    public static String getAppName() {
        return "touchscreen";
    }

    public static boolean hasView(BObject bObject, AgentInfo agentInfo) {
        BTypeSpec bTypeSpec;
        int n = 0;
        while (n < notTouchscreenFriendly.length) {
            if (agentInfo.getAgentType().toString().equals(notTouchscreenFriendly[n])) {
                return false;
            }
            ++n;
        }
        if (agentInfo.getAgentType().is(BWbView.TYPE)) {
            AgentList agentList = Sys.getRegistry().getAgents(agentInfo.getAgentType());
            agentList = agentList.filter((AgentFilter)touchAgentFilter);
            boolean bl = false;
            if (agentList.size() > 0) {
                bl = true;
            }
            return bl;
        }
        return !bObject.getType().is(BIHistory.TYPE) || !agentInfo.getAgentType().is(BHxPxFlashChartDataView.TYPE) && !agentInfo.getAgentType().is(BHxPxFlashChartPane.TYPE) && !agentInfo.getAgentType().is(BHxTouchHistoryChart.TYPE) || (bTypeSpec = ((BIHistory)bObject).getRecordType()).getResolvedType().is(BNumericTrendRecord.TYPE);
    }

    public static boolean isUserAgentMobile(HxOp hxOp) {
        boolean bl = false;
        if (TouchUtil.isUserAgentIESimple(hxOp) || TouchUtil.isUserAgentIris(hxOp)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isUserAgentIESimple(HxOp hxOp) {
        if (hxOp.getUserAgent().isIE()) {
            String[] stringArray = hxOp.getUserAgent().getComments();
            if (stringArray == null) {
                return false;
            }
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].indexOf(IESIMPLE_COMMENT) > -1) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static boolean isUserAgentIris(HxOp hxOp) {
        boolean bl = false;
        if (hxOp.getUserAgent().toString().indexOf("Iris") > -1) {
            bl = true;
        }
        return bl;
    }

    public static class TouchAgentFilter
    extends AgentFilter {
        public boolean include(AgentInfo agentInfo) {
            return agentInfo.getAgentType().is(BHxView.TYPE) && !agentInfo.getAgentType().toString().equals("hx:HxPxWbView") && !agentInfo.getAgentType().toString().equals("entsecHx:HxPxWbWrapper");
        }
    }
}

