/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.mgr;

import java.util.ArrayList;
import javax.baja.hx.mgr.BHxAbstractManager;
import javax.baja.hx.mgr.HxMgrColumn;
import javax.baja.hx.mgr.HxMgrCommand;
import javax.baja.hx.mgr.MgrOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Type;

public class HxMgrModel {
    MgrOp op;
    BComponent[] rows;
    HxMgrColumn[] cols;
    HxMgrColumn[] editable;
    HxMgrCommand[] cmds;

    public void init(MgrOp mgrOp) {
        this.op = mgrOp;
        this.rows = this.makeRows();
        this.cols = (HxMgrColumn[])this.makeColumns().clone();
        this.cmds = (HxMgrCommand[])this.makeCommands().clone();
        ArrayList<HxMgrColumn> arrayList = new ArrayList<HxMgrColumn>();
        int n = 0;
        while (n < this.cols.length) {
            HxMgrColumn hxMgrColumn = this.cols[n];
            hxMgrColumn.init(this);
            if (hxMgrColumn.isEditable()) {
                arrayList.add(hxMgrColumn);
            }
            ++n;
        }
        this.editable = arrayList.toArray(new HxMgrColumn[arrayList.size()]);
    }

    public final MgrOp getMgrOp() {
        return this.op;
    }

    public final BComponent[] getRows() {
        return this.rows;
    }

    public String toRowValue(BComponent bComponent, int n) {
        return Integer.toString(n);
    }

    public int valueToIndex(String string) {
        return Integer.parseInt(string);
    }

    public BComponent valueToComponent(String string) {
        return this.rows[this.valueToIndex(string)];
    }

    public final HxMgrColumn[] getColumns() {
        return (HxMgrColumn[])this.cols.clone();
    }

    public final HxMgrColumn getColumn(int n) {
        return this.cols[n];
    }

    public final HxMgrColumn[] getEditableColumns() {
        return (HxMgrColumn[])this.editable.clone();
    }

    public final HxMgrCommand[] getCommands() {
        return (HxMgrCommand[])this.cmds.clone();
    }

    public String getTableTitle() {
        return BHxAbstractManager.lexDatabaseObjects;
    }

    public String getRowType() {
        return "objects";
    }

    public Type[] getNewTypes() {
        return null;
    }

    public Type[] getIncludeTypes() {
        return new Type[]{BComponent.TYPE};
    }

    public boolean accept(BComponent bComponent) {
        return true;
    }

    public BComponent newInstance(Type type) throws Exception {
        return (BComponent)type.getInstance();
    }

    protected BComponent[] makeRows() {
        BComponent[] bComponentArray = this.op.get().asComponent().getChildComponents();
        Type[] typeArray = this.getIncludeTypes();
        ArrayList<BComponent> arrayList = new ArrayList<BComponent>();
        int n = 0;
        while (n < bComponentArray.length) {
            BComponent bComponent = bComponentArray[n];
            int n2 = 0;
            while (n2 < typeArray.length) {
                if (bComponent.getType().is(typeArray[n2]) && this.accept(bComponent)) {
                    arrayList.add(bComponentArray[n]);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new BComponent[arrayList.size()]);
    }

    protected HxMgrColumn[] makeColumns() {
        return new HxMgrColumn[]{new HxMgrColumn.Name(), new HxMgrColumn.Type()};
    }

    protected HxMgrCommand[] makeCommands() {
        return new HxMgrCommand[0];
    }
}

