/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx;

import com.tridium.net.BHttpsScheme;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.file.BIFile;
import javax.baja.hx.BHxProfile;
import javax.baja.hx.HxUtil;
import javax.baja.hx.MultiPartForm;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;
import javax.baja.web.WebOp;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HxOp
extends WebOp {
    private BComplex delegate;
    private HashMap config;
    private BFacets facets;
    private boolean readonly;
    private String path;
    private String[] keys;
    private HxDocument document;
    private boolean mounted;

    public HxOp make(OrdTarget ordTarget) {
        return this.make(this.getUniqueName(ordTarget), ordTarget);
    }

    public HxOp make(String string, OrdTarget ordTarget) {
        HxOp hxOp = new HxOp(string, ordTarget, this);
        hxOp.mounted = this.mounted;
        return hxOp;
    }

    public HxOp make(String string, BObject bObject, BFacets bFacets) {
        HxOp hxOp = this.make(string, new OrdTarget((OrdTarget)this, bObject));
        hxOp.mergeFacets(bFacets);
        hxOp.mounted = false;
        return hxOp;
    }

    void loadPostBody() throws Exception {
        WebOp webOp = this.getWebOp();
        byte[] byArray = new byte[webOp.getRequest().getContentLength()];
        DataInputStream dataInputStream = new DataInputStream((InputStream)webOp.getRequest().getInputStream());
        dataInputStream.readFully(byArray);
        this.document.postBody = new String(byArray);
    }

    public BHxProfile getProfile() {
        return this.document.profile;
    }

    public WebOp getWebOp() {
        return this.document.webop;
    }

    public String getPath() {
        return this.path;
    }

    public BFacets getFacets() {
        return BFacets.make((BFacets)super.getFacets(), (BFacets)this.facets);
    }

    public HxOp mergeFacets(BFacets bFacets) {
        this.facets = BFacets.make((BFacets)this.facets, (BFacets)bFacets);
        return this;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    public boolean isMultiPartForm() {
        return this.document.multiPart;
    }

    public void setMultiPartForm() {
        this.document.multiPart = true;
    }

    public Lexicon getLexicon(String string) {
        Lexicon lexicon = (Lexicon)this.document.lexicons.get(string);
        if (lexicon == null) {
            lexicon = Lexicon.make((String)string, (Context)this);
            this.document.lexicons.put(string, lexicon);
        }
        return lexicon;
    }

    public void addCookie(String string, String string2) {
        Cookie cookie = new Cookie(string, string2);
        cookie.setPath("/");
        this.getResponse().addCookie(cookie);
    }

    public String getCookie(String string) {
        Cookie[] cookieArray = this.getRequest().getCookies();
        int n = 0;
        while (n < cookieArray.length) {
            if (cookieArray[n].getName().equals(string)) {
                return cookieArray[n].getValue();
            }
            ++n;
        }
        return null;
    }

    public void removeCookie(String string) {
        Cookie cookie = new Cookie(string, "");
        cookie.setPath("/");
        cookie.setMaxAge(0);
        this.getResponse().addCookie(cookie);
    }

    public Object getAttribute(String string) {
        return this.getRequest().getAttribute(string);
    }

    public String[] getAttributeNames() {
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = this.getRequest().getAttributeNames();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setAttribute(String string, Object object) {
        this.getRequest().setAttribute(string, object);
    }

    public BValue getConfig(String string, BValue bValue) {
        BValue bValue2;
        if (this.config != null && (bValue2 = (BValue)this.config.get(string)) != null) {
            return bValue2;
        }
        if (this.delegate != null && (bValue2 = this.delegate.get(string)) != null) {
            return bValue2;
        }
        return bValue;
    }

    public void setConfig(String string, BValue bValue) {
        if (this.config == null) {
            this.config = new HashMap();
        }
        this.config.put(string, bValue);
    }

    public void setConfig(BComplex bComplex) {
        this.delegate = bComplex;
    }

    public StringBuffer getContent() {
        return this.document.content.getBuffer();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.document.overrideWriter != null) {
            return this.document.overrideWriter;
        }
        return this.document.writer;
    }

    public PrintWriter setWriter(PrintWriter printWriter) throws IOException {
        this.document.overrideWriter = printWriter;
        return this.document.overrideWriter;
    }

    public PrintWriter resetWriter() throws IOException {
        this.document.overrideWriter = null;
        return null;
    }

    public boolean isDynamic() {
        return this.document.dynamic;
    }

    public void setDynamic() {
        this.document.dynamic = true;
    }

    public boolean isRaw() {
        return this.document.raw;
    }

    public void setRaw() {
        if (this.getRequest().getScheme().equals(BHttpsScheme.INSTANCE.getId()) && this.getUserAgent() != null && this.getUserAgent().isIE()) {
            this.getResponse().setHeader("Cache-Control", "");
        }
        this.document.raw = true;
    }

    public String scope(String string) {
        if (this.path.length() == 0) {
            return string;
        }
        return this.path + '.' + string;
    }

    public String getUniqueName() {
        return "uid" + this.document.id++;
    }

    public String getUniqueName(OrdTarget ordTarget) {
        if (ordTarget == null || !(ordTarget.get() instanceof BComplex)) {
            return this.getUniqueName();
        }
        return ((BComplex)ordTarget.get()).getName();
    }

    public void addHeadTag(String string) {
        if (!this.document.htags.contains(string)) {
            this.document.htags.add(string);
        }
    }

    public String[] getHeadTags() {
        return this.document.htags.toArray(new String[this.document.htags.size()]);
    }

    public void addStyleSheet(String string) {
        BOrd bOrd = BOrd.make((String)string);
        this.addStyleSheet(bOrd);
    }

    public void addStyleSheet(BOrd bOrd) {
        if (!this.document.styles.contains(bOrd)) {
            this.document.styles.add(bOrd);
            if (!this.getRequest().getMethod().toLowerCase().equals("get")) {
                this.addOnload("hx.addStyleSheet('" + bOrd + "');");
            }
        }
    }

    public String[] getStyleSheets() {
        String[] stringArray = new String[this.document.styles.size()];
        int n = 0;
        while (n < this.document.styles.size()) {
            stringArray[n] = this.document.styles.get(n).toString();
            ++n;
        }
        return stringArray;
    }

    public BOrd[] getStyleSheetOrds() {
        return this.document.styles.toArray(new BOrd[this.document.styles.size()]);
    }

    public void addJavaScript(String string) {
        BOrd bOrd = BOrd.make((String)string);
        this.addJavaScript(bOrd);
    }

    public void addJavaScript(BOrd bOrd) {
        if (!this.document.scripts.contains(bOrd)) {
            this.document.scripts.add(bOrd);
            if (!this.getRequest().getMethod().toLowerCase().equals("get")) {
                this.addOnload("hx.addJavaScript('" + bOrd + "');");
            }
        }
    }

    public String[] getJavaScript() {
        String[] stringArray = new String[this.document.scripts.size()];
        int n = 0;
        while (n < this.document.scripts.size()) {
            stringArray[n] = this.document.scripts.get(n).toString();
            ++n;
        }
        return stringArray;
    }

    public BOrd[] getJavaScriptOrds() {
        return this.document.scripts.toArray(new BOrd[this.document.scripts.size()]);
    }

    public void addOnload(String string) {
        this.document.onload.add(string);
    }

    public void addOnunload(String string) {
        this.document.onunload.add(string);
    }

    public void addOnresize(String string) {
        this.document.onresize.add(string);
    }

    public String[] getOnload() {
        return this.document.onload.toArray(new String[this.document.onload.size()]);
    }

    public String[] getOnunload() {
        return this.document.onunload.toArray(new String[this.document.onunload.size()]);
    }

    public String[] getOnresize() {
        return this.document.onresize.toArray(new String[this.document.onresize.size()]);
    }

    public void addGlobal(String string) {
        this.document.global.add(string);
    }

    public String[] getGlobal() {
        return this.document.global.toArray(new String[this.document.global.size()]);
    }

    public boolean isBajaScript() {
        return this.document.bajaScript;
    }

    public String getBajaScriptStartArg() {
        return this.document.bajaScriptStartArg;
    }

    public String getBajaScriptStopArg() {
        return this.document.bajaScriptStopArg;
    }

    public boolean isJQuery() {
        return this.document.jQuery;
    }

    public String getPostBody() {
        return this.document.postBody;
    }

    public void decodeFormValues() {
        if (this.document.form != null) {
            return;
        }
        if (this.isMultiPartForm()) {
            try {
                this.document.form = new MultiPartForm().decode(this);
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        } else {
            this.document.form = new HashMap();
            String[] stringArray = TextUtil.split((String)this.document.postBody, (char)'&');
            int n = 0;
            while (n < stringArray.length) {
                String[] stringArray2 = TextUtil.split((String)stringArray[n], (char)'=');
                this.document.form.put(HxUtil.decode(stringArray2[0]), HxUtil.decode(stringArray2[1]));
                ++n;
            }
        }
    }

    public boolean isFormPost() {
        return this.document.formPost;
    }

    public boolean isUpdate() {
        return this.document.update;
    }

    public boolean isAction() {
        return this.document.action;
    }

    public boolean isShowActionMenu() {
        return this.document.showActionMenu;
    }

    public String getFormValue(String string) {
        this.decodeFormValues();
        String string2 = null;
        if (this.path.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(this.path).append(".").append(string);
            string2 = (String)this.document.form.get(stringBuffer.toString());
        } else {
            string2 = (String)this.document.form.get(string);
        }
        return string2;
    }

    public String[] getFormKeys() {
        this.decodeFormValues();
        if (this.keys == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = this.document.form.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.path.length() == 0) {
                    arrayList.add(string);
                    continue;
                }
                if (!string.startsWith(this.path) || string.charAt(this.path.length()) != '.') continue;
                arrayList.add(string.substring(this.path.length() + 1));
            }
            this.keys = arrayList.toArray(new String[arrayList.size()]);
        }
        return this.keys;
    }

    public BIFile getFile(String string) {
        if (this.document.files == null) {
            return null;
        }
        if (this.path.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(this.path).append(".").append(string);
            string = stringBuffer.toString();
        }
        return (BIFile)this.document.files.get(string);
    }

    public String getRedirect() {
        return this.document.redirect;
    }

    public void setRedirect(String string) {
        this.document.redirect = string;
    }

    public boolean isErrorSent() {
        return this.document.error;
    }

    public void sendError(Exception exception) {
        this.sendError(500, exception);
    }

    public void sendError(int n, Exception exception) {
        try {
            boolean bl = ((BWebService)Sys.getService((Type)BWebService.TYPE)).getShowStackTrace();
            if (this.document.webop.getResponse().isCommitted()) {
                ServletOutputStream servletOutputStream = this.document.webop.getResponse().getOutputStream();
                if (bl) {
                    StringWriter stringWriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringWriter));
                    servletOutputStream.write(stringWriter.toString().getBytes());
                } else {
                    servletOutputStream.write(exception.toString().getBytes());
                }
            } else if (bl) {
                StringWriter stringWriter = new StringWriter();
                stringWriter.write("<pre><code>");
                exception.printStackTrace(new PrintWriter(stringWriter));
                stringWriter.write("</code></pre>");
                this.document.webop.getResponse().sendError(n, stringWriter.toString());
            } else {
                this.document.webop.getResponse().sendError(n, exception.toString());
            }
            this.document.error = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setProfile(BHxProfile bHxProfile) {
        this.document.profile = bHxProfile;
    }

    public boolean canWrite() {
        if (!this.mounted || this.getComponent() == null) {
            return this.readonly ^ true;
        }
        boolean bl = false;
        if (super.canWrite() && !this.readonly) {
            bl = true;
        }
        return bl;
    }

    void setFile(String string, BIFile bIFile) {
        if (this.document.files == null) {
            this.document.files = new HashMap();
        }
        this.document.files.put(string, bIFile);
    }

    void deleteTempFiles() throws Exception {
        if (this.document.files == null) {
            return;
        }
        Iterator iterator = this.document.files.values().iterator();
        while (iterator.hasNext()) {
            BIFile bIFile = (BIFile)iterator.next();
            bIFile.delete();
        }
    }

    public void bajaScript() {
        this.document.bajaScript = true;
    }

    public void setBajaScriptStartArg(String string) {
        this.document.bajaScript = true;
        this.document.bajaScriptStartArg = string;
    }

    public void setBajaScriptStopArg(String string) {
        this.document.bajaScript = true;
        this.document.bajaScriptStopArg = string;
    }

    public void jQuery() {
        this.document.jQuery = true;
    }

    private final /* synthetic */ void this() {
        this.delegate = null;
        this.config = null;
        this.facets = BFacets.NULL;
        this.readonly = false;
        this.path = "";
        this.keys = null;
        this.mounted = true;
    }

    protected HxOp(String string, OrdTarget ordTarget, HxOp hxOp) {
        super(ordTarget, hxOp.getService(), hxOp.getRequest(), hxOp.getResponse());
        this.this();
        this.document = hxOp.document;
        this.path = hxOp.path;
        if (hxOp.path.length() > 0) {
            this.path = this.path + '.';
        }
        this.path = this.path + string;
    }

    public HxOp(WebOp webOp) throws Exception {
        super((OrdTarget)webOp.getBase(), webOp.getService(), webOp.getRequest(), webOp.getResponse());
        String string;
        this.this();
        this.document = new HxDocument(webOp);
        if (webOp.getRequest().getMethod().equals("POST") && (string = webOp.getRequest().getContentType()) != null) {
            if (string.startsWith("application/x-www-form-urlencoded") || string.startsWith("multipart/form-data")) {
                if (string.startsWith("multipart/form-data")) {
                    this.setMultiPartForm();
                } else {
                    this.loadPostBody();
                }
                this.document.formPost = true;
                this.decodeFormValues();
            } else if (string.startsWith("application/x-niagara-hx-update")) {
                this.loadPostBody();
                this.document.update = true;
            } else if (string.startsWith("application/x-niagara-hx-action")) {
                this.loadPostBody();
                this.document.action = true;
            } else if (string.startsWith("application/x-niagara-hx-showActionMenu")) {
                this.loadPostBody();
                this.document.showActionMenu = true;
            } else {
                this.loadPostBody();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class HxDocument {
        WebOp webop;
        int id;
        HashMap lexicons;
        BHxProfile profile;
        boolean multiPart;
        ArrayList htags;
        ArrayList styles;
        ArrayList scripts;
        ArrayList onload;
        ArrayList onunload;
        ArrayList onresize;
        ArrayList global;
        StringWriter content;
        PrintWriter writer;
        PrintWriter overrideWriter;
        boolean dynamic;
        boolean raw;
        boolean error;
        boolean bajaScript;
        String bajaScriptStartArg;
        String bajaScriptStopArg;
        boolean jQuery;
        HashMap form;
        HashMap files;
        String postBody;
        boolean formPost;
        boolean update;
        boolean action;
        boolean showActionMenu;
        String redirect;

        private final /* synthetic */ void this() {
            this.id = 0;
            this.lexicons = new HashMap();
            this.multiPart = false;
            this.htags = new ArrayList();
            this.styles = new ArrayList();
            this.scripts = new ArrayList();
            this.onload = new ArrayList();
            this.onunload = new ArrayList();
            this.onresize = new ArrayList();
            this.global = new ArrayList();
            this.content = new StringWriter();
            this.writer = new PrintWriter(this.content);
            this.overrideWriter = null;
            this.dynamic = false;
            this.raw = false;
            this.error = false;
            this.bajaScript = false;
            this.bajaScriptStartArg = "";
            this.bajaScriptStopArg = "";
            this.jQuery = false;
            this.form = null;
            this.files = null;
            this.postBody = null;
            this.formPost = false;
            this.update = false;
            this.action = false;
            this.showActionMenu = false;
            this.redirect = null;
        }

        public HxDocument(WebOp webOp) {
            this.this();
            this.webop = webOp;
        }
    }
}

