/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.rte;

import com.tridium.hx.rte.BRichTextEditor;
import javax.baja.gx.BImage;
import javax.baja.hx.HxOp;
import javax.baja.sys.Context;
import javax.baja.ui.spell.BSpellChecker;
import javax.baja.util.Lexicon;

public class RteCommands {
    public static final Command separator = new Separator();
    public static final Command undo = new Undo();
    public static final Command redo = new Redo();
    public static final Command bold = new Bold();
    public static final Command italic = new Italic();
    public static final Command underline = new Underline();
    public static final Command hyperlink = new Hyperlink();
    public static final Command subscript = new Subscript();
    public static final Command superscript = new Superscript();
    public static final Command removeFormat = new RemoveFormat();
    public static final Command spellCheck = new SpellCheck();
    static BImage undoIcon = BImage.make((String)"module://icons/x16/undo.png");
    static BImage redoIcon = BImage.make((String)"module://icons/x16/redo.png");
    static BImage boldIcon = BImage.make((String)"module://icons/x16/bold.png");
    static BImage italicIcon = BImage.make((String)"module://icons/x16/italic.png");
    static BImage underlineIcon = BImage.make((String)"module://icons/x16/underline.png");
    static BImage hyperlinkIcon = BImage.make((String)"module://icons/x16/hyperlink.png");
    static BImage subscriptIcon = BImage.make((String)"module://icons/x16/subscript.png");
    static BImage superscriptIcon = BImage.make((String)"module://icons/x16/superscript.png");
    static BImage removeFormatIcon = BImage.make((String)"module://icons/x16/eraser.png");
    static BImage spellCheckIcon = BImage.make((String)"module://icons/x16/spelling.png");

    static String lex(String string, Context context) {
        return Lexicon.make((String)"hx", (Context)context).getText("rte." + string);
    }

    public static class Separator
    extends Command {
        public BImage getIcon() {
            return null;
        }

        public String getCode(HxOp hxOp) {
            return null;
        }
    }

    static class Undo
    extends BuiltinCommand {
        public BImage getIcon() {
            return undoIcon;
        }

        public String getCommandName() {
            return "undo";
        }

        public String getDescription(Context context) {
            return RteCommands.lex("undo", context);
        }

        public boolean enabled(HxOp hxOp) {
            return hxOp.getUserAgent().isIE() ^ true;
        }

        Undo() {
        }
    }

    static class Redo
    extends BuiltinCommand {
        public BImage getIcon() {
            return redoIcon;
        }

        public String getCommandName() {
            return "redo";
        }

        public String getDescription(Context context) {
            return RteCommands.lex("redo", context);
        }

        public boolean enabled(HxOp hxOp) {
            return hxOp.getUserAgent().isIE() ^ true;
        }

        Redo() {
        }
    }

    static class Bold
    extends BuiltinCommand {
        public BImage getIcon() {
            return boldIcon;
        }

        public String getCommandName() {
            return "bold";
        }

        public String getDescription(Context context) {
            return RteCommands.lex("bold", context);
        }

        Bold() {
        }
    }

    static class Italic
    extends BuiltinCommand {
        public BImage getIcon() {
            return italicIcon;
        }

        public String getCommandName() {
            return "italic";
        }

        public String getDescription(Context context) {
            return RteCommands.lex("italic", context);
        }

        Italic() {
        }
    }

    static class Underline
    extends BuiltinCommand {
        public BImage getIcon() {
            return underlineIcon;
        }

        public String getCommandName() {
            return "underline";
        }

        public String getDescription(Context context) {
            return RteCommands.lex("underline", context);
        }

        Underline() {
        }
    }

    static class Hyperlink
    extends Command {
        public BImage getIcon() {
            return hyperlinkIcon;
        }

        public String getCode(HxOp hxOp) {
            return "rte.createHyperlink();";
        }

        public String getDescription(Context context) {
            return RteCommands.lex("hyperlink", context);
        }

        Hyperlink() {
        }
    }

    static class Subscript
    extends BuiltinCommand {
        public BImage getIcon() {
            return subscriptIcon;
        }

        public String getCommandName() {
            return "subscript";
        }

        public String getDescription(Context context) {
            return RteCommands.lex("subscript", context);
        }

        Subscript() {
        }
    }

    static class Superscript
    extends BuiltinCommand {
        public BImage getIcon() {
            return superscriptIcon;
        }

        public String getCommandName() {
            return "superscript";
        }

        public String getDescription(Context context) {
            return RteCommands.lex("superscript", context);
        }

        Superscript() {
        }
    }

    static class RemoveFormat
    extends BuiltinCommand {
        public BImage getIcon() {
            return removeFormatIcon;
        }

        public String getCommandName() {
            return "removeformat";
        }

        public String getDescription(Context context) {
            return RteCommands.lex("removeFormat", context);
        }

        RemoveFormat() {
        }
    }

    static class SpellCheck
    extends Command {
        public BImage getIcon() {
            return spellCheckIcon;
        }

        public String getCode(HxOp hxOp) {
            return BRichTextEditor.INSTANCE.spellCheck.getInvokeCode(hxOp);
        }

        public String getDescription(Context context) {
            return RteCommands.lex("spellCheck", context);
        }

        public boolean enabled(HxOp hxOp) {
            BSpellChecker bSpellChecker = BSpellChecker.get();
            boolean bl = false;
            if (bSpellChecker != null) {
                bl = true;
            }
            return bl;
        }

        SpellCheck() {
        }
    }

    public static abstract class BuiltinCommand
    extends Command {
        public abstract String getCommandName();

        public String getCommandParams() {
            return null;
        }

        public String getCode(HxOp hxOp) {
            String string = this.getCommandName();
            String string2 = this.getCommandParams();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("rte.invoke(\"").append(string).append("\",");
            if (string2 == null) {
                stringBuffer.append(" null");
            } else {
                stringBuffer.append("\"").append(string2).append("\"");
            }
            stringBuffer.append(");");
            return stringBuffer.toString();
        }
    }

    public static abstract class Command {
        public abstract BImage getIcon();

        public abstract String getCode(HxOp var1);

        public String getDescription(Context context) {
            return null;
        }

        public boolean enabled(HxOp hxOp) {
            return true;
        }
    }
}

