/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.gx;

import com.tridium.web.WebUtil;
import java.util.Stack;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.BRectGeom;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BajaRuntimeException;
import javax.servlet.http.HttpServletRequest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HxGraphics
implements Graphics {
    private HxOp op;
    private HtmlWriter out;
    private Stack stack;
    private String id;
    private int width;
    private int height;
    private double tx;
    private double ty;
    private BBrush brush;
    private BPen pen;
    private BFont font;
    private IGeom clip;

    public static HxGraphics make(HxOp hxOp, String string, int n, int n2) throws Exception {
        return new HxGraphics(hxOp, string, n, n2);
    }

    public void useAntiAliasing(boolean bl) {
    }

    public BBrush getBrush() {
        return this.brush;
    }

    public void setBrush(BBrush bBrush) {
        this.brush = bBrush;
        BBrush.Paint paint = bBrush.getPaint();
        if (paint instanceof BBrush.LinearGradient) {
            BBrush.LinearGradient linearGradient = (BBrush.LinearGradient)paint;
            BBrush.Stop[] stopArray = linearGradient.getStops();
            double d = (linearGradient.getAngle() - 90.0) / 180.0 * Math.PI;
            double d2 = Math.sqrt(Math.pow(this.height, 2) + Math.pow(this.width, 2));
            Point point = new Point(-this.tx + ((double)this.width + Math.sin(d %= (double)2 * Math.PI) * d2) / (double)2, -this.ty + ((double)this.height + Math.cos(d) * d2) / (double)2);
            Point point2 = new Point(-this.tx + ((double)this.width + Math.sin(d) * -d2) / (double)2, -this.ty + ((double)this.height + Math.cos(d) * -d2) / (double)2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("hx.setLinearGradient(g,").append((int)point.x).append(",").append((int)point.y).append(",").append((int)point2.x).append(",").append((int)point2.y).append(",[");
            int n = 0;
            while (n < stopArray.length) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("[");
                stringBuffer.append(stopArray[n].getOffset());
                stringBuffer.append(",");
                stringBuffer.append("'").append(stopArray[n].getColor().toHtmlString()).append("'");
                stringBuffer.append("]");
                ++n;
            }
            stringBuffer.append("]);\n");
            this.out.w((Object)stringBuffer.toString());
        } else if (paint instanceof BBrush.RadialGradient) {
            BBrush.RadialGradient radialGradient = (BBrush.RadialGradient)paint;
            BColor bColor = radialGradient.getStops()[0].getColor();
            this.out.w((Object)("hx.setColor(g," + bColor.getRed() + ',' + bColor.getGreen() + ',' + bColor.getBlue() + ',' + (double)bColor.getAlpha() / 255.0 + ");\n"));
        } else if (paint instanceof BBrush.Image) {
            String string = WebUtil.toUri((OrdTarget)this.op, (HttpServletRequest)this.op.getRequest(), (BOrd)((BBrush.Image)paint).getImage().getOrdList().get(0));
            this.out.w((Object)"var imgBrush = new Image();\n");
            this.out.w((Object)"var imgBrushLoaded = false;\n");
            this.out.w((Object)"imgBrush.onLoad = new function() { imgBrushLoaded = true; };\n");
            this.out.w((Object)("imgBrush.src='" + string + "';\n"));
            this.out.w((Object)"while(!imgBrushLoaded);\n");
        } else {
            BColor bColor = paint instanceof BBrush.Solid ? ((BBrush.Solid)paint).getColor() : BColor.black;
            this.out.w((Object)("hx.setColor(g," + bColor.getRed() + ',' + bColor.getGreen() + ',' + bColor.getBlue() + ',' + (double)bColor.getAlpha() / 255.0 + ");\n"));
        }
    }

    public void setBrush(BColor bColor) {
        this.setBrush(bColor.toBrush());
    }

    public BPen getPen() {
        return this.pen;
    }

    public void setPen(BPen bPen) {
        this.pen = bPen;
        this.out.w((Object)("g.lineWidth = " + this.getPen().getWidth() + ";\n"));
    }

    public BFont getFont() {
        return this.font;
    }

    public void setFont(BFont bFont) {
        this.font = bFont;
        this.out.w((Object)"if(g.font){\n");
        this.out.w((Object)"g.font = '");
        if (bFont.isBold()) {
            this.out.w((Object)"bold ");
        }
        if (bFont.isUnderline()) {
            this.out.w((Object)"underline ");
        }
        if (bFont.isItalic()) {
            this.out.w((Object)"italics ");
        }
        this.out.w((int)bFont.getSize()).w((Object)"px ");
        if (bFont.getName().equals("monospaced")) {
            this.out.w((Object)"Courier New");
        } else {
            this.out.w((Object)bFont.getName());
        }
        this.out.w((Object)"';\n");
        this.out.w((Object)"}\n");
    }

    public void transform(BTransform bTransform) {
        if (bTransform == null) {
            return;
        }
        BTransform.Transform[] transformArray = bTransform.getTransforms();
        int n = 0;
        while (n < transformArray.length) {
            BTransform.Transform transform = transformArray[n];
            switch (transform.getTransformCase()) {
                case 2: {
                    BTransform.Scale scale = (BTransform.Scale)transform;
                    if (Double.isNaN(scale.getY()) || Double.isNaN(scale.getX())) break;
                    this.out.w((Object)("g.scale(" + scale.getX() + ',' + scale.getY() + ");\n"));
                    break;
                }
                case 1: {
                    BTransform.Translate translate = (BTransform.Translate)transform;
                    this.translate(translate.getX(), translate.getY());
                    break;
                }
                case 3: {
                    BTransform.Rotate rotate = (BTransform.Rotate)transform;
                    this.out.w((Object)("g.rotate(" + rotate.getAngle() / 180.0 * Math.PI + ");\n"));
                }
            }
            ++n;
        }
    }

    public void translate(double d, double d2) {
        this.tx += d;
        this.ty += d2;
        this.out.w((Object)("g.translate(" + (int)d + ',' + (int)d2 + ");\n"));
        if (this.clip != null) {
            IRectGeom iRectGeom = this.clip.bounds();
            this.clip = BRectGeom.make((double)(iRectGeom.x() - d), (double)(iRectGeom.y() - d2), (double)iRectGeom.width(), (double)iRectGeom.height());
        }
    }

    public IGeom getClip() {
        return this.clip;
    }

    public IRectGeom getClipBounds() {
        return this.getClip().bounds();
    }

    public void clip(IGeom iGeom) {
        this.clip = this.clip != null ? iGeom.intersection(this.clip) : iGeom;
        IRectGeom iRectGeom = this.clip.bounds();
        this.out.w((Object)("hx.clipRect(g," + (int)iRectGeom.x() + ',' + (int)iRectGeom.y() + ',' + (int)iRectGeom.width() + ',' + (int)iRectGeom.height() + ");\n"));
    }

    public void clip(double d, double d2, double d3, double d4) {
        this.clip((IGeom)new RectGeom(d, d2, d3, d4));
    }

    public void stroke(IGeom iGeom) {
        switch (iGeom.getGeomCase()) {
            case 1: {
                ILineGeom iLineGeom = (ILineGeom)iGeom;
                this.strokeLine(iLineGeom.x1(), iLineGeom.y1(), iLineGeom.x2(), iLineGeom.y2());
                break;
            }
            case 2: {
                IRectGeom iRectGeom = (IRectGeom)iGeom;
                this.strokeRect(iRectGeom.x(), iRectGeom.y(), iRectGeom.width(), iRectGeom.height());
                break;
            }
            case 3: {
                this.drawEllipse((IEllipseGeom)iGeom);
                break;
            }
            case 4: {
                this.drawPolygon((IPolygonGeom)iGeom);
                break;
            }
            case 5: {
                this.drawPath((IPathGeom)iGeom);
                break;
            }
        }
        this.out.w((Object)"g.stroke();\n");
    }

    public void fill(IGeom iGeom) {
        switch (iGeom.getGeomCase()) {
            case 2: {
                IRectGeom iRectGeom = (IRectGeom)iGeom;
                this.fillRect(iRectGeom.x(), iRectGeom.y(), iRectGeom.width(), iRectGeom.height());
                break;
            }
            case 3: {
                this.drawEllipse((IEllipseGeom)iGeom);
                break;
            }
            case 4: {
                this.drawPolygon((IPolygonGeom)iGeom);
                break;
            }
            case 5: {
                this.drawPath((IPathGeom)iGeom);
                break;
            }
        }
        this.out.w((Object)"g.fill();\n");
    }

    public void strokeLine(double d, double d2, double d3, double d4) {
        this.out.w((Object)("hx.strokeLine(g," + (int)d + ',' + (int)d2 + ',' + (int)d3 + ',' + (int)d4 + ");\n"));
    }

    public void strokeRect(double d, double d2, double d3, double d4) {
        this.out.w((Object)("g.strokeRect(" + (int)d + ',' + (int)d2 + ',' + (int)d3 + ',' + (int)d4 + ");\n"));
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        this.out.w((Object)("g.fillRect(" + (int)d + ',' + (int)d2 + ',' + (int)d3 + ',' + (int)d4 + ");\n"));
    }

    public void drawString(String string, double d, double d2) {
        if (this.brush.isNull()) {
            return;
        }
        try {
            d = this.tx + d;
            d2 = this.ty + d2 - this.font.getAscent();
            this.out.w((Object)"if(g.fillText){\n");
            this.out.w((Object)("g.fillText(\"" + string + "\"," + (int)(d - this.tx) + ',' + (int)(d2 - this.ty + (double)2) + ");\n"));
            this.out.w((Object)"} else {\n");
            this.out.w((Object)"hx.drawString('").w((Object)this.id).w((Object)("',\"" + string + "\",'" + HxUtil.makeColor(this.brush, BColor.black).toHtmlString() + "','" + HxUtil.makeFont(this.font) + "'," + (int)d + ',' + (int)d2 + ");\n"));
            this.out.w((Object)"}\n");
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void drawString(char[] cArray, int n, int n2, double d, double d2) {
        this.drawString(new String(cArray, n, n2), d, d2);
    }

    public void drawImage(BImage bImage, double d, double d2) {
        if (bImage.getOrdList().size() > 0) {
            this.out.w((Object)"if(g.drawImage) {\n");
            String string = WebUtil.toUri((OrdTarget)this.op, (HttpServletRequest)this.op.getRequest(), (BOrd)bImage.getOrdList().get(0));
            this.out.w((Object)"var img = new Image();\n");
            this.out.w((Object)("img.src='" + string + "';\n"));
            this.out.w((Object)("g.drawImage(img, " + (int)d + ',' + (int)d2 + ");"));
            this.out.w((Object)"}\n");
        }
    }

    private final void drawEllipse(IEllipseGeom iEllipseGeom) {
        int n = (int)((iEllipseGeom.height() + iEllipseGeom.width()) / (double)4);
        this.out.w((Object)"g.beginPath();\n");
        this.out.w((Object)("g.arc(" + (int)(iEllipseGeom.x() + (double)n) + ',' + (int)(iEllipseGeom.y() + (double)n) + ',' + n + ",0, Math.PI*2, false);\n"));
    }

    private final void drawPolygon(IPolygonGeom iPolygonGeom) {
        this.out.w((Object)"g.beginPath();\n");
        int n = 0;
        while (n < iPolygonGeom.size()) {
            int n2 = (int)iPolygonGeom.x(n);
            int n3 = (int)iPolygonGeom.y(n);
            if (n == 0) {
                this.out.w((Object)("g.moveTo(" + n2 + ',' + n3 + ");\n"));
            } else {
                this.out.w((Object)("g.lineTo(" + n2 + ',' + n3 + ");\n"));
            }
            ++n;
        }
        this.out.w((Object)"g.closePath();\n");
    }

    private final void drawPath(IPathGeom iPathGeom) {
        this.out.w((Object)"g.beginPath();\n");
        int n = 0;
        while (n < iPathGeom.size()) {
            int n2;
            int n3;
            int n4;
            int n5;
            IPathGeom.Segment segment = iPathGeom.segment(n);
            if (segment instanceof IPathGeom.ClosePath) {
                this.out.w((Object)"g.closePath();\n");
            }
            if (segment instanceof IPathGeom.MoveTo) {
                n5 = (int)((IPathGeom.MoveTo)segment).getX();
                n4 = (int)((IPathGeom.MoveTo)segment).getY();
                this.out.w((Object)("g.moveTo(" + n5 + ',' + n4 + ");\n"));
            }
            if (segment instanceof IPathGeom.LineTo) {
                n5 = (int)((IPathGeom.LineTo)segment).getX();
                n4 = (int)((IPathGeom.LineTo)segment).getY();
                this.out.w((Object)("g.lineTo(" + n5 + ',' + n4 + ");\n"));
            }
            if (segment instanceof IPathGeom.CurveTo) {
                n5 = (int)((IPathGeom.CurveTo)segment).getX();
                n4 = (int)((IPathGeom.CurveTo)segment).getY();
                n3 = (int)((IPathGeom.CurveTo)segment).getX1();
                n2 = (int)((IPathGeom.CurveTo)segment).getY1();
                int n6 = (int)((IPathGeom.CurveTo)segment).getX2();
                int n7 = (int)((IPathGeom.CurveTo)segment).getY2();
                this.out.w((Object)("g.bezierCurveTo(" + n3 + ',' + n2 + ',' + n6 + ',' + n7 + ',' + n5 + ',' + n4 + ");\n"));
            }
            if (segment instanceof IPathGeom.SmoothCurveTo) {
                n5 = (int)((IPathGeom.SmoothCurveTo)segment).getX();
                n4 = (int)((IPathGeom.SmoothCurveTo)segment).getY();
                n3 = (int)((IPathGeom.SmoothCurveTo)segment).getX2();
                n2 = (int)((IPathGeom.SmoothCurveTo)segment).getY2();
                this.out.w((Object)("g.quadraticCurveTo(" + n3 + ',' + n2 + ',' + n5 + ',' + n4 + ");\n"));
            }
            if (segment instanceof IPathGeom.QuadTo) {
                n5 = (int)((IPathGeom.QuadTo)segment).getX();
                n4 = (int)((IPathGeom.QuadTo)segment).getY();
                n3 = (int)((IPathGeom.QuadTo)segment).getX1();
                n2 = (int)((IPathGeom.QuadTo)segment).getY1();
                this.out.w((Object)("g.quadraticCurveTo(" + n3 + ',' + n2 + ',' + n5 + ',' + n4 + ");\n"));
            }
            if (segment instanceof IPathGeom.SmoothQuadTo) {
                n5 = (int)((IPathGeom.SmoothQuadTo)segment).getX();
                n4 = (int)((IPathGeom.SmoothQuadTo)segment).getY();
                this.out.w((Object)("g.quadraticCurveTo(" + n5 + ',' + n4 + ',' + n5 + ',' + n4 + ");\n"));
            }
            if (segment instanceof IPathGeom.ArcTo) {
                n5 = (int)((IPathGeom.ArcTo)segment).getX();
                n4 = (int)((IPathGeom.ArcTo)segment).getY();
                this.out.w((Object)("g.lineTo(" + n5 + ',' + n4 + ");\n"));
            }
            ++n;
        }
    }

    public void clear(int n, int n2) {
        this.out.w((Object)"hx.clearCanvas(g,'").w(n).w((Object)"','").w(n2).w((Object)"','").w((Object)this.id).w((Object)"');\n");
    }

    public void clear() {
        this.clear(this.width, this.height);
    }

    public void push() {
        this.out.w((Object)"g.save();\n");
        GxState gxState = new GxState();
        gxState.tx = this.tx;
        gxState.ty = this.ty;
        gxState.brush = this.brush;
        gxState.pen = this.pen;
        gxState.font = this.font;
        gxState.clip = this.clip;
        this.stack.push(gxState);
    }

    public void pop() {
        this.out.w((Object)"g.restore();\n");
        GxState gxState = (GxState)this.stack.pop();
        this.tx = gxState.tx;
        this.ty = gxState.ty;
        this.brush = gxState.brush;
        this.pen = gxState.pen;
        this.font = gxState.font;
        this.clip = gxState.clip;
    }

    public void dispose() {
        this.out.w((Object)"}\n");
    }

    private final /* synthetic */ void this() {
        this.stack = new Stack();
        this.tx = 0.0;
        this.ty = 0.0;
    }

    private HxGraphics(HxOp hxOp, String string, int n, int n2) throws Exception {
        this.this();
        this.op = hxOp;
        this.out = hxOp.getHtmlWriter();
        this.id = string;
        this.width = n;
        this.height = n2;
        this.out.w((Object)"{\n");
        this.out.w((Object)"var g = document.getElementById('").w((Object)string).w((Object)"').getContext('2d');\n");
        this.out.w((Object)"g.textAlign='left';");
        this.out.w((Object)"g.textBaseline='top';");
        this.setBrush(BBrush.DEFAULT);
        this.setFont(BFont.DEFAULT);
        this.setPen(BPen.DEFAULT);
        this.clip(0.0, 0.0, n, n2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class GxState {
        public double tx;
        public double ty;
        public BBrush brush;
        public BPen pen;
        public BFont font;
        public IGeom clip;

        GxState() {
        }
    }
}

