/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.event;

import com.tridium.event.BNiagaraEventDeviceExt;
import com.tridium.fox.message.FoxBlob;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nd.BNiagaraStation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.event.BEvent;
import javax.baja.event.BEventService;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BEventChannel
extends BFoxChannel {
    public static final Type TYPE;
    public static final String CHANNEL_NAME = "Event";
    private Queue queue;
    static /* synthetic */ Class class$com$tridium$event$BEventChannel;
    static /* synthetic */ Class class$com$tridium$event$BNiagaraEventDeviceExt;

    public Type getType() {
        return TYPE;
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (BEventService.log.isTraceOn()) {
            BEventService.log.trace("Request received '" + string + '\'');
        }
        if (string.equals("event")) {
            return this.event(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Throwable {
        String string = foxCircuit.command;
        if (BEventService.log.isTraceOn()) {
            BEventService.log.trace("Circuit open '" + string + '\'');
        }
        if (!string.equals("eventStream")) {
            throw new InvalidCommandException(string);
        }
        this.event(foxCircuit);
    }

    public synchronized void sendEvent(BEvent bEvent) {
        this.sendEvent(bEvent, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void sendEvent(BEvent bEvent, boolean bl) {
        BEventService.log.trace("Sending event.");
        try {
            try {
                ((BNiagaraStation)this.getConnection().getParent()).engageNoRetry("eventChannel", 5000L);
                this.sendAsync(this.makeRequest(bEvent));
                this.getDeviceExt().setLastSendTime(BAbsTime.now());
            }
            catch (Exception exception) {
                if (BEventService.log.isTraceOn()) {
                    BEventService.log.error("Unable to send event.", (Throwable)exception);
                }
                if (bl) {
                    this.queue.enqueue((Object)bEvent);
                }
                this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
                this.getDeviceExt().setLastSendFailureCause(exception.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((BNiagaraStation)this.getConnection().getParent()).disengage("eventChannel");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        ((BNiagaraStation)this.getConnection().getParent()).disengage("eventChannel");
    }

    public synchronized void sendEvents(BEvent[] bEventArray) throws Exception {
        this.sendEvents(bEventArray, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void sendEvents(BEvent[] bEventArray, boolean bl) throws Exception {
        BEventService.log.trace("Sending events.");
        try {
            try {
                ((BNiagaraStation)this.getConnection().getParent()).engageNoRetry("eventChannel", 5000L);
                this.sendAsync(this.makeRequest(bEventArray));
                this.getDeviceExt().setLastSendTime(BAbsTime.now());
            }
            catch (Exception exception) {
                if (BEventService.log.isTraceOn()) {
                    BEventService.log.error("Unable to send events.", (Throwable)exception);
                }
                this.queue.enqueue((Object)bEventArray);
                this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
                this.getDeviceExt().setLastSendFailureCause(exception.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((BNiagaraStation)this.getConnection().getParent()).disengage("eventChannel");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        ((BNiagaraStation)this.getConnection().getParent()).disengage("eventChannel");
    }

    private final FoxResponse event(FoxRequest foxRequest) {
        FoxTuple[] foxTupleArray = foxRequest.list("event");
        if (BEventService.log.isTraceOn()) {
            BEventService.log.trace("Received " + foxTupleArray.length + " event(s).");
        }
        this.processEvents(foxTupleArray);
        return new FoxResponse(foxRequest);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void flush() {
        if (this.queue.isEmpty()) {
            return;
        }
        if (BEventService.log.isTraceOn()) {
            BEventService.log.trace("Flushing " + this.queue.size() + " queued events.");
        }
        FoxCircuit foxCircuit = null;
        try {
            try {
                foxCircuit = this.openCircuit("eventStream");
                ((BNiagaraStation)this.getConnection().getParent()).engageNoRetry("eventChannelStream", 5000L);
                try {
                    while (!this.queue.isEmpty()) {
                        BEventService.log.trace("Flushing event.");
                        FoxRequest foxRequest = this.makeRequest((BEvent)((Object)this.queue.dequeue()));
                        if (this.queue.isEmpty()) {
                            foxRequest.add("last", true);
                            foxCircuit.writeMessage((FoxMessage)foxRequest);
                            break;
                        }
                        foxCircuit.writeMessage((FoxMessage)foxRequest);
                    }
                    this.getDeviceExt().setLastSendTime(BAbsTime.now());
                }
                catch (Exception exception) {
                    this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
                    this.getDeviceExt().setLastSendFailureCause(exception.toString());
                }
                foxCircuit.close();
            }
            catch (Exception exception) {
                BEventService.log.error("Unable to flush events.", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            ((BNiagaraStation)this.getConnection().getParent()).disengage("eventChannelStream");
            if (foxCircuit != null && foxCircuit.isOpen()) {
                foxCircuit.close();
            }
            throw throwable;
        }
        {
            Object var3_7 = null;
        }
        ((BNiagaraStation)this.getConnection().getParent()).disengage("eventChannelStream");
        if (foxCircuit != null && foxCircuit.isOpen()) {
            foxCircuit.close();
        }
        BEventService.log.trace("Circuit closed.");
    }

    private final void event(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage;
            do {
                foxMessage = foxCircuit.readMessage();
                FoxTuple[] foxTupleArray = foxMessage.list("event");
                if (BEventService.log.isTraceOn()) {
                    BEventService.log.trace("Received " + foxTupleArray.length + " event(s).");
                }
                this.processEvents(foxTupleArray);
            } while (!foxMessage.getBoolean("last", false));
        }
        catch (Exception exception) {
            BEventService.log.error("Error streaming events.", (Throwable)exception);
        }
        foxCircuit.close();
        BEventService.log.trace("Circuit closed.");
    }

    private final FoxRequest makeRequest(BEvent bEvent) {
        FoxRequest foxRequest = this.makeRequest("event");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ValueDocEncoder valueDocEncoder = new ValueDocEncoder((OutputStream)byteArrayOutputStream);
            valueDocEncoder.encodeDocument((BValue)bEvent);
            valueDocEncoder.close();
            foxRequest.add("event", byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            BEventService.log.error("Unable to encode event", (Throwable)exception);
        }
        return foxRequest;
    }

    private final FoxRequest makeRequest(BEvent[] bEventArray) {
        FoxRequest foxRequest = this.makeRequest("event");
        int n = 0;
        while (n < bEventArray.length) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ValueDocEncoder valueDocEncoder = new ValueDocEncoder((OutputStream)byteArrayOutputStream);
                valueDocEncoder.encodeDocument((BValue)bEventArray[n]);
                valueDocEncoder.close();
                foxRequest.add("event", byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                BEventService.log.error("Unable to encode event", (Throwable)exception);
            }
            ++n;
        }
        return foxRequest;
    }

    private final void processEvents(FoxTuple[] foxTupleArray) {
        int n = 0;
        while (n < foxTupleArray.length) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((FoxBlob)foxTupleArray[n]).data);
                ValueDocDecoder valueDocDecoder = new ValueDocDecoder((InputStream)byteArrayInputStream);
                BEvent bEvent = (BEvent)valueDocDecoder.decodeDocument();
                valueDocDecoder.close();
                bEvent.setSource(BOrdList.add((BOrdList)bEvent.getSource(), (BOrd)this.getDeviceExt().getSlotPathOrd()));
                BEventService.get().process(bEvent);
            }
            catch (Exception exception) {
                BEventService.log.error("Unable to procese event(s).", (Throwable)exception);
            }
            ++n;
        }
    }

    private final BNiagaraEventDeviceExt getDeviceExt() {
        try {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)this.getConnection().getParent();
            Class clazz = class$com$tridium$event$BNiagaraEventDeviceExt;
            if (clazz == null) {
                clazz = class$com$tridium$event$BNiagaraEventDeviceExt = BEventChannel.class("[Lcom.tridium.event.BNiagaraEventDeviceExt;", false);
            }
            return (BNiagaraEventDeviceExt)((Object)bNiagaraStation.getChildren(clazz)[0]);
        }
        catch (Exception exception) {
            BEventService.log.error("Unable to find BNiagaraEventDeviceExt.", (Throwable)exception);
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.queue = new Queue();
    }

    public BEventChannel() {
        super(CHANNEL_NAME);
        this.this();
    }

    static {
        Class clazz = class$com$tridium$event$BEventChannel;
        if (clazz == null) {
            clazz = class$com$tridium$event$BEventChannel = BEventChannel.class("[Lcom.tridium.event.BEventChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

