/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.io;

import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.WrapperException;
import java.io.InputStream;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObixDecoder
implements Context {
    private static final String AX_CONTRACT = "/obix/def/";
    private static final int AX_CONTRACT_LEN = 10;
    private Context ctxt;
    private boolean debug;
    private BFacets facets;
    private InputStream in;
    private XElem root;
    private BEnumRange range;
    private boolean useNew;

    public void addFacets(BFacets bFacets) {
        this.facets = bFacets == null ? null : BFacets.make((BFacets)this.getFacets(), (BFacets)bFacets);
    }

    public Context getBase() {
        return this.ctxt;
    }

    public BObject getFacet(String string) {
        return this.getFacets().getFacet(string);
    }

    public BFacets getFacets() {
        if (this.facets != null) {
            return this.facets;
        }
        if (this.ctxt != null) {
            return this.ctxt.getFacets();
        }
        return null;
    }

    public String getLanguage() {
        return this.ctxt.getLanguage();
    }

    public BUser getUser() {
        return this.ctxt.getUser();
    }

    public BValue decode() throws Exception {
        BValue bValue = this.useNew ? this.decodeNew() : this.decodeOld();
        return bValue;
    }

    public BValue decode(BValue bValue) throws Exception {
        if (this.useNew) {
            return this.decodeNew(bValue);
        }
        return this.decodeOld(bValue);
    }

    private final BValue decodeOld() throws Exception {
        return this.make(this.parse(), this);
    }

    private final BValue decodeOld(BValue bValue) throws Exception {
        if (bValue == null) {
            return this.decode();
        }
        if (bValue.isComplex()) {
            return this.decode(this.parse(), bValue.asComplex().newCopy(true), this.ctxt);
        }
        return this.decode(this.parse(), bValue, this.ctxt);
    }

    private final BValue decodeNew() throws Exception {
        return this.make2(this.parse(), this);
    }

    private final BValue decodeNew(BValue bValue) throws Exception {
        if (bValue == null) {
            return this.decodeNew();
        }
        if (bValue.isComplex()) {
            return this.decode2(this.parse(), bValue.asComplex().newCopy(true), this.ctxt);
        }
        return this.decode2(this.parse(), bValue, this.ctxt);
    }

    public XElem getDocument() {
        return this.parse();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean isUseNew() {
        return this.useNew;
    }

    public void setUseNew(boolean bl) {
        this.useNew = bl;
    }

    private final XElem parse() {
        try {
            if (this.root == null) {
                XParser xParser = XParser.make((InputStream)this.in);
                this.root = xParser.parse(false);
                if (this.debug) {
                    ObixDecoder.d("PARSING:");
                    this.root.dump();
                }
            }
            return this.root;
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
    }

    private final BValue decode(XElem xElem, BValue bValue, Context context) throws Exception {
        String string = xElem.name();
        if (string.equals("obj")) {
            if (bValue instanceof BComplex) {
                BComplex bComplex = bValue.asComplex();
                XElem[] xElemArray = xElem.elems();
                int n = 0;
                if (xElemArray != null) {
                    n = xElemArray.length;
                }
                int n2 = n;
                int n3 = 0;
                while (n3 < n2) {
                    BValue bValue2;
                    string = xElemArray[n3].get("name");
                    Property property = bComplex.getProperty(string);
                    if (property != null) {
                        BValue bValue3 = bComplex.get(property);
                        bValue2 = this.decode(xElemArray[n3], bValue3, context);
                        if (bValue2 != null && bValue2 != bValue3) {
                            bComplex.set(property, bValue2);
                        }
                    } else if (bComplex instanceof BComponent) {
                        bValue2 = this.make(xElemArray[n3], context);
                        if (bValue2 != null) {
                            bComplex.asComponent().add(string, bValue2);
                        }
                    } else {
                        throw new IllegalStateException("Cannot translate: " + xElem);
                    }
                    ++n3;
                }
            }
            return bValue;
        }
        if (string.equals("enum")) {
            BIEnum bIEnum = (BIEnum)bValue;
            BEnumRange bEnumRange = (BEnumRange)context.getFacets().get("range");
            if (bEnumRange == null) {
                bEnumRange = bIEnum.getEnum().getRange();
            }
            return bEnumRange.get(xElem.get("val", null));
        }
        if (string.equals("abstime")) {
            return ObixUtils.dateTime(xElem.get("val", null));
        }
        if (string.equals("reltime")) {
            return BRelTime.make((long)ObixUtils.duration(xElem.get("val", null)));
        }
        if (bValue.isSimple()) {
            return (BValue)bValue.asSimple().decodeFromString(xElem.get("val", null));
        }
        throw new IllegalStateException("Cannot translate: " + xElem);
    }

    private final BValue make(XElem xElem, Context context) throws Exception {
        if (xElem == null) {
            return null;
        }
        String string = xElem.name();
        if (string.equals("abstime")) {
            return ObixUtils.dateTime(xElem.get("val", null));
        }
        if (string.equals("bool")) {
            if (xElem.getb("null", false)) {
                return null;
            }
            return BBoolean.make((boolean)ObixUtils.bool(xElem.get("val", null)));
        }
        if (string.equals("enum")) {
            if (xElem.getb("null", false)) {
                return null;
            }
            BFacets bFacets = context.getFacets();
            BEnumRange bEnumRange = (BEnumRange)bFacets.get("range");
            if (bEnumRange == null) {
                throw new IllegalStateException("Cannot translate: " + xElem);
            }
            return bEnumRange.get(xElem.get("val", null));
        }
        if (string.equals("int")) {
            if (xElem.getb("null", false)) {
                return null;
            }
            return BInteger.make((int)Integer.parseInt(xElem.get("val", null)));
        }
        if (string.equals("list")) {
            BComponent bComponent = new BComponent();
            XElem[] xElemArray = xElem.elems();
            int n = 0;
            if (xElemArray != null) {
                n = xElemArray.length;
            }
            int n2 = n;
            int n3 = 0;
            while (n3 < n2) {
                BValue bValue = this.make(xElemArray[n3], context);
                if (bValue != null) {
                    bComponent.add(xElemArray[n3].get("name", xElemArray[n3].name() + '?'), bValue);
                }
                ++n3;
            }
            return bComponent;
        }
        if (string.equals("obj")) {
            BComponent bComponent = new BComponent();
            XElem[] xElemArray = xElem.elems();
            int n = 0;
            if (xElemArray != null) {
                n = xElemArray.length;
            }
            int n4 = n;
            int n5 = 0;
            while (n5 < n4) {
                BValue bValue = this.make(xElemArray[n5], context);
                if (bValue != null) {
                    bComponent.add(xElemArray[n5].get("name", xElemArray[n5].name() + '?'), bValue);
                }
                ++n5;
            }
            return bComponent;
        }
        if (string.equals("real")) {
            if (xElem.getb("null", false)) {
                return null;
            }
            return BDouble.make((double)Double.parseDouble(xElem.get("val", null)));
        }
        if (string.equals("reltime")) {
            return BRelTime.make((long)ObixUtils.duration(xElem.get("val", null)));
        }
        if (string.equals("str")) {
            if (xElem.getb("null", false)) {
                return null;
            }
            return BString.make((String)xElem.get("val", null));
        }
        if (string.equals("uri")) {
            return BString.make((String)xElem.get("val", null));
        }
        throw new IllegalArgumentException("Invalid obj: " + xElem);
    }

    private final BValue decode2(XElem xElem, BValue bValue, Context context) throws Exception {
        BTypeSpec bTypeSpec;
        String string;
        BValue bValue2;
        block21: {
            bValue2 = bValue;
            string = xElem.name();
            String string2 = xElem.get("is", "no contract");
            if (this.debug) {
                System.out.println("ObixDecoder.decode2(src=" + string + ", sink=" + bValue + ", cx=" + context + ", src is:" + string2);
            }
            try {
                if (string2.startsWith(AX_CONTRACT) && (bTypeSpec = BTypeSpec.make((String)string2.substring(AX_CONTRACT.length()))) != null && bTypeSpec != BTypeSpec.NULL) {
                    bValue2 = (BValue)bTypeSpec.getInstance();
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block21;
                exception.printStackTrace();
                System.out.println("Exception decoding source\n" + xElem + "\n using prototype\n" + bValue + "\nusing default sink...");
            }
        }
        if (this.debug) {
            System.out.println("sink:" + bValue.toDebugString() + " type=" + bValue.getTypeDisplayName(null) + "\nv (snk):" + bValue2.toDebugString() + " type=" + bValue2.getTypeDisplayName(null));
        }
        if (string.equals("obj")) {
            if (bValue2 instanceof BComplex) {
                bTypeSpec = bValue2.asComplex();
                XElem[] xElemArray = xElem.elems();
                int n = 0;
                if (xElemArray != null) {
                    n = xElemArray.length;
                }
                int n2 = n;
                int n3 = 0;
                while (n3 < n2) {
                    BValue bValue3;
                    string = xElemArray[n3].get("name");
                    Property property = bTypeSpec.getProperty(string);
                    if (property != null) {
                        BValue bValue4 = bTypeSpec.get(property);
                        bValue3 = this.decode2(xElemArray[n3], bValue4, context);
                        if (bValue3 != null && bValue3 != bValue4) {
                            bTypeSpec.set(property, bValue3);
                        }
                    } else if (bTypeSpec instanceof BComponent) {
                        bValue3 = this.make2(xElemArray[n3], context);
                        if (bValue3 != null) {
                            bTypeSpec.asComponent().add(string, bValue3);
                        }
                    } else {
                        throw new IllegalStateException("Cannot translate: " + xElem);
                    }
                    ++n3;
                }
            }
            return bValue2;
        }
        if (string.equals("enum")) {
            bTypeSpec = (BIEnum)bValue2;
            BEnumRange bEnumRange = (BEnumRange)context.getFacets().get("range");
            if (bEnumRange == null) {
                bEnumRange = bTypeSpec.getEnum().getRange();
            }
            if (bValue2 instanceof BDynamicEnum) {
                return BDynamicEnum.make((int)bEnumRange.get(xElem.get("val", null)).getOrdinal(), (BEnumRange)bEnumRange);
            }
            return bEnumRange.get(xElem.get("val", null));
        }
        if (string.equals("abstime")) {
            return ObixUtils.dateTime(xElem.get("val", null));
        }
        if (string.equals("reltime")) {
            return BRelTime.make((long)ObixUtils.duration(xElem.get("val", null)));
        }
        if (bValue2.isSimple()) {
            return (BValue)bValue2.asSimple().decodeFromString(xElem.get("val", null));
        }
        throw new IllegalStateException("Cannot translate: " + xElem);
    }

    private final BValue make2(XElem xElem, Context context) throws Exception {
        return this.make2(xElem, context, null);
    }

    private final BValue make2(XElem xElem, Context context, Type type) throws Exception {
        this.dbg("make2: val=" + xElem + " cx=" + context + " t=" + type);
        try {
            if (xElem == null) {
                return null;
            }
            String string = xElem.get("is", null);
            String string2 = xElem.name();
            if (string != null && string.length() > 0) {
                String string3 = null;
                int n = string.indexOf(32);
                string3 = n < 0 ? string : string.substring(0, n);
                if (string3.startsWith(AX_CONTRACT)) {
                    BTypeSpec bTypeSpec = BTypeSpec.make((String)string3.substring(10));
                    BObject bObject = bTypeSpec.getInstance();
                    if (bObject.isComplex()) {
                        BComplex bComplex = (BComplex)bObject;
                        this.setFromVal(bComplex, xElem);
                        XElem[] xElemArray = xElem.elems();
                        int n2 = 0;
                        if (xElemArray != null) {
                            n2 = xElemArray.length;
                        }
                        int n3 = n2;
                        int n4 = 0;
                        while (n4 < n3) {
                            BValue bValue;
                            String string4 = xElemArray[n4].get("name", "");
                            Slot slot = bComplex.getSlot(string4);
                            if (slot != null) {
                                if (slot.isProperty()) {
                                    Property property = slot.asProperty();
                                    bValue = this.make2(xElemArray[n4], context, property.getType());
                                    if (bValue != null) {
                                        bComplex.set(property, bValue);
                                    } else {
                                        this.dbg("!! make2 returned null for kid:");
                                        if (this.debug) {
                                            xElemArray[n4].dump();
                                        }
                                    }
                                }
                            } else {
                                bValue = this.make2(xElemArray[n4], context, null);
                                this.dbg("!!! adding dynamic slot: '" + bValue + "' type=" + (bValue != null ? bValue.getTypeDisplayName(null) : "null"));
                                bComplex.asComponent().add(string4, bValue);
                            }
                            ++n4;
                        }
                        return bComplex;
                    }
                    BSimple bSimple = (BSimple)bObject;
                    String string5 = xElem.get("val", null);
                    String string6 = xElem.get("name", "");
                    BValue bValue = (BValue)bSimple.decodeFromString(string5);
                    this.dbg("simple with type '" + string6 + "':\n  " + xElem + "\n  " + bValue + " [" + bValue.getType() + ']');
                    if (bValue.getType().is(BFacets.TYPE) && string6.equals("facets")) {
                        this.range = (BEnumRange)((BFacets)bValue).getFacet("range");
                    }
                    return bValue;
                }
                this.dbg("Primary contract is not a Niagara definition: '" + string3 + "'; using standard make()");
                return this.make(xElem, context);
            }
            this.dbg("make2: non-contract case!!!");
            if (string2.equals("abstime")) {
                return ObixUtils.dateTime(xElem.get("val", null));
            }
            if (string2.equals("bool")) {
                if (xElem.getb("null", false)) {
                    return null;
                }
                return BBoolean.make((boolean)ObixUtils.bool(xElem.get("val", null)));
            }
            if (string2.equals("enum")) {
                if (xElem.getb("null", false)) {
                    return null;
                }
                BFacets bFacets = context.getFacets();
                BEnumRange bEnumRange = null;
                if (bFacets != null) {
                    bEnumRange = (BEnumRange)bFacets.get("range");
                }
                if (bEnumRange != null) {
                    return bEnumRange.get(xElem.get("val", null));
                }
                String string7 = xElem.get("range", null);
                if (string7 != null && string7.startsWith(AX_CONTRACT)) {
                    int n = string7.lastIndexOf(47);
                    BTypeSpec bTypeSpec = BTypeSpec.make((String)string7.substring(10, n));
                    BEnum bEnum = (BEnum)bTypeSpec.getInstance();
                    bEnumRange = bEnum.getRange();
                }
                if (bEnumRange != null) {
                    return bEnumRange.get(xElem.get("val", null));
                }
                throw new IllegalStateException("Cannot translate: " + xElem);
            }
            if (string2.equals("int")) {
                if (xElem.getb("null", false)) {
                    return null;
                }
                return BInteger.make((int)Integer.parseInt(xElem.get("val", null)));
            }
            if (string2.equals("list")) {
                this.dbg("\nmake2: list!\n  " + xElem);
                BComponent bComponent = new BComponent();
                XElem[] xElemArray = xElem.elems();
                int n = 0;
                if (xElemArray != null) {
                    n = xElemArray.length;
                }
                int n5 = n;
                int n6 = 0;
                while (n6 < n5) {
                    BValue bValue = this.make2(xElemArray[n6], context);
                    if (bValue != null) {
                        bComponent.add(xElemArray[n6].get("name", xElemArray[n6].name() + '?'), bValue);
                    }
                    ++n6;
                }
                return bComponent;
            }
            if (string2.equals("real")) {
                if (xElem.getb("null", false)) {
                    return null;
                }
                return BDouble.make((double)Double.parseDouble(xElem.get("val", null)));
            }
            if (string2.equals("reltime")) {
                return BRelTime.make((long)ObixUtils.duration(xElem.get("val", null)));
            }
            if (string2.equals("str")) {
                this.dbg("\nmake2: string!\n  " + xElem);
                if (xElem.getb("null", false)) {
                    return null;
                }
                String string8 = xElem.get("val", null);
                if (type != null) {
                    return (BValue)((BSimple)type.getInstance()).decodeFromString(string8);
                }
                return BString.make((String)xElem.get("val", null));
            }
            if (string2.equals("uri")) {
                this.dbg("\nmake2: uri!\n  " + xElem);
                return BOrd.make((String)xElem.get("val", null));
            }
            if (string2.equals("ref")) {
                this.dbg("make2: ref!\n  " + xElem);
                return this.make2(xElem, context);
            }
            if (string2.equals("obj")) {
                this.dbg("\nmake2: obj!\n  " + xElem);
                BComponent bComponent = null;
                if (type != null) {
                    BValue bValue = (BValue)type.getInstance();
                    if (type.is(BSimple.TYPE)) {
                        return (BValue)bValue.asSimple().decodeFromString(xElem.get("val", ""));
                    }
                    if (type.is(BComponent.TYPE)) {
                        bComponent = bValue.asComponent();
                    }
                } else {
                    bComponent = new BComponent();
                }
                if (bComponent == null) {
                    throw new IllegalStateException("Cannot decode non-contract typed BObject:" + xElem);
                }
                XElem[] xElemArray = xElem.elems();
                int n = 0;
                if (xElemArray != null) {
                    n = xElemArray.length;
                }
                int n7 = n;
                int n8 = 0;
                while (n8 < n7) {
                    BValue bValue = this.make2(xElemArray[n8], context);
                    if (bValue != null) {
                        bComponent.add(xElemArray[n8].get("name", xElemArray[n8].name() + '?'), bValue);
                    }
                    ++n8;
                }
                return bComponent;
            }
            throw new IllegalArgumentException("Invalid obj: " + xElem);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.dbg("Exception in make2!: val=");
            xElem.dump();
            throw exception;
        }
    }

    private final void setFromVal(BComplex bComplex, XElem xElem) {
        String string = xElem.get("val", "");
        this.dbg("setFromVal: cpx=" + bComplex + ", val=" + xElem + ", sval=" + string);
        if (bComplex instanceof BStatusValue) {
            if (bComplex instanceof BStatusBoolean) {
                ((BStatusBoolean)bComplex).setValue(BBoolean.decode((String)string));
            } else if (bComplex instanceof BStatusNumeric) {
                ((BStatusNumeric)bComplex).setValue(BDouble.decode((String)string));
            } else if (bComplex instanceof BStatusEnum) {
                BEnumRange bEnumRange = this.range;
                if (bEnumRange == null) {
                    bEnumRange = ((BStatusEnum)bComplex).getValue().getRange();
                }
                if (bEnumRange.isTag(string)) {
                    ((BStatusEnum)bComplex).setValue(bEnumRange.get(string));
                } else {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                    }
                    ((BStatusEnum)bComplex).setValue(BDynamicEnum.make((int)n, (BEnumRange)bEnumRange));
                }
            } else if (bComplex instanceof BStatusString) {
                ((BStatusString)bComplex).setValue(string);
            }
            if (xElem.getb("null", false)) {
                ((BStatusValue)bComplex).setStatusNull(true);
            }
        } else {
            this.dbg("setFromVal:don't know how to do anything to a " + bComplex.getType() + " with " + string);
        }
        this.dbg("setFromVal: cpx -> " + bComplex);
    }

    private static final void d(String string) {
        System.out.println(string);
    }

    private final void dbg(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    private final /* synthetic */ void this() {
        this.debug = false;
        this.range = null;
        this.useNew = true;
    }

    public ObixDecoder(XElem xElem, Context context) throws Exception {
        this(xElem, context, false);
    }

    private ObixDecoder(XElem xElem, Context context, boolean bl) throws Exception {
        this.this();
        this.root = xElem;
        this.ctxt = context;
        this.debug = bl;
    }

    public ObixDecoder(InputStream inputStream, Context context) throws Exception {
        this(inputStream, context, false);
    }

    private ObixDecoder(InputStream inputStream, Context context, boolean bl) throws Exception {
        this.this();
        this.in = inputStream;
        this.ctxt = context;
        this.debug = bl;
    }
}

