/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver;

import com.tridium.obix.util.ObixUtils;
import com.tridium.silk.Fault;
import com.tridium.silk.SoapContext;
import com.tridium.silk.Soaplet;
import com.tridium.silk.SoapletUtil;
import com.tridium.silk.Wsdl;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.baja.file.BIFile;
import javax.baja.license.Feature;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.obix.driver.XElemTunnel;
import javax.baja.obix.driver.lobby.BObixLobby;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;
import javax.servlet.http.HttpServletRequest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixServer
extends BWebServlet
implements Soaplet {
    public static final Property servletName = BObixServer.newProperty((int)1, (String)"obix", null);
    public static final Property debug = BObixServer.newProperty((int)0, (boolean)false, null);
    public static final Property lobby = BObixServer.newProperty((int)262, (BValue)new BObixLobby(), null);
    public static final Type TYPE;
    private static final String servletPath = "/obix";
    private static final String soapPath = "/obix/soap";
    private static final String wsdlPath = "/obix/wsdl";
    private static final String xsdPath = "/obix/xsd";
    private static final String xslPath = "/obix/xsl";
    private static byte[] xsd;
    private static byte[] xsl;
    private boolean licensed;
    static /* synthetic */ Class class$javax$baja$obix$driver$BObixServer;

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean bl) {
        this.setBoolean(debug, bl, null);
    }

    public BObixLobby getLobby() {
        return (BObixLobby)this.get(lobby);
    }

    public void setLobby(BObixLobby bObixLobby) {
        this.set(lobby, (BValue)bObixLobby, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BObixNetwork getObixNetwork() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BObixNetwork) {
                return (BObixNetwork)bComplex;
            }
            bComplex = bComplex.getParent();
        }
        return null;
    }

    public String getServletPath() {
        return servletPath;
    }

    public String getSoapPath() {
        return soapPath;
    }

    public XElem getWsdl(WebOp webOp) throws Exception {
        String string = webOp.getRequest().getRequestURL().toString();
        BOrd bOrd = BOrd.make((String)"module://obixDriver/com/tridium/obix/rsc/wsdl.xsd");
        BIFile bIFile = (BIFile)bOrd.resolve((BObject)this).get();
        XParser xParser = XParser.make((InputStream)new ByteArrayInputStream(bIFile.read()));
        XElem xElem = xParser.parse();
        xElem.addAttr("targetNamespace", "http://obix.org/ns/wsdl/1.0");
        XElem xElem2 = xElem.elem("import");
        String string2 = string.substring(0, string.lastIndexOf(this.getWsdlPath()));
        String string3 = ObixUtils.concat(string2, this.getXsdPath());
        xElem2.addAttr("schemaLocation", string3);
        String string4 = string.substring(0, string.indexOf(this.getServletPath()));
        string4 = string4 + this.getSoapPath();
        Wsdl wsdl = new Wsdl("oBIX", "http://obix.org/ns/wsdl/1.0", string4);
        wsdl.addType(xElem);
        wsdl.addOperation("read", new XElem("obixRead"), new XElem("obix:obj"));
        wsdl.addOperation("write", new XElem("obixWrite"), new XElem("obix:obj"));
        wsdl.addOperation("invoke", new XElem("obixInvoke"), new XElem("obix:obj"));
        XElem xElem3 = wsdl.getDocument();
        xElem3.defineNs("obix", "http://obix.org/ns/schema/1.0");
        return xElem3;
    }

    public String getWsdlPath() {
        return wsdlPath;
    }

    public byte[] getXsd() throws Exception {
        if (xsd == null) {
            BOrd bOrd = BOrd.make((String)"module://obixDriver/com/tridium/obix/rsc/obix.xsd");
            BIFile bIFile = (BIFile)bOrd.resolve((BObject)this).get();
            xsd = bIFile.read();
        }
        return xsd;
    }

    public String getXsdPath() {
        return xsdPath;
    }

    public byte[] getXsl() throws Exception {
        if (xsl == null) {
            BOrd bOrd = BOrd.make((String)"module://obixDriver/com/tridium/obix/rsc/obix.xsl");
            BIFile bIFile = (BIFile)bOrd.resolve((BObject)this).get();
            xsl = bIFile.read();
        }
        return xsl;
    }

    public String getXslPath() {
        return xslPath;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return true;
    }

    public OrdTarget resolve(String string, Context context) {
        string = ObixUtils.replace(string, "~", "|obix:");
        string = ObixUtils.replace(string, "/|", "|");
        return this.getLobby().resolve(ObixUtils.resource("/" + this.getServletName(), string), context);
    }

    public void service(SoapContext soapContext) throws Exception, Fault {
        XElem xElem = soapContext.getRequest().getBody().elem(0);
        String string = xElem.name();
        String string2 = xElem.get("href");
        OrdTarget ordTarget = this.resolve(string2, (Context)soapContext);
        if (!string2.endsWith("/")) {
            string2 = string2 + '/';
        }
        XElem xElem2 = null;
        if (xElem.contentSize() > 0) {
            xElem2 = xElem.elem(0);
        }
        XElemTunnel xElemTunnel = new XElemTunnel(string, this, ordTarget, string2, xElem2, soapContext);
        soapContext.getResponse().addEntry((XElem)xElemTunnel);
    }

    public void service(WebOp webOp) throws Exception {
        String string;
        if (!this.licensed) {
            webOp.getResponse().sendError(500, "Unlicensed oBIX Server");
            return;
        }
        if (!this.getEnabled()) {
            webOp.getResponse().sendError(410, "oBIX Server Disabled");
            return;
        }
        ObixEncoder obixEncoder = null;
        HttpServletRequest httpServletRequest = webOp.getRequest();
        String string2 = httpServletRequest.getRequestURI();
        if (httpServletRequest.getProtocol().endsWith("1.1") && System.getProperty("obix.disableChunked", "false").equals("false")) {
            webOp.getResponse().setHeader("transfer-encoding", "chunked");
        }
        if ((string = httpServletRequest.getQueryString()) != null) {
            string2 = string2 + '?' + string;
        }
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            if (string2.startsWith(this.getSoapPath())) {
                SoapletUtil.service((WebOp)webOp, (Soaplet)this);
                return;
            }
            String string3 = TextUtil.toUpperCase((String)httpServletRequest.getMethod());
            if (!string3.equals("GET")) {
                inputStream = this.getFullyReadInputStream(httpServletRequest);
            }
            webOp.setContentType("text/xml");
            if (webOp.getService().isGzippable(httpServletRequest, "text/xml") && System.getProperty("obix.disableGzipped", "false").equals("false")) {
                webOp.getResponse().setHeader("content-encoding", "gzip");
            }
            outputStream = webOp.getOutputStream();
            if (string2.equalsIgnoreCase(this.getXslPath())) {
                outputStream.write(this.getXsl());
            } else if (string2.equalsIgnoreCase(this.getXsdPath())) {
                outputStream.write(this.getXsd());
            } else if (string3.equals("GET") && string2.equalsIgnoreCase(this.getWsdlPath())) {
                XWriter xWriter = new XWriter(outputStream);
                this.getWsdl(webOp).write(xWriter);
                xWriter.flush();
            } else {
                String string4 = httpServletRequest.getRequestURL().toString();
                if (!string4.endsWith("/")) {
                    string4 = string4 + '/';
                }
                obixEncoder = new ObixEncoder("/" + this.getServletName(), string4, outputStream);
                obixEncoder.setDebug(this.getDebug());
                XWriter xWriter = obixEncoder.getWriter();
                xWriter.prolog();
                xWriter.w((Object)"<?xml-stylesheet type='text/xsl' href='");
                xWriter.w((Object)this.getXslPath()).w((Object)"'?>\n");
                Map map = obixEncoder.attributes();
                map.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                map.put("xsi:schemaLocation", "http://obix.org/ns/schema/1.0 " + this.getXsdPath());
                boolean bl = this.getDebug();
                string2 = this.convertPercents(string2, bl);
                string2 = this.convertVirtuals(string2, bl);
                OrdTarget ordTarget = this.resolve(string2, (Context)webOp);
                if (string3.equals("GET")) {
                    obixEncoder.encode(ordTarget);
                } else {
                    ObixDecoder obixDecoder = new ObixDecoder(inputStream, (Context)ordTarget);
                    obixDecoder.setDebug(this.getDebug());
                    int n = inputStream.available();
                    if (n > 0) {
                        obixDecoder.getDocument();
                    }
                    if ((n = inputStream.available()) > 0) {
                        byte[] byArray = new byte[n];
                        while (inputStream.read(byArray) > 0) {
                        }
                    }
                    if (string3.equals("PUT")) {
                        ObixUtils.serviceWrite(ordTarget, obixDecoder, obixEncoder);
                    } else if (string3.equals("POST")) {
                        ObixUtils.serviceInvoke(ordTarget, obixDecoder, obixEncoder);
                    } else {
                        throw new Exception("Unsupported HTTP method: " + string3);
                    }
                }
                obixEncoder.commit();
            }
        }
        catch (Exception exception) {
            if (outputStream == null) {
                outputStream = webOp.getOutputStream();
            }
            if (obixEncoder == null) {
                String string5 = httpServletRequest.getRequestURL().toString();
                if (!string5.endsWith("/")) {
                    string5 = string5 + '/';
                }
                obixEncoder = new ObixEncoder("/" + this.getServletName(), string5, outputStream);
                obixEncoder.setDebug(this.getDebug());
            }
            obixEncoder.encode(exception);
            obixEncoder.commit();
        }
    }

    public InputStream getFullyReadInputStream(HttpServletRequest httpServletRequest) throws Exception {
        if (httpServletRequest.getContentLength() == -1) {
            return httpServletRequest.getInputStream();
        }
        DataInputStream dataInputStream = new DataInputStream((InputStream)httpServletRequest.getInputStream());
        byte[] byArray = new byte[httpServletRequest.getContentLength()];
        dataInputStream.readFully(byArray);
        return new ByteArrayInputStream(byArray);
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        try {
            Feature feature = this.getObixNetwork().getLicenseFeature();
            this.licensed = feature.getb("export", false);
            if (!this.licensed) {
                this.configFatal("Server not licensed");
            }
        }
        catch (LicenseException licenseException) {
            this.licensed = false;
            this.configFatal("Server not licensed");
            throw licenseException;
        }
    }

    private final String convertPercents(String string, boolean bl) {
        String string2 = string;
        int n = string.indexOf(37);
        if (n >= 0) {
            if (bl) {
                System.out.println(" >>>>>>> Correcting percent-escaped URI " + string + "...");
            }
            string2 = SlotPath.unescape((String)string.replace('%', '$'));
            if (bl) {
                System.out.println(" >>>>>>> URI converted to " + string2);
            }
        }
        return string2;
    }

    private final String convertVirtuals(String string, boolean bl) {
        String string2 = string;
        int n = string.indexOf("|virtual:");
        if (n >= 0) {
            if (bl) {
                System.out.println(" >>>>>>> Converting Virtual component URI " + string + "...");
            }
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n + 9));
            String string3 = string.substring(n + 9);
            string3 = SlotPath.unescape((String)string3);
            stringBuffer.append(string3);
            string2 = stringBuffer.toString();
            if (bl) {
                System.out.println(" >>>>>>> URI escaped to " + string2);
            }
        }
        return string2;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.licensed = true;
    }

    public BObixServer() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$obix$driver$BObixServer;
        if (clazz == null) {
            clazz = class$javax$baja$obix$driver$BObixServer = BObixServer.class("[Ljavax.baja.obix.driver.BObixServer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        xsd = null;
        xsl = null;
    }
}

