/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver;

import com.tridium.obix.driver.alarm.BObixAlarmDeviceExt;
import com.tridium.obix.driver.history.BObixHistoryDeviceExt;
import com.tridium.obix.driver.point.BObixPointDeviceExt;
import com.tridium.obix.driver.schedule.BObixScheduleDeviceExt;
import com.tridium.obix.driver.util.BObixPollScheduler;
import com.tridium.obix.driver.util.BObixState;
import com.tridium.obix.util.WrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.naming.SlotPath;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.security.BPassword;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import obix.Abstime;
import obix.Bool;
import obix.Enum;
import obix.Int;
import obix.Obj;
import obix.Real;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Uri;
import obix.Val;
import obix.io.ObixEncoder;
import obix.net.BatchIn;
import obix.net.ObixSession;
import obix.net.SessionWatch;
import obix.net.WatchListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixClient
extends BDevice {
    public static final Property lobby = BObixClient.newProperty((int)64, (String)"http://url/to/lobby/here", null);
    public static final Property authUser = BObixClient.newProperty((int)0, (String)"", null);
    public static final Property authPass = BObixClient.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property debugResponses = BObixClient.newProperty((int)0, (boolean)false, null);
    public static final Property debugRequests = BObixClient.newProperty((int)0, (boolean)false, null);
    public static final Property pollScheduler = BObixClient.newProperty((int)0, (BValue)new BObixPollScheduler(), null);
    public static final Property state = BObixClient.newProperty((int)67, (BValue)BObixState.detached, null);
    public static final Property alarms = BObixClient.newProperty((int)0, (BValue)new BObixAlarmDeviceExt(), null);
    public static final Property histories = BObixClient.newProperty((int)0, (BValue)new BObixHistoryDeviceExt(), null);
    public static final Property points = BObixClient.newProperty((int)0, (BValue)new BObixPointDeviceExt(), null);
    public static final Property schedules = BObixClient.newProperty((int)4, (BValue)new BObixScheduleDeviceExt(), null);
    public static final Property sessionTimeout = BObixClient.newProperty((int)4, (BValue)BRelTime.make((long)15000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true)));
    public static final Property watchSafetyFactor = BObixClient.newProperty((int)0, (BValue)BRelTime.make((long)10000L), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true)), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)5))));
    public static final Action attach = BObixClient.newAction((int)20, null);
    public static final Action detach = BObixClient.newAction((int)20, null);
    public static final Action reattach = BObixClient.newAction((int)16, null);
    public static final Type TYPE;
    private ObixEncoder debugger;
    private Uri lobbyUri;
    private ObixSession session;
    private BObixNetwork network;
    private boolean licenseChecked;
    private Boolean tridium;
    private Object sync;
    static /* synthetic */ Class class$javax$baja$obix$driver$BObixClient;

    public String getLobby() {
        return this.getString(lobby);
    }

    public void setLobby(String string) {
        this.setString(lobby, string, null);
    }

    public String getAuthUser() {
        return this.getString(authUser);
    }

    public void setAuthUser(String string) {
        this.setString(authUser, string, null);
    }

    public BPassword getAuthPass() {
        return (BPassword)this.get(authPass);
    }

    public void setAuthPass(BPassword bPassword) {
        this.set(authPass, (BValue)bPassword, null);
    }

    public boolean getDebugResponses() {
        return this.getBoolean(debugResponses);
    }

    public void setDebugResponses(boolean bl) {
        this.setBoolean(debugResponses, bl, null);
    }

    public boolean getDebugRequests() {
        return this.getBoolean(debugRequests);
    }

    public void setDebugRequests(boolean bl) {
        this.setBoolean(debugRequests, bl, null);
    }

    public BObixPollScheduler getPollScheduler() {
        return (BObixPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BObixPollScheduler bObixPollScheduler) {
        this.set(pollScheduler, (BValue)bObixPollScheduler, null);
    }

    public BObixState getState() {
        return (BObixState)this.get(state);
    }

    public void setState(BObixState bObixState) {
        this.set(state, (BValue)bObixState, null);
    }

    public BObixAlarmDeviceExt getAlarms() {
        return (BObixAlarmDeviceExt)this.get(alarms);
    }

    public void setAlarms(BObixAlarmDeviceExt bObixAlarmDeviceExt) {
        this.set(alarms, (BValue)bObixAlarmDeviceExt, null);
    }

    public BObixHistoryDeviceExt getHistories() {
        return (BObixHistoryDeviceExt)this.get(histories);
    }

    public void setHistories(BObixHistoryDeviceExt bObixHistoryDeviceExt) {
        this.set(histories, (BValue)bObixHistoryDeviceExt, null);
    }

    public BObixPointDeviceExt getPoints() {
        return (BObixPointDeviceExt)this.get(points);
    }

    public void setPoints(BObixPointDeviceExt bObixPointDeviceExt) {
        this.set(points, (BValue)bObixPointDeviceExt, null);
    }

    public BObixScheduleDeviceExt getSchedules() {
        return (BObixScheduleDeviceExt)this.get(schedules);
    }

    public void setSchedules(BObixScheduleDeviceExt bObixScheduleDeviceExt) {
        this.set(schedules, (BValue)bObixScheduleDeviceExt, null);
    }

    public BRelTime getSessionTimeout() {
        return (BRelTime)this.get(sessionTimeout);
    }

    public void setSessionTimeout(BRelTime bRelTime) {
        this.set(sessionTimeout, (BValue)bRelTime, null);
    }

    public BRelTime getWatchSafetyFactor() {
        return (BRelTime)this.get(watchSafetyFactor);
    }

    public void setWatchSafetyFactor(BRelTime bRelTime) {
        this.set(watchSafetyFactor, (BValue)bRelTime, null);
    }

    public void attach() {
        this.invoke(attach, null, null);
    }

    public void detach() {
        this.invoke(detach, null, null);
    }

    public void reattach() {
        this.invoke(reattach, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void atSteadyState() throws Exception {
        super.atSteadyState();
        if (this.getEnabled()) {
            this.attach();
        }
        this.deviceAtSteadyState();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (context != Context.decoding && this.isRunning()) {
            if (property.equals((Object)lobby) || property.equals((Object)authUser) || property.equals((Object)authPass)) {
                this.lobbyUri = null;
                this.reattach();
            } else if (property.equals((Object)status)) {
                if (this.isDown() || this.isDisabled() || this.isFault()) {
                    if (this.getState().isEngaged()) {
                        this.detach();
                    }
                } else if (this.getState().isDisengaged()) {
                    this.attach();
                }
            } else if (property.equals((Object)enabled) && !this.isDisabled()) {
                this.getObixNetwork().enqueue(new Runnable(){

                    public final void run() {
                        BObixClient.this.session();
                    }
                });
            }
        }
    }

    public void doAttach() {
        if (this.getState().isEngaged() || this.isDisabled() || this.isFatalFault()) {
            return;
        }
        if (lobby.isEquivalentToDefaultValue(this.get(lobby))) {
            this.configFail("Configure Lobby URI");
            return;
        }
        this.configOk();
        this.getLog().trace("Attaching on " + this.getName());
        try {
            this.setAttaching();
            this.session();
            this.setAttached();
            this.pingOk();
        }
        catch (Throwable throwable) {
            this.getLog().error("Device attach:" + this.getName(), throwable);
            this.pingFail(throwable.toString());
            this.setDetached();
            return;
        }
        try {
            this.getPoints().attach();
        }
        catch (Throwable throwable) {
            this.getLog().error("Point device extension attach:" + this.getName(), throwable);
        }
        try {
            this.getAlarms().attach();
        }
        catch (Throwable throwable) {
            this.getLog().error("Alarm device extension attach:" + this.getName(), throwable);
        }
    }

    public void doDetach() {
        this.doDetach(false);
    }

    private final void doDetach(boolean bl) {
        if (this.getState().isDisengaged()) {
            return;
        }
        this.getLog().trace("Detaching on " + this.getName());
        try {
            this.setDetached();
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (Exception exception) {}
            }
            this.session = null;
        }
        catch (Throwable throwable) {
            this.getLog().error("Device detach:" + this.getName(), throwable);
        }
        try {
            this.getPoints().detach(bl);
        }
        catch (Throwable throwable) {
            this.getLog().error("Point device extension detach:" + this.getName(), throwable);
        }
        try {
            this.getAlarms().detach();
        }
        catch (Throwable throwable) {
            this.getLog().error("Alarm device extension detach:" + this.getName(), throwable);
        }
    }

    public void doReattach() {
        this.doDetach(true);
        this.getPoints().doVerifyPoints();
        this.doAttach();
    }

    public void doPing() {
        try {
            if (lobby.isEquivalentToDefaultValue(this.get(lobby))) {
                this.configFail("Configure Lobby URI");
                return;
            }
            this.configOk();
            if (this.getState().isAttached()) {
                this.session().ping();
                this.getPoints().attach();
                this.getAlarms().attach();
                this.pingOk();
            } else if (this.getState().isDetached()) {
                this.attach();
            }
        }
        catch (Throwable throwable) {
            this.getLog().error("Ping failed", throwable);
            this.pingFail(throwable.getMessage());
        }
    }

    public Type getNetworkType() {
        return BObixNetwork.TYPE;
    }

    public final Uri getAbsoluteUri(Uri uri) {
        if (uri.isAbsolute()) {
            return uri;
        }
        return uri.normalize(this.lobby());
    }

    public final BObixNetwork getObixNetwork() {
        if (this.network == null) {
            BComplex bComplex = this.getParent();
            while (bComplex != null) {
                if (bComplex instanceof BObixNetwork) {
                    this.network = (BObixNetwork)bComplex;
                    break;
                }
                bComplex = bComplex.getParent();
            }
        }
        return this.network;
    }

    public final Uri getRelativeUri(Uri uri) {
        if (uri.isRelative()) {
            return uri;
        }
        Uri uri2 = this.lobby();
        if (uri.get().startsWith(uri2.get())) {
            String string = uri.get();
            String string2 = uri2.getAuthority();
            if (string2.endsWith("/")) {
                return new Uri(string.substring(string2.length() - 1));
            }
            return new Uri(string.substring(string2.length()));
        }
        return uri;
    }

    public final Boolean isTridiumServer() {
        return this.isTridiumServer(this.session());
    }

    public BatchIn makeBatch() throws Exception {
        return this.session().makeBatch();
    }

    public BFacets makeBoolRange(Uri uri) {
        Obj obj = this.obixRead(uri);
        this.obixReadFully(obj);
        String string = "true";
        Obj obj2 = obj.get("true");
        if (obj2 != null && obj2.getDisplayName() != null) {
            string = obj2.getDisplayName();
        }
        String string2 = "false";
        obj2 = obj.get("false");
        if (obj2 != null && obj2.getDisplayName() != null) {
            string2 = obj2.getDisplayName();
        }
        return BFacets.makeBoolean((BString)BString.make((String)string), (BString)BString.make((String)string2));
    }

    public BFacets makeFacets(BFacets bFacets, Obj obj) {
        BFacets bFacets2 = bFacets;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (obj.isVal()) {
            if (obj.isBool()) {
                Bool bool = (Bool)obj;
                Uri uri = this.normalize((Obj)bool, bool.getRange());
                if (uri != null) {
                    String string = bFacets.gets("boolUri", "");
                    if (!uri.get().equals(string)) {
                        hashtable.put("boolUri", BString.make((String)this.getRelativeUri(uri).get()));
                    }
                } else {
                    bFacets2 = BFacets.makeRemove((BFacets)bFacets2, (String)"trueText");
                    bFacets2 = BFacets.makeRemove((BFacets)bFacets2, (String)"falseText");
                }
            } else if (obj.isReal()) {
                Real real = (Real)obj;
                hashtable.put("min", BDouble.make((double)real.getMin()));
                hashtable.put("max", BDouble.make((double)real.getMax()));
                hashtable.put("precision", BInteger.make((int)real.getPrecision()));
                Uri uri = this.normalize((Obj)real, real.getUnit());
                if (uri != null) {
                    String string = bFacets.gets("unitsUri", "");
                    if (!uri.get().equals(string)) {
                        hashtable.put("unitsUri", BString.make((String)this.getRelativeUri(uri).get()));
                    }
                } else {
                    bFacets2 = BFacets.makeRemove((BFacets)bFacets2, (String)"units");
                }
            } else if (obj.isInt()) {
                Int intVal = (Int)obj;
                hashtable.put("min", BDouble.make((double)intVal.getMin()));
                hashtable.put("max", BDouble.make((double)intVal.getMax()));
                Uri uri = this.normalize((Obj)intVal, intVal.getUnit());
                if (uri != null) {
                    String string = bFacets.gets("unitsUri", "");
                    if (!uri.get().equals(string)) {
                        hashtable.put("unitsUri", BString.make((String)this.getRelativeUri(uri).get()));
                    }
                } else {
                    bFacets2 = BFacets.makeRemove((BFacets)bFacets2, (String)"units");
                }
            } else if (obj.isEnum()) {
                Enum enum_ = (Enum)obj;
                Uri uri = this.normalize((Obj)enum_, enum_.getRange());
                if (uri != null) {
                    String string = bFacets.gets("enumUri", "");
                    if (!uri.get().equals(string)) {
                        hashtable.put("enumUri", BString.make((String)this.getRelativeUri(uri).get()));
                    }
                } else {
                    bFacets2 = BFacets.makeRemove((BFacets)bFacets2, (String)"range");
                }
            } else if (obj.isReltime()) {
                hashtable.put("units", BUnit.getUnit((String)"millisecond"));
            }
        }
        if (hashtable.size() > 0) {
            bFacets2 = BFacets.make((BFacets)bFacets2, (BFacets)BFacets.make(hashtable));
        }
        return bFacets2;
    }

    public BEnumRange makeEnumRange(Uri uri) {
        String string = uri.get();
        if (string.startsWith("obix:")) {
            if (string.equals("obix:Weekday")) {
                return BWeekday.sunday.getRange();
            }
            if (string.equals("obix:Month")) {
                return BMonth.may.getRange();
            }
            throw new RuntimeException("Unknown range: " + string);
        }
        Obj obj = this.obixRead(uri);
        this.obixReadFully(obj);
        Obj[] objArray = obj.list();
        int n = objArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = SlotPath.escape((String)objArray[n2].getName());
            ++n2;
        }
        return BEnumRange.make((String[])stringArray);
    }

    public Obj makeObj(BValue bValue, Context context) {
        BStatus bStatus;
        BIBoolean bIBoolean;
        Obj obj = null;
        if (bValue == null) {
            obj = new Obj();
            obj.setNull(true);
            return obj;
        }
        if (bValue instanceof BIBoolean) {
            bIBoolean = (BIBoolean)bValue;
            obj = new Bool(bIBoolean.getBoolean());
        } else if (bValue instanceof BAbsTime) {
            bIBoolean = (BAbsTime)bValue;
            obj = new Abstime(bIBoolean.getMillis(), TimeZone.getTimeZone(bIBoolean.getTimeZone().getId()));
        } else if (bValue instanceof BRelTime) {
            bIBoolean = (BRelTime)bValue;
            obj = new Reltime(bIBoolean.getMillis());
        } else if (bValue instanceof BInteger) {
            bIBoolean = (BInteger)bValue;
            obj = new Int((long)bIBoolean.getInt());
        } else if (bValue instanceof BINumeric) {
            bIBoolean = (BINumeric)bValue;
            obj = new Real(bIBoolean.getNumeric());
        } else if (bValue instanceof BIEnum) {
            bIBoolean = (BIEnum)bValue;
            bStatus = new Enum();
            bStatus.set(SlotPath.unescape((String)bIBoolean.getEnum().getTag()));
            BEnumRange bEnumRange = null;
            if (context != null) {
                bEnumRange = (BEnumRange)context.getFacets().get("range");
            }
            if (bEnumRange == null) {
                bEnumRange = (BEnumRange)bIBoolean.getEnumFacets().get("range");
            }
            if (bEnumRange != null) {
                bStatus.set(SlotPath.unescape((String)bEnumRange.getTag(bIBoolean.getEnum().getOrdinal())));
            }
            obj = bStatus;
        } else {
            bIBoolean = new Str();
            try {
                if (bValue.isSimple()) {
                    bIBoolean.set(bValue.asSimple().encodeToString());
                } else {
                    bIBoolean.set(bValue.toString(context));
                }
            }
            catch (Exception exception) {
                bIBoolean.set(bValue.toString(context));
            }
            obj = bIBoolean;
        }
        if (bValue instanceof BIStatus) {
            bIBoolean = (BIStatus)bValue;
            bStatus = bIBoolean.getStatus();
            if (bStatus.isDisabled()) {
                obj.setStatus(Status.disabled);
            } else if (bStatus.isFault()) {
                obj.setStatus(Status.fault);
            } else if (bStatus.isDown()) {
                obj.setStatus(Status.down);
            } else if (bStatus.isAlarm() && bStatus.isUnackedAlarm()) {
                obj.setStatus(Status.unackedAlarm);
            } else if (bStatus.isAlarm()) {
                obj.setStatus(Status.alarm);
            } else if (bStatus.isUnackedAlarm()) {
                obj.setStatus(Status.unacked);
            } else if (bStatus.isOverridden()) {
                obj.setStatus(Status.overridden);
            }
            if (bStatus.isNull()) {
                obj.setNull(true);
            }
        }
        if (bValue.isNull()) {
            obj.setNull(true);
        } else if (bValue instanceof BStatusValue && (bIBoolean = (BStatusValue)bValue).getValueValue().isNull()) {
            obj.setNull(true);
        }
        return obj;
    }

    public BSimple makeSimple(Obj obj, Context context) {
        BBoolean bBoolean = null;
        if (obj.isBool()) {
            Bool bool = (Bool)obj;
            bBoolean = bool.get() ? BBoolean.TRUE : BBoolean.FALSE;
        } else if (obj.isReal()) {
            Real real = (Real)obj;
            bBoolean = BDouble.make((double)real.get());
        } else if (obj.isInt()) {
            Int intVal = (Int)obj;
            bBoolean = BInteger.make((int)((int)intVal.get()));
        } else if (obj.isEnum()) {
            BEnumRange bEnumRange = (BEnumRange)context.getFacets().get("range");
            Enum enum_ = (Enum)obj;
            if (bEnumRange == null) {
                try {
                    bBoolean = BDynamicEnum.make((int)Integer.parseInt(enum_.get()));
                }
                catch (Exception exception) {
                    throw new WrapperException(exception);
                }
            } else {
                try {
                    bBoolean = bEnumRange.get(SlotPath.escape((String)enum_.get()));
                }
                catch (Exception exception) {
                    try {
                        bBoolean = BDynamicEnum.make((int)Integer.parseInt(enum_.get()));
                    }
                    catch (Exception exception2) {
                        throw new WrapperException(exception);
                    }
                }
            }
        } else if (obj.isReltime()) {
            Reltime reltime = (Reltime)obj;
            bBoolean = BRelTime.make((long)reltime.get());
        } else if (obj.isVal()) {
            Val val = (Val)obj;
            bBoolean = BString.make((String)val.encodeVal());
        } else {
            bBoolean = BString.make((String)obj.toDisplayString());
        }
        return bBoolean;
    }

    public BStatusValue makeStatusValue(Obj obj, BFacets bFacets) {
        int n;
        Object object;
        Bool bool;
        BStatusBoolean bStatusBoolean = null;
        if (obj.isBool()) {
            bool = (Bool)obj;
            bStatusBoolean = new BStatusBoolean();
            bStatusBoolean.setValueValue((BValue)BBoolean.make((boolean)bool.get()));
        } else if (obj.isReal()) {
            bool = (Real)obj;
            bStatusBoolean = new BStatusNumeric();
            bStatusBoolean.setValueValue((BValue)BDouble.make((double)bool.get()));
        } else if (obj.isInt()) {
            bool = (Int)obj;
            bStatusBoolean = new BStatusNumeric();
            bStatusBoolean.setValueValue((BValue)BDouble.make((double)bool.get()));
        } else if (obj.isEnum()) {
            bool = (BEnumRange)bFacets.get("range");
            object = (Enum)obj;
            BStatusEnum bStatusEnum = new BStatusEnum();
            bStatusBoolean = bStatusEnum;
            if (bool == null) {
                try {
                    bStatusEnum.setValue(BDynamicEnum.make((int)Integer.parseInt(object.get())));
                }
                catch (Exception exception) {
                    throw new WrapperException(exception);
                }
            } else {
                try {
                    bStatusEnum.setValue(bool.get(SlotPath.escape((String)object.get())));
                }
                catch (Exception exception) {
                    try {
                        bStatusEnum.setValueValue((BValue)BDynamicEnum.make((int)Integer.parseInt(object.get())));
                    }
                    catch (Exception exception2) {
                        throw new WrapperException(exception);
                    }
                }
            }
        } else if (obj.isReltime()) {
            bool = (Reltime)obj;
            bStatusBoolean = new BStatusNumeric();
            bStatusBoolean.setValueValue((BValue)BDouble.make((double)bool.get()));
        } else if (obj.isVal()) {
            bool = (Val)obj;
            bStatusBoolean = new BStatusString();
            bStatusBoolean.setValueValue((BValue)BString.make((String)bool.encodeVal()));
        } else {
            bStatusBoolean = new BStatusString();
            bStatusBoolean.setValueValue((BValue)BString.make((String)obj.toDisplayString()));
        }
        bool = obj.getStatus();
        if (bool == Status.alarm) {
            bStatusBoolean.setStatus(BStatus.alarm);
        } else if (bool == Status.disabled) {
            bStatusBoolean.setStatus(BStatus.disabled);
        } else if (bool == Status.down) {
            bStatusBoolean.setStatus(BStatus.down);
        } else if (bool == Status.fault) {
            bStatusBoolean.setStatus(BStatus.fault);
        } else if (bool == Status.ok) {
            bStatusBoolean.setStatus(BStatus.ok);
        } else if (bool == Status.overridden) {
            bStatusBoolean.setStatus(BStatus.overridden);
        } else if (bool == Status.unacked) {
            bStatusBoolean.setStatus(BStatus.unackedAlarm);
        } else if (bool == Status.unackedAlarm) {
            bStatusBoolean.setStatus(BStatus.makeAlarm((BStatus)BStatus.unackedAlarm, (boolean)true));
        }
        object = obj.getDisplay();
        if (object != null && (n = ((String)object).indexOf("@")) > 0) {
            bStatusBoolean.setStatus("activeLevel", (BIDataValue)BString.make((String)((String)object).substring(n + 1).trim()));
        }
        if (obj.isNull()) {
            bStatusBoolean.setStatusNull(true);
        }
        return bStatusBoolean;
    }

    public BUnit makeUnits(Uri uri) {
        if (uri.get().startsWith("obix:units/")) {
            String string = uri.get().substring(11);
            BUnit bUnit = BUnit.getUnit((String)(string = string.replace('_', ' ')));
            if (bUnit == null) {
                throw new RuntimeException("Unit not found: " + string);
            }
            return bUnit;
        }
        Obj obj = this.obixRead(uri);
        this.obixReadFully(obj);
        String string = obj.getDisplay();
        BUnit bUnit = BUnit.getUnit((String)string);
        if (bUnit != null) {
            return bUnit;
        }
        String string2 = obj.get("symbol").getStr();
        double d = obj.get("scale").getReal();
        Obj obj2 = obj.get("dimension");
        BDimension bDimension = BDimension.make((int)((int)obj2.get("m").getInt()), (int)((int)obj2.get("kg").getInt()), (int)((int)obj2.get("sec").getInt()), (int)((int)obj2.get("A").getInt()), (int)((int)obj2.get("K").getInt()), (int)((int)obj2.get("mol").getInt()), (int)((int)obj2.get("cd").getInt()));
        return BUnit.make((String)string, (String)string2, (BDimension)bDimension, (double)d);
    }

    public SessionWatch makeWatch(String string, long l, WatchListener watchListener) throws Exception {
        return this.session().makeWatch(string, l, watchListener);
    }

    public Obj obixInvoke(Uri uri, Obj obj) {
        try {
            this.debug(true, "Invoke Request: " + uri.get(), obj);
            Obj obj2 = this.session().invoke(this.getAbsoluteUri(uri), obj);
            this.debug(false, "Invoke Response: ", obj2);
            return obj2;
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
    }

    public Obj obixRead(Uri uri) {
        try {
            this.debug(true, "Read Request: ", (Obj)uri);
            Obj obj = this.session().read(this.getAbsoluteUri(uri));
            this.debug(false, "Read Response: ", obj);
            return obj;
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
    }

    public void obixReadChildren(Obj obj) {
        Obj[] objArray = obj.list();
        if (objArray == null) {
            return;
        }
        int n = objArray.length;
        while (--n >= 0) {
            if (!objArray[n].isRef()) continue;
            Obj obj2 = this.obixRead(objArray[n].getNormalizedHref());
            obj.replace(objArray[n], obj2);
        }
    }

    public void obixReadFully(Obj obj) {
        Obj[] objArray = obj.list();
        int n = objArray.length;
        while (--n >= 0) {
            if (objArray[n].isRef()) {
                Obj obj2 = this.obixRead(objArray[n].getNormalizedHref());
                obj.replace(objArray[n], obj2);
                objArray[n] = obj2;
            }
            this.obixReadFully(objArray[n]);
        }
    }

    public Obj obixWrite(Obj obj) {
        try {
            this.debug(true, "Write Request: ", obj);
            obj.setHref(this.getAbsoluteUri(obj.getHref()));
            Obj obj2 = this.session().write(obj);
            this.debug(false, "Write Response: ", obj2);
            return obj2;
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
    }

    public InputStream open(Uri uri) throws Exception {
        return this.session().open(this.getAbsoluteUri(uri));
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public IFuture postPing() {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, ping, null, null));
        return null;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("ObixClient");
        spyWriter.prop((Object)"licenseChecked", this.licenseChecked());
        spyWriter.prop((Object)"session", (Object)this.session);
        spyWriter.prop((Object)"network", (Object)this.network);
        spyWriter.prop((Object)"lobbyUri", (Object)this.lobbyUri);
        spyWriter.endProps();
        super.spy(spyWriter);
    }

    public final void started() throws Exception {
        this.network = null;
        super.started();
        this.deviceStarted();
    }

    public void stopped() throws Exception {
        try {
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
            if (this.getState().isEngaged()) {
                this.detach();
            }
        }
        catch (Exception exception) {}
        super.stopped();
    }

    public String toString(Context context) {
        return "ObixClient:" + this.getName();
    }

    protected void deviceAtSteadyState() throws Exception {
    }

    protected void deviceStarted() throws Exception {
    }

    protected Uri getFullRelativeUri(Obj obj, Uri uri) {
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void checkObixLicense(ObixSession obixSession) {
        if (this.licenseChecked()) {
            return;
        }
        if (this.isDown()) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            try {
                String string;
                Boolean bl = this.isTridiumServer(obixSession);
                if (bl == null) {
                    return;
                }
                if (!bl.booleanValue() && (string = this.getObixNetwork().checkObixLimit("foreignDevice.limit")) != null) {
                    this.configFatal(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.configFatal(exception.toString());
            }
            this.licenseChecked = true;
            return;
        }
    }

    private final void debug(boolean bl, String string, Obj obj) {
        if (bl && !this.getDebugRequests()) {
            return;
        }
        if (!bl && !this.getDebugResponses()) {
            return;
        }
        try {
            if (this.debugger == null) {
                this.debugger = new ObixEncoder((OutputStream)System.out);
            }
            System.out.println(string);
            this.debugger.encode(obj);
            this.debugger.flush();
        }
        catch (Exception exception) {}
    }

    private final Boolean isTridiumServer(ObixSession obixSession) {
        if (this.tridium != null) {
            return this.tridium;
        }
        if (this.isDown()) {
            return null;
        }
        try {
            Obj obj;
            String string;
            Obj obj2;
            String string2;
            Obj obj3 = obixSession.read(this.lobby());
            if (obj3 == null) {
                return null;
            }
            Obj obj4 = obj3.get("about");
            if (obj4 == null) {
                return null;
            }
            if (obj4.getHref() != null && (string2 = (obj2 = (obj4 = obixSession.read(obj4.getNormalizedHref())).get("vendorName")).getStr()).indexOf("Tridium") >= 0 && (string = (obj = obj4.get("productName")).getStr()).indexOf("Niagara") >= 0) {
                this.tridium = Boolean.TRUE;
                return this.tridium;
            }
            this.tridium = Boolean.FALSE;
        }
        catch (ConnectException connectException) {
            this.pingFail(connectException.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.tridium = Boolean.FALSE;
        }
        return this.tridium;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean licenseChecked() {
        Object object = this.sync;
        synchronized (object) {
            return this.licenseChecked;
        }
    }

    private final Uri lobby() {
        if (this.lobbyUri == null) {
            String string = this.getLobby();
            if (!string.endsWith("/")) {
                string = string + '/';
            }
            this.lobbyUri = new Uri(string);
        }
        return this.lobbyUri;
    }

    private final Uri normalize(Obj obj, Uri uri) {
        if (uri == null || uri.get().equals("")) {
            return null;
        }
        if (obj == null) {
            return uri;
        }
        Uri uri2 = this.getAbsoluteUri(obj.getRoot().getHref());
        if (uri2 == null || uri2.get().equals("")) {
            return uri;
        }
        Uri uri3 = this.getFullRelativeUri(obj, uri);
        return uri3.normalize(uri2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ObixSession session() {
        try {
            Object object;
            if (this.session == null) {
                object = new ObixSession(new Uri(this.getLobby()), this.getAuthUser(), this.getAuthPass().getValue(), (int)this.getSessionTimeout().getMillis());
                object.open();
                this.session = object;
            }
            object = this.sync;
            synchronized (object) {
                if (this.licenseChecked()) return this.session;
                this.checkObixLicense(this.session);
                return this.session;
            }
        }
        catch (IOException iOException) {
            this.pingFail(iOException.toString());
            throw new WrapperException(iOException);
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
    }

    private final void setAttached() {
        this.setState(BObixState.attached);
    }

    private final void setAttaching() {
        this.setState(BObixState.attaching);
    }

    private final void setDetached() {
        this.setState(BObixState.detached);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.licenseChecked = false;
        this.tridium = null;
        this.sync = new Object();
    }

    public BObixClient() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$obix$driver$BObixClient;
        if (clazz == null) {
            clazz = class$javax$baja$obix$driver$BObixClient = BObixClient.class("[Ljavax.baja.obix.driver.BObixClient;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

