/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.util;

import com.tridium.obix.util.ObixConstants;
import com.tridium.obix.util.ObixUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.baja.obix.io.BIObixAgent;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.xml.XWriter;

public class Obj
implements ObixConstants {
    String display;
    String displayName;
    String element;
    String href;
    String icon;
    String in;
    String is;
    String max;
    String min;
    String name;
    Boolean nil;
    String of;
    String out;
    String precision;
    String range;
    String status;
    String tz;
    String units;
    String val;
    Boolean writable;

    public String getDisplayName() {
        return this.displayName;
    }

    public Obj setDisplayName(String string) {
        this.displayName = string;
        return this;
    }

    public String getDisplay() {
        return this.display;
    }

    public Obj setDisplay(String string) {
        this.display = string;
        return this;
    }

    public String getElement() {
        return this.element;
    }

    public Obj setElement(String string) {
        this.element = string;
        return this;
    }

    public String getHref() {
        return this.href;
    }

    public Obj setHref(String string) {
        this.href = string;
        return this;
    }

    public String getIcon() {
        return this.icon;
    }

    public Obj setIcon(String string) {
        this.icon = string;
        return this;
    }

    public String getIn() {
        return this.in;
    }

    public Obj setIn(String string) {
        this.in = string;
        return this;
    }

    public String getIs() {
        return this.is;
    }

    public Obj setIs(String string) {
        this.is = string;
        return this;
    }

    public String getMax() {
        return this.max;
    }

    public Obj setMax(String string) {
        this.max = string;
        return this;
    }

    public String getMin() {
        return this.min;
    }

    public Obj setMin(String string) {
        this.min = string;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Obj setName(String string) {
        this.name = string;
        return this;
    }

    public Boolean getNull() {
        return this.nil;
    }

    public boolean isNull() {
        boolean bl = false;
        if (this.nil != null && this.nil.booleanValue()) {
            bl = true;
        }
        return bl;
    }

    public Obj setNull(Boolean bl) {
        this.nil = bl;
        return this;
    }

    public String getOf() {
        return this.of;
    }

    public Obj setOf(String string) {
        this.of = string;
        return this;
    }

    public String getOut() {
        return this.out;
    }

    public Obj setOut(String string) {
        this.out = string;
        return this;
    }

    public String getPrecision() {
        return this.precision;
    }

    public Obj setPrecision(String string) {
        this.precision = string;
        return this;
    }

    public String getRange() {
        return this.range;
    }

    public Obj setRange(String string) {
        this.range = string;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public Obj setStatus(String string) {
        this.status = string;
        return this;
    }

    public String getTz() {
        return this.tz;
    }

    public Obj setTz(String string) {
        this.tz = string;
        return this;
    }

    public String getUnits() {
        return this.units;
    }

    public Obj setUnits(String string) {
        this.units = string;
        return this;
    }

    public String getVal() {
        return this.val;
    }

    public Obj setVal(String string) {
        this.val = string;
        return this;
    }

    public Boolean getWritable() {
        return this.writable;
    }

    public Obj setWritable(Boolean bl) {
        this.writable = bl;
        return this;
    }

    public void addContract(String string) {
        this.addContract(string, false);
    }

    public void addPrimaryContract(String string) {
        this.addContract(string, true);
    }

    public Obj endElem(ObixEncoder obixEncoder) {
        XWriter xWriter = obixEncoder.getWriter();
        xWriter.indent(obixEncoder.outdent());
        xWriter.w((Object)"</").w((Object)this.element).w((Object)">\n");
        return this;
    }

    public String[] getContracts() {
        return this.getContracts(this.is);
    }

    public Obj initAbstime(String string, BAbsTime bAbsTime) {
        this.reset().setElement("abstime").setName(string);
        if (bAbsTime == null || bAbsTime.isNull()) {
            return this.setNull(Boolean.TRUE);
        }
        return this.setVal(ObixUtils.dateTime(bAbsTime)).setTz(bAbsTime.getTimeZone().getId());
    }

    public Obj initAbstime(String string, String string2) {
        return this.reset().setElement("abstime").setName(string).setVal(string2);
    }

    public Obj initBool(String string, boolean bl) {
        this.reset().setElement("bool").setName(string);
        return this.setVal(bl ? "true" : "false");
    }

    public Obj initEnum(String string, String string2) {
        return this.reset().setElement("enum").setName(string).setVal(string2);
    }

    public Obj initErr(String string, String string2) {
        return this.reset().setElement("err").setHref(string).setDisplay(string2);
    }

    public Obj initFeed(String string, String string2, String string3) {
        return this.reset().setElement("feed").setName(string).setIn(string2).setOf(string3);
    }

    public Obj initInt(String string, int n) {
        this.reset().setElement("int").setName(string);
        return this.setVal(String.valueOf(n));
    }

    public Obj initList(String string, String string2) {
        return this.reset().setElement("list").setName(string).setOf(string2);
    }

    public Obj initObj(String string) {
        return this.reset().setName(string);
    }

    public Obj initOp(String string, String string2, String string3) {
        this.reset().setElement("op").setName(string);
        return this.setIn(string2).setOut(string3);
    }

    public Obj initReal(String string, double d) {
        this.reset().setElement("real").setName(string);
        return this.setVal(String.valueOf(d));
    }

    public Obj initRef(String string, String string2) {
        return this.reset().setElement("ref").setName(string).setHref(string2);
    }

    public Obj initReltime(String string, String string2) {
        return this.reset().setElement("reltime").setName(string).setVal(string2);
    }

    public Obj initStr(String string, String string2) {
        return this.reset().setElement("str").setName(string).setVal(string2);
    }

    public Obj initUri(String string, String string2) {
        return this.reset().setElement("uri").setName(string).setVal(string2);
    }

    public Obj makeRef() {
        this.setIn(null);
        this.setMax(null);
        this.setMin(null);
        this.setOf(null);
        this.setOut(null);
        this.setPrecision(null);
        this.setRange(null);
        this.setStatus(null);
        this.setTz(null);
        this.setUnits(null);
        this.setVal(null);
        this.setElement("ref");
        return this;
    }

    public Obj newCopy() {
        Obj obj = new Obj();
        obj.display = this.display;
        obj.displayName = this.displayName;
        obj.element = this.element;
        obj.href = this.href;
        obj.icon = this.icon;
        obj.in = this.in;
        obj.is = this.is;
        obj.max = this.max;
        obj.min = this.min;
        obj.name = this.name;
        obj.nil = this.nil;
        obj.of = this.of;
        obj.out = this.out;
        obj.precision = this.precision;
        obj.range = this.range;
        obj.status = this.status;
        obj.tz = this.tz;
        obj.units = this.units;
        obj.val = this.val;
        obj.writable = this.writable;
        return obj;
    }

    public final Obj reset() {
        this.display = null;
        this.displayName = null;
        this.element = "obj";
        this.href = null;
        this.icon = null;
        this.in = null;
        this.is = null;
        this.max = null;
        this.min = null;
        this.name = null;
        this.nil = null;
        this.of = null;
        this.out = null;
        this.precision = null;
        this.range = null;
        this.status = null;
        this.tz = null;
        this.units = null;
        this.val = null;
        this.writable = null;
        return this;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.href != null) {
            stringBuffer.append("href=").append(this.href).append(',');
        }
        if (this.name != null) {
            stringBuffer.append("name=").append(this.name).append(',');
        }
        if (this.is != null) {
            stringBuffer.append("is=").append(this.is).append(',');
        }
        if (this.val != null) {
            stringBuffer.append("val=").append(this.val).append(',');
        }
        if (this.element != null) {
            stringBuffer.append("element=").append(this.element).append(',');
        }
        if (this.displayName != null) {
            stringBuffer.append("displayName=").append(this.displayName).append(',');
        }
        if (this.display != null) {
            stringBuffer.append("display=").append(this.display).append(',');
        }
        if (this.icon != null) {
            stringBuffer.append("icon=").append(this.icon).append(',');
        }
        if (this.in != null) {
            stringBuffer.append("in=").append(this.in).append(',');
        }
        if (this.max != null) {
            stringBuffer.append("max=").append(this.max).append(',');
        }
        if (this.min != null) {
            stringBuffer.append("min=").append(this.min).append(',');
        }
        if (this.nil != null) {
            stringBuffer.append("null=").append(this.nil).append(',');
        }
        if (this.of != null) {
            stringBuffer.append("of=").append(this.of).append(',');
        }
        if (this.out != null) {
            stringBuffer.append("out=").append(this.out).append(',');
        }
        if (this.precision != null) {
            stringBuffer.append("precision=").append(this.precision).append(',');
        }
        if (this.range != null) {
            stringBuffer.append("range=").append(this.range).append(',');
        }
        if (this.status != null) {
            stringBuffer.append("status=").append(this.status).append(',');
        }
        if (this.tz != null) {
            stringBuffer.append("tz=").append(this.tz).append(',');
        }
        if (this.units != null) {
            stringBuffer.append("units=").append(this.units).append(',');
        }
        if (this.writable != null) {
            stringBuffer.append("writable=").append(this.writable);
        }
        if ((n = stringBuffer.length()) > 0 && stringBuffer.charAt(--n) == ',') {
            stringBuffer.setLength(n);
        }
        return stringBuffer.toString();
    }

    public void write(ObixEncoder obixEncoder, boolean bl) {
        this.write(obixEncoder, bl, null);
    }

    public void write(ObixEncoder obixEncoder, boolean bl, BIObixAgent bIObixAgent) {
        String string;
        String string2 = this.displayName;
        String string3 = this.display;
        String string4 = this.href;
        String string5 = this.icon;
        String string6 = this.in;
        String string7 = this.is;
        String string8 = this.max;
        String string9 = this.min;
        String string10 = this.name;
        String string11 = this.nil == null ? null : String.valueOf(this.nil);
        String string12 = this.of;
        String string13 = this.out;
        String string14 = this.precision;
        String string15 = this.range;
        String string16 = this.status;
        String string17 = this.tz;
        String string18 = this.units;
        String string19 = this.val;
        String string20 = string = this.writable == null ? null : String.valueOf(this.writable);
        if (bIObixAgent != null) {
            if (!this.element.equals("ref")) {
                this.element = bIObixAgent.processElem(this.element);
            }
            string2 = bIObixAgent.processAttr("displayName", string2);
            string3 = bIObixAgent.processAttr("display", string3);
            string4 = bIObixAgent.processAttr("href", string4);
            string5 = bIObixAgent.processAttr("icon", string5);
            string6 = bIObixAgent.processAttr("in", string6);
            string7 = bIObixAgent.processAttr("is", string7);
            string8 = bIObixAgent.processAttr("max", string8);
            string9 = bIObixAgent.processAttr("min", string9);
            string10 = bIObixAgent.processAttr("name", string10);
            string11 = bIObixAgent.processAttr("null", string11);
            string12 = bIObixAgent.processAttr("of", string12);
            string13 = bIObixAgent.processAttr("out", string13);
            string14 = bIObixAgent.processAttr("precision", string14);
            string15 = bIObixAgent.processAttr("range", string15);
            string16 = bIObixAgent.processAttr("status", string16);
            string17 = bIObixAgent.processAttr("tz", this.tz);
            string18 = bIObixAgent.processAttr("unit", string18);
            string19 = bIObixAgent.processAttr("val", string19);
            string = bIObixAgent.processAttr("writable", string);
        }
        XWriter xWriter = obixEncoder.getWriter();
        if (string19 != null && string3 != null && string19.equals(string3)) {
            string3 = null;
        }
        if (string10 != null && string2 != null && string10.equals(string2)) {
            string2 = null;
        }
        if (this.element == null) {
            throw new IllegalStateException("Missing element name: " + this.toString());
        }
        xWriter.indent(obixEncoder.getIndent());
        xWriter.w('<').w((Object)this.element);
        if (string10 != null) {
            xWriter.w(' ').attr("name", string10);
        }
        if (string19 != null) {
            xWriter.w(' ').attr("val", string19);
        }
        if (string16 != null) {
            xWriter.w(' ').attr("status", string16);
        }
        if (string4 != null) {
            xWriter.w(' ').attr("href", string4);
        }
        if (string7 != null && obixEncoder.getEncodeIs()) {
            if (obixEncoder.getIndent() == 0) {
                xWriter.w(' ').attr("is", this.cleanContracts(string4, string7));
            } else {
                xWriter.w(' ').attr("is", string7);
            }
        }
        if (string12 != null) {
            xWriter.w(' ').attr("of", string12);
        }
        if (string6 != null) {
            xWriter.w(' ').attr("in", string6);
        }
        if (string13 != null) {
            xWriter.w(' ').attr("out", string13);
        }
        if (string11 != null) {
            xWriter.w(' ').attr("null", string11);
        }
        if (obixEncoder.getEncodeFacets()) {
            if (string3 != null) {
                xWriter.w(' ').attr("display", string3);
            }
            if (string2 != null) {
                xWriter.w(' ').attr("displayName", string2);
            }
            if (string5 != null) {
                xWriter.w(' ').attr("icon", string5);
            }
            if (string8 != null) {
                xWriter.w(' ').attr("max", string8);
            }
            if (string9 != null) {
                xWriter.w(' ').attr("min", string9);
            }
            if (string14 != null) {
                xWriter.w(' ').attr("precision", string14);
            }
            if (string15 != null) {
                xWriter.w(' ').attr("range", string15);
            }
            if (string17 != null) {
                xWriter.w(' ').attr("tz", string17);
            }
            if (string18 != null) {
                xWriter.w(' ').attr("unit", string18);
            }
            if (string != null && string4 != null) {
                xWriter.w(' ').attr("writable", string);
            }
        }
        if (obixEncoder.getIndent() == 0) {
            obixEncoder.attributes().put("xmlns", "http://obix.org/ns/schema/1.0");
        }
        this.writeAttributes(obixEncoder);
        if (bl) {
            xWriter.w((Object)">\n");
            obixEncoder.indent();
        } else {
            xWriter.w((Object)"/>\n");
        }
    }

    private final void addContract(String string, boolean bl) {
        if (string == null) {
            return;
        }
        String[] stringArray = this.getContracts();
        int n = stringArray.length;
        while (--n >= 0) {
            if (!stringArray[n].equals(string)) continue;
            return;
        }
        this.is = this.is == null ? string.trim() : (bl ? string + ' ' + this.is : this.is + ' ' + string);
    }

    private final String cleanContracts(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string2;
        }
        String[] stringArray = this.getContracts(string2);
        if (stringArray == null) {
            return string2;
        }
        int n = stringArray.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (this.match(string, stringArray[n2])) {
                bl = true;
                stringArray[n2] = null;
                break;
            }
            ++n2;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n) {
                if (stringArray[n3] != null) {
                    stringBuffer.append(stringArray[n3]).append(' ');
                }
                ++n3;
            }
            string2 = stringBuffer.toString().trim();
        }
        return string2;
    }

    private final String[] getContracts(String string) {
        if (string == null) {
            return new String[0];
        }
        int n = string.length();
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c <= ' ') {
                if (stringBuffer.length() > 0) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString());
        }
        n = vector.size();
        Object[] objectArray = new String[n];
        if (n == 0) {
            return objectArray;
        }
        vector.copyInto(objectArray);
        return objectArray;
    }

    private final boolean match(String string, String string2) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return false;
        }
        boolean bl = false;
        if (n + string2.length() + 1 >= this.href.length()) {
            bl = true;
        }
        return bl;
    }

    private final void writeAttributes(ObixEncoder obixEncoder) {
        Map map = obixEncoder.attributes();
        if (map != null && map.size() > 0) {
            XWriter xWriter = obixEncoder.getWriter();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                xWriter.w(' ').attr(string, (String)map.get(string));
            }
            map.clear();
        }
    }

    public Obj() {
        this.element = "obj";
    }

    public Obj(String string) {
        this.element = string;
    }
}

