/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.util.ObixConstants;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.WrapperException;
import java.net.InetAddress;
import javax.baja.history.BHistoryService;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.obix.driver.lobby.BIObixLobbyAgent;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixAbout
extends BObixAgent
implements BIObixLobbyAgent,
ObixConstants {
    public static final Property obixVersion = BObixAbout.newProperty((int)257, (String)"1.0", null);
    public static final Property serverName = BObixAbout.newProperty((int)257, (String)BObixAbout.serverName(), null);
    public static final Property serverTime = BObixAbout.newProperty((int)257, (BValue)Clock.time(), null);
    public static final Property serverBootTime = BObixAbout.newProperty((int)257, (BValue)Clock.time(), null);
    public static final Property vendorName = BObixAbout.newProperty((int)257, (String)"Tridium, Inc.", null);
    public static final Property vendorUrl = BObixAbout.newProperty((int)257, (BValue)BOrd.make((String)"http://www.tridium.com"), null);
    public static final Property productName = BObixAbout.newProperty((int)257, (String)"Niagara AX", null);
    public static final Property productVersion = BObixAbout.newProperty((int)257, (String)BObixAbout.version(), null);
    public static final Property productUrl = BObixAbout.newProperty((int)257, (BValue)BOrd.make((String)"http://www.tridium.com"), null);
    public static final Property tz = BObixAbout.newProperty((int)257, (String)BObixAbout.tz(), null);
    public static final Property componentCount = BObixAbout.newProperty((int)261, (String)BObixAbout.componentCount(), null);
    public static final Property localHistoryCount = BObixAbout.newProperty((int)261, (String)BObixAbout.localHistoryCount(), null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$obix$server$BObixAbout;

    public String getObixVersion() {
        return this.getString(obixVersion);
    }

    public void setObixVersion(String string) {
        this.setString(obixVersion, string, null);
    }

    public String getServerName() {
        return this.getString(serverName);
    }

    public void setServerName(String string) {
        this.setString(serverName, string, null);
    }

    public BAbsTime getServerTime() {
        return (BAbsTime)this.get(serverTime);
    }

    public void setServerTime(BAbsTime bAbsTime) {
        this.set(serverTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getServerBootTime() {
        return (BAbsTime)this.get(serverBootTime);
    }

    public void setServerBootTime(BAbsTime bAbsTime) {
        this.set(serverBootTime, (BValue)bAbsTime, null);
    }

    public String getVendorName() {
        return this.getString(vendorName);
    }

    public void setVendorName(String string) {
        this.setString(vendorName, string, null);
    }

    public BOrd getVendorUrl() {
        return (BOrd)this.get(vendorUrl);
    }

    public void setVendorUrl(BOrd bOrd) {
        this.set(vendorUrl, (BValue)bOrd, null);
    }

    public String getProductName() {
        return this.getString(productName);
    }

    public void setProductName(String string) {
        this.setString(productName, string, null);
    }

    public String getProductVersion() {
        return this.getString(productVersion);
    }

    public void setProductVersion(String string) {
        this.setString(productVersion, string, null);
    }

    public BOrd getProductUrl() {
        return (BOrd)this.get(productUrl);
    }

    public void setProductUrl(BOrd bOrd) {
        this.set(productUrl, (BValue)bOrd, null);
    }

    public String getTz() {
        return this.getString(tz);
    }

    public void setTz(String string) {
        this.setString(tz, string, null);
    }

    public String getComponentCount() {
        return this.getString(componentCount);
    }

    public void setComponentCount(String string) {
        this.setString(componentCount, string, null);
    }

    public String getLocalHistoryCount() {
        return this.getString(localHistoryCount);
    }

    public void setLocalHistoryCount(String string) {
        this.setString(localHistoryCount, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void encodeLobbyChild(ObixEncoder obixEncoder, Context context) {
        try {
            Obj obj = new Obj();
            obj.setHref(obixEncoder.getHref());
            obj.setName("about");
            obj.setElement("ref");
            obj.setIs("obix:About");
            obj.write(obixEncoder, false);
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
    }

    public String getLobbyName() {
        return "about";
    }

    public String processAttr(String string, String string2) {
        if (string.equals("is")) {
            return "obix:About";
        }
        return string2;
    }

    public OrdTarget resolve(String string, Context context) {
        this.setServerTime(Clock.time());
        try {
            BOrd bOrd = BOrd.make((String)"station:");
            bOrd = BOrd.make((BOrd)bOrd, (BOrd)this.getSlotPathOrd());
            if (string.equals("") || string.equals("/")) {
                return bOrd.resolve((BObject)Sys.getStation(), context);
            }
            bOrd = BOrd.make((BOrd)bOrd, (String)("slot:" + string.substring(1)));
            return bOrd.resolve((BObject)Sys.getStation(), context);
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
    }

    private static final String componentCount() {
        try {
            BStation bStation = Sys.getStation();
            if (bStation != null) {
                return "" + bStation.getComponentSpace().getComponentCount();
            }
            return "workbench";
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    private static final String localHistoryCount() {
        try {
            BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
            if (bHistoryDatabase instanceof BLocalHistoryDatabase) {
                BLocalHistoryDatabase bLocalHistoryDatabase = (BLocalHistoryDatabase)bHistoryDatabase;
                Cursor cursor = bLocalHistoryDatabase.cursor();
                int n = 0;
                while (cursor.next()) {
                    ++n;
                }
                return "" + n;
            }
            return "0";
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    private static final String serverName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    private static final String tz() {
        try {
            return BTimeZone.getLocal().getId();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    private static final String version() {
        try {
            BModule bModule = Sys.getBajaModule();
            Version version = bModule.getVendorVersion();
            return version.toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$obix$server$BObixAbout;
        if (clazz == null) {
            clazz = class$com$tridium$obix$server$BObixAbout = BObixAbout.class("[Lcom.tridium.obix.server.BObixAbout;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

