/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.point;

import com.tridium.obix.driver.point.BObixForceUpdate;
import com.tridium.obix.driver.point.BObixPointDeviceExt;
import com.tridium.obix.driver.point.BObixPointFolder;
import com.tridium.obix.driver.point.BObixProxyAction;
import com.tridium.obix.driver.util.BIObixPollable;
import com.tridium.obix.driver.util.BObixSubscription;
import com.tridium.obix.driver.util.BObixTuningPolicy;
import java.util.Hashtable;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIRemoteAlarmSource;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BIWritablePoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import obix.Contract;
import obix.Err;
import obix.Int;
import obix.Obj;
import obix.Op;
import obix.Reltime;
import obix.Uri;
import obix.io.ObixEncoder;
import obix.net.BatchIn;
import obix.net.ErrException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixProxyExt
extends BProxyExt
implements BIObixPollable,
BIRemoteAlarmSource {
    public static final Property deviceFacets = BObixProxyExt.newProperty((int)0, (BValue)BObixProxyExt.makeDeviceFacets(), null);
    public static final Property href = BObixProxyExt.newProperty((int)0, (String)"", null);
    public static final Property subscription = BObixProxyExt.newProperty((int)67, (BValue)BObixSubscription.unsubscribed, null);
    public static final Action forceUpdate = BObixProxyExt.newAction((int)0, null);
    public static final Action ackAlarm = BObixProxyExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE;
    static Uri writablePoint;
    private static final String R2CMD_MANUAL_SET = "manualSet";
    private static final String R2CMD_MANUAL_ACTIVE = "manualActive";
    private static final String R2CMD_MANUAL_INACTIVE = "manualInactive";
    private static final String R2CMD_MANUAL_AUTO = "manualAuto";
    private static final String R2CMD_OVERRIDE = "override";
    private static final String R2CMD_CANCEL = "cancel";
    private static final String R2CMD_SET_OVERRIDE_VALUE = "setOverrideValue";
    private BObixPointDeviceExt deviceExt;
    private BObixPointFolder folder;
    private boolean force;
    private boolean readSubscribed;
    private String subscribedHref;
    private Context context;
    private boolean licenseChecked;
    private boolean fatalFault;
    private String fatalFaultCause;
    static /* synthetic */ Class class$com$tridium$obix$driver$point$BObixProxyExt;

    public String getHref() {
        return this.getString(href);
    }

    public void setHref(String string) {
        this.setString(href, string, null);
    }

    public BObixSubscription getSubscription() {
        return (BObixSubscription)this.get(subscription);
    }

    public void setSubscription(BObixSubscription bObixSubscription) {
        this.set(subscription, (BValue)bObixSubscription, null);
    }

    public void forceUpdate() {
        this.invoke(forceUpdate, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void atSteadyState() throws Exception {
        super.atSteadyState();
        if (!this.isDisabled()) {
            this.getObixNetwork().enqueue(new Runnable(){

                public final void run() {
                    BObixProxyExt.this.checkObixLicense();
                }
            });
        }
        this.proxyAtSteadyState();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        this.context = context;
        if (context == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)href)) {
            if (this.subscribedHref != null && this.getSubscription().isSubscribed()) {
                this.getObixPointDeviceExt().unsubscribe(this.subscribedHref, this, context);
            }
            if (this.isReadSubscribed()) {
                this.readSubscribed(context);
            }
        } else if (property.equals((Object)enabled)) {
            if (!this.isDisabled()) {
                this.checkObixLicense();
            }
        } else if (property.equals((Object)tuningPolicyName)) {
            this.getObixPointDeviceExt().updateRefreshPeriod(this.getTuningPolicy().getStaleTime());
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        return this.getObixClient().getAlarms().doAckAlarm(bAlarmRecord);
    }

    public void doForceUpdate() {
        this.force = true;
        this.read();
    }

    public Type getDeviceExtType() {
        return BObixPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        if (this.getParent() instanceof BIWritablePoint) {
            return BReadWriteMode.readWrite;
        }
        return BReadWriteMode.readonly;
    }

    public BObixPointFolder getFolder() {
        if (this.folder == null) {
            BComplex bComplex = this.getParent();
            while (bComplex != null) {
                if (bComplex instanceof BObixPointFolder) {
                    this.folder = (BObixPointFolder)bComplex;
                    break;
                }
                bComplex = bComplex.getParent();
            }
        }
        return this.folder;
    }

    public Log getLog() {
        return this.getObixPointDeviceExt().getLog();
    }

    public BObixClient getObixClient() {
        return (BObixClient)this.getDevice();
    }

    public BObixPointDeviceExt getObixPointDeviceExt() {
        if (this.deviceExt == null) {
            this.deviceExt = (BObixPointDeviceExt)this.getDeviceExt();
        }
        return this.deviceExt;
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public BPollFrequency getPollFrequency() {
        return ((BObixTuningPolicy)this.getTuningPolicy()).getPollFrequency();
    }

    public boolean isReadSubscribed() {
        return this.readSubscribed;
    }

    public void poll() {
        if (this.getSubscription().isUnsubscribed()) {
            this.read();
        }
        if (this.getObixClient().isTridiumServer().booleanValue()) {
            BObixPointDeviceExt bObixPointDeviceExt = this.getObixPointDeviceExt();
            if (bObixPointDeviceExt.getSubLog().isTraceOn()) {
                bObixPointDeviceExt.getSubLog().trace("resubscribing polled point " + this.toPathString() + " in " + (Object)((Object)this.getObixClient()));
            }
            this.getObixPointDeviceExt().subscribe(this, BObixPointDeviceExt.pollCx);
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public void read() {
        this.getObixPointDeviceExt().read(this);
    }

    public void readSubscribed(Context context) {
        this.context = context;
        if (!this.licenseChecked) {
            this.checkObixLicense();
        }
        if (this.fatalFault) {
            this.readFail(this.fatalFaultCause);
            return;
        }
        this.readSubscribed = true;
        if (this.getSubscription().isSubscribed()) {
            return;
        }
        if (this.getHref().equals("")) {
            this.subscribeFail("Empty href");
        } else {
            this.setSubscription(BObixSubscription.pending);
            this.getObixPointDeviceExt().subscribe(this, BObixPointDeviceExt.readSubscribedCx);
        }
    }

    public void readUnsubscribed(Context context) {
        this.readSubscribed = false;
        this.context = context;
        if (!this.getSubscription().isUnsubscribed()) {
            this.getObixPointDeviceExt().unsubscribe(this.subscribedHref != null ? this.subscribedHref : this.getHref(), this, context);
        } else {
            this.getObixClient().getPollScheduler().unsubscribe(this);
        }
        this.setSubscription(BObixSubscription.unsubscribed);
    }

    public void setStale(boolean bl, Context context) {
        super.setStale(bl, context);
        this.context = context;
        if (Sys.atSteadyState() && bl && this.getObixClient().getStatus().isValid() && this.getSubscription().isSubscribed()) {
            if (this.getObixPointDeviceExt().getSubDebug()) {
                System.out.println("setting stale on " + this + " in " + (Object)((Object)this.getObixClient()) + "; resubscribing");
            }
            this.getObixPointDeviceExt().subscribe(this, BObixPointDeviceExt.staleCx);
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("ObixProxyExt");
        spyWriter.prop((Object)"deviceExt", (Object)this.deviceExt);
        spyWriter.prop((Object)"folder", (Object)this.folder);
        spyWriter.prop((Object)"force", this.force);
        spyWriter.prop((Object)"readSubscribed", this.readSubscribed);
        spyWriter.prop((Object)"subscribedHref", (Object)this.subscribedHref);
        spyWriter.prop((Object)"licenseChecked", this.licenseChecked);
        spyWriter.prop((Object)"fatalFault", this.fatalFault);
        spyWriter.prop((Object)"fatalFaultCause", (Object)this.fatalFaultCause);
        spyWriter.endProps();
        super.spy(spyWriter);
    }

    public final void started() throws Exception {
        super.started();
        this.proxyStarted();
    }

    public void stopped() throws Exception {
        this.deviceExt = null;
        this.folder = null;
        super.stopped();
    }

    public String toString(Context context) {
        return "ObixPxExt:" + this.getHref();
    }

    public boolean write(Context context) {
        this.context = context;
        if (!this.licenseChecked) {
            this.checkObixLicense();
        }
        if (this.fatalFault) {
            this.writeFail(this.fatalFaultCause);
            return false;
        }
        if (this.getHref().equals("")) {
            return false;
        }
        this.getObixPointDeviceExt().write(this, context);
        return true;
    }

    protected void batchWrite(BatchIn batchIn) {
        block10: {
            BEnumRange bEnumRange;
            BComplex bComplex = this.getParent();
            BFacets bFacets = this.getDeviceFacets();
            BEnumRange bEnumRange2 = bEnumRange = bFacets == null ? null : (BEnumRange)bFacets.get("range");
            if (bComplex instanceof BEnumWritable && (bEnumRange == null || bEnumRange.isNull())) {
                String string = this.context == null ? "" : this.context.getLanguage();
                Lexicon lexicon = Lexicon.make((String)"obixDriver", (String)string);
                String string2 = lexicon == null ? "No Range defined" : lexicon.get("ErrorMsg.enumRange", "No Range defined");
                this.writeFail(string2);
            } else {
                BStatusValue bStatusValue = this.getWriteValue();
                Obj obj = this.convert(bStatusValue);
                obj.setStatus(null);
                try {
                    if (this.getWriteOp() == null) {
                        if (!obj.isNull()) {
                            batchIn.write(obj);
                        } else {
                            this.writeReset();
                        }
                    } else {
                        Obj obj2 = new Obj();
                        obj2.setIs(new Contract("obix:WritePointIn"));
                        obj2.add("value", obj);
                        batchIn.invoke(new Uri(this.getWriteOp()), obj2);
                    }
                }
                catch (ErrException errException) {
                    if (this.isRunning()) {
                        this.writeFail(this.getErrorString(errException.err));
                    }
                }
                catch (Exception exception) {
                    if (!this.isRunning()) break block10;
                    this.writeFail(exception.toString());
                }
            }
        }
    }

    protected void batchWriteResult(Obj obj) {
        if (obj.isErr()) {
            this.writeFail(this.getErrorString((Err)obj));
        } else {
            this.writeOk(this.convert(obj));
        }
    }

    protected void force(Obj obj) {
        BFacets bFacets;
        Uri uri;
        Op op;
        if (!this.isRunning()) {
            return;
        }
        BControlPoint bControlPoint = (BControlPoint)this.getParent();
        if (bControlPoint == null) {
            return;
        }
        BObixClient bObixClient = this.getObixClient();
        if (bObixClient == null) {
            return;
        }
        Property[] propertyArray = bControlPoint.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            BValue bValue = bControlPoint.get(propertyArray[n]);
            if (bValue instanceof BObixForceUpdate) {
                bControlPoint.remove(propertyArray[n]);
            }
            if (bValue instanceof BObixProxyAction) {
                bControlPoint.remove(propertyArray[n]);
            }
            ++n;
        }
        bControlPoint.add("forceUpdate?", (BValue)new BObixForceUpdate());
        Obj[] objArray = obj.list();
        int n2 = 0;
        while (n2 < objArray.length) {
            if (objArray[n2].isOp()) {
                op = (Op)objArray[n2];
                uri = this.getObixPointDeviceExt().getFullNormalizedHref(op, obj);
                if (uri != null && this.isSimple(op.getIn()) && this.isSimple(op.getOut())) {
                    bFacets = this.getSimpleType(op.getIn().primary());
                    Type type = this.getSimpleType(op.getOut().primary());
                    uri = bObixClient.getRelativeUri(uri);
                    BObixProxyAction bObixProxyAction = new BObixProxyAction(uri.get(), (Type)bFacets, type);
                    int n3 = 0;
                    String string = op.getName();
                    if (string.equals(R2CMD_MANUAL_SET) || string.equals(R2CMD_MANUAL_ACTIVE) || string.equals(R2CMD_MANUAL_INACTIVE) || string.equals(R2CMD_MANUAL_AUTO) || string.equals(R2CMD_OVERRIDE) || string.equals(R2CMD_CANCEL) || string.equals(R2CMD_SET_OVERRIDE_VALUE)) {
                        n3 |= 0x100;
                    }
                    if ((string = op.toDisplayName()).equals("")) {
                        n3 |= 4;
                        string = op.getName();
                    }
                    string = SlotPath.escape((String)string);
                    bControlPoint.add(string + '?', (BValue)bObixProxyAction, n3);
                }
            }
            ++n2;
        }
        String string = this.getDeviceFacets().gets("boolUri", null);
        if (string != null) {
            op = new Uri(string);
            uri = bObixClient.makeBoolRange((Uri)op);
            bFacets = BFacets.make((BFacets)this.getDeviceFacets(), (BFacets)uri);
            this.setDeviceFacets(bFacets);
        }
        if ((string = this.getDeviceFacets().gets("enumUri", null)) != null) {
            op = new Uri(string);
            uri = BFacets.make((BFacets)this.getDeviceFacets(), (String)"range", (BIDataValue)bObixClient.makeEnumRange((Uri)op));
            this.setDeviceFacets((BFacets)uri);
        }
        if ((string = this.getDeviceFacets().gets("unitsUri", null)) != null) {
            op = new Uri(string);
            uri = BFacets.make((BFacets)this.getDeviceFacets(), (String)"units", (BIDataValue)bObixClient.makeUnits((Uri)op));
            this.setDeviceFacets((BFacets)uri);
        }
        if (this.getDeviceFacets().getb("uninitialized", false)) {
            op = BFacets.makeRemove((BFacets)this.getDeviceFacets(), (String)"uninitialized");
            this.setDeviceFacets((BFacets)op);
            op = BFacets.makeRemove((BFacets)op, (String)"element");
            op = BFacets.makeRemove((BFacets)op, (String)"boolUri");
            op = BFacets.makeRemove((BFacets)op, (String)"enumUri");
            op = BFacets.makeRemove((BFacets)op, (String)"unitsUri");
            uri = (BFacets)this.getParent().get("facets");
            uri = BFacets.make((BFacets)uri, (BFacets)op);
            this.getParent().set("facets", (BValue)uri);
        }
        if (this.isReadSubscribed() && this.getSubscription().isUnsubscribed()) {
            this.getObixPointDeviceExt().subscribe(this, BObixPointDeviceExt.forceCx);
        }
    }

    protected void performWrite() throws Exception {
        block8: {
            BStatusValue bStatusValue = this.getWriteValue();
            Obj obj = this.convert(bStatusValue);
            obj.setStatus(null);
            try {
                if (this.getWriteOp() == null) {
                    if (!obj.isNull()) {
                        obj = this.getObixClient().obixWrite(obj);
                    } else {
                        this.writeReset();
                    }
                } else {
                    obj = this.getObixClient().obixInvoke(new Uri(this.getWriteOp()), obj);
                }
                if (obj.isErr()) {
                    this.writeFail(this.getErrorString((Err)obj));
                } else {
                    this.writeOk(this.convert(obj));
                    this.getLog().trace("Write success (" + this.toPathString() + ") - " + bStatusValue);
                }
            }
            catch (ErrException errException) {
                if (!this.isRunning()) break block8;
                this.writeFail(this.getErrorString(errException.err));
            }
        }
    }

    protected void proxyAtSteadyState() throws Exception {
    }

    protected void proxyStarted() throws Exception {
    }

    protected void readOk(Obj obj) {
        block8: {
            try {
                Obj obj2;
                BFacets bFacets;
                if (this.fatalFault) {
                    this.readFail(this.fatalFaultCause);
                    return;
                }
                if (obj.isErr()) {
                    this.readFail(this.getErrorString((Err)obj));
                    return;
                }
                BFacets bFacets2 = this.getDeviceFacets();
                if (!bFacets2.equals((Object)(bFacets = BObixProxyExt.makeFacets(bFacets2, obj, this.getObixClient())))) {
                    this.setDeviceFacets(bFacets);
                }
                if (this.force || this.getDeviceFacets().getb("uninitialized", false)) {
                    obj2 = this.getObixPointDeviceExt().getForceObj(obj);
                    this.force = false;
                    this.force(obj2);
                }
                obj2 = this.convert(obj);
                this.readOk((BStatusValue)obj2);
                if (!obj2.getStatus().isOk()) {
                    this.setFaultCause("Status reported by server.");
                } else {
                    this.setFaultCause("");
                }
            }
            catch (Exception exception) {
                if (!this.isRunning()) break block8;
                this.getLog().error("Receiving - " + obj.getHref(), (Throwable)exception);
                this.readFail(exception.toString());
            }
        }
    }

    protected void subscribeFail(String string) {
        this.getLog().trace(this.toPathString() + ": subscribe failure (" + string + ')');
        this.setSubscription(BObixSubscription.unsubscribed);
        this.readFail(string);
    }

    protected void subscribeFailTryPolling(String string) {
        this.getLog().trace(this.toPathString() + ": subscribe failure (" + string + ')');
        this.setSubscription(BObixSubscription.unsubscribed);
        if (!this.getHref().equals("")) {
            this.getObixClient().getPollScheduler().subscribe(this);
        } else {
            this.readFail(string);
        }
    }

    protected void subscribeOk() {
        this.subscribedHref = this.getHref();
        this.setSubscription(BObixSubscription.subscribed);
        this.getObixClient().getPollScheduler().unsubscribe(this);
    }

    static BFacets makeFacets(BFacets bFacets, Obj obj, BObixClient bObixClient) throws Exception {
        Obj obj2;
        BFacets bFacets2 = bObixClient.makeFacets(bFacets, obj);
        Hashtable<String, BString> hashtable = new Hashtable<String, BString>();
        hashtable.put("element", BString.make((String)obj.getElement()));
        if (obj.getIs() != null && obj.getIs().contains(writablePoint) && (obj2 = obj.get("writePoint")) != null) {
            hashtable.put("writeOp", BString.make((String)bObixClient.getRelativeUri(obj2.getNormalizedHref()).get()));
        }
        return BFacets.make((BFacets)bFacets2, (BFacets)BFacets.make(hashtable));
    }

    private final void checkObixLicense() {
        String string;
        if (this.licenseChecked) {
            return;
        }
        Boolean bl = this.getObixClient().isTridiumServer();
        if (bl == null) {
            return;
        }
        if (!bl.booleanValue() && (string = this.getObixNetwork().checkObixLimit("foreignPoint.limit")) != null) {
            this.configFatal(string);
        }
        this.licenseChecked = true;
    }

    private final BStatusValue convert(Obj obj) {
        return this.getObixClient().makeStatusValue(obj, this.getDeviceFacets());
    }

    private final Obj convert(BStatusValue bStatusValue) {
        Obj obj = this.getObixClient().makeObj((BValue)bStatusValue, (Context)this.getDeviceFacets());
        String string = this.getElement();
        if (string.equals("int") && bStatusValue instanceof BStatusNumeric) {
            BDouble bDouble = (BDouble)bStatusValue.getValueValue();
            Int intVal = new Int();
            intVal.set((long)((int)bDouble.getDouble()));
            intVal.setNull(obj.isNull());
            obj = intVal;
        } else if (string.equals("reltime") && bStatusValue instanceof BStatusNumeric) {
            Reltime reltime = new Reltime();
            BNumber bNumber = (BNumber)bStatusValue.getValueValue();
            BRelTime bRelTime = BRelTime.make((long)bNumber.getLong());
            reltime.set(bRelTime.getMillis());
            reltime.setNull(obj.isNull());
            obj = reltime;
        } else if (string.equals("uri") && bStatusValue instanceof BStatusString) {
            BStatusString bStatusString = (BStatusString)bStatusValue;
            Uri uri = new Uri(bStatusString.getValue());
            uri.setNull(obj.isNull());
            obj = uri;
        }
        obj.setHref(new Uri(this.getHref()));
        return obj;
    }

    private final String getElement() {
        return this.getDeviceFacets().gets("element", "obj");
    }

    private final String getErrorString(Err err) {
        String string = err.getDisplay();
        if (string != null && string.length() > 0) {
            return string;
        }
        return ObixEncoder.toString((Obj)err);
    }

    private final Type getSimpleType(Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = uri.get();
        if (!string.startsWith("obix:")) {
            return null;
        }
        if (string.equals("obix:abstime")) {
            return BAbsTime.TYPE;
        }
        if (string.equals("obix:bool")) {
            return BBoolean.TYPE;
        }
        if (string.equals("obix:enum")) {
            return BIEnum.TYPE;
        }
        if (string.equals("obix:int")) {
            return BInteger.TYPE;
        }
        if (string.equals("obix:real")) {
            return BDouble.TYPE;
        }
        if (string.equals("obix:reltime")) {
            return BRelTime.TYPE;
        }
        if (string.equals("obix:str")) {
            return BString.TYPE;
        }
        return null;
    }

    private final String getWriteOp() {
        return this.getDeviceFacets().gets("writeOp", null);
    }

    private final boolean isSimple(Contract contract) {
        if (contract == null) {
            return true;
        }
        Uri uri = contract.primary();
        if (uri == null) {
            return true;
        }
        if (uri.get().equals("obix:Nil")) {
            return true;
        }
        if (uri.get().equals("obix:obj") && contract.size() == 1) {
            return true;
        }
        boolean bl = false;
        if (this.getSimpleType(uri) != null) {
            bl = true;
        }
        return bl;
    }

    private static final BFacets makeDeviceFacets() {
        return BFacets.make((BFacets)BFacets.NULL, (String)"uninitialized", (BIDataValue)BBoolean.TRUE);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.deviceExt = null;
        this.folder = null;
        this.force = false;
        this.readSubscribed = false;
        this.subscribedHref = null;
        this.context = null;
        this.licenseChecked = false;
        this.fatalFault = false;
        this.fatalFaultCause = null;
    }

    public BObixProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$obix$driver$point$BObixProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$obix$driver$point$BObixProxyExt = BObixProxyExt.class("[Lcom.tridium.obix.driver.point.BObixProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        writablePoint = new Uri("obix:WritablePoint");
    }
}

