/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.history;

import com.tridium.obix.driver.history.ArchiveInvocation;
import com.tridium.obix.driver.history.BObixHistoryDiscoveryJob;
import com.tridium.obix.driver.history.BObixHistoryImport;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixHistoryDeviceExt
extends BHistoryDeviceExt {
    public static final Property retryDelay = BObixHistoryDeviceExt.newProperty((int)4, (BValue)BRelTime.makeSeconds((int)0), null);
    public static final Property retryGroupSize = BObixHistoryDeviceExt.newProperty((int)4, (int)Integer.MAX_VALUE, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Action getClient = BObixHistoryDeviceExt.newAction((int)4, null);
    public static final Action submitHistoryDiscoveryJob = BObixHistoryDeviceExt.newAction((int)4, null);
    public static final Type TYPE;
    private boolean attached;
    private Log log;
    private long lastArchiveTicks;
    private int groupCount;
    static /* synthetic */ Class class$com$tridium$obix$driver$history$BObixHistoryDeviceExt;

    public BRelTime getRetryDelay() {
        return (BRelTime)this.get(retryDelay);
    }

    public void setRetryDelay(BRelTime bRelTime) {
        this.set(retryDelay, (BValue)bRelTime, null);
    }

    public int getRetryGroupSize() {
        return this.getInt(retryGroupSize);
    }

    public void setRetryGroupSize(int n) {
        this.setInt(retryGroupSize, n, null);
    }

    public BOrd getClient() {
        return (BOrd)this.invoke(getClient, null, null);
    }

    public BOrd submitHistoryDiscoveryJob() {
        return (BOrd)this.invoke(submitHistoryDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void attach() {
        this.attached = true;
    }

    public void detach() {
        this.attached = false;
    }

    public BOrd doGetClient() {
        return this.getObixClient().getSlotPathOrd();
    }

    public BOrd doSubmitHistoryDiscoveryJob(Context context) {
        return new BObixHistoryDiscoveryJob(this, this.getObixClient().get("lobby")).submit(context);
    }

    public Type getExportDescriptorType() {
        return null;
    }

    public Type getImportDescriptorType() {
        return BObixHistoryImport.TYPE;
    }

    public Type getDeviceType() {
        return BObixClient.TYPE;
    }

    public Log getLog() {
        if (this.log == null) {
            try {
                this.log = Log.getLog((String)(this.getObixClient().getLog().getLogName() + "-Histories"));
            }
            catch (Exception exception) {
                this.log = this.getObixClient().getLog();
            }
        }
        return this.log;
    }

    public BObixClient getObixClient() {
        return (BObixClient)this.getParent();
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public boolean isAttached() {
        return this.attached;
    }

    public boolean isChildLegal(BComponent bComponent) {
        return true;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    IFuture post(Invocation invocation) {
        BObixHistoryImport bObixHistoryImport;
        if (invocation instanceof ArchiveInvocation && (bObixHistoryImport = ((ArchiveInvocation)invocation).getHistoryImport()).getStatus().isFault()) {
            long l;
            long l2 = Clock.ticks();
            if (l2 > (l = this.lastArchiveTicks + this.getRetryDelay().getMillis())) {
                this.getObixNetwork().enqueue((Runnable)invocation);
                this.lastArchiveTicks = l2;
                this.groupCount = 1;
            } else {
                int n = this.getRetryGroupSize();
                if (this.groupCount < n) {
                    this.getObixNetwork().enqueue((Runnable)invocation);
                    ++this.groupCount;
                } else {
                    this.getLog().trace("Skipping import of " + bObixHistoryImport.getName() + " due to retry delay (now=" + l2 + "; waiting until " + l + ')');
                    bObixHistoryImport.setState(BDescriptorState.idle);
                }
            }
            return null;
        }
        this.getObixNetwork().enqueue((Runnable)invocation);
        return null;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("ObixHistoryDeviceExt");
        spyWriter.prop((Object)"attached", this.attached);
        spyWriter.prop((Object)"lastArchiveTicks", (double)this.lastArchiveTicks);
        spyWriter.prop((Object)"groupCount", this.groupCount);
        spyWriter.endProps();
        super.spy(spyWriter);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.attached = false;
        this.log = null;
        this.lastArchiveTicks = 0L;
        this.groupCount = 0;
    }

    public BObixHistoryDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$obix$driver$history$BObixHistoryDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$obix$driver$history$BObixHistoryDeviceExt = BObixHistoryDeviceExt.class("[Lcom.tridium.obix.driver.history.BObixHistoryDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

