/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPowerNxs;

import com.tridium.platform.BPlatformService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BPowerMonitorPlatformServiceNxs
extends BPlatformService
implements BIAlarmablePlatformService {
    public static final Property upsTalking = BPowerMonitorPlatformServiceNxs.newProperty((int)1, (boolean)false, (BFacets)BFacets.makeBoolean((String)"talking", (String)"no comm"));
    public static final Property upsDescription = BPowerMonitorPlatformServiceNxs.newProperty((int)3, (String)"unknown", null);
    public static final Property upsSerialNumber = BPowerMonitorPlatformServiceNxs.newProperty((int)3, (String)"unknown", null);
    public static final Property upsData = BPowerMonitorPlatformServiceNxs.newProperty((int)3, (String)"", null);
    public static final Property primaryPowerPresent = BPowerMonitorPlatformServiceNxs.newProperty((int)1, (boolean)true, (BFacets)BFacets.makeBoolean((String)"dc ok", (String)"dc low"));
    public static final Property batteryOk = BPowerMonitorPlatformServiceNxs.newProperty((int)1, (boolean)true, (BFacets)BFacets.makeBoolean((String)"battery ok", (String)"battery failed"));
    public static final Property batteryCharged = BPowerMonitorPlatformServiceNxs.newProperty((int)3, (boolean)true, (BFacets)BFacets.makeBoolean((String)"battery charged", (String)"battery not charged"));
    public static final Property runningOnBattery = BPowerMonitorPlatformServiceNxs.newProperty((int)3, (boolean)false, (BFacets)BFacets.makeBoolean((String)"running on battery", (String)"not running on battery"));
    public static final Property shutdownDelay = BPowerMonitorPlatformServiceNxs.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)1), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.makeMinutes((int)0), (String)"max", (BIDataValue)BRelTime.makeMinutes((int)15)));
    public static final Property batteryAlarmSupport = BPowerMonitorPlatformServiceNxs.newProperty((int)0, (BValue)BPowerMonitorPlatformServiceNxs.initBatteryAlarmSupport(), null);
    public static final Property batteryAlarmProxy = BPowerMonitorPlatformServiceNxs.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property powerAlarmSupport = BPowerMonitorPlatformServiceNxs.newProperty((int)0, (BValue)BPowerMonitorPlatformServiceNxs.initPowerAlarmSupport(), null);
    public static final Property powerAlarmProxy = BPowerMonitorPlatformServiceNxs.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property upsNotFoundAlarmSupport = BPowerMonitorPlatformServiceNxs.newProperty((int)0, (BValue)BPowerMonitorPlatformServiceNxs.initUpsNotFoundAlarmSupport(), null);
    public static final Property upsNotFoundAlarmProxy = BPowerMonitorPlatformServiceNxs.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Action primaryTimerExpired = BPowerMonitorPlatformServiceNxs.newAction((int)4, null);
    public static final Action shutdownTimerExpired = BPowerMonitorPlatformServiceNxs.newAction((int)4, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static final int FT_OK = 0;
    public static final int FT_INVALID_HANDLE = 1;
    public static final int FT_DEVICE_NOT_FOUND = 2;
    public static final int FT_DEVICE_NOT_OPENED = 3;
    public static final int FT_IO_ERROR = 4;
    public static final int FT_INSUFFICIENT_RESOURCES = 5;
    public static final int FT_INVALID_PARAMETER = 6;
    public static final int FT_INVALID_BAUD_RATE = 7;
    public static final int FT_DEVICE_NOT_OPENED_FOR_ERASE = 8;
    public static final int FT_DEVICE_NOT_OPENED_FOR_WRITE = 9;
    public static final int FT_FAILED_TO_WRITE_DEVICE = 10;
    public static final int FT_EEPROM_READ_FAILED = 11;
    public static final int FT_EEPROM_WRITE_FAILED = 12;
    public static final int FT_EEPROM_ERASE_FAILED = 13;
    public static final int FT_EEPROM_NOT_PRESENT = 14;
    public static final int FT_EEPROM_NOT_PROGRAMMED = 15;
    public static final int FT_INVALID_ARGS = 16;
    public static final int FT_NOT_SUPPORTED = 17;
    public static final int FT_OTHER_ERROR = 18;
    public static Log log;
    private static final String ALARM_TYPE_PRIMARY_POWER = "primaryPower";
    private static final String ALARM_TYPE_BATTERY = "battery";
    private static final String ALARM_TYPE_UPS_NOT_FOUND = "ups";
    int usbDeviceIndex;
    Clock.Ticket primaryTicket;
    Clock.Ticket shutdownTicket;
    private boolean firstPass;
    static /* synthetic */ Class class$com$tridium$platPowerNxs$BPowerMonitorPlatformServiceNxs;

    public boolean getUpsTalking() {
        return this.getBoolean(upsTalking);
    }

    public void setUpsTalking(boolean bl) {
        this.setBoolean(upsTalking, bl, null);
    }

    public String getUpsDescription() {
        return this.getString(upsDescription);
    }

    public void setUpsDescription(String string) {
        this.setString(upsDescription, string, null);
    }

    public String getUpsSerialNumber() {
        return this.getString(upsSerialNumber);
    }

    public void setUpsSerialNumber(String string) {
        this.setString(upsSerialNumber, string, null);
    }

    public String getUpsData() {
        return this.getString(upsData);
    }

    public void setUpsData(String string) {
        this.setString(upsData, string, null);
    }

    public boolean getPrimaryPowerPresent() {
        return this.getBoolean(primaryPowerPresent);
    }

    public void setPrimaryPowerPresent(boolean bl) {
        this.setBoolean(primaryPowerPresent, bl, null);
    }

    public boolean getBatteryOk() {
        return this.getBoolean(batteryOk);
    }

    public void setBatteryOk(boolean bl) {
        this.setBoolean(batteryOk, bl, null);
    }

    public boolean getBatteryCharged() {
        return this.getBoolean(batteryCharged);
    }

    public void setBatteryCharged(boolean bl) {
        this.setBoolean(batteryCharged, bl, null);
    }

    public boolean getRunningOnBattery() {
        return this.getBoolean(runningOnBattery);
    }

    public void setRunningOnBattery(boolean bl) {
        this.setBoolean(runningOnBattery, bl, null);
    }

    public BRelTime getShutdownDelay() {
        return (BRelTime)this.get(shutdownDelay);
    }

    public void setShutdownDelay(BRelTime bRelTime) {
        this.set(shutdownDelay, (BValue)bRelTime, null);
    }

    public BPlatformAlarmSupport getBatteryAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(batteryAlarmSupport);
    }

    public void setBatteryAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(batteryAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getBatteryAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(batteryAlarmProxy);
    }

    public void setBatteryAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(batteryAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getPowerAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(powerAlarmSupport);
    }

    public void setPowerAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(powerAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getPowerAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(powerAlarmProxy);
    }

    public void setPowerAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(powerAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getUpsNotFoundAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(upsNotFoundAlarmSupport);
    }

    public void setUpsNotFoundAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(upsNotFoundAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getUpsNotFoundAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(upsNotFoundAlarmProxy);
    }

    public void setUpsNotFoundAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(upsNotFoundAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public void primaryTimerExpired() {
        this.invoke(primaryTimerExpired, null, null);
    }

    public void shutdownTimerExpired() {
        this.invoke(shutdownTimerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doStationStarted(BStation bStation) {
        super.doStationStarted(bStation);
        this.loadLibraries();
        this.getPowerAlarmProxy().setAlarmSupport(this.getPowerAlarmSupport());
        this.getBatteryAlarmProxy().setAlarmSupport(this.getBatteryAlarmSupport());
        this.getUpsNotFoundAlarmProxy().setAlarmSupport(this.getUpsNotFoundAlarmSupport());
        this.doPrimaryTimerExpired();
        this.primaryTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.SECOND, (Action)primaryTimerExpired, null);
    }

    private final int determineUpsDriver() {
        int n = -1;
        n = this.getNumberOfDevices();
        if (n == -1) {
            this.setUpsSerialNumber("unknown");
            this.setUpsDescription("unknown");
        } else {
            log.trace("trying to locate device with descripton:" + this.getLexicon().getText("upsDescription"));
            int n2 = 0;
            while (n2 < n) {
                String string = this.getDeviceDescription(n2);
                if (string.startsWith(this.getLexicon().getText("upsDescription").trim())) {
                    log.trace("found " + string);
                    this.setUpsSerialNumber(this.getDeviceSerialNumber(n2));
                    this.setUpsDescription(string);
                    return n2;
                }
                ++n2;
            }
        }
        this.setUpsSerialNumber("unknown");
        this.setUpsDescription("unknown");
        log.trace("not found");
        return -1;
    }

    public int getUsbDeviceIndex() {
        if (this.usbDeviceIndex == -1) {
            this.usbDeviceIndex = this.determineUpsDriver();
        }
        return this.usbDeviceIndex;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
    }

    public void doPrimaryTimerExpired() {
        BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord;
        String string;
        if (this.getUsbDeviceIndex() == -1) {
            if (this.getUpsTalking()) {
                log.trace("UPS stopped talking");
                BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord2 = this.getUpsNotFoundAlarmSupport().makeNewFaultAlarm();
                this.getUpsNotFoundAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                this.setUpsTalking(false);
            }
            return;
        }
        if (!this.getUpsTalking()) {
            log.trace("UPS resumed talking");
            string = this.getUpsNotFoundAlarmSupport().makeToNormal();
            this.getUpsNotFoundAlarmProxy().firePlatformServiceAlarmEvent((BPlatformServiceAlarmRecord)string);
            this.setUpsTalking(true);
        }
        if ((string = this.getNewUpsData()).equals("")) {
            this.usbDeviceIndex = -1;
            log.trace("SITOP driver did not return expected byte count");
            this.setUpsData("");
            return;
        }
        this.setUpsData(string.replace('\r', ' ').replace('\n', ' '));
        log.trace(this.getUpsData());
        boolean bl = false;
        if (string.indexOf("BUFRD") != -1) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (string.indexOf("BA>85") != -1) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if (string.indexOf("DC_OK") != -1) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        boolean bl7 = false;
        if (string.indexOf("*BAT*") != -1) {
            bl7 = true;
        }
        boolean bl8 = bl7;
        boolean bl9 = this.getBatteryOk();
        boolean bl10 = this.getPrimaryPowerPresent();
        this.setBatteryOk(bl2);
        this.setBatteryCharged(bl4);
        this.setPrimaryPowerPresent(bl6);
        this.setRunningOnBattery(bl8);
        if (bl6) {
            if (this.shutdownTicket != null) {
                this.shutdownTicket.cancel();
            }
        } else {
            if (bl10 || this.firstPass) {
                log.trace("Primary power lost");
                if (this.shutdownTicket != null) {
                    this.shutdownTicket.cancel();
                }
                this.shutdownTicket = Clock.schedule((BComponent)this, (BRelTime)this.getShutdownDelay(), (Action)shutdownTimerExpired, null);
                bPlatformServiceAlarmRecord = this.getPowerAlarmSupport().makeNewFaultAlarm();
                this.getPowerAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
            }
            if (!bl2) {
                log.trace("UPS bad, shutting down immediately");
                this.doShutdownTimerExpired();
                return;
            }
        }
        if (bl6 && !bl10) {
            log.trace("Primary power restored");
            if (this.shutdownTicket != null) {
                this.shutdownTicket.cancel();
            }
            bPlatformServiceAlarmRecord = this.getPowerAlarmSupport().makeToNormal();
            this.getPowerAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
        }
        if (bl6 && bl2 != bl9) {
            if (!bl2 && bl9) {
                log.trace("Battery test failed");
                bPlatformServiceAlarmRecord = this.getBatteryAlarmSupport().makeNewFaultAlarm();
                this.getBatteryAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
            } else if (bl2 && !bl9) {
                log.trace("Battery test passed");
                bPlatformServiceAlarmRecord = this.getBatteryAlarmSupport().makeToNormal();
                this.getBatteryAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
            }
        }
        this.firstPass = false;
    }

    private final String getNewUpsData() {
        String string = "";
        int n = 0;
        while (n < 10) {
            try {
                string = this.pollUps();
            }
            catch (IOException iOException) {}
            if (string.indexOf("ALARM") != -1) {
                return string;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            ++n;
        }
        return string;
    }

    private final String pollUps() throws IOException {
        byte[] byArray = new byte[28];
        int n = this.openReadClose(this.usbDeviceIndex, byArray);
        if (n != 28) {
            throw new IOException("Invalid response from UPS");
        }
        return new String(byArray, 0, n);
    }

    public void doShutdownTimerExpired() {
        log.trace("Primary power loss shutdown timer expired, saving database, shutting down");
        try {
            BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            bSystemPlatformService.reboot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getPowerAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getBatteryAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getUpsNotFoundAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getPowerAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getBatteryAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getUpsNotFoundAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    public BBoolean ackAlarm(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    static BPlatformAlarmSupport initBatteryAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:batteryTestFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:batteryTestPassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_BATTERY));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initPowerAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:primaryPowerLost)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:primaryPowerRestored)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_PRIMARY_POWER));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initUpsNotFoundAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:upsNotResponding)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:upsFound)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_UPS_NOT_FOUND));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    protected abstract void loadLibraries();

    protected abstract int getNumberOfDevices();

    protected abstract String getDeviceSerialNumber(int var1);

    protected abstract String getDeviceDescription(int var1);

    protected abstract int openReadClose(int var1, byte[] var2);

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.usbDeviceIndex = -1;
        this.firstPass = true;
    }

    public BPowerMonitorPlatformServiceNxs() {
        this.this();
        this.setPlatformServiceDescription(this.getLexicon().getText("PowerMonitorPlatformService.description"));
    }

    static {
        Class clazz = class$com$tridium$platPowerNxs$BPowerMonitorPlatformServiceNxs;
        if (clazz == null) {
            clazz = class$com$tridium$platPowerNxs$BPowerMonitorPlatformServiceNxs = BPowerMonitorPlatformServiceNxs.class("[Lcom.tridium.platPowerNxs.BPowerMonitorPlatformServiceNxs;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"batteryFull.png");
        log = Log.getLog((String)"power");
    }
}

