/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfIp.udp.comm;

import com.tridium.ddf.comm.BIDdfCommunicator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDdfUdpMulticastHelper
extends BVector {
    public static final Property status = BDdfUdpMulticastHelper.newProperty((int)0, (BValue)BStatus.ok, null);
    public static final Property faultCause = BDdfUdpMulticastHelper.newProperty((int)0, (BValue)BFormat.DEFAULT, null);
    public static final Property jaceIpAddress = BDdfUdpMulticastHelper.newProperty((int)0, (String)"localHost", null);
    public static final Property jaceUdpPort = BDdfUdpMulticastHelper.newProperty((int)0, (int)-1, null);
    public static final Property udpGroupAddresses = BDdfUdpMulticastHelper.newProperty((int)0, (BValue)new BVector(), (BFacets)BFacets.make((String)"fieldEditor", (String)"alarm:StringListFE"));
    public static final Type TYPE;
    public static final Lexicon LEX;
    public static final String lexkeyJaceMulticastSocketOpenError = "JaceMulticastSocketOpenError";
    public static final String lexkeyJaceSocketConnectionError = "JaceSocketConnectionError";
    public static final String lexkeyJaceUnknownHostException = "JaceUnknownHostException";
    public static final String lexkeyInvalidGroup = "InvalidMulticastGroup";
    public static final String jaceMulticastSocketOpenError;
    public static final String jaceSocketConnectionError;
    public static final String jaceUnknownHostException;
    public static final String invalidMulticastGroup;
    public static final String formatLexicon = "lexicon(devUdpDriver:";
    public static final BFormat formatJaceMulticastSocketOpenError;
    public static final BFormat formatJaceSocketConnectionError;
    public static final BFormat formatJaceUnknownHostException;
    private Vector multiCastGroups;
    protected MulticastSocket multicastSocket;
    static /* synthetic */ Class class$com$tridium$ddfIp$udp$comm$BDdfUdpMulticastHelper;
    static /* synthetic */ Class class$javax$baja$sys$BString;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public BFormat getFaultCause() {
        return (BFormat)this.get(faultCause);
    }

    public void setFaultCause(BFormat bFormat) {
        this.set(faultCause, (BValue)bFormat, null);
    }

    public String getJaceIpAddress() {
        return this.getString(jaceIpAddress);
    }

    public void setJaceIpAddress(String string) {
        this.setString(jaceIpAddress, string, null);
    }

    public int getJaceUdpPort() {
        return this.getInt(jaceUdpPort);
    }

    public void setJaceUdpPort(int n) {
        this.setInt(jaceUdpPort, n, null);
    }

    public BVector getUdpGroupAddresses() {
        return (BVector)this.get(udpGroupAddresses);
    }

    public void setUdpGroupAddresses(BVector bVector) {
        this.set(udpGroupAddresses, (BValue)bVector, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIDdfCommunicator getCommunicator() {
        BComplex bComplex = this.getParent();
        while (!(bComplex instanceof BIDdfCommunicator)) {
            bComplex = bComplex.getParent();
        }
        return (BIDdfCommunicator)bComplex;
    }

    public MulticastSocket getSocket() {
        try {
            if (this.multicastSocket == null) {
                this.multicastSocket = new MulticastSocket(this.getJaceUdpPort());
                this.multicastSocket.setInterface(InetAddress.getByName(this.getJaceIpAddress()));
                this.joinOrLeaveUdpGroups();
            }
            return this.multicastSocket;
        }
        catch (SocketException socketException) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(formatJaceSocketConnectionError);
            this.getCommunicator().getLog().error(jaceSocketConnectionError, (Throwable)socketException);
        }
        catch (UnknownHostException unknownHostException) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(formatJaceUnknownHostException);
            this.getCommunicator().getLog().error(jaceUnknownHostException, (Throwable)unknownHostException);
        }
        catch (IOException iOException) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(formatJaceMulticastSocketOpenError);
            this.getCommunicator().getLog().error(jaceMulticastSocketOpenError, (Throwable)iOException);
        }
        return null;
    }

    public void closeSocket() {
        if (this.multicastSocket != null) {
            this.multicastSocket.close();
            this.multicastSocket = null;
        }
    }

    protected void joinOrLeaveUdpGroups() {
        if (this.multicastSocket != null) {
            BVector bVector = this.getUdpGroupAddresses();
            Class clazz = class$javax$baja$sys$BString;
            if (clazz == null) {
                clazz = class$javax$baja$sys$BString = BDdfUdpMulticastHelper.class("[Ljavax.baja.sys.BString;", false);
            }
            BString[] bStringArray = (BString[])bVector.getChildren(clazz);
            this.joinUdpGroups(bStringArray);
            this.leaveUdpGroups(bStringArray);
        }
    }

    protected void joinUdpGroups(BString[] bStringArray) {
        if (this.multicastSocket != null) {
            int n = 0;
            while (n < bStringArray.length) {
                if (!this.multiCastGroups.contains(bStringArray[n])) {
                    try {
                        this.multiCastGroups.addElement(bStringArray[n]);
                        this.multicastSocket.joinGroup(InetAddress.getByName(bStringArray[n].getString()));
                    }
                    catch (IOException iOException) {
                        this.setStatus(BStatus.fault);
                        this.setFaultCause(BDdfUdpMulticastHelper.formatInvalidMulticastGroup(bStringArray[n], iOException));
                        this.getCommunicator().getLog().error(invalidMulticastGroup, (Throwable)iOException);
                    }
                }
                ++n;
            }
        }
    }

    protected void leaveUdpGroups(BString[] bStringArray) {
        Iterator iterator = this.multiCastGroups.iterator();
        Array array = new Array((Object[])bStringArray);
        while (iterator.hasNext()) {
            BString bString = (BString)iterator.next();
            if (array.contains((Object)bString)) continue;
            try {
                this.multicastSocket.leaveGroup(InetAddress.getByName(bString.getString()));
            }
            catch (IOException iOException) {
                this.setStatus(BStatus.fault);
                this.setFaultCause(BDdfUdpMulticastHelper.formatInvalidMulticastGroup(bString, iOException));
                this.getCommunicator().getLog().error(invalidMulticastGroup, (Throwable)iOException);
            }
            iterator.remove();
        }
    }

    public void changed(Property property, Context context) {
        if (property.equals((Object)udpGroupAddresses)) {
            this.joinOrLeaveUdpGroups();
        } else if (property.equals((Object)jaceIpAddress) || property.equals((Object)jaceUdpPort)) {
            this.closeSocket();
        }
        super.changed(property, context);
    }

    public static String formatLexicon(String string) {
        return formatLexicon + string + ')';
    }

    public static final BFormat formatInvalidMulticastGroup(BString bString, Exception exception) {
        return BFormat.make((String)(bString.toString() + ':' + BDdfUdpMulticastHelper.formatLexicon(lexkeyInvalidGroup) + ':' + exception));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.multiCastGroups = null;
        this.multicastSocket = null;
    }

    public BDdfUdpMulticastHelper() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ddfIp$udp$comm$BDdfUdpMulticastHelper;
        if (clazz == null) {
            clazz = class$com$tridium$ddfIp$udp$comm$BDdfUdpMulticastHelper = BDdfUdpMulticastHelper.class("[Lcom.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$ddfIp$udp$comm$BDdfUdpMulticastHelper;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$ddfIp$udp$comm$BDdfUdpMulticastHelper = BDdfUdpMulticastHelper.class("[Lcom.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper;", false);
        }
        LEX = Lexicon.make((Class)clazz2);
        jaceMulticastSocketOpenError = LEX.getText(lexkeyJaceMulticastSocketOpenError);
        jaceSocketConnectionError = LEX.getText(lexkeyJaceSocketConnectionError);
        jaceUnknownHostException = LEX.getText(lexkeyJaceUnknownHostException);
        invalidMulticastGroup = LEX.getText(lexkeyInvalidGroup);
        formatJaceMulticastSocketOpenError = BFormat.make((String)BDdfUdpMulticastHelper.formatLexicon(lexkeyJaceMulticastSocketOpenError));
        formatJaceSocketConnectionError = BFormat.make((String)BDdfUdpMulticastHelper.formatLexicon(lexkeyJaceSocketConnectionError));
        formatJaceUnknownHostException = BFormat.make((String)BDdfUdpMulticastHelper.formatLexicon(lexkeyJaceUnknownHostException));
    }
}

