/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo;

import com.tridium.fox.session.ServerException;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.remoteVideo.BRemoteVideoChannel;
import com.tridium.remoteVideo.BRemoteVideoSource;
import com.tridium.remoteVideo.RemoteFoxVideoStream;
import com.tridium.remoteVideo.nd.BNiagaraCameraExt;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoChannel;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BRemoteVideoService
extends BAbstractService {
    public static final Action addCameraExtToNiagaraStations = BRemoteVideoService.newAction((int)4, null);
    public static final Action resolveRemoteVideoSource = BRemoteVideoService.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static Type[] serviceTypes;
    public static Log log;
    private boolean serviceStarted;
    private Object serviceStartedMonitor;
    protected Object remoteVideoSourceAdditionMonitor;
    protected Object videoSourceAccess;
    static /* synthetic */ Class class$com$tridium$remoteVideo$BRemoteVideoService;
    static /* synthetic */ Class class$javax$baja$driver$BDeviceNetwork;
    static /* synthetic */ Class class$com$tridium$remoteVideo$BRemoteVideoSource;

    public final void addCameraExtToNiagaraStations() {
        this.invoke(addCameraExtToNiagaraStations, null, null);
    }

    public final BOrd resolveRemoteVideoSource(BString bString) {
        return (BOrd)this.invoke(resolveRemoteVideoSource, (BValue)bString, null);
    }

    public final Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void serviceStarted() throws Exception {
        this.getComponentSpace().enableMixIn(BNiagaraCameraExt.TYPE);
        Object object = this.serviceStartedMonitor;
        synchronized (object) {
            this.serviceStarted = true;
            this.serviceStartedMonitor.notifyAll();
        }
        super.serviceStarted();
    }

    public final void serviceStopped() throws Exception {
        this.getComponentSpace().disableMixIn(BNiagaraCameraExt.TYPE);
        super.serviceStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void waitForServiceStarted() throws InterruptedException {
        Object object = this.serviceStartedMonitor;
        synchronized (object) {
            if (!this.serviceStarted) {
                this.serviceStartedMonitor.wait(10000L);
                if (!this.serviceStarted) {
                    throw new ServiceNotFoundException("BRemoteVideoService did not start even after 10 seconds.");
                }
            }
            return;
        }
    }

    public final void doAddCameraExtToNiagaraStations() {
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] bDeviceArray = bNiagaraNetwork.getDevices();
        int n = 0;
        while (n < bDeviceArray.length) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)bDeviceArray[n];
            this.addCameraToNiagaraStationIfNecessary(bNiagaraStation);
            ++n;
        }
    }

    public final void addCameraToNiagaraStationIfNecessary(BNiagaraStation bNiagaraStation) {
        boolean bl = this.scanForCameraExt(bNiagaraStation);
        if (!bl) {
            bNiagaraStation.add("Cameras", (BValue)new BNiagaraCameraExt());
        }
    }

    public final boolean scanForCameraExt(BNiagaraStation bNiagaraStation) {
        BDeviceExt[] bDeviceExtArray = bNiagaraStation.getDeviceExts();
        boolean bl = false;
        int n = 0;
        while (n < bDeviceExtArray.length && !bl) {
            if (bDeviceExtArray[n] instanceof BNiagaraCameraExt) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public final BOrd doResolveRemoteVideoSource(BString bString) {
        String string = bString.toString();
        int n = string.indexOf("//");
        if (n >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2);
            if (!string3.startsWith("h:")) {
                string3 = "slot:/" + string3;
            }
            BOrd bOrd = BOrd.make((String)string3);
            if (log.isTraceOn()) {
                log.trace("Resolving remote video source. Niagara Station Name = " + string2 + " remoteCameraOrd=" + bOrd);
            }
            return this.doResolveRemoteVideoSource(string2, bOrd);
        }
        throw new BajaRuntimeException("remoteVideo: missing \"//\"\nHINT: The remoteVideo ord needs to be of the format \"<stationName>//<remote camera slot path>\"");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final BOrd doCopyRemoteVideoSourceToThisStation(BNiagaraStation bNiagaraStation, BOrd bOrd) {
        BOrd bOrd2;
        String string = Sys.getStation().getStationName();
        BFoxClientConnection bFoxClientConnection = bNiagaraStation.getClientConnection();
        try {
            try {
                try {
                    bFoxClientConnection.engageNoRetry((BFoxClientConnection.Interest)RemoteFoxVideoStream.REMOTE_VIDEO_INTEREST);
                }
                catch (Exception exception) {
                    throw new LocalizableRuntimeException("videoDriver", "RemoteVideo.NiagaraStation.UnableToConnect", new Object[]{string, bNiagaraStation.getStationName()});
                }
                if (!bFoxClientConnection.isConnected()) {
                    throw new LocalizableRuntimeException("videoDriver", "RemoteVideo.NiagaraStation.UnableToConnect", new Object[]{string, bNiagaraStation.getStationName()});
                }
                try {
                    BRemoteVideoChannel bRemoteVideoChannel = (BRemoteVideoChannel)bFoxClientConnection.getChannels().get("remoteVideo", BRemoteVideoChannel.TYPE);
                    if (log.isTraceOn()) {
                        log.trace("Copying remote video source to this station. Niagara Station Name = " + bNiagaraStation.getName() + " remoteCameraOrd=" + bOrd);
                    }
                    bOrd2 = this.doCopyRemoteVideoSourceToThisStation(bRemoteVideoChannel, bNiagaraStation.getName(), bOrd);
                }
                catch (ServerException serverException) {
                    String string2 = serverException.getMessage();
                    if (!string2.equals("com.tridium.fox.session.InvalidChannelException: remoteVideo")) throw serverException;
                    throw new LocalizableRuntimeException("videoDriver", "RemoteVideo.RemoteStation.RemoteVideoService.NotFound", new Object[]{bNiagaraStation.getStationName()});
                }
                Object var6_12 = null;
            }
            catch (BajaRuntimeException bajaRuntimeException) {
                throw bajaRuntimeException;
            }
            catch (ServerException serverException2) {
                throw new RuntimeException(){
                    private static final long serialVersionUID = -5967474529806763526L;

                    public final String toString() {
                        if (serverException2.getMessage().startsWith("javax.baja.sys.BajaRuntimeException: RemoteVideo")) {
                            return serverException2.getMessage();
                        }
                        return serverException2.toString();
                    }
                };
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            bFoxClientConnection.disengage((BFoxClientConnection.Interest)RemoteFoxVideoStream.REMOTE_VIDEO_INTEREST);
            throw throwable;
        }
        bFoxClientConnection.disengage((BFoxClientConnection.Interest)RemoteFoxVideoStream.REMOTE_VIDEO_INTEREST);
        return bOrd2;
    }

    public static final String getLocalResolveMessage(Exception exception) {
        LocalizableRuntimeException localizableRuntimeException;
        if (exception instanceof LocalizableRuntimeException && (localizableRuntimeException = (LocalizableRuntimeException)exception).getLexiconModule().equals("videoDriver") && localizableRuntimeException.getLexiconKey().startsWith("RemoteVideo.")) {
            return localizableRuntimeException.toString();
        }
        return null;
    }

    protected final String getLocalStationName() {
        try {
            BStation bStation = (BStation)BOrd.make((String)"station:|slot:/").get();
            if (bStation == null) {
                log.error("Unable to find local station.");
                throw new IllegalStateException("Unable to find local station. ");
            }
            String string = bStation.getStationName();
            if (string == null || string.length() == 0) {
                throw new IllegalStateException("Unable to determine local station name.");
            }
            return string;
        }
        catch (UnresolvedException unresolvedException) {
            throw new IllegalStateException("Unable to resolve local station");
        }
    }

    protected final BOrd doResolveRemoteVideoSource(String string, BOrd bOrd) {
        if (string.equals(this.getLocalStationName())) {
            if (bOrd.toString().startsWith("station:|")) {
                return bOrd;
            }
            return BOrd.make((String)("station:|" + bOrd.toString()));
        }
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        if (bNiagaraNetwork == null) {
            throw new LocalizableRuntimeException("videoDriver", "RemoteVideo.NiagaraNetwork.NotFound");
        }
        BNiagaraStation bNiagaraStation = (BNiagaraStation)bNiagaraNetwork.getStation(string);
        if (bNiagaraStation == null) {
            throw new LocalizableRuntimeException("videoDriver", "RemoteVideo.NiagaraStation.NotFound", new Object[]{string});
        }
        return this.doCopyRemoteVideoSourceToThisStation(bNiagaraStation, bOrd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final BOrd doCopyRemoteVideoSourceToThisStation(BRemoteVideoChannel bRemoteVideoChannel, String string, BOrd bOrd) throws Exception {
        if (log.isTraceOn()) {
            log.trace("Copying remote video source to this station -- 2 --. Niagara Station Name = " + string + " remoteCameraOrd=" + bOrd);
        }
        BRemoteVideoSource bRemoteVideoSource = bRemoteVideoChannel.getNetworkForDriverVideoSource(bOrd);
        Object object = this.videoSourceAccess;
        synchronized (object) {
            BRemoteVideoSource bRemoteVideoSource2;
            block13: {
                BDeviceNetwork bDeviceNetwork;
                BDeviceNetwork bDeviceNetwork2;
                block12: {
                    if (log.isTraceOn()) {
                        log.trace("Copying remote video source to this station -- 3 --. Niagara Station Name = " + string + " remoteCameraOrd=" + bOrd);
                    }
                    bRemoteVideoSource2 = this.getRemoteVideoSource(string, bOrd);
                    bRemoteVideoSource2.setCameraOrd(bRemoteVideoSource.getCameraOrd());
                    bRemoteVideoSource2.setCameraHandleOrd(bRemoteVideoSource.getCameraHandleOrd());
                    Class clazz = class$javax$baja$driver$BDeviceNetwork;
                    if (clazz == null) {
                        clazz = class$javax$baja$driver$BDeviceNetwork = BRemoteVideoService.class("[Ljavax.baja.driver.BDeviceNetwork;", false);
                    }
                    BDeviceNetwork bDeviceNetwork3 = (BDeviceNetwork)bRemoteVideoSource.getChildren(clazz)[0];
                    String string2 = bDeviceNetwork3.getPropertyInParent().getName();
                    CopyHints copyHints = new CopyHints();
                    copyHints.swizzleHandles = true;
                    copyHints.defaultOnClone = false;
                    bDeviceNetwork2 = (BDeviceNetwork)bDeviceNetwork3.newCopy(copyHints);
                    this.hideDynamicComponents((BComponent)bDeviceNetwork2);
                    bDeviceNetwork = (BDeviceNetwork)bRemoteVideoSource2.get(string2);
                    if (bDeviceNetwork != null) break block12;
                    Property property = bRemoteVideoSource2.add(string2 + '?', (BValue)bDeviceNetwork2);
                    bDeviceNetwork = (BDeviceNetwork)bRemoteVideoSource2.get(property);
                    if (!bDeviceNetwork.isFatalFault() && !bRemoteVideoSource2.isLicensed()) {
                        bDeviceNetwork.configFail("Unlicensed: javax.baja.license.FeatureNotLicensedException: tridium:remotevideo");
                    }
                    break block13;
                }
                try {
                    this.deepCopy((BComponent)bDeviceNetwork2, (BComponent)bDeviceNetwork);
                    Object var15_15 = null;
                }
                catch (Throwable throwable) {
                    Object var15_14 = null;
                    bDeviceNetwork.fw(11);
                    if (!bDeviceNetwork.isFatalFault() && !bRemoteVideoSource2.isLicensed()) {
                        bDeviceNetwork.configFail("Unlicensed: javax.baja.license.FeatureNotLicensedException: tridium:remotevideo");
                    }
                    bDeviceNetwork.updateStatus();
                    throw throwable;
                }
                bDeviceNetwork.fw(11);
                if (!bDeviceNetwork.isFatalFault() && !bRemoteVideoSource2.isLicensed()) {
                    bDeviceNetwork.configFail("Unlicensed: javax.baja.license.FeatureNotLicensedException: tridium:remotevideo");
                }
                bDeviceNetwork.updateStatus();
            }
            return bRemoteVideoSource2.getSlotPathOrd();
        }
    }

    protected final void hideDynamicComponents(BComponent bComponent) {
        SlotCursor slotCursor = bComponent.getSlots();
        while (slotCursor.nextComponent()) {
            Property property = slotCursor.property();
            if (property == null) continue;
            try {
                int n = bComponent.getFlags((Slot)property);
                bComponent.setFlags((Slot)property, n | 4);
                this.hideDynamicComponents(slotCursor.get().asComponent());
            }
            catch (Exception exception) {
                log.error("Unable to hide video driver property under temporarily mounted driver", (Throwable)exception);
            }
        }
    }

    protected final void deepCopy(BComponent bComponent, BComponent bComponent2) {
        BStatus bStatus;
        BStatus bStatus2;
        BDevice bDevice;
        BDevice bDevice2;
        if (bComponent2 instanceof BDevice && bComponent instanceof BDevice) {
            bDevice2 = (BDevice)bComponent2;
            bDevice = (BDevice)bComponent;
            bStatus2 = bDevice2.getStatus();
            bStatus = bDevice.getStatus();
            bComponent2.copyFrom((BComplex)bComponent, Context.decoding);
            bDevice2.setStatus(BStatus.make((int)(bStatus2.getBits() | bStatus.getBits())));
            bDevice2.fw(11);
        } else if (bComponent2 instanceof BDeviceNetwork && bComponent instanceof BDeviceNetwork) {
            bDevice2 = (BDeviceNetwork)bComponent2;
            bDevice = (BDeviceNetwork)bComponent;
            bStatus2 = bDevice2.getStatus();
            bStatus = bDevice.getStatus();
            bComponent2.copyFrom((BComplex)bComponent, Context.decoding);
            bDevice2.setStatus(BStatus.make((int)(bStatus2.getBits() | bStatus.getBits())));
            bDevice2.fw(11);
        } else {
            bComponent2.copyFrom((BComplex)bComponent, Context.decoding);
        }
        bDevice2 = bComponent.getSlots();
        while (bDevice2.nextComponent()) {
            bDevice = bDevice2.property();
            bStatus2 = bComponent2.getProperty(bDevice.getName());
            if (bStatus2 == null || !((bStatus = bComponent2.get((Property)bStatus2)) instanceof BComponent)) continue;
            this.deepCopy((BComponent)bDevice2.get(), (BComponent)bStatus);
        }
    }

    /*
     * Exception decompiling
     */
    protected final BRemoteVideoSource getRemoteVideoSource(String var1_1, BOrd var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [3 : 54->285)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BOrd getLocalCameraOrdFromAlarmRPC(Object object, Context context) throws Exception {
        BOrd bOrd;
        BComponent bComponent = (BComponent)object;
        BOrd bOrd2 = (BOrd)bComponent.get("cameraOrd");
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation bNiagaraStation = (BNiagaraStation)bNiagaraNetwork.get(bComponent.get("stationName").toString());
        bNiagaraStation.getClientConnection();
        String string = TYPE + ".getLocalCameraOrdFromAlarm." + BUuid.make().toString();
        BFoxClientConnection.StringInterest stringInterest = new BFoxClientConnection.StringInterest(string);
        try {
            bNiagaraStation.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)stringInterest);
            BDataChannel bDataChannel = (BDataChannel)bNiagaraStation.getClientConnection().getChannels().get("data", BDataChannel.TYPE);
            BOrd bOrd3 = BOrd.make((String)("station:|" + bOrd2 + "/proxyExt/pointId"));
            BString bString = (BString)bDataChannel.resolve(bOrd3);
            bOrd = BOrd.make((String)bString.toString());
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            bNiagaraStation.getClientConnection().disengage((BFoxClientConnection.Interest)stringInterest);
            throw throwable;
        }
        bNiagaraStation.getClientConnection().disengage((BFoxClientConnection.Interest)stringInterest);
        return bOrd;
    }

    public final AgentList getAgents(Context context) {
        try {
            AgentList agentList = super.getAgents(context);
            agentList.remove("workbench:PropertySheet");
            agentList.remove("workbench:SlotSheet");
            agentList.remove("workbench:LinkSheet");
            agentList.remove("wiresheet:WireSheet");
            agentList.remove("pxEditor:PxEditor");
            return agentList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public final boolean isChildLegal(BComponent bComponent) {
        return bComponent instanceof BRemoteVideoSource;
    }

    public final Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.serviceStarted = false;
        this.serviceStartedMonitor = new Object();
        this.remoteVideoSourceAdditionMonitor = new Object();
        this.videoSourceAccess = new Object();
    }

    public BRemoteVideoService() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$remoteVideo$BRemoteVideoService;
        if (clazz == null) {
            clazz = class$com$tridium$remoteVideo$BRemoteVideoService = BRemoteVideoService.class("[Lcom.tridium.remoteVideo.BRemoteVideoService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://remoteVideo/icons/remoteVideoService.png");
        serviceTypes = new Type[]{TYPE};
        log = Log.getLog((String)"remoteVideo.remoteVideoService");
        BFoxChannelRegistry bFoxChannelRegistry = BFoxChannelRegistry.getPrototype();
        if (bFoxChannelRegistry.get("remoteVideo") == null) {
            if (log.isTraceOn()) {
                log.trace("Registering fox channel: remoteVideo");
            }
            bFoxChannelRegistry.add("remoteVideo", (BValue)new BRemoteVideoChannel());
        } else if (log.isTraceOn()) {
            log.trace("Not registering fox channel: remoteVideo");
        }
        if (bFoxChannelRegistry.get("FoxVideoChannel") == null) {
            if (log.isTraceOn()) {
                log.trace("Registering fox channel: FoxVideoChannel");
            }
            bFoxChannelRegistry.add("FoxVideoChannel", (BValue)new BFoxVideoChannel());
        } else if (log.isTraceOn()) {
            log.trace("Not registering fox channel: FoxVideoChannel");
        }
    }
}

