/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.util;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.messages.AaPhpAckTransactionAlarmReq;
import com.tridium.aaphp.messages.AaPhpAckTransactionAlarmResponse;
import com.tridium.aaphp.messages.AaPhpReadMessageTextRequest;
import com.tridium.aaphp.messages.AaPhpReadMessageTextResponse;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAaPhpNativeEventsProcessor
extends BAlarmSourceInfo
implements BIAlarmSource {
    public static final Action ackAlarm = BAaPhpNativeEventsProcessor.newAction((int)5, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE;
    AlarmSupport alarmSupport;
    String nextAlarmText;
    BFacets aaphpEventFacets;
    BAbsTime aaphpEventTime;
    static /* synthetic */ Class class$com$tridium$aaphp$util$BAaPhpNativeEventsProcessor;

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, (BAlarmSourceInfo)this);
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BAaPhpDevice;
    }

    public BAaPhpDevice getAaPhpDevice() {
        return (BAaPhpDevice)this.getParent();
    }

    public BAaPhpNetwork getAaPhpNetwork() {
        return (BAaPhpNetwork)this.getAaPhpDevice().getNetwork();
    }

    public synchronized boolean readAaPhpAlarms() {
        BAaPhpDevice bAaPhpDevice = this.getAaPhpDevice();
        AaPhpReadMessageTextResponse[] aaPhpReadMessageTextResponseArray = AaPhpReadMessageTextRequest.readAllMessages(this.getAaPhpNetwork(), this.getAaPhpNetwork().translateAddress(bAaPhpDevice.getAddress()));
        if (aaPhpReadMessageTextResponseArray != null) {
            this.processReplies(aaPhpReadMessageTextResponseArray);
        }
        boolean bl = false;
        if (aaPhpReadMessageTextResponseArray != null) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void generateAlarm() {
        try {
            try {
                BFacets bFacets = BFacets.make((String)"msgText", (String)this.nextAlarmText);
                if (this.aaphpEventFacets != null) {
                    bFacets = BFacets.make((BFacets)bFacets, (BFacets)this.aaphpEventFacets);
                }
                this.alarmSupport.newOffnormalAlarm(bFacets);
            }
            catch (Exception exception) {
                this.getAaPhpDevice().getNetwork().getLog().error("Error forwarding AaPhp alarm to Niagara AX", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.aaphpEventFacets = null;
            this.nextAlarmText = "";
            this.aaphpEventTime = null;
            throw throwable;
        }
        {
            Object var2_5 = null;
            this.aaphpEventFacets = null;
            this.nextAlarmText = "";
            this.aaphpEventTime = null;
            return;
        }
    }

    private final void processAaPhpTransactionAlarm(AaPhpReadMessageTextResponse aaPhpReadMessageTextResponse) {
        this.aaphpEventTime = aaPhpReadMessageTextResponse.isStructuredTransaction() ? aaPhpReadMessageTextResponse.getAbsTime() : null;
        this.aaphpEventFacets = BFacets.make((String)"transaction", (BIDataValue)BInteger.make((int)aaPhpReadMessageTextResponse.getTransactionId()), (String)"aaphpTime", (BIDataValue)this.aaphpEventTime);
        this.nextAlarmText = aaPhpReadMessageTextResponse.getMessageText();
    }

    private final void processAaPhpContinuationMsg(AaPhpReadMessageTextResponse aaPhpReadMessageTextResponse) {
        this.nextAlarmText = this.nextAlarmText + "\r\n" + aaPhpReadMessageTextResponse.getText();
    }

    private final void processAaPhpUnrestrictedEvent(AaPhpReadMessageTextResponse aaPhpReadMessageTextResponse) {
        this.aaphpEventTime = null;
        this.aaphpEventFacets = null;
        this.nextAlarmText = aaPhpReadMessageTextResponse.getMessageText();
    }

    private static final boolean isAaPhpEvent(AaPhpReadMessageTextResponse aaPhpReadMessageTextResponse) {
        boolean bl = false;
        if (aaPhpReadMessageTextResponse.getResponseType() == '=') {
            bl = true;
        }
        return bl;
    }

    private final void processAaPhpEvent(AaPhpReadMessageTextResponse aaPhpReadMessageTextResponse) {
        if (aaPhpReadMessageTextResponse.isTransaction()) {
            this.processAaPhpTransactionAlarm(aaPhpReadMessageTextResponse);
        } else if (aaPhpReadMessageTextResponse.isContinuation()) {
            this.processAaPhpContinuationMsg(aaPhpReadMessageTextResponse);
        } else if (aaPhpReadMessageTextResponse.isUnrestricted()) {
            this.processAaPhpUnrestrictedEvent(aaPhpReadMessageTextResponse);
        }
        this.generateAlarm();
    }

    private final void processReply(AaPhpReadMessageTextResponse aaPhpReadMessageTextResponse) {
        if (BAaPhpNativeEventsProcessor.isAaPhpEvent(aaPhpReadMessageTextResponse)) {
            this.processAaPhpEvent(aaPhpReadMessageTextResponse);
        }
    }

    private final void processReplies(AaPhpReadMessageTextResponse[] aaPhpReadMessageTextResponseArray) {
        int n = 0;
        while (n < aaPhpReadMessageTextResponseArray.length) {
            this.processReply(aaPhpReadMessageTextResponseArray[n]);
            ++n;
        }
    }

    public BBoolean doAckAlarm(final BAlarmRecord bAlarmRecord) {
        BInteger bInteger = (BInteger)bAlarmRecord.getAlarmData().get("transaction");
        if (bInteger == null) {
            return BBoolean.TRUE;
        }
        final int n = bInteger.getInt();
        final BAaPhpNetwork bAaPhpNetwork = (BAaPhpNetwork)this.getAaPhpDevice().getNetwork();
        final int n2 = bAaPhpNetwork.translateAddress(this.getAaPhpDevice().getAddress());
        bAaPhpNetwork.post(new Runnable(){

            public final void run() {
                AaPhpAckTransactionAlarmReq aaPhpAckTransactionAlarmReq = new AaPhpAckTransactionAlarmReq(n2, n);
                AaPhpAckTransactionAlarmResponse aaPhpAckTransactionAlarmResponse = (AaPhpAckTransactionAlarmResponse)bAaPhpNetwork.sendSync(aaPhpAckTransactionAlarmReq);
                if (aaPhpAckTransactionAlarmResponse == null) {
                    bAaPhpNetwork.getLog().error("AaPhp Timeout. Unable to acknowledge alarm transaction from device " + n2 + ". AaPhp transaction id=" + n);
                } else if (aaPhpAckTransactionAlarmResponse.isError()) {
                    bAaPhpNetwork.getLog().error("AaPhp Error. Unable to acknowledge alarm transaction from device " + n2 + ". AaPhp transaction id=" + n + ". AaPhp error =" + aaPhpAckTransactionAlarmResponse.getErrorMsg());
                } else {
                    try {
                        BAaPhpNativeEventsProcessor.this.alarmSupport.ackAlarm(bAlarmRecord);
                    }
                    catch (Exception exception) {
                        bAaPhpNetwork.getLog().error("Niagara AX alarming error. Unable to acknowlege alarm transaction from device " + n2 + " ,aaphp tranaction=" + n, (Throwable)exception);
                    }
                }
            }
        });
        return BBoolean.FALSE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.nextAlarmText = "";
        this.aaphpEventFacets = null;
        this.aaphpEventTime = null;
    }

    public BAaPhpNativeEventsProcessor() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$aaphp$util$BAaPhpNativeEventsProcessor;
        if (clazz == null) {
            clazz = class$com$tridium$aaphp$util$BAaPhpNativeEventsProcessor = BAaPhpNativeEventsProcessor.class("[Lcom.tridium.aaphp.util.BAaPhpNativeEventsProcessor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

