/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.util;

import com.tridium.aaphp.util.AaPhpTextUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BajaRuntimeException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AaPhpOrdParser {
    public static final String SCHEME_AAPHP = "aaphp";
    public static final String SCHEME_CHANNEL = "channel";
    public static final String SCHEME_POINT = "point";
    public static final String SCHEME_FILE = "file";
    public static final String SCHEME_OBJECT = "object";
    public static final String SCHEME_ATTR = "attr";
    public static final String SCHEME_DRV = "drv";
    public static final String SCHEME_PATH = "path";
    public static final String SCHEME_FNAME = "fname";
    public static final String SCHEME_EXT = "ext";
    public static final String SCHEME_N = "n";
    static final String AAPHP_ITEM = "AaPhp Item";
    final OrdQuery[] aaphpOrdPieces;
    boolean channelAttr;
    boolean pointObject;
    boolean pointAttr;
    boolean fileDrive;
    boolean filePath;

    public char getDrive() {
        if (this.isFileDrive()) {
            String string = this.aaphpOrdPieces[2].getBody();
            if (string != null && string.length() > 0) {
                if (string.length() > 1) {
                    throw new BajaRuntimeException("The 'drv' must be exactly one character, not " + string + " which is " + string.length() + " characters.");
                }
                char c = Character.toUpperCase(string.charAt(0));
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z') {
                    return c;
                }
                throw new BajaRuntimeException("The 'drv' must be 0-9 or A-Z, not " + c);
            }
            throw new BajaRuntimeException("The 'drv' must not be empty.");
        }
        throw new BajaRuntimeException("Cannot get drive for a aaphp ord that is not a aaphp-fileDrive ord!");
    }

    public String getFName() {
        if (this.isFileDrive()) {
            String string = this.aaphpOrdPieces[3].getBody();
            if (string != null && string.length() > 0) {
                if (string.length() > 8) {
                    throw new BajaRuntimeException("The 'fname' must be no more than eight characters in length, not " + string + " which is " + string.length() + " long.");
                }
                return AaPhpTextUtil.padRight((String)string, (int)8);
            }
            throw new BajaRuntimeException("The 'fname' must not be empty.");
        }
        throw new BajaRuntimeException("Cannot get fname for a aaphp ord that is not a aaphp-fileDrive ord!");
    }

    public String getExt() {
        if (this.isFileDrive()) {
            String string = this.aaphpOrdPieces[4].getBody();
            if (string != null && string.length() > 0) {
                if (string.length() > 3) {
                    throw new BajaRuntimeException("The 'ext' must be no more than three characters in length, not " + string + " which is " + string.length() + " long.");
                }
                return AaPhpTextUtil.padLeft((String)string, (int)3);
            }
            throw new BajaRuntimeException("The 'ext' must not be empty.");
        }
        throw new BajaRuntimeException("Cannot get ext for a aaphp ord that is not a aaphp-fileDrive ord!");
    }

    private final char validateFileNum(String string) {
        if (string != null && string.length() > 0) {
            if (string.length() > 1) {
                throw new BajaRuntimeException("The 'n' must be exactly one character, not " + string + " which is " + string.length() + " characters!");
            }
            char c = Character.toUpperCase(string.charAt(0));
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
                return c;
            }
            throw new BajaRuntimeException("The 'n' must be 0-9 or A-Z, not " + c);
        }
        throw new BajaRuntimeException("The 'n' must not be empty!");
    }

    public char getFileNum() {
        if (this.isFileDrive()) {
            return this.validateFileNum(this.aaphpOrdPieces[5].getBody());
        }
        if (this.isFilePath()) {
            return this.validateFileNum(this.aaphpOrdPieces[3].getBody());
        }
        throw new BajaRuntimeException("Cannot get fileNum for a aaphp ord that is niether a aaphp-fileDrive nor a aaphp-filePath ord!");
    }

    public String getFilePath() {
        if (this.isFilePath()) {
            String string = this.aaphpOrdPieces[2].getBody();
            if (string != null && string.length() > 0) {
                return string;
            }
            throw new BajaRuntimeException("The 'path' must not be empty.");
        }
        throw new BajaRuntimeException("Cannot get filePath for a aaphp ord that is not a aaphp-file-path ord!");
    }

    public String getChannel() {
        if (this.isChannelAttr()) {
            return this.aaphpOrdPieces[1].getBody();
        }
        throw new BajaRuntimeException("Cannot get channel for a aaphp ord that is not a aaphp-channel ord!");
    }

    public String getAttr() {
        if (this.isChannelAttr() || this.isPointAttr()) {
            return this.aaphpOrdPieces[2].getBody();
        }
        throw new BajaRuntimeException("Cannot get attr for a aaphp ord that is neither a aaphp-channel nor aaphp-point-attr ord!");
    }

    public String getPoint() {
        if (this.isPointAttr()) {
            return this.aaphpOrdPieces[1].getBody();
        }
        throw new BajaRuntimeException("Cannot get name of point for a aaphp ord that is not a aaphp-point-attr ord!");
    }

    public String getObject() {
        if (this.isPointObject()) {
            return this.aaphpOrdPieces[2].getBody();
        }
        throw new BajaRuntimeException("Cannot get object for a aaphp ord that is not a aaphp-point-object ord!");
    }

    public String getObjectNoAttr() {
        String string = this.getObject();
        int n = string.lastIndexOf(58);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getObjectAttr() {
        String string = this.getObject();
        int n = string.lastIndexOf(58);
        if (n < 0) {
            return "  ";
        }
        return AaPhpTextUtil.truncate((String)string.substring(n + 1), (int)2);
    }

    public boolean isChannelAttr() {
        return this.channelAttr;
    }

    public boolean isPointAttr() {
        return this.pointAttr;
    }

    public boolean isPointObject() {
        return this.pointObject;
    }

    public boolean isFileDrive() {
        return this.fileDrive;
    }

    public boolean isFilePath() {
        return this.filePath;
    }

    public String getNextAaPhpOrd(String string) {
        string = AaPhpTextUtil.truncate((String)string, (int)2);
        StringBuffer stringBuffer = new StringBuffer(SCHEME_AAPHP).append(':').append('|');
        if (this.isChannelAttr()) {
            stringBuffer.append(SCHEME_CHANNEL).append(':').append(this.getChannel()).append('|');
        } else if (this.isPointObject()) {
            stringBuffer.append(SCHEME_POINT).append(':').append('|').append(SCHEME_OBJECT).append(':').append(this.getObjectNoAttr()).append(':').append(string);
        } else if (this.isPointAttr()) {
            stringBuffer.append(SCHEME_POINT).append(':').append(this.getPoint()).append('|').append(SCHEME_ATTR).append(':').append(string);
        } else {
            throw new IllegalStateException("Cannot get next aaphp ord from this ord. Please have my program fixed!");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isFileDrive()) {
            stringBuffer.append(this.getDrive()).append(':').append(this.getFName().trim()).append('.').append(this.getExt().trim()).append('#').append(this.getFileNum());
        } else if (this.isFilePath()) {
            stringBuffer.append(this.getFilePath()).append('#').append(this.getFileNum());
        } else if (this.isChannelAttr()) {
            stringBuffer.append(SCHEME_CHANNEL).append(' ').append(this.getChannel()).append(' ').append(SCHEME_ATTR).append(' ').append(this.getAttr());
        } else if (this.isPointAttr()) {
            stringBuffer.append(SCHEME_POINT).append(' ').append(this.getPoint()).append(' ').append(SCHEME_ATTR).append(' ').append(this.getAttr());
        } else if (this.isPointObject()) {
            stringBuffer.append(SCHEME_OBJECT).append(' ').append(this.getObject());
        } else {
            stringBuffer.append(AAPHP_ITEM);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println("Integer.MAX_VALUE=2147483647");
        System.out.println("Integer.MIN_VALUE=-2147483648");
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{"aaphp:|file:|path:pp..pp|n:n"};
        }
        int n = 0;
        while (n < stringArray.length) {
            BOrd bOrd = BOrd.make((String)stringArray[n]);
            OrdQuery[] ordQueryArray = bOrd.parse();
            int n2 = 0;
            while (n2 < ordQueryArray.length) {
                System.out.println("Scheme = " + ordQueryArray[n2].getScheme());
                System.out.println("Body   = " + ordQueryArray[n2].getBody());
                ++n2;
            }
            AaPhpOrdParser aaPhpOrdParser = new AaPhpOrdParser(stringArray[n]);
            if (aaPhpOrdParser.isChannelAttr()) {
                System.out.println("Ord is a aaphp-channel ord");
            }
            if (aaPhpOrdParser.isFileDrive()) {
                System.out.println("Ord is a aaphp-file-drv ord");
            }
            if (aaPhpOrdParser.isFilePath()) {
                System.out.println("Ord is a aaphp-file-path ord");
            }
            if (aaPhpOrdParser.isPointAttr()) {
                System.out.println("Ord is a aaphp-point-attr ord");
            }
            if (aaPhpOrdParser.isPointObject()) {
                System.out.println("Ord is a aaphp-point-object ord");
            }
            ++n;
        }
    }

    private final /* synthetic */ void this() {
        this.channelAttr = false;
        this.pointObject = false;
        this.pointAttr = false;
        this.fileDrive = false;
        this.filePath = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AaPhpOrdParser(String string) {
        this.this();
        this.aaphpOrdPieces = BOrd.make((String)string).parse();
        if (this.aaphpOrdPieces == null || this.aaphpOrdPieces.length < 3) throw new BajaRuntimeException("AaPhp ords cannot be empty. They must contain at least three ord queries.");
        if (!this.aaphpOrdPieces[0].getScheme().equals(SCHEME_AAPHP)) throw new BajaRuntimeException("The first schema of aaphp ords must be 'aaphp'!");
        if (this.aaphpOrdPieces[0].getBody().trim().length() != 0) throw new BajaRuntimeException("The aaphp body of aaphp ords must be empty!");
        String string2 = this.aaphpOrdPieces[1].getScheme();
        String string3 = this.aaphpOrdPieces[2].getScheme();
        if (string2.equals(SCHEME_CHANNEL)) {
            if (!string3.equals(SCHEME_ATTR)) throw new BajaRuntimeException("The third schem of aaphp-channel ords must be 'attr'!");
            this.channelAttr = true;
            return;
        } else if (string2.equals(SCHEME_POINT)) {
            if (string3.equals(SCHEME_OBJECT)) {
                this.pointObject = true;
                return;
            } else {
                if (!string3.equals(SCHEME_ATTR)) throw new BajaRuntimeException("The third scheme of aaphp-point ords must either be 'object' or 'attr'!");
                this.pointAttr = true;
            }
            return;
        } else {
            if (!string2.equals(SCHEME_FILE)) throw new BajaRuntimeException("The second scheme of aaphp ords must either be 'channel','point', or 'file'");
            if (string3.equals(SCHEME_DRV)) {
                if (this.aaphpOrdPieces.length != 6) throw new BajaRuntimeException("AaPhp-file-drv must have six parts: 'aaphp','file','drv','fname','ext',and'n'!");
                String string4 = this.aaphpOrdPieces[3].getScheme();
                String string5 = this.aaphpOrdPieces[4].getScheme();
                String string6 = this.aaphpOrdPieces[5].getScheme();
                if (!string4.equals(SCHEME_FNAME)) throw new BajaRuntimeException("The fourth part of a aaphp-file-drv ord must be 'fname'!");
                if (!string5.equals(SCHEME_EXT)) throw new BajaRuntimeException("The fifth part of a aaphp-file-drv-fname ord must be 'ext', not " + string5);
                if (!string6.equals(SCHEME_N)) throw new BajaRuntimeException("The sixth part of a aaphp-file-drv-fname-ext ord must be 'n'!");
                this.fileDrive = true;
                this.getDrive();
                this.getFName();
                this.getExt();
                this.getFileNum();
                return;
            } else {
                if (!string3.equals(SCHEME_PATH)) throw new BajaRuntimeException("The third scheme of aaphp-file ords must either be 'drv' or 'path'!");
                if (this.aaphpOrdPieces.length != 4) throw new BajaRuntimeException("AaPhp-file-path must have four parts: 'aaphp','file','path','n'!");
                if (!this.aaphpOrdPieces[3].getScheme().equals(SCHEME_N)) throw new BajaRuntimeException("The fourth part of a aaphp-file-path ord must be 'n'!");
                this.filePath = true;
                this.getFilePath();
                this.getFileNum();
            }
        }
    }
}

