/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.datatypes.BAaPhpRecvFileJobParam;
import com.tridium.aaphp.datatypes.BAaPhpRecvFileParam;
import com.tridium.aaphp.ui.BAaPhpDeviceManager;
import com.tridium.aaphp.util.AaPhpOrdParser;
import com.tridium.fox.sys.BFoxSession;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrController;

public class AaPhpRecvFileCommand
extends MgrController.MgrCommand {
    final BAaPhpDeviceManager aaphpDeviceManager;

    public boolean ifIsOnClient(BOrd bOrd) {
        try {
            ((BIFile)bOrd.resolve().get()).getInputStream();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean validateSyntax(BAaPhpRecvFileParam bAaPhpRecvFileParam) {
        if (bAaPhpRecvFileParam != null) {
            try {
                new AaPhpOrdParser(bAaPhpRecvFileParam.getSource());
            }
            catch (Exception exception) {
                BDialog.error((BWidget)this.aaphpDeviceManager, (String)"recvFile", (Object)"Unrecognized AaPhp File Ord", (Throwable)exception);
                return false;
            }
            return bAaPhpRecvFileParam.getDestination() != null && bAaPhpRecvFileParam.getDestination() != BOrd.NULL;
        }
        return false;
    }

    int getFoxSession(BOrd bOrd) {
        BFoxSession bFoxSession = (BFoxSession)BOrd.toSession((BObject)this.aaphpDeviceManager.getAaPhpNetwork());
        return bFoxSession.getConnection().session().getRemoteId();
    }

    void receiveFile(BAaPhpRecvFileParam bAaPhpRecvFileParam, BAaPhpDevice bAaPhpDevice) throws Exception {
        BOrd bOrd = bAaPhpRecvFileParam.getDestination();
        BAaPhpRecvFileJobParam bAaPhpRecvFileJobParam = new BAaPhpRecvFileJobParam();
        bAaPhpRecvFileJobParam.setRecvFileParam((BAaPhpRecvFileParam)bAaPhpRecvFileParam.newCopy());
        if (this.ifIsOnClient(bOrd)) {
            bAaPhpRecvFileJobParam.setClientSessionId(this.getFoxSession(bOrd));
        }
        BOrd bOrd2 = bAaPhpDevice.submitRecvFileJob(bAaPhpRecvFileJobParam);
        this.aaphpDeviceManager.getLearn().setJob(bOrd2);
        this.aaphpDeviceManager.getController().doLearnMode(true);
    }

    public CommandArtifact doInvoke() throws Exception {
        BAaPhpRecvFileParam bAaPhpRecvFileParam;
        this.aaphpDeviceManager.getController().learnMode.setSelected(true);
        BAaPhpDevice[] bAaPhpDeviceArray = this.aaphpDeviceManager.getSelectedDevices();
        if (bAaPhpDeviceArray != null && bAaPhpDeviceArray.length > 0 && this.validateSyntax(bAaPhpRecvFileParam = (BAaPhpRecvFileParam)BWbFieldEditor.dialog((BWidget)this.aaphpDeviceManager, (String)"recvFile", (BObject)this.aaphpDeviceManager.getAaPhpNetwork().getLastRecvFileParam().newCopy()))) {
            this.aaphpDeviceManager.getAaPhpNetwork().setLastRecvFileParam((BAaPhpRecvFileParam)bAaPhpRecvFileParam.newCopy());
            this.receiveFile(bAaPhpRecvFileParam, bAaPhpDeviceArray[0]);
        }
        return null;
    }

    public AaPhpRecvFileCommand(BAaPhpDeviceManager bAaPhpDeviceManager) {
        super((BWidget)bAaPhpDeviceManager, BAaPhpDevice.LEXICON, "recvFile");
        this.aaphpDeviceManager = bAaPhpDeviceManager;
    }
}

