/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.datatypes.BAaPhpGatherSetupInfoJobParam;
import com.tridium.aaphp.ui.BAaPhpDeviceManager;
import com.tridium.aaphp.util.AaPhpFileSupport;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.ui.file.BNFileChooser;
import com.tridium.util.TimeFormat;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.TextUtil;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.xml.XParser;

public class AaPhpExamineSetupCommand
extends MgrController.MgrCommand {
    public static final String RESULTS_FILE_TIME_FORMAT = "YYYYMMDDHHmmss";
    public static final String MODULE_NAME = BAaPhpNetwork.TYPE.getModule().getModuleName();
    static final IFileFilter XML_FILE_FILTER = new IFileFilter(){

        public final boolean accept(BIFile bIFile) {
            if (bIFile == null || bIFile.getExtension() == null) {
                return false;
            }
            return bIFile.getExtension().equalsIgnoreCase("xml");
        }

        public final String getDescription(Context context) {
            return "Xml Files (*.xml)";
        }
    };
    final BAaPhpNetwork aaPhpNet;
    final BAaPhpDeviceManager aaphpDeviceManager;
    final String aaPhpStationHostName;

    public CommandArtifact doInvoke() throws Exception {
        this.aaphpDeviceManager.getController().learnMode.setSelected(true);
        BOrd bOrd = this.promptForTerminalCommandsFileOrd();
        if (bOrd != null) {
            BBlob bBlob = this.getTerminalCommandsFileBytes(bOrd);
            BOrd bOrd2 = this.promptForResultsFileOrd();
            if (bOrd2 != null) {
                BAaPhpGatherSetupInfoJobParam bAaPhpGatherSetupInfoJobParam = this.makeGatherChangesJobParam(bOrd, bBlob, bOrd2);
                this.aaphpDeviceManager.getLearn().setJob(this.aaphpDeviceManager.getSelectedDevices()[0].submitGatherSetupInfoJob(bAaPhpGatherSetupInfoJobParam));
                this.aaPhpNet.setLastTerminalCommandsFileOrd(bOrd);
                BAaPhpDevice bAaPhpDevice = this.aaphpDeviceManager.getSelectedDevices()[0];
                bAaPhpDevice.setEarlierSetupInfoFileOrd(bAaPhpDevice.getRecentSetupInfoFileOrd());
                bAaPhpDevice.setRecentSetupInfoFileOrd(bOrd2);
            }
        }
        return null;
    }

    private final BOrd promptForResultsFileOrd() throws Exception {
        String string = this.aaphpDeviceManager.getSelectedDevices()[0].getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TextUtil.capitalize((String)MODULE_NAME));
        stringBuffer.append(TextUtil.capitalize((String)this.aaPhpStationHostName));
        stringBuffer.append(TextUtil.capitalize((String)string));
        stringBuffer.append("SetupInfo");
        stringBuffer.append(TimeFormat.format((BAbsTime)BAbsTime.now(), (String)RESULTS_FILE_TIME_FORMAT)).append(".txt");
        BNFileChooser bNFileChooser = (BNFileChooser)BNFileChooser.makeSave((BWidget)this.aaphpDeviceManager);
        bNFileChooser.setTitle(this.aaphpDeviceManager.getLexicon().getText("examineSetup.results.prompt"));
        bNFileChooser.setDefaultFileName(stringBuffer.toString());
        bNFileChooser.setCurrentNavDirectory((BINavNode)BFileSystem.INSTANCE.getSysHome());
        BOrd bOrd = bNFileChooser.show();
        return bOrd;
    }

    public boolean ifIsOnClient(BOrd bOrd) {
        try {
            ((BIFile)bOrd.resolve().get()).getInputStream();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    int getFoxSession(BOrd bOrd) {
        BFoxSession bFoxSession = (BFoxSession)BOrd.toSession((BObject)this.aaPhpNet);
        return bFoxSession.getConnection().session().getRemoteId();
    }

    private final BAaPhpGatherSetupInfoJobParam makeGatherChangesJobParam(BOrd bOrd, BBlob bBlob, BOrd bOrd2) {
        BAaPhpGatherSetupInfoJobParam bAaPhpGatherSetupInfoJobParam = new BAaPhpGatherSetupInfoJobParam();
        if (bBlob == null) {
            bAaPhpGatherSetupInfoJobParam.setTerminalCommandsfileBlob(BBlob.DEFAULT);
            bAaPhpGatherSetupInfoJobParam.setTerminalCommandsFileOrd(bOrd);
        } else {
            bAaPhpGatherSetupInfoJobParam.setTerminalCommandsfileBlob(bBlob);
            bAaPhpGatherSetupInfoJobParam.setTerminalCommandsFileOrd(BOrd.NULL);
        }
        bAaPhpGatherSetupInfoJobParam.setResultsFileOrd(bOrd2);
        if (this.ifIsOnClient(bOrd2)) {
            bAaPhpGatherSetupInfoJobParam.setResultsFileFoxId(this.getFoxSession(bOrd2));
        }
        return bAaPhpGatherSetupInfoJobParam;
    }

    private final BBlob getTerminalCommandsFileBytes(BOrd bOrd) throws Exception {
        BBlob bBlob = AaPhpFileSupport.getFirmwareBlob(bOrd);
        if (bBlob != null && bBlob != BBlob.DEFAULT) {
            XParser xParser = XParser.make((String)new String(bBlob.copyBytes()));
            xParser.parse();
            return bBlob;
        }
        return null;
    }

    private final BOrd promptForTerminalCommandsFileOrd() throws Exception {
        BOrd bOrd = this.aaPhpNet.getLastTerminalCommandsFileOrd();
        BNFileChooser bNFileChooser = (BNFileChooser)BNFileChooser.makeOpen((BWidget)this.aaphpDeviceManager);
        bNFileChooser.setTitle(this.aaphpDeviceManager.getLexicon().getText("examineSetup.terminalCommands.prompt"));
        bNFileChooser.setCurrentDirectory(bOrd);
        bNFileChooser.setCurrentFilter(XML_FILE_FILTER);
        return bNFileChooser.show();
    }

    public AaPhpExamineSetupCommand(BAaPhpDeviceManager bAaPhpDeviceManager) {
        super((BWidget)bAaPhpDeviceManager, BAaPhpDevice.LEXICON, "examineSetup");
        this.aaphpDeviceManager = bAaPhpDeviceManager;
        this.aaPhpNet = bAaPhpDeviceManager.getAaPhpNetwork();
        this.aaPhpStationHostName = this.aaPhpNet.getHost().getNavName();
    }
}

