/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.point;

import com.tridium.aaphp.datatypes.BAaPhpOrd;
import com.tridium.aaphp.datatypes.BAaPhpStarAttribute;
import com.tridium.aaphp.enums.BAaPhpPrewriteAttributeEnum;
import com.tridium.aaphp.messages.AaPhpReadAttributeRequest;
import com.tridium.aaphp.messages.AaPhpReadAttributeResponse;
import com.tridium.aaphp.messages.AaPhpSimpleAckResponse;
import com.tridium.aaphp.messages.AaPhpWriteAttributeRequest;
import com.tridium.aaphp.messages.AaPhpWriteAttributeResponse;
import com.tridium.aaphp.point.AaPhpCvOverrideRequest;
import com.tridium.aaphp.point.AaPhpSetDateRequest;
import com.tridium.aaphp.point.AaPhpSetTimeRequest;
import com.tridium.aaphp.point.BAaPhpAttributeProxyExt;
import com.tridium.aaphp.point.BAaPhpCvOverrideAction;
import com.tridium.aaphp.point.BAaPhpCvResetOverrideAction;
import com.tridium.aaphp.point.BAaPhpSetDateAction;
import com.tridium.aaphp.point.BAaPhpSetTimeAction;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAaPhpStarProxyExt
extends BAaPhpAttributeProxyExt {
    public static final Property aaPhpOrd = BAaPhpStarProxyExt.newProperty((int)0, (BValue)new BAaPhpStarAttribute(), null);
    public static final Property prewriteAttribute = BAaPhpStarProxyExt.newProperty((int)4, (BValue)BAaPhpPrewriteAttributeEnum.none, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$aaphp$point$BAaPhpStarProxyExt;
    static /* synthetic */ Class class$com$tridium$aaphp$point$BAaPhpSetTimeAction;
    static /* synthetic */ Class class$com$tridium$aaphp$point$BAaPhpSetDateAction;
    static /* synthetic */ Class class$com$tridium$aaphp$point$BAaPhpCvOverrideAction;
    static /* synthetic */ Class class$com$tridium$aaphp$point$BAaPhpCvResetOverrideAction;

    public BAaPhpOrd getAaPhpOrd() {
        return (BAaPhpOrd)this.get(aaPhpOrd);
    }

    public void setAaPhpOrd(BAaPhpOrd bAaPhpOrd) {
        this.set(aaPhpOrd, (BValue)bAaPhpOrd, null);
    }

    public BAaPhpPrewriteAttributeEnum getPrewriteAttribute() {
        return (BAaPhpPrewriteAttributeEnum)this.get(prewriteAttribute);
    }

    public void setPrewriteAttribute(BAaPhpPrewriteAttributeEnum bAaPhpPrewriteAttributeEnum) {
        this.set(prewriteAttribute, (BValue)bAaPhpPrewriteAttributeEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkCvOverrideAction();
        this.checkTimeAction();
        this.checkDateAction();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)prewriteAttribute)) {
            this.checkCvOverrideAction();
            this.readReset();
            this.writeOk(this.getReadValue());
        }
        if (property.equals((Object)aaPhpOrd)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
            this.checkTimeAction();
            this.checkDateAction();
            this.checkCvOverrideAction();
            this.doForceRead();
        }
    }

    void processResponseData(AaPhpReadAttributeResponse aaPhpReadAttributeResponse) {
        this.attrConv = aaPhpReadAttributeResponse.getAttrConv();
        ((BAaPhpStarAttribute)this.getAaPhpOrd()).setNumericEncodingType(this.attrConv.getAaPhpType());
        super.processResponseData(aaPhpReadAttributeResponse);
    }

    public void checkTimeAction() {
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$aaphp$point$BAaPhpSetTimeAction;
        if (clazz == null) {
            clazz = class$com$tridium$aaphp$point$BAaPhpSetTimeAction = BAaPhpStarProxyExt.class("[Lcom.tridium.aaphp.point.BAaPhpSetTimeAction;", false);
        }
        BAaPhpSetTimeAction[] bAaPhpSetTimeActionArray = (BAaPhpSetTimeAction[])bControlPoint.getChildren(clazz);
        int n = ((BAaPhpStarAttribute)this.getAaPhpOrd()).getNumericEncodingType();
        switch (n) {
            case 24: {
                if (bAaPhpSetTimeActionArray.length == 0) {
                    BAaPhpSetTimeAction bAaPhpSetTimeAction = new BAaPhpSetTimeAction();
                    this.getParentPoint().add("AdjustTime", (BValue)bAaPhpSetTimeAction, 2);
                }
                return;
            }
        }
        int n2 = 0;
        while (n2 < bAaPhpSetTimeActionArray.length) {
            this.getParentPoint().remove((BComplex)bAaPhpSetTimeActionArray[n2]);
            ++n2;
        }
    }

    public void setTimeAttribute(BValue bValue, Context context) {
        if (bValue instanceof BTime) {
            this.getLog().trace("Set Time Attribute on " + this + ":value=" + bValue);
            switch (((BAaPhpStarAttribute)this.getAaPhpOrd()).getNumericEncodingType()) {
                case 24: {
                    this.getAaPhpNetwork().postWrite(new AaPhpSetTimeRequest(this, (BTime)bValue));
                    return;
                }
            }
            return;
        }
    }

    public boolean setTimeAttribute(BTime bTime) {
        this.getLog().trace("setTimeAttribute:" + bTime + ' ' + bTime.getHour() + ':' + bTime.getMinute() + ':' + bTime.getSecond());
        int n = bTime.getHour();
        int n2 = bTime.getMinute();
        long l = n2 / 10 << 12 | n2 % 10 << 8 | n / 10 << 4 | n % 10;
        AaPhpWriteAttributeRequest aaPhpWriteAttributeRequest = new AaPhpWriteAttributeRequest(this.getDeviceAddress(), this.getAaPhpOrd().getAaPhpOrd(), l);
        AaPhpWriteAttributeResponse aaPhpWriteAttributeResponse = (AaPhpWriteAttributeResponse)this.getAaPhpNetwork().sendSync(aaPhpWriteAttributeRequest);
        if (aaPhpWriteAttributeResponse == null) {
            this.writeFail("device time out while setting time value");
            this.getDevice().pingFail("timeout");
            return false;
        }
        if (aaPhpWriteAttributeResponse.isError()) {
            this.writeFail("error while setting time value:" + aaPhpWriteAttributeResponse.getErrorMsg());
            return false;
        }
        this.writeOk((BStatusValue)new BStatusString(bTime.toString((Context)BFacets.make((String)"showDate", (BIDataValue)BBoolean.make((boolean)false)))));
        return true;
    }

    public void checkDateAction() {
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$aaphp$point$BAaPhpSetDateAction;
        if (clazz == null) {
            clazz = class$com$tridium$aaphp$point$BAaPhpSetDateAction = BAaPhpStarProxyExt.class("[Lcom.tridium.aaphp.point.BAaPhpSetDateAction;", false);
        }
        BAaPhpSetDateAction[] bAaPhpSetDateActionArray = (BAaPhpSetDateAction[])bControlPoint.getChildren(clazz);
        int n = ((BAaPhpStarAttribute)this.getAaPhpOrd()).getNumericEncodingType();
        switch (n) {
            case 49: {
                if (bAaPhpSetDateActionArray.length == 0) {
                    BAaPhpSetDateAction bAaPhpSetDateAction = new BAaPhpSetDateAction();
                    this.getParentPoint().add("AdjustDate", (BValue)bAaPhpSetDateAction, 2);
                }
                return;
            }
        }
        int n2 = 0;
        while (n2 < bAaPhpSetDateActionArray.length) {
            this.getParentPoint().remove((BComplex)bAaPhpSetDateActionArray[n2]);
            ++n2;
        }
    }

    public void setDateAttribute(BValue bValue, Context context) {
        if (bValue instanceof BAbsTime) {
            this.getLog().trace("Set Date Attribute on " + this + ":value=" + (BAbsTime)bValue);
            switch (((BAaPhpStarAttribute)this.getAaPhpOrd()).getNumericEncodingType()) {
                case 49: {
                    this.getAaPhpNetwork().postWrite(new AaPhpSetDateRequest(this, (BAbsTime)bValue));
                    return;
                }
            }
            return;
        }
    }

    public boolean setDateAttribute(BAbsTime bAbsTime) {
        int n = bAbsTime.getYear();
        int n2 = bAbsTime.getMonth().getMonthOfYear();
        int n3 = bAbsTime.getDay();
        long l = n / 1000 << 28 | n % 1000 / 100 << 24 | n % 100 / 10 << 20 | n % 10 << 16 | n2 / 10 << 12 | n2 % 10 << 8 | n3 / 10 << 4 | n3 % 10;
        AaPhpWriteAttributeRequest aaPhpWriteAttributeRequest = new AaPhpWriteAttributeRequest(this.getDeviceAddress(), this.getAaPhpOrd().getAaPhpOrd(), l);
        AaPhpWriteAttributeResponse aaPhpWriteAttributeResponse = (AaPhpWriteAttributeResponse)this.getAaPhpNetwork().sendSync(aaPhpWriteAttributeRequest);
        if (aaPhpWriteAttributeResponse == null) {
            this.writeFail("device time out while setting date value");
            this.getDevice().pingFail("timeout");
            return false;
        }
        if (aaPhpWriteAttributeResponse.isError()) {
            this.writeFail("error while setting date value:" + aaPhpWriteAttributeResponse.getErrorMsg());
            return false;
        }
        this.writeOk((BStatusValue)new BStatusString(bAbsTime.toString((Context)BFacets.make((String)"showTime", (BIDataValue)BBoolean.make((boolean)false)))));
        return true;
    }

    public void checkCvOverrideAction() {
        if (((BAaPhpStarAttribute)this.getAaPhpOrd()).getAttr().equals("CV") && !this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)prewriteAttribute, this.getFlags((Slot)prewriteAttribute) & 0xFFFFFFFB);
        }
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$aaphp$point$BAaPhpCvOverrideAction;
        if (clazz == null) {
            clazz = class$com$tridium$aaphp$point$BAaPhpCvOverrideAction = BAaPhpStarProxyExt.class("[Lcom.tridium.aaphp.point.BAaPhpCvOverrideAction;", false);
        }
        BAaPhpCvOverrideAction[] bAaPhpCvOverrideActionArray = (BAaPhpCvOverrideAction[])bControlPoint.getChildren(clazz);
        BControlPoint bControlPoint2 = this.getParentPoint();
        Class clazz2 = class$com$tridium$aaphp$point$BAaPhpCvResetOverrideAction;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$aaphp$point$BAaPhpCvResetOverrideAction = BAaPhpStarProxyExt.class("[Lcom.tridium.aaphp.point.BAaPhpCvResetOverrideAction;", false);
        }
        BAaPhpCvResetOverrideAction[] bAaPhpCvResetOverrideActionArray = (BAaPhpCvResetOverrideAction[])bControlPoint2.getChildren(clazz2);
        int n = 0;
        while (n < bAaPhpCvOverrideActionArray.length) {
            this.getParentPoint().remove((BComplex)bAaPhpCvOverrideActionArray[n]);
            ++n;
        }
        n = 0;
        while (n < bAaPhpCvResetOverrideActionArray.length) {
            this.getParentPoint().remove((BComplex)bAaPhpCvResetOverrideActionArray[n]);
            ++n;
        }
        if (!this.getParentPoint().isWritablePoint() && ((BAaPhpStarAttribute)this.getAaPhpOrd()).getAttr().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            BAaPhpCvOverrideAction bAaPhpCvOverrideAction = new BAaPhpCvOverrideAction();
            bAaPhpCvOverrideAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            if (this.getPrewriteAttribute().getAttribute().equals("OI")) {
                this.getParentPoint().add("Override", (BValue)bAaPhpCvOverrideAction, 2);
            } else {
                this.getParentPoint().add("Manual", (BValue)bAaPhpCvOverrideAction, 2);
            }
            BAaPhpCvResetOverrideAction bAaPhpCvResetOverrideAction = new BAaPhpCvResetOverrideAction();
            if (this.getPrewriteAttribute().getAttribute().equals("OI")) {
                this.getParentPoint().add("CancelOverride", (BValue)bAaPhpCvResetOverrideAction, 2);
            } else {
                this.getParentPoint().add("Auto", (BValue)bAaPhpCvResetOverrideAction, 2);
            }
        }
    }

    public void setCvOverride(BValue bValue, Context context) {
        this.getLog().trace("Set CV override on " + this + ":value=" + bValue);
        if (!this.getParentPoint().isWritablePoint() && ((BAaPhpStarAttribute)this.getAaPhpOrd()).getAttr().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            this.getAaPhpNetwork().postWrite(new AaPhpCvOverrideRequest(this, bValue));
        }
    }

    public void resetCvOverride(BValue bValue, Context context) {
        this.getLog().trace("Reset CV override on " + this);
        if (!this.getParentPoint().isWritablePoint() && ((BAaPhpStarAttribute)this.getAaPhpOrd()).getAttr().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            this.getAaPhpNetwork().postAsync(new Runnable(){

                public final void run() {
                    BAaPhpStarAttribute bAaPhpStarAttribute = (BAaPhpStarAttribute)BAaPhpStarProxyExt.this.getAaPhpOrd().newCopy();
                    bAaPhpStarAttribute.setAttr(BAaPhpStarProxyExt.this.getPrewriteAttribute().getAttribute());
                    AaPhpWriteAttributeRequest aaPhpWriteAttributeRequest = new AaPhpWriteAttributeRequest(BAaPhpStarProxyExt.this.getDeviceAddress(), bAaPhpStarAttribute.getAaPhpOrd(), BAaPhpStarProxyExt.this.getPrewriteAttribute().getMakeUnwritableValue());
                    AaPhpWriteAttributeResponse aaPhpWriteAttributeResponse = (AaPhpWriteAttributeResponse)BAaPhpStarProxyExt.this.getAaPhpNetwork().sendSync(aaPhpWriteAttributeRequest);
                    if (aaPhpWriteAttributeResponse == null) {
                        BAaPhpStarProxyExt.this.writeFail("device time out while clearing override");
                        BAaPhpStarProxyExt.this.getDevice().pingFail("timeout");
                    } else if (aaPhpWriteAttributeResponse.isError()) {
                        BAaPhpStarProxyExt.this.writeFail("error clearing override:" + aaPhpWriteAttributeResponse.getErrorMsg());
                    }
                }
            });
        }
    }

    boolean updateOutput(BStatusValue bStatusValue) {
        if (!this.prewriteAttribute()) {
            this.writeFail("unable to set override or manual");
            return false;
        }
        return super.updateOutput(bStatusValue);
    }

    boolean prewriteAttribute() {
        if (!this.getPrewriteAttribute().prewriteRequired()) {
            return true;
        }
        String string = this.getPrewriteAttribute().getAttribute();
        BAaPhpStarAttribute bAaPhpStarAttribute = (BAaPhpStarAttribute)this.getAaPhpOrd().newCopy();
        bAaPhpStarAttribute.setAttr(string);
        long l = this.getPrewriteAttribute().getMakeWritableValue();
        String string2 = bAaPhpStarAttribute.getAaPhpOrd();
        AaPhpWriteAttributeRequest aaPhpWriteAttributeRequest = new AaPhpWriteAttributeRequest(this.getDeviceAddress(), string2, l);
        AaPhpSimpleAckResponse aaPhpSimpleAckResponse = (AaPhpSimpleAckResponse)this.getAaPhpNetwork().sendSync(aaPhpWriteAttributeRequest);
        if (aaPhpSimpleAckResponse == null) {
            return false;
        }
        return !aaPhpSimpleAckResponse.isError();
    }

    protected void pollForData() {
        BAaPhpStarAttribute bAaPhpStarAttribute = (BAaPhpStarAttribute)this.getAaPhpOrd();
        if (bAaPhpStarAttribute.getAttr().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            BAaPhpStarAttribute bAaPhpStarAttribute2 = (BAaPhpStarAttribute)bAaPhpStarAttribute.newCopy();
            bAaPhpStarAttribute2.setAttr(this.getPrewriteAttribute().getAttribute());
            this.overriddenState = this.discoverOverriddenState(bAaPhpStarAttribute2);
        } else {
            this.overriddenState = false;
        }
        super.pollForData();
    }

    protected boolean discoverOverriddenState(BAaPhpOrd bAaPhpOrd) {
        AaPhpReadAttributeRequest aaPhpReadAttributeRequest = null;
        AaPhpReadAttributeResponse aaPhpReadAttributeResponse = null;
        boolean bl = false;
        try {
            String string = bAaPhpOrd.getAaPhpOrd();
            aaPhpReadAttributeRequest = new AaPhpReadAttributeRequest(this.getDeviceAddress(), string);
            aaPhpReadAttributeResponse = (AaPhpReadAttributeResponse)this.getAaPhpNetwork().sendSync(aaPhpReadAttributeRequest);
            if (aaPhpReadAttributeResponse == null) {
                this.readFail("device timeout");
            } else if (aaPhpReadAttributeResponse.isError()) {
                this.readFail("AaPhpError reading override attribute:" + aaPhpReadAttributeResponse.getErrorMsg());
            } else {
                bl = this.getPrewriteAttribute().isOverridden(aaPhpReadAttributeResponse.getBooleanValue(null));
            }
        }
        catch (Exception exception) {
            this.readFail("" + exception);
            exception.printStackTrace();
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$aaphp$point$BAaPhpStarProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$aaphp$point$BAaPhpStarProxyExt = BAaPhpStarProxyExt.class("[Lcom.tridium.aaphp.point.BAaPhpStarProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

