/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.messages.AaPhpInputStream;
import com.tridium.aaphp.messages.AaPhpMessage;
import com.tridium.aaphp.messages.AaPhpOutputStream;
import com.tridium.aaphp.messages.AaPhpReadAttributeResponse;
import com.tridium.aaphp.messages.AaPhpReceivedMessage;
import com.tridium.aaphp.util.AaPhpOrdParser;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.sys.BajaRuntimeException;

public class AaPhpReadAttributeRequest
extends AaPhpMessage {
    final AaPhpOrdParser aaphpOrdParser;
    final String aaphpOrd;

    protected String getCommandCode() {
        if (this.aaphpOrdParser.isChannelAttr()) {
            return "00";
        }
        if (this.aaphpOrdParser.isPointAttr()) {
            return "02";
        }
        if (this.aaphpOrdParser.isPointObject()) {
            return "02";
        }
        throw new BajaRuntimeException("Unrecognized aaphp ord:" + this.aaphpOrd);
    }

    public void write(OutputStream outputStream) {
        AaPhpOutputStream aaPhpOutputStream = new AaPhpOutputStream();
        aaPhpOutputStream.write(59);
        aaPhpOutputStream.write(this.getUnitNumberAddress());
        aaPhpOutputStream.writeCmdCode(this.getCommandCode());
        if (this.aaphpOrdParser.isChannelAttr()) {
            aaPhpOutputStream.writeChannel(this.aaphpOrdParser.getChannel());
            aaPhpOutputStream.writeAttribute(this.aaphpOrdParser.getAttr());
        } else if (this.aaphpOrdParser.isPointAttr()) {
            aaPhpOutputStream.writePointName(this.aaphpOrdParser.getPoint());
            aaPhpOutputStream.writeAttribute(this.aaphpOrdParser.getAttr());
        } else if (this.aaphpOrdParser.isPointObject()) {
            aaPhpOutputStream.write(39);
            aaPhpOutputStream.writeObjectName(this.aaphpOrdParser.getObject());
            aaPhpOutputStream.write(39);
        } else {
            throw new BajaRuntimeException("Unrecognized aaphp ord:" + this.aaphpOrd);
        }
        aaPhpOutputStream.writeCrc();
        aaPhpOutputStream.write(13);
        try {
            outputStream.write(aaPhpOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public Message toResponse(ReceivedMessage receivedMessage) {
        return new AaPhpReadAttributeResponse(new AaPhpInputStream(((AaPhpReceivedMessage)receivedMessage).getBytes()));
    }

    public AaPhpReadAttributeRequest(int n, String string) {
        super(n);
        this.aaphpOrd = string;
        this.aaphpOrdParser = new AaPhpOrdParser(string);
    }
}

