/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.util.AaPhpTextUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.baja.sys.BAbsTime;
import javax.baja.util.TextUtil;

public class AaPhpOutputStream
extends ByteArrayOutputStream {
    static final String FOUR_ZEROS = "0000";

    public synchronized void write(int n) {
        super.write(n);
    }

    public void writeAttribute(String string) {
        string = TextUtil.padLeft((String)string, (int)2);
        string = TextUtil.truncate((String)string, (int)2);
        this.writeString(string);
    }

    public void writeCmdCode(String string) {
        string = TextUtil.padLeft((String)string, (int)2);
        string = TextUtil.truncate((String)string, (int)2);
        this.writeString(string);
    }

    private final void writeString(String string) {
        try {
            this.write(string.getBytes());
        }
        catch (IOException iOException) {}
    }

    public void writeVirtualTerminal(String string) {
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            if (n2 < 32 || n2 == 59 || n2 == 127) {
                this.write(27);
                this.writeString(AaPhpTextUtil.byteToHexString(n2).toUpperCase());
            } else {
                this.write(n2);
            }
            ++n;
        }
    }

    public void writeTimeDate(BAbsTime bAbsTime) {
        if (bAbsTime.getHour() < 10) {
            this.writeString("0");
        }
        this.writeString(Integer.toString(bAbsTime.getHour()));
        if (bAbsTime.getMinute() < 10) {
            this.writeString("0");
        }
        this.writeString(Integer.toString(bAbsTime.getMinute()));
        if (bAbsTime.getSecond() < 10) {
            this.writeString("0");
        }
        this.writeString(Integer.toString(bAbsTime.getSecond()));
        if (bAbsTime.getDay() < 16) {
            this.writeString("0");
        }
        this.writeString(Integer.toHexString(bAbsTime.getDay()).toUpperCase());
        int n = bAbsTime.getMonth().getMonthOfYear();
        this.writeString("0");
        this.writeString(Integer.toHexString(n).toUpperCase());
        int n2 = bAbsTime.getYear() % 100;
        if (n2 < 16) {
            this.writeString("0");
        }
        this.writeString(Integer.toHexString(n2).toUpperCase());
    }

    public void writePointName(String string) {
        string = TextUtil.padRight((String)string, (int)12);
        string = TextUtil.truncate((String)string, (int)12);
        this.writeString(string);
    }

    public void writeObjectName(String string) {
        string = TextUtil.truncate((String)string, (int)32);
        this.writeString(string);
    }

    public void writeChannel(String string) {
        this.writeString(string);
    }

    public void writeFName(String string) {
        System.out.println(".." + string + "..");
        string = AaPhpTextUtil.padRight((String)string, (int)8);
        string = AaPhpTextUtil.truncate((String)string, (int)8);
        this.writeString(string);
    }

    public void writeExt(String string) {
        string = AaPhpTextUtil.padLeft((String)string, (int)3);
        string = AaPhpTextUtil.truncate((String)string, (int)3);
        this.writeString(string);
    }

    public void writeFileNum(char c) {
        this.write(c);
    }

    public void writeFilePath(String string) {
        this.writeString(string);
    }

    public void writeUnitNumber(int n) {
        this.write(n & 0xFF);
    }

    public void writeCrc() {
        this.writeRawDataHex16(AaPhpOutputStream.makeCrc(this.toByteArray()));
    }

    public void writeRawDataHex16(int n) {
        this.writeString(AaPhpTextUtil.byteToHexString(n & 0xFF));
        this.writeString(AaPhpTextUtil.byteToHexString((n & 0xFF00) >> 8));
    }

    public void writeRawDataHex32(long l) {
        this.writeString(AaPhpTextUtil.byteToHexString((int)(l & 0xFFL)));
        this.writeString(AaPhpTextUtil.byteToHexString((int)((l & 0xFF00L) >> 8)));
        this.writeString(AaPhpTextUtil.byteToHexString((int)((l & 0xFF0000L) >> 16)));
        this.writeString(AaPhpTextUtil.byteToHexString((int)((l & 0xFFFFFFFFFF000000L) >> 24)));
    }

    public void writeHexBytes(byte[] byArray, int n, int n2) {
        if (n2 - n > 128) {
            throw new IllegalArgumentException("The number of bytes must be less than or equal to 128, not " + (n2 - n) + '!');
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n2 && n3 < byArray.length) {
            stringBuffer.append(TextUtil.byteToHexString((int)(byArray[n3] & 0xFF)).toUpperCase());
            ++n3;
        }
        try {
            this.write(stringBuffer.toString().getBytes());
        }
        catch (IOException iOException) {}
    }

    public void writeHexBytes(byte[] byArray) {
        if (byArray.length > 128) {
            throw new IllegalArgumentException("The length of the given byte array must be less than or equal to 128, not " + byArray.length + '!');
        }
        try {
            this.write(AaPhpTextUtil.bytesToHex(byArray).getBytes());
        }
        catch (IOException iOException) {}
    }

    public static boolean checkCrc(byte[] byArray) {
        return new CrcComputer().crcCheck(byArray);
    }

    static int makeCrc(byte[] byArray) {
        return new CrcComputer().crcMake(byArray);
    }

    public AaPhpOutputStream() {
    }

    public AaPhpOutputStream(int n) {
        super(n);
    }

    static class CrcComputer {
        int crc;

        void crcInit() {
            this.crc = 0;
        }

        void eachByte(byte by) {
            int n = 8;
            do {
                int n2;
                if ((n2 = by & 1 ^ this.crc & 1) != 0) {
                    this.crc ^= 0x4002;
                }
                int n3 = n2 << 24 | (this.crc & (char)-1) << 8 | by & 0xFF;
                this.crc = ((n3 >>= 1) & 0xFFFF00) >> 8;
                by = (byte)(n3 & 0xFF);
            } while (--n > 0);
        }

        boolean crcCheck(byte[] byArray) {
            this.crcInit();
            int n = 0;
            while (n < byArray.length - 4) {
                this.eachByte(byArray[n]);
                ++n;
            }
            n = byArray.length;
            byte[] byArray2 = new byte[]{byArray[n - 4], byArray[n - 3]};
            byte[] byArray3 = new byte[]{byArray[n - 2], byArray[n - 1]};
            String string = new String(byArray2);
            String string2 = new String(byArray3);
            int n2 = Integer.parseInt(string, 16);
            int n3 = Integer.parseInt(string2, 16);
            this.eachByte((byte)n2);
            this.eachByte((byte)n3);
            boolean bl = false;
            if (this.crc == 0) {
                bl = true;
            }
            return bl;
        }

        int crcMake(byte[] byArray) {
            this.crcInit();
            int n = 0;
            while (n < byArray.length) {
                this.eachByte(byArray[n]);
                ++n;
            }
            return this.crc;
        }

        CrcComputer() {
        }
    }
}

