/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.messages.AaPhpOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;

public class AaPhpInputStream
extends ByteArrayInputStream {
    public char readResponseType() {
        return (char)this.read();
    }

    public String readAttributeName() {
        return this.readString(2);
    }

    public int readEncodingType() {
        int n;
        try {
            n = Integer.parseInt(this.readString(2), 16);
        }
        catch (NumberFormatException numberFormatException) {
            n = 255;
        }
        return n;
    }

    public String readString(int n) {
        byte[] byArray = new byte[n];
        try {
            this.read(byArray);
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException("Cannot parse attribute name from bytes.", (Throwable)iOException);
        }
        return new String(byArray);
    }

    public long readRawDataHex32() {
        return this.readRawDataHex8() | this.readRawDataHex8() << 8 | this.readRawDataHex8() << 16 | this.readRawDataHex8() << 24;
    }

    public int readRawDataHex16() {
        return this.readRawDataHex8() | this.readRawDataHex8() << 8;
    }

    public int readRawDataHex8() {
        String string = this.readString(2);
        return Integer.parseInt(string, 16);
    }

    public String readMessageText() {
        return this.readString(this.available() - 4);
    }

    public String readErrorClass() {
        return this.readString(2);
    }

    public String readErrorNumber() {
        return this.readString(2);
    }

    public String readErrorMessage() {
        return this.readString(this.available() - 4);
    }

    public void readHexBytes(byte[] byArray, int n, int n2) {
        if (n2 - n > 128) {
            throw new IllegalArgumentException("The number of bytes must be less than or equal to 128, not " + (n2 - n) + '!');
        }
        int n3 = n;
        while (n3 < n2 && n3 < byArray.length) {
            byArray[n3] = (byte)this.readRawDataHex8();
            ++n3;
        }
    }

    public byte[] readHexBytes() {
        int n = (this.available() - 4) / 2;
        byte[] byArray = new byte[n];
        this.readHexBytes(byArray, 0, n);
        return byArray;
    }

    public AaPhpInputStream(byte[] byArray) {
        this(byArray, true);
    }

    public AaPhpInputStream(byte[] byArray, boolean bl) {
        super(byArray);
        if (bl && byArray[0] != 42 && !AaPhpOutputStream.checkCrc(byArray)) {
            throw new LocalizableRuntimeException("aaphp", "crcError");
        }
    }

    public AaPhpInputStream(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }
}

