/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.job;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.messages.AaPhpCloseFileRequest;
import com.tridium.aaphp.messages.AaPhpCloseFileResponse;
import com.tridium.aaphp.messages.AaPhpOpenFileRequest;
import com.tridium.aaphp.messages.AaPhpOpenFileResponse;
import com.tridium.aaphp.messages.AaPhpWriteFileRequest;
import com.tridium.aaphp.messages.AaPhpWriteFileResponse;
import com.tridium.aaphp.util.AaPhpOrdParser;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.baja.job.BSimpleJob;
import javax.baja.sys.BBlob;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAaPhpWriteFileJob
extends BSimpleJob {
    public static final Type TYPE;
    static final String LEX_SEND_AAPHP_FILE = "sendFile.send.start";
    static final String LEX_SENT_AAPHP_FILE = "sendFile.send.done";
    static final String LEX_SEND_UPDATE = "sendFile.send.update";
    static final String LEX_SEND_FILE_TIMEOUT = "sendFile.send.timeout";
    static final String LEX_SEND_FILE_ERROR = "sendFile.send.aaphpError";
    static final String LEX_AAPHP = "aaphp";
    static final String LEX_OPENING_AAPHP_FILE = "sendFile.open.start";
    static final String LEX_OPENED_AAPHP_FILE = "sendFile.open.done";
    static final String LEX_OPEN_FILE_TIMEOUT = "sendFile.open.timeout";
    static final String LEX_OPEN_FILE_ERROR = "sendFile.open.aaphpError";
    static final String LEX_CLOSING_AAPHP_FILE = "sendFile.close.start";
    static final String LEX_CLOSED_AAPHP_FILE = "sendFile.close.done";
    static final String LEX_CLOSE_FILE_TIMEOUT = "sendFile.close.timeout";
    static final String LEX_CLOSE_FILE_ERROR = "sendFile.close.aaphpError";
    static final String LEX_SEND_COMPLETE = "sendFile.complete";
    static final int RECORD_SIZE = 128;
    Object[] lexLogObjectArray;
    final BAaPhpNetwork aaphpNet;
    final byte[] fileData;
    final String aaphpFileOrd;
    final String aaphpFileOrdFriendly;
    final int unitNumberAddress;
    private final int numRecords;
    final char fileNum;
    static /* synthetic */ Class class$com$tridium$aaphp$job$BAaPhpWriteFileJob;

    public Type getType() {
        return TYPE;
    }

    static String dumpToString(byte[] byArray, int n, int n2) {
        StringWriter stringWriter = new StringWriter();
        ByteArrayUtil.hexDump((PrintWriter)new PrintWriter(stringWriter), (byte[])byArray, (int)n, (int)(n - n2));
        stringWriter.flush();
        return stringWriter.toString();
    }

    private final void sendRecord(char c, int n, int n2, int n3) {
        AaPhpWriteFileResponse aaPhpWriteFileResponse = (AaPhpWriteFileResponse)this.aaphpNet.sendSync(new AaPhpWriteFileRequest(this.unitNumberAddress, n, c, this.fileData, n2, n3));
        if (aaPhpWriteFileResponse == null || aaPhpWriteFileResponse.isError()) {
            String string = BAaPhpWriteFileJob.dumpToString(this.fileData, n2, n3);
            if (aaPhpWriteFileResponse == null) {
                throw BAaPhpWriteFileJob.lexError(LEX_SEND_FILE_TIMEOUT, new Object[]{Integer.toString(n), this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress), "\n" + string});
            }
            if (aaPhpWriteFileResponse.isError()) {
                throw BAaPhpWriteFileJob.lexError(LEX_SEND_FILE_ERROR, new Object[]{Integer.toString(n), this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress), "\n" + string});
            }
        }
    }

    private final void sendAaPhpFile() {
        this.lexLog(LEX_SEND_AAPHP_FILE);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        int n = 0;
        int n2 = 0;
        while (n < this.fileData.length) {
            l5 = Clock.ticks();
            if (n2 > 5) {
                this.logMessage(BAaPhpDevice.LEXICON.getText(LEX_SEND_UPDATE, new Object[]{BRelTime.toString((long)l4)}));
            }
            this.sendRecord(this.fileNum, n2, n, n + 128);
            this.progress((int)((float)n2 / (float)this.numRecords * 100.0f));
            l6 = Clock.ticks();
            l = l6 - l5;
            l3 = (l2 += l) / (long)(n2 + 1);
            l4 = (long)(this.numRecords - n2) * l3;
            n += 128;
            ++n2;
        }
        this.lexLog(LEX_SENT_AAPHP_FILE);
    }

    void lexLog(String string) {
        if (this.lexLogObjectArray == null) {
            this.lexLogObjectArray = new Object[]{this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress)};
        }
        this.logMessage(BAaPhpDevice.LEXICON.getText(string, this.lexLogObjectArray));
    }

    static LocalizableRuntimeException lexError(String string) {
        return new LocalizableRuntimeException(LEX_AAPHP, string);
    }

    static LocalizableRuntimeException lexError(String string, Object[] objectArray) {
        return new LocalizableRuntimeException(LEX_AAPHP, string, objectArray);
    }

    static LocalizableRuntimeException lexError(String string, Object object, Object object2) {
        return new LocalizableRuntimeException(LEX_AAPHP, string, new Object[]{object, object2});
    }

    AaPhpOpenFileResponse openAaPhpFile() {
        this.lexLog(LEX_OPENING_AAPHP_FILE);
        AaPhpOpenFileResponse aaPhpOpenFileResponse = (AaPhpOpenFileResponse)this.aaphpNet.sendSync(new AaPhpOpenFileRequest(this.unitNumberAddress, this.aaphpFileOrd, this.numRecords));
        if (aaPhpOpenFileResponse == null) {
            throw BAaPhpWriteFileJob.lexError(LEX_OPEN_FILE_TIMEOUT, this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress));
        }
        if (aaPhpOpenFileResponse.isError()) {
            throw BAaPhpWriteFileJob.lexError(LEX_OPEN_FILE_ERROR, this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress));
        }
        this.lexLog(LEX_OPENED_AAPHP_FILE);
        this.heartbeat();
        return aaPhpOpenFileResponse;
    }

    void closeAaPhpFile(boolean bl) {
        this.lexLog(LEX_CLOSING_AAPHP_FILE);
        AaPhpCloseFileResponse aaPhpCloseFileResponse = (AaPhpCloseFileResponse)this.aaphpNet.sendSync(new AaPhpCloseFileRequest(this.unitNumberAddress, this.fileNum));
        if (aaPhpCloseFileResponse == null) {
            throw BAaPhpWriteFileJob.lexError(LEX_CLOSE_FILE_TIMEOUT, this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress));
        }
        if (aaPhpCloseFileResponse.isError() && !bl) {
            throw BAaPhpWriteFileJob.lexError(LEX_CLOSE_FILE_ERROR, this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress));
        }
        this.lexLog(LEX_CLOSED_AAPHP_FILE);
        this.heartbeat();
    }

    public void run(Context context) throws Exception {
        long l = Clock.ticks();
        this.closeAaPhpFile(true);
        this.openAaPhpFile();
        this.sendAaPhpFile();
        this.closeAaPhpFile(false);
        long l2 = Clock.ticks();
        this.logMessage(BAaPhpDevice.LEXICON.getText(LEX_SEND_COMPLETE, new Object[]{BRelTime.toString((long)(l2 - l))}));
    }

    void logMessage(String string) {
        this.log().message(string);
        if (this.aaphpNet != null) {
            int n = this.aaphpNet.getLog().getSeverity();
            this.aaphpNet.getLog().setSeverity(1);
            this.aaphpNet.getLog().message("Write File Job:" + string);
            this.aaphpNet.getLog().setSeverity(n);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lexLogObjectArray = null;
    }

    public BAaPhpWriteFileJob() {
        this.this();
        this.aaphpNet = null;
        this.fileData = null;
        this.aaphpFileOrd = null;
        this.aaphpFileOrdFriendly = null;
        this.unitNumberAddress = Integer.MIN_VALUE;
        this.fileNum = '\u0000';
        this.numRecords = Integer.MIN_VALUE;
    }

    public BAaPhpWriteFileJob(BAaPhpNetwork bAaPhpNetwork, int n, BBlob bBlob, String string) {
        this.this();
        this.aaphpNet = bAaPhpNetwork;
        this.fileData = bBlob.copyBytes();
        this.aaphpFileOrd = string;
        this.aaphpFileOrdFriendly = new AaPhpOrdParser(string).toString();
        this.unitNumberAddress = n;
        this.fileNum = new AaPhpOrdParser(string).getFileNum();
        int n2 = this.fileData.length / 128;
        if (this.fileData.length % 128 != 0) {
            ++n2;
        }
        this.numRecords = n2;
    }

    static {
        Class clazz = class$com$tridium$aaphp$job$BAaPhpWriteFileJob;
        if (clazz == null) {
            clazz = class$com$tridium$aaphp$job$BAaPhpWriteFileJob = BAaPhpWriteFileJob.class("[Lcom.tridium.aaphp.job.BAaPhpWriteFileJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

