/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.job;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpStarNetwork;
import com.tridium.aaphp.datatypes.BAaPhpLearnStarPointsParam;
import com.tridium.aaphp.datatypes.BAaPhpStarAttribute;
import com.tridium.aaphp.enums.BAaPhpDataTypesEnum;
import com.tridium.aaphp.messages.AaPhpReadAttributeRequest;
import com.tridium.aaphp.messages.AaPhpReadAttributeResponse;
import com.tridium.aaphp.messages.AaPhpReadNextAttributeRequest;
import com.tridium.aaphp.messages.AaPhpReadNextAttributeResponse;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAaPhpLearnStarPointsJob
extends BSimpleJob {
    public static final Property learnedPoints = BAaPhpLearnStarPointsJob.newProperty((int)0, (BValue)new BFolder(), null);
    public static final Property discoveryParameters = BAaPhpLearnStarPointsJob.newProperty((int)0, (BValue)new BAaPhpLearnStarPointsParam(), null);
    public static final Topic learnedEntirePoint = BAaPhpLearnStarPointsJob.newTopic((int)4, null);
    public static final Type TYPE;
    static final String MSG_KEY = "discovery.update";
    static final String BAD_SUBUNIT_NBR = "BadSubunitNumber";
    static final String SUBUNIT_NOT_IN_MAP = "SubunitNotInMap";
    static final String NO_CARD = "NoCard";
    static final String BAD_TYPE = "BadType";
    static final String BAD_CHANNEL = "BadChannel";
    long numPriorGuesses;
    long prev1;
    long prev2;
    long prev3;
    String defaultAttr;
    String recycledAaPhpOrd;
    BAaPhpStarAttribute recycledStarAttrib;
    BAaPhpStarNetwork aaphpNet;
    BAaPhpDevice aaphpDev;
    int unit;
    int subUnit;
    int fromSubUnit;
    int toSubUnit;
    int nbrSubUnits;
    int nbrPerSubUnit;
    int card;
    int fromCard;
    int toCard;
    int nbrCards;
    int nbrPerCard;
    int channel;
    int fromChannel;
    int toChannel;
    int nbrChannels;
    int nbrPerChannel;
    int subChannel;
    int fromSubChannel;
    int toSubChannel;
    int nbrSubChannels;
    int nbrPerSubChannel;
    BAaPhpDataTypesEnum[] fundamentalTypes;
    int typeId;
    int fromTypeId;
    int toTypeId;
    int nbrTypeIds;
    int nbrPerTypeId;
    int numLearnAttempts;
    int necessaryLearnAttempts;
    long startTick;
    static /* synthetic */ Class class$com$tridium$aaphp$job$BAaPhpLearnStarPointsJob;
    static /* synthetic */ Class class$com$tridium$aaphp$enums$BAaPhpDataTypesEnum;

    public BFolder getLearnedPoints() {
        return (BFolder)this.get(learnedPoints);
    }

    public void setLearnedPoints(BFolder bFolder) {
        this.set(learnedPoints, (BValue)bFolder, null);
    }

    public BAaPhpLearnStarPointsParam getDiscoveryParameters() {
        return (BAaPhpLearnStarPointsParam)this.get(discoveryParameters);
    }

    public void setDiscoveryParameters(BAaPhpLearnStarPointsParam bAaPhpLearnStarPointsParam) {
        this.set(discoveryParameters, (BValue)bAaPhpLearnStarPointsParam, null);
    }

    public void fireLearnedEntirePoint(BValue bValue) {
        this.fire(learnedEntirePoint, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        this.logMessage(BAaPhpDevice.LEXICON.getText("discovery.start", new Object[]{new Integer(this.necessaryLearnAttempts)}));
        this.startTick = Clock.ticks();
        this.learnSubUnits();
        this.logMessage(BAaPhpDevice.LEXICON.getText("discovery.complete", new Object[]{BRelTime.toString((long)(Clock.ticks() - this.startTick))}));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void learnSubUnits() {
        this.subUnit = this.fromSubUnit;
        while (this.subUnit <= this.toSubUnit) {
            int n;
            Object var2_1;
            try {
                try {
                    this.learnDataTypes();
                }
                catch (SubUnitNotInMapException subUnitNotInMapException) {
                }
                catch (BadSubUnitNumberException badSubUnitNumberException) {}
            }
            catch (Throwable throwable) {
                var2_1 = null;
                n = (this.subUnit + 1 - this.fromSubUnit) * this.nbrPerSubUnit;
                this.progress((int)((double)n / (double)this.necessaryLearnAttempts * 100.0));
                throw throwable;
            }
            {
                var2_1 = null;
                n = (this.subUnit + 1 - this.fromSubUnit) * this.nbrPerSubUnit;
            }
            this.progress((int)((double)n / (double)this.necessaryLearnAttempts * 100.0));
            ++this.subUnit;
        }
        return;
    }

    private final void learnDataTypes() throws SubUnitNotInMapException, BadSubUnitNumberException {
        this.typeId = this.fromTypeId;
        while (this.typeId <= this.toTypeId) {
            if (this.typeId > this.fromTypeId) {
                this.timedJobMessage();
            }
            this.learnCards();
            ++this.typeId;
        }
    }

    private final void learnCards() throws SubUnitNotInMapException, BadSubUnitNumberException {
        this.card = this.fromCard;
        while (this.card <= this.toCard) {
            try {
                this.learnChannels();
            }
            catch (NoCardException noCardException) {}
            ++this.card;
        }
    }

    private final int getPointsSoFar() {
        return (this.subUnit - this.fromSubUnit) * this.nbrPerSubUnit + (this.typeId - this.fromTypeId) * this.nbrPerTypeId + (this.card - this.fromCard) * this.nbrPerCard + (this.channel - this.fromChannel) * this.nbrPerChannel + (this.subChannel - this.fromSubChannel) * this.nbrPerSubChannel;
    }

    private final void updateProgress() {
        this.progress((int)((double)this.getPointsSoFar() / (double)this.necessaryLearnAttempts * 100.0));
    }

    private final void learnChannels() throws SubUnitNotInMapException, BadSubUnitNumberException, NoCardException {
        this.channel = this.fromChannel;
        while (this.channel <= this.toChannel) {
            this.learnSubChannels();
            ++this.channel;
        }
    }

    private final void learnSubChannels() throws SubUnitNotInMapException, BadSubUnitNumberException, NoCardException {
        this.subChannel = this.fromSubChannel;
        while (this.subChannel <= this.toSubChannel) {
            this.updateProgress();
            this.learnPoint();
            ++this.subChannel;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void timedJobMessage() {
        long l;
        double d = this.getPointsSoFar();
        long l2 = l = (long)((double)(Clock.ticks() - this.startTick) / d * ((double)this.necessaryLearnAttempts - d));
        try {
            if (this.numPriorGuesses == 1L) {
                l2 = (l2 + this.prev1) / (long)2;
            } else if (this.numPriorGuesses == (long)2) {
                l2 = (l2 + this.prev1 + this.prev2) / (long)3;
            } else if (this.numPriorGuesses >= (long)3) {
                l2 = (l2 + this.prev1 + this.prev2 + this.prev3) / (long)4;
            }
            if (this.numPriorGuesses > (long)2) {
                Object[] objectArray = new Object[]{BRelTime.toString((long)l2)};
                String string = BAaPhpDevice.LEXICON.getText(MSG_KEY, objectArray);
                this.logMessage(string);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            ++this.numPriorGuesses;
            this.prev3 = this.prev2;
            this.prev2 = this.prev1;
            this.prev1 = l;
            throw throwable;
        }
        {
            Object var8_8 = null;
            ++this.numPriorGuesses;
            this.prev3 = this.prev2;
            this.prev2 = this.prev1;
            this.prev1 = l;
            return;
        }
    }

    private final void learnPoint() throws SubUnitNotInMapException, BadSubUnitNumberException, NoCardException {
        this.recycledStarAttrib.setSubUnit(this.subUnit);
        this.recycledStarAttrib.setCard(this.card);
        this.recycledStarAttrib.setChannel(this.channel);
        this.recycledStarAttrib.setSubChannel(this.subChannel);
        this.recycledStarAttrib.setFundamentalType(this.fundamentalTypes[this.typeId]);
        this.recycledStarAttrib.setAttr("  ");
        this.learnPoint((BComponent)this.getLearnedPoints());
    }

    private final void learnPoint(BComponent bComponent) throws SubUnitNotInMapException, BadSubUnitNumberException, NoCardException {
        if (this.isAlive()) {
            this.recycledAaPhpOrd = this.recycledStarAttrib.getAaPhpOrd();
            AaPhpReadAttributeRequest aaPhpReadAttributeRequest = new AaPhpReadAttributeRequest(this.unit, this.recycledAaPhpOrd);
            AaPhpReadAttributeResponse aaPhpReadAttributeResponse = (AaPhpReadAttributeResponse)this.aaphpNet.sendSync(aaPhpReadAttributeRequest);
            if (aaPhpReadAttributeResponse != null) {
                if (aaPhpReadAttributeResponse.isError()) {
                    if (aaPhpReadAttributeResponse.getErrorMsg().equalsIgnoreCase(SUBUNIT_NOT_IN_MAP)) {
                        throw new SubUnitNotInMapException();
                    }
                    if (aaPhpReadAttributeResponse.getErrorMsg().equalsIgnoreCase(BAD_SUBUNIT_NBR)) {
                        throw new BadSubUnitNumberException();
                    }
                    if (aaPhpReadAttributeResponse.getErrorMsg().equalsIgnoreCase(NO_CARD)) {
                        throw new NoCardException();
                    }
                } else {
                    this.processLearnedPoint(bComponent, aaPhpReadAttributeResponse);
                }
            }
        } else if (this.getJobState() == BJobState.canceled || this.getJobState() == BJobState.canceling) {
            throw new JobCancelException();
        }
    }

    private final void processLearnedPoint(BComponent bComponent, AaPhpReadAttributeResponse aaPhpReadAttributeResponse) {
        String string = this.recycledStarAttrib.getFundamentalType().getDisplayTag(null) + '_' + Integer.toString(this.recycledStarAttrib.getCard(), 16) + '_' + Integer.toString(this.recycledStarAttrib.getChannel(), 16);
        string = string + '_' + aaPhpReadAttributeResponse.getAttributeName();
        string = SlotPath.escape((String)string);
        BAaPhpStarAttribute bAaPhpStarAttribute = (BAaPhpStarAttribute)this.recycledStarAttrib.newCopy();
        bAaPhpStarAttribute.setRawDataHex(aaPhpReadAttributeResponse.getRawDataHex());
        bAaPhpStarAttribute.setNumericEncodingType(aaPhpReadAttributeResponse.getEncodingValue());
        bAaPhpStarAttribute.setAttr(aaPhpReadAttributeResponse.getAttributeName());
        bAaPhpStarAttribute.setDiscoverValue(aaPhpReadAttributeResponse.getAttrConv().getStringVal(null));
        bComponent.add(string + '?', (BValue)bAaPhpStarAttribute, 0, aaPhpReadAttributeResponse.getAttrConv().getDefaultFacets(), null);
        this.heartbeat();
        if (bComponent instanceof BFolder) {
            this.defaultAttr = aaPhpReadAttributeResponse.getAttributeName();
            this.learnAttributes(bAaPhpStarAttribute);
        } else if (bComponent instanceof BAaPhpStarAttribute) {
            this.learnAttributes((BAaPhpStarAttribute)bComponent);
        } else {
            throw new IllegalArgumentException("The given parent should be been a BFolder or BAaPhpStarAttribute. Please have my program fixed.");
        }
    }

    private final void learnAttributes(BAaPhpStarAttribute bAaPhpStarAttribute) {
        AaPhpReadNextAttributeRequest aaPhpReadNextAttributeRequest = new AaPhpReadNextAttributeRequest(this.unit, this.recycledAaPhpOrd);
        AaPhpReadNextAttributeResponse aaPhpReadNextAttributeResponse = (AaPhpReadNextAttributeResponse)this.aaphpNet.sendSync(aaPhpReadNextAttributeRequest);
        if (aaPhpReadNextAttributeResponse != null && !aaPhpReadNextAttributeResponse.isError() && aaPhpReadNextAttributeResponse.getNextAaPhpOrd() != null) {
            if (!aaPhpReadNextAttributeResponse.getAttributeName().equals(this.defaultAttr) && aaPhpReadNextAttributeResponse.getAttributeName().trim().length() > 0) {
                this.recycledStarAttrib.setAttr(aaPhpReadNextAttributeResponse.getAttributeName());
                this.recycledAaPhpOrd = this.recycledStarAttrib.getAaPhpOrd();
                this.processLearnedPoint(bAaPhpStarAttribute, aaPhpReadNextAttributeResponse);
            } else {
                this.fireLearnedEntirePoint((BValue)BString.DEFAULT);
            }
        }
    }

    private final void logMessage(String string) {
        this.log().message(string);
        if (this.aaphpNet != null) {
            int n = this.aaphpNet.getLog().getSeverity();
            this.aaphpNet.getLog().setSeverity(1);
            this.aaphpNet.getLog().message("Learn Star Points Job:" + string);
            this.aaphpNet.getLog().setSeverity(n);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.numPriorGuesses = 0L;
        this.prev1 = 0L;
        this.prev2 = 0L;
        this.prev3 = 0L;
        this.defaultAttr = "CV";
        this.recycledStarAttrib = new BAaPhpStarAttribute();
        this.typeId = 0;
        this.numLearnAttempts = 0;
        this.startTick = 0L;
    }

    public BAaPhpLearnStarPointsJob() {
        this.this();
    }

    public BAaPhpLearnStarPointsJob(BAaPhpDevice bAaPhpDevice, BAaPhpLearnStarPointsParam bAaPhpLearnStarPointsParam) {
        this.this();
        this.aaphpDev = bAaPhpDevice;
        this.aaphpNet = (BAaPhpStarNetwork)bAaPhpDevice.getAaPhpNetwork();
        this.unit = this.aaphpNet.translateAddress(bAaPhpDevice.getAddress());
        this.fromSubUnit = bAaPhpLearnStarPointsParam.getFromSubUnit();
        this.toSubUnit = bAaPhpLearnStarPointsParam.getToSubUnit();
        this.fromCard = bAaPhpLearnStarPointsParam.getFromCard();
        this.toCard = bAaPhpLearnStarPointsParam.getToCard();
        this.fromChannel = bAaPhpLearnStarPointsParam.getFromChannel();
        this.toChannel = bAaPhpLearnStarPointsParam.getToChannel();
        this.fromSubChannel = bAaPhpLearnStarPointsParam.getFromSubChannel();
        this.toSubChannel = bAaPhpLearnStarPointsParam.getToSubChannel();
        BVector bVector = bAaPhpLearnStarPointsParam.getFundamentalTypes().getEnumValues();
        Class clazz = class$com$tridium$aaphp$enums$BAaPhpDataTypesEnum;
        if (clazz == null) {
            clazz = class$com$tridium$aaphp$enums$BAaPhpDataTypesEnum = BAaPhpLearnStarPointsJob.class("[Lcom.tridium.aaphp.enums.BAaPhpDataTypesEnum;", false);
        }
        this.fundamentalTypes = (BAaPhpDataTypesEnum[])bVector.getChildren(clazz);
        this.fromTypeId = 0;
        this.toTypeId = this.fundamentalTypes.length - 1;
        this.nbrSubChannels = this.toSubChannel - this.fromSubChannel + 1;
        this.nbrChannels = this.toChannel - this.fromChannel + 1;
        this.nbrCards = this.toCard - this.fromCard + 1;
        this.nbrTypeIds = this.toTypeId - this.fromTypeId + 1;
        this.nbrSubUnits = this.toSubUnit - this.fromSubUnit + 1;
        this.nbrPerSubChannel = 1;
        this.nbrPerChannel = this.nbrSubChannels * this.nbrPerSubChannel;
        this.nbrPerCard = this.nbrChannels * this.nbrPerChannel;
        this.nbrPerTypeId = this.nbrCards * this.nbrPerCard;
        this.nbrPerSubUnit = this.nbrTypeIds * this.nbrPerTypeId;
        this.necessaryLearnAttempts = this.nbrSubUnits * this.nbrPerSubUnit;
        this.setDiscoveryParameters(bAaPhpLearnStarPointsParam);
    }

    static {
        Class clazz = class$com$tridium$aaphp$job$BAaPhpLearnStarPointsJob;
        if (clazz == null) {
            clazz = class$com$tridium$aaphp$job$BAaPhpLearnStarPointsJob = BAaPhpLearnStarPointsJob.class("[Lcom.tridium.aaphp.job.BAaPhpLearnStarPointsJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SubUnitNotInMapException
    extends Exception {
        SubUnitNotInMapException() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BadSubUnitNumberException
    extends Exception {
        BadSubUnitNumberException() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class NoCardException
    extends Exception {
        NoCardException() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BadChannelException
    extends Exception {
        BadChannelException() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BadTypeException
    extends Exception {
        BadTypeException() {
        }
    }
}

