/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.job;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.messages.AaPhpCloseVirtualTerminalRequest;
import com.tridium.aaphp.messages.AaPhpOpenVirtualTerminalRequest;
import com.tridium.aaphp.messages.AaPhpSimpleAckResponse;
import com.tridium.aaphp.messages.AaPhpVirtualTerminalRequest;
import com.tridium.aaphp.messages.AaPhpVirtualTerminalResponse;
import com.tridium.util.EscUtil;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBlob;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAaPhpGatherSetupInfoJob
extends BSimpleJob {
    public static final Property resultsFileOrd = BAaPhpGatherSetupInfoJob.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Property earlierResultsFileOrd = BAaPhpGatherSetupInfoJob.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Property deviceName = BAaPhpGatherSetupInfoJob.newProperty((int)1, (String)"", null);
    public static final Property compareComplete = BAaPhpGatherSetupInfoJob.newProperty((int)1, (boolean)false, null);
    public static final Type TYPE;
    static final String HEADER_CONST1 = "******************************************************************************\n* Xml Script Checksum = ";
    static final String HEADER_CONST2 = "* NOTE: If the checksum differs in another version of this file then that file\n* was generated using a different set of terminal XML commands.\n******************************************************************************\n";
    private static final String TERMINAL_COMMANDS = "TerminalCommands";
    private static final String KEYSTROKES_COMMAND = "KeyStrokes";
    private static final String REPEAT_ATTRIBUTE = "repeat";
    private static final String SLEEP_COMMAND = "Sleep";
    private static final String GATHER_COMMAND = "Gather";
    private boolean shouldGatherCommand;
    private final BAaPhpDevice device;
    private final BAaPhpNetwork network;
    private final String terminalCommandsXmlContents;
    private final PreventDoubleSpacingOutputStream resultsOut;
    private int numXmlElements;
    private int processedXmlElements;
    static /* synthetic */ Class class$com$tridium$aaphp$job$BAaPhpGatherSetupInfoJob;

    public BOrd getResultsFileOrd() {
        return (BOrd)this.get(resultsFileOrd);
    }

    public void setResultsFileOrd(BOrd bOrd) {
        this.set(resultsFileOrd, (BValue)bOrd, null);
    }

    public BOrd getEarlierResultsFileOrd() {
        return (BOrd)this.get(earlierResultsFileOrd);
    }

    public void setEarlierResultsFileOrd(BOrd bOrd) {
        this.set(earlierResultsFileOrd, (BValue)bOrd, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String string) {
        this.setString(deviceName, string, null);
    }

    public boolean getCompareComplete() {
        return this.getBoolean(compareComplete);
    }

    public void setCompareComplete(boolean bl) {
        this.setBoolean(compareComplete, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    private final void writeHeader() throws Exception {
        CheckedOutputStream checkedOutputStream = new CheckedOutputStream(new ByteArrayOutputStream(), new CRC32());
        checkedOutputStream.write(this.terminalCommandsXmlContents.getBytes());
        this.resultsOut.write(HEADER_CONST1.getBytes());
        this.resultsOut.write(Long.toHexString(checkedOutputStream.getChecksum().getValue()).getBytes());
        this.resultsOut.write(10);
        this.resultsOut.write(HEADER_CONST2.getBytes());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Context context) throws Exception {
        try {
            this.openTerminalSession();
            this.writeHeader();
            this.executeXmlScript();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.closeTerminalSession();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.closeTerminalSession();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void executeXmlScript() throws OpenSummaryFileException, CloseSummaryFileException, TerminalCommandXmlFormatException, WriteSummaryFileException, OpenTerminalCommandsException, OpenTerminalCommandsParserException, ParseTerminalCommandsParserException {
        try {
            XElem xElem = this.getTerminalCommands();
            if (xElem == null) {
                throw new TerminalCommandXmlFormatException("The terminal commands xml file does not seem to be an XML document.", null);
            }
            if (!xElem.name().equalsIgnoreCase(TERMINAL_COMMANDS)) throw new TerminalCommandXmlFormatException("The outermost document of the terminal commands xml file must be <TerminalCommands>...</TerminalCommands> not <" + xElem.name() + ">...</" + xElem.name() + '>', xElem);
            this.processRootCommand(xElem);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            try {
                this.log().message("Saving setup info...");
                this.resultsOut.flush();
                this.resultsOut.close();
                this.log().message("Setup info saved.");
                throw throwable;
            }
            catch (IOException iOException) {
                throw new CloseSummaryFileException(iOException);
            }
        }
        {
            Object var2_4 = null;
        }
        try {}
        catch (IOException iOException) {
            throw new CloseSummaryFileException(iOException);
        }
        this.log().message("Saving setup info...");
        this.resultsOut.flush();
        this.resultsOut.close();
        this.log().message("Setup info saved.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processCommand(XElem xElem) throws TerminalCommandXmlFormatException, WriteSummaryFileException {
        String string = xElem.name();
        try {
            if (string == null) {
                throw new TerminalCommandXmlFormatException("It seems that there is an empty XML tag in the terminal commands xml file.", xElem);
            }
            if (string.equalsIgnoreCase(GATHER_COMMAND)) {
                this.processGatherCommand(xElem);
            } else if (string.equalsIgnoreCase(KEYSTROKES_COMMAND)) {
                this.processKeyStrokesCommand(xElem);
            } else if (string.equalsIgnoreCase(SLEEP_COMMAND)) {
                this.processSleepCommand(xElem);
            } else {
                this.log().message("Ignoring unsupported inner tag from script XML file: <" + string + ">...</" + string + '>');
            }
            Object var4_5 = null;
            this.consumeTerminalOuptut(xElem);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.consumeTerminalOuptut(xElem);
            float f = (float)(++this.processedXmlElements) * 100.0f / (float)this.numXmlElements;
            if (f > 99.0f) {
                this.progress(99);
            } else {
                this.progress((int)f);
            }
            if (this.getJobState() == BJobState.canceling) {
                throw new JobCancelException();
            }
            throw throwable;
        }
        float f = (float)(++this.processedXmlElements) * 100.0f / (float)this.numXmlElements;
        if (f > 99.0f) {
            this.progress(99);
        } else {
            this.progress((int)f);
        }
        if (this.getJobState() == BJobState.canceling) {
            throw new JobCancelException();
        }
    }

    private final void processKeyStrokesCommand(XElem xElem) throws WriteSummaryFileException {
        XContent[] xContentArray = xElem.content();
        if (xContentArray == null || xContentArray.length < 1) {
            this.log().message("Ignoring empty <Keystrokes> on line " + xElem.line());
        } else {
            int n = xElem.geti(REPEAT_ATTRIBUTE, 1);
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                int n3 = 0;
                while (n3 < xContentArray.length) {
                    if (xContentArray[n3] instanceof XText) {
                        String string = ((XText)xContentArray[n3]).string();
                        if (!bl) {
                            bl = true;
                            this.log().message("Sending keystrokes to virtual terminal: " + EscUtil.slot.escape(string) + (n > 1 ? " (" + n + " times)" : ""));
                        }
                        this.processKeyStrokes(string, xElem);
                    }
                    ++n3;
                }
                this.consumeTerminalOuptut(xElem);
                ++n2;
            }
        }
    }

    private final void processKeyStrokes(String string, XElem xElem) throws WriteSummaryFileException {
        if (string != null && string.length() > 0) {
            this.exchangeTerminalData(string, xElem);
        }
    }

    private final void consumeTerminalOuptut(XElem xElem) throws WriteSummaryFileException {
        String string = this.exchangeTerminalData("", xElem);
        while (string != null && string.length() > 0) {
            string = this.exchangeTerminalData("", xElem);
        }
    }

    private static final String stringReplace(String string, String string2, String string3) {
        if (string2.equals("")) {
            throw new IllegalArgumentException("Old pattern must have content.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        String string4 = stringBuffer.toString();
        while (string4.indexOf(string2) >= 0) {
            string4 = BAaPhpGatherSetupInfoJob.stringReplace(string4, string2, string3);
        }
        return string4;
    }

    private final String exchangeTerminalData(String string, XElem xElem) throws WriteSummaryFileException {
        AaPhpVirtualTerminalRequest aaPhpVirtualTerminalRequest = new AaPhpVirtualTerminalRequest(this.network.translateAddress(this.device.getAddress()), string);
        AaPhpVirtualTerminalResponse aaPhpVirtualTerminalResponse = (AaPhpVirtualTerminalResponse)this.device.getAaPhpNetwork().sendSync(aaPhpVirtualTerminalRequest);
        if (this.getJobState() == BJobState.canceling) {
            throw new JobCancelException();
        }
        if (aaPhpVirtualTerminalResponse == null) {
            this.log().message(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":No response from the field device after the driver transmitted \"" + string + "\" per your XML command on line " + xElem.line());
        } else if (aaPhpVirtualTerminalResponse.isError()) {
            this.log().message(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":The field device reported an error after the driver transmitted \"" + string + "\" per your XML command on line " + xElem.line());
        } else {
            if (aaPhpVirtualTerminalResponse.isEmpty()) {
                return null;
            }
            String string2 = aaPhpVirtualTerminalResponse.getMessageText();
            if (this.shouldGatherCommand) {
                try {
                    this.resultsOut.write(string2);
                }
                catch (IOException iOException) {
                    throw new WriteSummaryFileException(iOException);
                }
            }
            return string2;
        }
        return null;
    }

    private final void processSleepCommand(XElem xElem) throws TerminalCommandXmlFormatException {
        String string = xElem.string().trim();
        if (string == null) {
            this.log().message("Ignoring empty sleep <Sleep> tag on line " + xElem.line());
        } else {
            try {
                this.log().message("Sleeping for " + string + " milliseconds.");
                int n = Integer.parseInt(string);
                Thread.sleep(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TerminalCommandXmlFormatException("The sleep duration should be a number in milliseconds.", xElem);
            }
            catch (InterruptedException interruptedException) {
                String string2 = "Unexpected emergency wakeup from sleep occurred while processing the Sleep tag on line " + xElem.line();
                this.log().message(string2);
                throw new BajaRuntimeException(string2);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processGatherCommand(XElem xElem) throws TerminalCommandXmlFormatException, WriteSummaryFileException {
        this.shouldGatherCommand = true;
        this.log().message("Gather mode on. Gathering virtual terminal output to setup info file.");
        XElem[] xElemArray = xElem.elems();
        if (xElemArray != null && xElemArray.length > 0) {
            int n = 0;
            while (n < xElemArray.length) {
                this.processCommand(xElemArray[n]);
                ++n;
            }
        }
        try {
            try {
                Thread.sleep(this.network.getResponseTimeout().getMillis() * (long)2);
            }
            catch (InterruptedException interruptedException) {
                throw new JobCancelException("Something just interrupted this job.");
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.shouldGatherCommand = false;
            this.log().message("Gather mode off.");
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.shouldGatherCommand = false;
        }
        this.log().message("Gather mode off.");
    }

    private final void processRootCommand(XElem xElem) throws TerminalCommandXmlFormatException, WriteSummaryFileException {
        XElem[] xElemArray = xElem.elems();
        if (xElemArray == null || xElemArray.length < 1) {
            throw new TerminalCommandXmlFormatException("The outermost document of the terminal commands xml file must contain data (one or more <Keystrokes> or <Sleep> tags optionally grouped within a <Log> tag).", xElem);
        }
        this.countXmlElements(xElemArray);
        int n = 0;
        while (n < xElemArray.length) {
            this.processCommand(xElemArray[n]);
            ++n;
        }
    }

    private final void countXmlElements(XElem[] xElemArray) {
        if (xElemArray != null && xElemArray.length > 0) {
            int n = 0;
            while (n < xElemArray.length) {
                this.countXmlElements(xElemArray[n].elems());
                ++n;
                ++this.numXmlElements;
            }
        }
    }

    private final XElem getTerminalCommands() throws OpenTerminalCommandsException, OpenTerminalCommandsParserException, ParseTerminalCommandsParserException {
        if (this.terminalCommandsXmlContents != null) {
            XParser xParser;
            try {
                xParser = XParser.make((String)this.terminalCommandsXmlContents);
            }
            catch (Exception exception) {
                throw new OpenTerminalCommandsParserException(exception);
            }
            try {
                return xParser.parse();
            }
            catch (Exception exception) {
                throw new ParseTerminalCommandsParserException(exception);
            }
        }
        throw new OpenTerminalCommandsException(new NullPointerException());
    }

    private final void openTerminalSession() {
        BRelTime bRelTime = BRelTime.make((long)(this.network.getResponseTimeout().getMillis() * (long)3));
        AaPhpOpenVirtualTerminalRequest aaPhpOpenVirtualTerminalRequest = new AaPhpOpenVirtualTerminalRequest(this.network.translateAddress(this.device.getAddress()));
        AaPhpSimpleAckResponse aaPhpSimpleAckResponse = (AaPhpSimpleAckResponse)this.network.sendSync(aaPhpOpenVirtualTerminalRequest, bRelTime, 0);
        if (aaPhpSimpleAckResponse == null) {
            throw new RuntimeException(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":Timeout opening terminal to gather setup info.");
        }
        if (aaPhpSimpleAckResponse.isError()) {
            throw new RuntimeException(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":Error opening terminal to gather setup info:" + aaPhpSimpleAckResponse.getErrorMsg());
        }
        this.log().message(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":Started terminal session to gather setup info");
    }

    private final void closeTerminalSession() {
        BRelTime bRelTime = BRelTime.make((long)(this.network.getResponseTimeout().getMillis() * (long)4));
        AaPhpCloseVirtualTerminalRequest aaPhpCloseVirtualTerminalRequest = new AaPhpCloseVirtualTerminalRequest(this.network.translateAddress(this.device.getAddress()));
        AaPhpSimpleAckResponse aaPhpSimpleAckResponse = (AaPhpSimpleAckResponse)this.network.sendSync(aaPhpCloseVirtualTerminalRequest, bRelTime, 0);
        if (aaPhpSimpleAckResponse == null) {
            throw new RuntimeException(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":Unable to end terminal session:No response to close terminal command");
        }
        if (aaPhpSimpleAckResponse.isError()) {
            throw new RuntimeException(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":Unable to end terminal session:" + aaPhpSimpleAckResponse.getErrorMsg());
        }
        this.log().message(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":Finished terminal session for gathering setup info.");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.shouldGatherCommand = false;
        this.numXmlElements = 0;
        this.processedXmlElements = 0;
    }

    public BAaPhpGatherSetupInfoJob() {
        this.this();
        this.device = null;
        this.network = null;
        this.terminalCommandsXmlContents = null;
        this.resultsOut = null;
    }

    public BAaPhpGatherSetupInfoJob(BAaPhpDevice bAaPhpDevice, BBlob bBlob, OutputStream outputStream, BOrd bOrd, BOrd bOrd2) {
        this.this();
        this.device = bAaPhpDevice;
        this.network = bAaPhpDevice.getAaPhpNetwork();
        this.terminalCommandsXmlContents = new String(bBlob.copyBytes());
        this.resultsOut = new PreventDoubleSpacingOutputStream(outputStream);
        this.setResultsFileOrd(bOrd);
        this.setEarlierResultsFileOrd(bOrd2);
        this.setDeviceName(bAaPhpDevice.getName());
    }

    static {
        Class clazz = class$com$tridium$aaphp$job$BAaPhpGatherSetupInfoJob;
        if (clazz == null) {
            clazz = class$com$tridium$aaphp$job$BAaPhpGatherSetupInfoJob = BAaPhpGatherSetupInfoJob.class("[Lcom.tridium.aaphp.job.BAaPhpGatherSetupInfoJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PreventDoubleSpacingOutputStream
    extends FilterOutputStream {
        OutputStream out;
        char lastCharPreviouslyWritten;

        public void write(String string) throws IOException {
            string = BAaPhpGatherSetupInfoJob.stringReplace(string, "\r\n", "\n");
            string = BAaPhpGatherSetupInfoJob.stringReplace(string, "\n\n", "\n");
            char c = (string = BAaPhpGatherSetupInfoJob.stringReplace(string, "  ", " ")).charAt(0);
            if (c == '\n' && this.lastCharPreviouslyWritten == '\n' || c == ' ' && this.lastCharPreviouslyWritten == ' ') {
                string = string.substring(1);
            }
            this.lastCharPreviouslyWritten = string.charAt(string.length() - 1);
            super.write(string.getBytes());
        }

        private final /* synthetic */ void this() {
            this.lastCharPreviouslyWritten = '\u0000';
        }

        PreventDoubleSpacingOutputStream(OutputStream outputStream) {
            super(outputStream);
            this.this();
            this.out = outputStream;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class OpenSummaryFileException
    extends BajaException {
        public String toString() {
            return "Unable to open output file on target file system:" + this.getCause();
        }

        OpenSummaryFileException(IOException iOException) {
            super((Throwable)iOException);
        }
    }

    static class CloseSummaryFileException
    extends BajaException {
        public String toString() {
            return "Unable to close summary output file on target file system:" + this.getCause();
        }

        CloseSummaryFileException(IOException iOException) {
            super((Throwable)iOException);
        }
    }

    public static class TerminalCommandXmlFormatException
    extends BajaException {
        XElem faulty;

        public String toString() {
            if (this.faulty == null) {
                return super.toString();
            }
            return super.toString() + " [ On Line " + this.faulty.line() + ']';
        }

        TerminalCommandXmlFormatException(String string, XElem xElem) {
            super(string);
            this.faulty = xElem;
        }
    }

    static class WriteSummaryFileException
    extends BajaException {
        public String toString() {
            return "Unable to write to output file on target file system:" + this.getCause();
        }

        WriteSummaryFileException(IOException iOException) {
            super((Throwable)iOException);
        }
    }

    public static class OpenTerminalCommandsException
    extends BajaException {
        public String toString() {
            return "Unable to open terminal commands file:" + this.getCause();
        }

        OpenTerminalCommandsException(Exception exception) {
            super((Throwable)exception);
        }
    }

    public static class OpenTerminalCommandsParserException
    extends BajaException {
        public String toString() {
            return "Unable to open parser for terminal commands file:" + this.getCause();
        }

        OpenTerminalCommandsParserException(Exception exception) {
            super((Throwable)exception);
        }
    }

    public static class ParseTerminalCommandsParserException
    extends BajaException {
        public String toString() {
            return "Unable to parse terminal commands file:" + this.getCause();
        }

        ParseTerminalCommandsParserException(Exception exception) {
            super((Throwable)exception);
        }
    }
}

