/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.enums.BNdioPointTypeEnum;
import com.tridium.ndio.point.BNdioAnalogOutputProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNdioVoltageOutputProxyExt
extends BNdioAnalogOutputProxyExt {
    public static final Property pointType = BNdioVoltageOutputProxyExt.newProperty((int)1, (BValue)BNdioPointTypeEnum.voltageOutput, null);
    public static final Property deviceFacets = BNdioVoltageOutputProxyExt.newProperty((int)1, (BValue)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt")));
    public static final Type TYPE;
    private boolean pendingValue;
    static /* synthetic */ Class class$com$tridium$ndio$point$BNdioVoltageOutputProxyExt;

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return super.isParentLegal(bComponent) && bComponent instanceof BNumericPoint;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readWrite;
    }

    public void read() {
        if (!this.pointSynchronized()) {
            return;
        }
        try {
            BStatusNumeric bStatusNumeric = this.readNumericValue();
            this.readOk((BStatusValue)bStatusNumeric);
        }
        catch (Exception exception) {
            this.readFail(exception.getMessage());
        }
    }

    public boolean write(Context context) {
        if (!Sys.atSteadyState()) {
            this.pendingValue = true;
        }
        if (!this.pointSynchronized()) {
            return false;
        }
        if (this.getWriteValue().getStatus().isNull()) {
            return false;
        }
        float f = (float)((BStatusNumeric)this.getWriteValue()).getValue();
        if (Float.isNaN(f)) {
            return false;
        }
        try {
            this.writeFloatValue(f);
            this.writeOk(this.getWriteValue());
            this.readOk((BStatusValue)new BStatusNumeric((double)f));
            return true;
        }
        catch (Exception exception) {
            this.writeFail(exception.getMessage());
            return false;
        }
    }

    public void atSteadyState() throws Exception {
        if (this.pendingValue) {
            this.write(null);
        }
    }

    protected BStatusNumeric readNumericValue() throws Exception {
        float f = this.getBoard().readValue(2, this.getAddress());
        this.setRaw((long)f);
        f = f * 10.0f / 4095.0f;
        if (f < 0.0f) {
            f = 0.0f;
        }
        boolean bl = this.getBoard().readOverrideValue(2, this.getAddress());
        BStatusNumeric bStatusNumeric = new BStatusNumeric((double)f);
        this.getHardwareOverride().evaluate((BStatusValue)bStatusNumeric, bl);
        return bStatusNumeric;
    }

    protected void writeFloatValue(float f) throws Exception {
        if (this.getBoard().getAoType(this.getAddress()) != 1) {
            log.error("physical analog out is not voltage type");
            this.writeFail("physical analog out is not voltage type");
            return;
        }
        float f2 = 10.0f;
        float f3 = 0.0f;
        if (f > f2) {
            f = f2;
        } else if (f < f3) {
            f = f3;
        }
        int n = (int)(f / f2 * 4095.0f) & 0xFFF;
        this.getBoard().writeValue(2, this.getAddress(), n);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pendingValue = false;
    }

    public BNdioVoltageOutputProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ndio$point$BNdioVoltageOutputProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$ndio$point$BNdioVoltageOutputProxyExt = BNdioVoltageOutputProxyExt.class("[Lcom.tridium.ndio.point.BNdioVoltageOutputProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

