/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.BNdioBoard;
import com.tridium.ndio.learn.BNdioPointDiscoveryJob;
import com.tridium.ndio.point.BNdioPointFolder;
import com.tridium.ndio.point.BNdioProxyExt;
import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNdioPointDeviceExt
extends BPointDeviceExt {
    public static final Action submitDiscoveryJob = BNdioPointDeviceExt.newAction((int)4, null);
    public static final Type TYPE;
    protected static final Log log;
    static /* synthetic */ Class class$com$tridium$ndio$point$BNdioPointDeviceExt;

    public BOrd submitDiscoveryJob() {
        return (BOrd)this.invoke(submitDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BNdioBoard;
    }

    public Type getProxyExtType() {
        return BNdioProxyExt.TYPE;
    }

    public Type getDeviceType() {
        return BNdioBoard.TYPE;
    }

    public Type getPointFolderType() {
        return BNdioPointFolder.TYPE;
    }

    public BNdioBoard getBoard() {
        return (BNdioBoard)this.getDevice();
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (this.isRunning() && property.getType().is(BControlPoint.TYPE)) {
            this.handlePointAdded((BControlPoint)this.get(property));
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
        if (this.isRunning() && property.getType().is(BControlPoint.TYPE)) {
            this.handlePointRemoved((BControlPoint)bValue);
        }
    }

    public void handlePointChanged(BControlPoint bControlPoint) {
        log.trace("handle point changed for " + bControlPoint.getName());
        BNdioProxyExt bNdioProxyExt = (BNdioProxyExt)bControlPoint.getProxyExt();
        bNdioProxyExt.setSynced(false);
        if (this.checkInvalidPoint(bControlPoint, bNdioProxyExt.getAddress())) {
            if (this.checkDuplicatePoint(bControlPoint, bNdioProxyExt.getAddress())) {
                bNdioProxyExt.configOk();
            }
        } else {
            this.checkDuplicatePoint(bControlPoint, bNdioProxyExt.getAddress());
        }
    }

    public void handlePointAdded(BControlPoint bControlPoint) {
        if (bControlPoint.getProxyExt() instanceof BNdioProxyExt) {
            log.trace("handle point added for " + bControlPoint.getName());
            BNdioProxyExt bNdioProxyExt = (BNdioProxyExt)bControlPoint.getProxyExt();
            if (this.checkInvalidPoint(bControlPoint, bNdioProxyExt.getAddress()) && this.checkDuplicatePoint(bControlPoint, bNdioProxyExt.getAddress())) {
                bNdioProxyExt.configOk();
            }
        }
    }

    public void handlePointRemoved(BControlPoint bControlPoint) {
        if (bControlPoint.getProxyExt() instanceof BNdioProxyExt) {
            log.trace("handle point removed for " + bControlPoint.getName());
            BNdioProxyExt bNdioProxyExt = (BNdioProxyExt)bControlPoint.getProxyExt();
            this.checkDuplicatePointCleared(bControlPoint, bNdioProxyExt.getAddress());
        }
    }

    private final boolean checkInvalidPoint(BControlPoint bControlPoint, int n) {
        BNdioProxyExt bNdioProxyExt = (BNdioProxyExt)bControlPoint.getProxyExt();
        if (n > this.getBoard().getCount(bNdioProxyExt.getIoType().getOrdinal()) || n < 1) {
            bNdioProxyExt.configFail("invalid address provided (1 <= addr <= " + this.getBoard().getCount(bNdioProxyExt.getIoType().getOrdinal()) + ')');
            return false;
        }
        return true;
    }

    private final boolean checkDuplicatePoint(BControlPoint bControlPoint, int n) {
        boolean bl = false;
        BNdioProxyExt bNdioProxyExt = (BNdioProxyExt)bControlPoint.getProxyExt();
        this.checkDuplicatePointCleared(bControlPoint, bNdioProxyExt.getPreviousAddress());
        BControlPoint[] bControlPointArray = this.getDeviceExt().getPoints();
        int n2 = 0;
        while (n2 < bControlPointArray.length) {
            BNdioProxyExt bNdioProxyExt2 = (BNdioProxyExt)bControlPointArray[n2].getProxyExt();
            if (bNdioProxyExt2.getIoType() == bNdioProxyExt.getIoType() && bNdioProxyExt2 != bNdioProxyExt && bNdioProxyExt2.getAddress() == n) {
                bl = true;
                bNdioProxyExt2.configFail("duplicate address: addresses must be unique/type");
            }
            ++n2;
        }
        if (bl) {
            bNdioProxyExt.configFail("duplicate address: addresses must be unique/type");
            return false;
        }
        return true;
    }

    private final void checkDuplicatePointCleared(BControlPoint bControlPoint, int n) {
        BNdioProxyExt bNdioProxyExt = (BNdioProxyExt)bControlPoint.getProxyExt();
        BControlPoint[] bControlPointArray = this.getDeviceExt().getPoints();
        if (n != 0) {
            BControlPoint bControlPoint2;
            BNdioProxyExt bNdioProxyExt2;
            ArrayList<BControlPoint> arrayList = new ArrayList<BControlPoint>(bControlPointArray.length);
            int n2 = 0;
            while (n2 < bControlPointArray.length) {
                bNdioProxyExt2 = (BNdioProxyExt)bControlPointArray[n2].getProxyExt();
                if (bNdioProxyExt2.getIoType() == bNdioProxyExt.getIoType() && bNdioProxyExt2 != bNdioProxyExt && bNdioProxyExt2.getAddress() == n) {
                    arrayList.add(bControlPointArray[n2]);
                }
                ++n2;
            }
            if (arrayList.size() == 1 && this.checkInvalidPoint(bControlPoint2 = (BControlPoint)arrayList.get(0), (bNdioProxyExt2 = (BNdioProxyExt)bControlPoint2.getProxyExt()).getAddress())) {
                bNdioProxyExt2.configOk();
            }
            arrayList = null;
        }
    }

    public void resetPoints() {
        BControlPoint[] bControlPointArray = this.getPoints();
        int n = 0;
        while (n < bControlPointArray.length) {
            this.handlePointChanged(bControlPointArray[n]);
            ++n;
        }
    }

    public BOrd doSubmitDiscoveryJob(Context context) {
        return new BNdioPointDiscoveryJob(this).submit(context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$ndio$point$BNdioPointDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$ndio$point$BNdioPointDeviceExt = BNdioPointDeviceExt.class("[Lcom.tridium.ndio.point.BNdioPointDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"ndio");
    }
}

