/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.conv;

import com.tridium.ndio.NdioException;
import com.tridium.ndio.point.BNdioVoltageInputProxyExt;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitException;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BShunt500OhmConversion
extends BProxyConversion {
    public static final BShunt500OhmConversion DEFAULT = BShunt500OhmConversion.make();
    private static BUnit VOLTS_UNIT = BUnit.getUnit((String)"volt");
    private static BUnit MA_UNIT = BUnit.getUnit((String)"milliampere");
    public static final Type TYPE;
    private static double[] src;
    private static double[] dest;
    private BProxyConversion subConv;
    static /* synthetic */ Class class$com$tridium$ndio$conv$BShunt500OhmConversion;

    public static final BShunt500OhmConversion make() {
        return new BShunt500OhmConversion();
    }

    public static final BShunt500OhmConversion make(BProxyConversion bProxyConversion) {
        return new BShunt500OhmConversion(bProxyConversion);
    }

    public final void convertDeviceToProxy(BProxyExt bProxyExt, BStatusValue bStatusValue, BStatusValue bStatusValue2) throws Exception {
        if (bStatusValue instanceof BStatusNumeric) {
            BUnit bUnit = (BUnit)bProxyExt.getDeviceFacets().get("units", (BObject)BUnit.NULL);
            if (!bProxyExt.getType().is(BNdioVoltageInputProxyExt.TYPE)) {
                throw new NdioException("500 Ohm shunt conversion can only be used with ndio voltage input");
            }
            if (bUnit.isConvertible(VOLTS_UNIT)) {
                double d = ((BStatusNumeric)bStatusValue).getValue();
                double d2 = this.convertTo(d, src, dest);
                bStatusValue2.setStatus(bStatusValue.getStatus());
                ((BStatusNumeric)bStatusValue2).setValue(d2);
                this.subConv.convertDeviceToProxy(bProxyExt, bStatusValue2, bStatusValue2);
                return;
            }
            bStatusValue2.copyFrom((BComplex)bStatusValue);
            throw new UnitException("Not convertible: " + bUnit);
        }
        bStatusValue2.copyFrom((BComplex)bStatusValue);
        throw new NdioException("Not convertible: invalid point type");
    }

    public final void convertProxyToDevice(BProxyExt bProxyExt, BStatusValue bStatusValue, BStatusValue bStatusValue2) throws Exception {
        bStatusValue2.copyFrom((BComplex)bStatusValue);
        throw new NdioException("Not convertible: invalid point type");
    }

    private final double convertTo(double d, double[] dArray, double[] dArray2) {
        int n = 0;
        int n2 = dArray.length;
        if (d < dArray[0]) {
            return dArray2[0];
        }
        if (d > dArray[n2 - 1]) {
            return dArray2[n2 - 1];
        }
        if (d == dArray[n2 - 1]) {
            return dArray2[n2 - 1];
        }
        int n3 = 0;
        while (n3 < n2 - 1) {
            if (d >= dArray[n3] && d < dArray[n3 + 1]) {
                n = n3;
                break;
            }
            ++n3;
        }
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        double d4 = dArray2[n];
        double d5 = dArray2[n + 1];
        return d4 - (d2 - d) * (d4 - d5) / (d2 - d3);
    }

    public final int hashCode() {
        return this.subConv.hashCode();
    }

    public final boolean equals(Object object) {
        BShunt500OhmConversion bShunt500OhmConversion;
        if (object instanceof BShunt500OhmConversion && (bShunt500OhmConversion = (BShunt500OhmConversion)((Object)object)).getSubConversion().getType() == this.subConv.getType()) {
            boolean bl = false;
            if (this.hashCode() == bShunt500OhmConversion.hashCode()) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final String toString(Context context) {
        return TYPE.getDisplayName(context);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        this.subConv.getType().getTypeSpec().encode(dataOutput);
        this.subConv.encode(dataOutput);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        BTypeSpec bTypeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decode(dataInput);
        return BShunt500OhmConversion.make((BProxyConversion)((BProxyConversion)bTypeSpec.getInstance()).decode(dataInput));
    }

    public final String encodeToString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.subConv.getType().getTypeSpec().encodeToString());
        stringBuffer.append(";");
        stringBuffer.append(this.subConv.encodeToString());
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        int n = string.indexOf(";");
        BTypeSpec bTypeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(string.substring(0, n));
        return BShunt500OhmConversion.make((BProxyConversion)((BProxyConversion)bTypeSpec.getInstance()).decodeFromString(string.substring(n + 1)));
    }

    public final BProxyConversion getSubConversion() {
        return this.subConv;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BShunt500OhmConversion() {
        this.subConv = BDefaultProxyConversion.DEFAULT;
    }

    private BShunt500OhmConversion(BProxyConversion bProxyConversion) {
        this.subConv = bProxyConversion;
    }

    static {
        Class clazz = class$com$tridium$ndio$conv$BShunt500OhmConversion;
        if (clazz == null) {
            clazz = class$com$tridium$ndio$conv$BShunt500OhmConversion = BShunt500OhmConversion.class("[Lcom.tridium.ndio.conv.BShunt500OhmConversion;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        double[] dArray = new double[3];
        dArray[1] = 3.912f;
        dArray[2] = 9.315f;
        src = dArray;
        double[] dArray2 = new double[3];
        dArray2[1] = 3.912f;
        dArray2[2] = 10.0;
        dest = dArray2;
    }
}

