/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio;

import com.tridium.ndio.BNdioNetwork;
import com.tridium.ndio.NdioConstants;
import com.tridium.ndio.NdioException;
import com.tridium.ndio.NdioProperties;
import com.tridium.ndio.NdioRebootException;
import javax.baja.log.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NdioProcessor
implements NdioConstants {
    static final Log log = Log.getLog((String)"ndio");
    private int ioPort;
    private boolean master;
    private int hdwrAddress;
    private String firmwareVersion;
    private int configCode;
    private NdioProperties ndioProps;
    private long firstReadTicks;

    public int getHdwrAddress() {
        return this.hdwrAddress;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public int getConfigCode() {
        return this.configCode;
    }

    public boolean getMultipleProcessors() {
        return this.ndioProps.getMultipleProcessors();
    }

    public int getUiCount() {
        return this.ndioProps.getUiCount();
    }

    public int getBoCount() {
        return this.ndioProps.getBoCount();
    }

    public int getAoCount() {
        return this.ndioProps.getAoCount();
    }

    public boolean getUiBiEnabled() {
        return this.ndioProps.getUiBiEnabled();
    }

    public boolean getUiHsEnabled() {
        return this.ndioProps.getUiHsEnabled();
    }

    public boolean getUiThEnabled() {
        return this.ndioProps.getUiThEnabled();
    }

    public boolean getUiPlEnabled() {
        return this.ndioProps.getUiPlEnabled();
    }

    public boolean getUiVEnabled() {
        return this.ndioProps.getUiVEnabled();
    }

    public boolean getUiMaEnabled() {
        return this.ndioProps.getUiMaEnabled();
    }

    public int getCount(int n) {
        return this.ndioProps.getCount(n);
    }

    public int getAoType(int n) {
        return this.ndioProps.getAoType(n);
    }

    int getAoOverrideMap(int n) {
        return this.ndioProps.getAoOverrideMap(n);
    }

    int getDoOverrideMap(int n) {
        return this.ndioProps.getDoOverrideMap(n);
    }

    public void resetInfo() {
        this.firmwareVersion = "-";
        this.configCode = 0;
        this.hdwrAddress = -1;
        this.ndioProps = NdioProperties.DEFAULT;
    }

    public void initDevice() throws Exception {
        this.resetInfo();
        this.recalcHdwrAddress();
        if (this.hdwrAddress < 0 || this.hdwrAddress > 7) {
            return;
        }
        if (BNdioNetwork.getPlatformService() != null) {
            int n = BNdioNetwork.getPlatformService().getFirmwareIntfNum(this.hdwrAddress);
            int n2 = BNdioNetwork.getPlatformService().getFirmwareBuildNum(this.hdwrAddress);
            this.firmwareVersion = "" + n + '.' + n2;
            this.configCode = BNdioNetwork.getPlatformService().readConfigCode(this.hdwrAddress);
            this.ndioProps = NdioProperties.make(this.configCode);
        }
    }

    public int readUIType(int n) throws Exception {
        return BNdioNetwork.getPlatformService().readUIType(this.hdwrAddress, n - 1);
    }

    public void writeUIType(int n, int n2) throws Exception {
        BNdioNetwork.getPlatformService().writeUIType(this.hdwrAddress, n - 1, n2);
    }

    public int readValue(int n, int n2) throws Exception {
        int n3 = BNdioNetwork.getPlatformService().readValue(this.hdwrAddress, n, n2 - 1);
        return n3;
    }

    public void writeValue(int n, int n2, int n3) throws Exception {
        BNdioNetwork.getPlatformService().writeValue(this.hdwrAddress, n, n2 - 1, n3);
    }

    public long readUICount(int n) throws Exception {
        return BNdioNetwork.getPlatformService().readUICount(this.hdwrAddress, n - 1);
    }

    public long readUICountDelta(int n) throws Exception {
        return BNdioNetwork.getPlatformService().readUICountDelta(this.hdwrAddress, n - 1);
    }

    public void recalcHdwrAddress() {
        int n = -1;
        if (this.ioPort >= 0) {
            n = NdioConstants.IO_PORT_TO_PROC_0[this.ioPort];
            if (!this.master) {
                ++n;
            }
        }
        this.hdwrAddress = n;
    }

    public void ping() throws Exception {
        int n = BNdioNetwork.getPlatformService().readIoType(this.hdwrAddress);
        int n2 = BNdioNetwork.getPlatformService().readIoConfigState(this.hdwrAddress);
        if (n == 0 || n2 == 0 || n2 == 1) {
            throw new NdioException("processor @ " + this.hdwrAddress + " was not found");
        }
        if (!BNdioNetwork.getPlatformService().isProcessorOk(this.hdwrAddress)) {
            log.error("processor " + this.hdwrAddress + " is not 'ok'");
            throw new NdioRebootException("processor " + this.hdwrAddress + " is not 'ok'");
        }
        if (BNdioNetwork.getPlatformService().getErrorFlags(this.hdwrAddress) != 0) {
            log.error("processor " + this.hdwrAddress + " failed with error flags " + BNdioNetwork.getPlatformService().getErrorFlags(this.hdwrAddress));
            throw new NdioException("processor " + this.hdwrAddress + " failed with error flags " + BNdioNetwork.getPlatformService().getErrorFlags(this.hdwrAddress));
        }
    }

    private final /* synthetic */ void this() {
        this.hdwrAddress = -1;
        this.firmwareVersion = "-";
        this.configCode = 0;
        this.ndioProps = NdioProperties.DEFAULT;
        this.firstReadTicks = -1;
    }

    public NdioProcessor() {
        this.this();
        this.ioPort = -1;
        this.master = true;
    }

    public NdioProcessor(int n, boolean bl) {
        this.this();
        this.ioPort = n;
        this.master = bl;
        try {
            this.initDevice();
        }
        catch (Exception exception) {}
    }
}

