/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio;

import com.tridium.ndio.BINdioRebootable;
import com.tridium.ndio.BNdioNetwork;
import com.tridium.platform.BSystemPlatformService;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.driver.ping.BIPingable;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNdioPingMonitor
extends BPingMonitor {
    public static final Property pingFrequency = BNdioPingMonitor.newProperty((int)0, (BValue)BRelTime.make((long)10000L), null);
    public static final Property startupAlarmDelay = BNdioPingMonitor.newProperty((int)5, (BValue)BRelTime.make((long)0L), null);
    public static final Property rebootEnabled = BNdioPingMonitor.newProperty((int)0, (boolean)true, null);
    public static final Property keepAliveTimeout = BNdioPingMonitor.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)30)));
    public static final Property rebootPeriod = BNdioPingMonitor.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)30), null);
    public static final Property maxRebootPeriodCount = BNdioPingMonitor.newProperty((int)0, (int)3, null);
    public static final Property rebootPeriodStart = BNdioPingMonitor.newProperty((int)69, (BValue)BAbsTime.DEFAULT, null);
    public static final Property rebootPeriodCount = BNdioPingMonitor.newProperty((int)69, (int)0, null);
    public static final Property totalRebootRequests = BNdioPingMonitor.newProperty((int)1, (int)0, null);
    public static final Property lastRebootRequest = BNdioPingMonitor.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Type TYPE;
    static final Log log;
    static final String NDIO_REBOOT = "ndioReboot";
    static Lexicon ndioLex;
    private Thread rebootThread;
    static /* synthetic */ Class class$com$tridium$ndio$BNdioPingMonitor;

    public boolean getRebootEnabled() {
        return this.getBoolean(rebootEnabled);
    }

    public void setRebootEnabled(boolean bl) {
        this.setBoolean(rebootEnabled, bl, null);
    }

    public BRelTime getKeepAliveTimeout() {
        return (BRelTime)this.get(keepAliveTimeout);
    }

    public void setKeepAliveTimeout(BRelTime bRelTime) {
        this.set(keepAliveTimeout, (BValue)bRelTime, null);
    }

    public BRelTime getRebootPeriod() {
        return (BRelTime)this.get(rebootPeriod);
    }

    public void setRebootPeriod(BRelTime bRelTime) {
        this.set(rebootPeriod, (BValue)bRelTime, null);
    }

    public int getMaxRebootPeriodCount() {
        return this.getInt(maxRebootPeriodCount);
    }

    public void setMaxRebootPeriodCount(int n) {
        this.setInt(maxRebootPeriodCount, n, null);
    }

    public BAbsTime getRebootPeriodStart() {
        return (BAbsTime)this.get(rebootPeriodStart);
    }

    public void setRebootPeriodStart(BAbsTime bAbsTime) {
        this.set(rebootPeriodStart, (BValue)bAbsTime, null);
    }

    public int getRebootPeriodCount() {
        return this.getInt(rebootPeriodCount);
    }

    public void setRebootPeriodCount(int n) {
        this.setInt(rebootPeriodCount, n, null);
    }

    public int getTotalRebootRequests() {
        return this.getInt(totalRebootRequests);
    }

    public void setTotalRebootRequests(int n) {
        this.setInt(totalRebootRequests, n, null);
    }

    public BAbsTime getLastRebootRequest() {
        return (BAbsTime)this.get(lastRebootRequest);
    }

    public void setLastRebootRequest(BAbsTime bAbsTime) {
        this.set(lastRebootRequest, (BValue)bAbsTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property == keepAliveTimeout) {
            BNdioNetwork bNdioNetwork = (BNdioNetwork)this.getParent();
            bNdioNetwork.updateKeepAliveTimeout(this.getKeepAliveTimeout().getMillis());
        }
    }

    public synchronized void pingFail(BIPingable bIPingable) {
        BINdioRebootable bINdioRebootable;
        if (this.rebootThread != null) {
            return;
        }
        super.pingFail(bIPingable);
        if (this.getRebootEnabled() && bIPingable instanceof BINdioRebootable && (bINdioRebootable = (BINdioRebootable)bIPingable).getRebootConditionMet()) {
            this.alertWithReboot(bIPingable);
            return;
        }
    }

    void alertWithReboot(BIPingable bIPingable) {
        if (this.rebootThread != null) {
            return;
        }
        boolean bl = this.exceededRebootLimit();
        boolean bl2 = false;
        try {
            AlarmSupport alarmSupport = (AlarmSupport)((BObject)bIPingable).fw(502);
            alarmSupport.setAlarmClass(bIPingable.getAlarmSourceInfo().getAlarmClass());
            bl2 = alarmSupport.isAckRequired(BSourceState.offnormal);
            BFacets bFacets = bIPingable.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal);
            String string = bFacets.gets("msgText", "");
            string = bl ? string + " (%lexicon(ndio:ndioReboot)%,%lexicon(ndio:ndioDisabled)%)" : string + " (%lexicon(ndio:ndioReboot)%)";
            alarmSupport.newAlert(BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)"msgText", (BIDataValue)BString.make((String)string), (String)NDIO_REBOOT, (BIDataValue)BBoolean.TRUE)));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        int n = bIPingable.getStatus().getBits();
        n |= 8;
        if (bl2) {
            n |= 0x80;
        }
        bIPingable.setStatus(BStatus.make((int)n));
        if (this.rebootThread == null) {
            this.rebootThread = new RebootThread();
            this.rebootThread.start();
        }
    }

    private final void reboot() {
        BSystemPlatformService bSystemPlatformService;
        log.error("ndio driver forcing station save and reboot");
        this.setTotalRebootRequests(this.getTotalRebootRequests() + 1);
        this.setLastRebootRequest(BAbsTime.now());
        try {
            bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            bSystemPlatformService.checkPropertiesLoaded();
            bSystemPlatformService.systemLog(3, "ndio driver forcing station save and reboot");
        }
        catch (Throwable throwable) {}
        try {
            bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            bSystemPlatformService.checkPropertiesLoaded();
            bSystemPlatformService.reboot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private final boolean exceededRebootLimit() {
        BAbsTime bAbsTime = BAbsTime.now();
        BRelTime bRelTime = this.getRebootPeriodStart().delta(bAbsTime);
        if (bRelTime.getSeconds() <= this.getRebootPeriod().getSeconds()) {
            this.setRebootPeriodCount(this.getRebootPeriodCount() + 1);
            if (bRelTime.getSeconds() < 0) {
                this.setRebootPeriodStart(bAbsTime);
            } else {
                if (this.getRebootPeriodCount() >= this.getMaxRebootPeriodCount()) {
                    Object object;
                    log.error("maximum number of ndio reboots reached, disabling ndio");
                    this.setRebootPeriodStart(bAbsTime);
                    this.setRebootPeriodCount(0);
                    try {
                        object = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                        object.checkPropertiesLoaded();
                        object.systemLog(3, "maximum number of ndio reboots reached, disabling ndio");
                    }
                    catch (Throwable throwable) {}
                    object = (BNdioNetwork)this.getParent();
                    object.setEnabled(false);
                    return true;
                }
                log.warning("ndio has rebooted " + this.getRebootPeriodCount() + " times since " + this.getRebootPeriodStart());
            }
        } else {
            this.setRebootPeriodStart(bAbsTime);
            this.setRebootPeriodCount(1);
        }
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.rebootThread = null;
    }

    public BNdioPingMonitor() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ndio$BNdioPingMonitor;
        if (clazz == null) {
            clazz = class$com$tridium$ndio$BNdioPingMonitor = BNdioPingMonitor.class("[Lcom.tridium.ndio.BNdioPingMonitor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"ndio");
        ndioLex = Lexicon.make((String)"ndio");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RebootThread
    extends Thread {
        public void run() {
            BNdioPingMonitor.this.reboot();
        }

        public RebootThread() {
            super("NdioRebootThread");
        }
    }
}

