/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio;

import com.tridium.ndio.BINdioRebootable;
import com.tridium.ndio.BNdioBoard;
import com.tridium.ndio.BNdioBoardFolder;
import com.tridium.ndio.BNdioPingMonitor;
import com.tridium.ndio.BNdioPollScheduler;
import com.tridium.ndio.NdioConstants;
import com.tridium.ndio.NdioProperties;
import com.tridium.ndio.learn.BNdioBoardDiscoveryJob;
import com.tridium.ndio.learn.BNdioBoardEntry;
import com.tridium.platNdio.BNdioPlatformService;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNdioNetwork
extends BDeviceNetwork
implements BINdioRebootable,
NdioConstants,
BIService {
    public static final Property monitor = BNdioNetwork.newProperty((int)0, (BValue)new BNdioPingMonitor(), null);
    public static final Property tuningPolicies = BNdioNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    public static final Property pollScheduler = BNdioNetwork.newProperty((int)0, (BValue)new BNdioPollScheduler(), null);
    public static final Property rebootConditionMet = BNdioNetwork.newProperty((int)71, (boolean)false, null);
    public static final Property averageKeepAliveLifetime = BNdioNetwork.newProperty((int)3, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property averageKeepAliveRecent = BNdioNetwork.newProperty((int)3, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property keepAlivePeak = BNdioNetwork.newProperty((int)3, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property totalKeepAlives = BNdioNetwork.newProperty((int)3, (int)0, null);
    public static final Property totalKeepAliveLateStarts = BNdioNetwork.newProperty((int)3, (int)0, null);
    public static final Action submitDiscoveryJob = BNdioNetwork.newAction((int)4, null);
    public static final Action keepAlive = BNdioNetwork.newAction((int)4, null);
    public static final Type TYPE;
    private static Type[] serviceTypes;
    public static final Log log;
    private static BNdioPlatformService platSvc;
    public static int NDIOD_KEEP_ALIVE_INTERVAL;
    public static long NDIOD_KEEP_ALIVE_WINDOW;
    public static int PING_OK;
    public static int PING_FAILED_DAEMON;
    public static int PING_FAILED_SERVICE;
    public static int PING_FAILED_EXCEPTION;
    private Clock.Ticket ticket;
    private boolean keepAliveStarted;
    private long lastKeepAliveTicks;
    private long startKeepAliveTicks;
    private long recentKeepAliveTicks;
    private long keepAliveCount;
    private long lastDeltaKeepAliveTicks;
    private long[] keepAliveDeltas;
    private int deltaIndex;
    private long keepAlivePeakTicks;
    private int pingState;
    private boolean hadSuccessfulPing;
    static /* synthetic */ Class class$com$tridium$ndio$BNdioNetwork;
    static /* synthetic */ Class class$com$tridium$ndio$BNdioBoard;

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap bTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bTuningPolicyMap, null);
    }

    public BNdioPollScheduler getPollScheduler() {
        return (BNdioPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BNdioPollScheduler bNdioPollScheduler) {
        this.set(pollScheduler, (BValue)bNdioPollScheduler, null);
    }

    public boolean getRebootConditionMet() {
        return this.getBoolean(rebootConditionMet);
    }

    public void setRebootConditionMet(boolean bl) {
        this.setBoolean(rebootConditionMet, bl, null);
    }

    public BRelTime getAverageKeepAliveLifetime() {
        return (BRelTime)this.get(averageKeepAliveLifetime);
    }

    public void setAverageKeepAliveLifetime(BRelTime bRelTime) {
        this.set(averageKeepAliveLifetime, (BValue)bRelTime, null);
    }

    public BRelTime getAverageKeepAliveRecent() {
        return (BRelTime)this.get(averageKeepAliveRecent);
    }

    public void setAverageKeepAliveRecent(BRelTime bRelTime) {
        this.set(averageKeepAliveRecent, (BValue)bRelTime, null);
    }

    public BRelTime getKeepAlivePeak() {
        return (BRelTime)this.get(keepAlivePeak);
    }

    public void setKeepAlivePeak(BRelTime bRelTime) {
        this.set(keepAlivePeak, (BValue)bRelTime, null);
    }

    public long getTotalKeepAlives() {
        return this.getLong(totalKeepAlives);
    }

    public void setTotalKeepAlives(long l) {
        this.setLong(totalKeepAlives, l, null);
    }

    public long getTotalKeepAliveLateStarts() {
        return this.getLong(totalKeepAliveLateStarts);
    }

    public void setTotalKeepAliveLateStarts(long l) {
        this.setLong(totalKeepAliveLateStarts, l, null);
    }

    public BOrd submitDiscoveryJob() {
        return (BOrd)this.invoke(submitDiscoveryJob, null, null);
    }

    public void keepAlive() {
        this.invoke(keepAlive, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getMonitor().getType() != BNdioPingMonitor.TYPE) {
            BPingMonitor bPingMonitor = this.getMonitor();
            BNdioPingMonitor bNdioPingMonitor = new BNdioPingMonitor();
            bNdioPingMonitor.setPingEnabled(bPingMonitor.getPingEnabled());
            bNdioPingMonitor.setAlarmOnFailure(bPingMonitor.getAlarmOnFailure());
            this.setMonitor(bNdioPingMonitor);
            log.message("Upgraded ping monitor for ndio network");
        }
        try {
            if (Sys.getService((Type)TYPE) != this) {
                log.error("Duplicate NdioNetwork, Only one NdioNetwork allowed per station!");
                this.configFail("Duplicate NdioNetwork, Only one NdioNetwork allowed per station!");
                return;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("NdioNetwork not registered as a service!");
            this.configFail("NdioNetwork not registered as a service!");
            return;
        }
        if (BNdioNetwork.getPlatformService() == null) {
            log.error("NdioPlatformService not found!");
            this.configFail("NdioPlatformService not found!");
            return;
        }
        this.startKeepAlive();
    }

    public void atSteadyState() throws Exception {
        this.startKeepAlive();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public void pingOk() {
        super.pingOk();
        this.hadSuccessfulPing = true;
    }

    public Type getDeviceType() {
        return BNdioBoard.TYPE;
    }

    public Type getDeviceFolderType() {
        return BNdioBoardFolder.TYPE;
    }

    public static BNdioPlatformService getPlatformService() {
        if (platSvc == null) {
            try {
                platSvc = (BNdioPlatformService)Sys.getService((Type)BNdioPlatformService.TYPE);
                platSvc.checkPropertiesLoaded();
            }
            catch (ServiceNotFoundException serviceNotFoundException) {}
        }
        return platSvc;
    }

    public BNdioBoard[] getBoards() {
        BDevice[] bDeviceArray = this.getDevices();
        BNdioBoard[] bNdioBoardArray = new BNdioBoard[bDeviceArray.length];
        System.arraycopy(bDeviceArray, 0, bNdioBoardArray, 0, bDeviceArray.length);
        return bNdioBoardArray;
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (this.isRunning() && property.getType().is(BNdioBoard.TYPE)) {
            this.handleBoardAdded((BNdioBoard)this.get(property));
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
        if (this.isRunning() && property.getType().is(BNdioBoard.TYPE)) {
            this.handleBoardRemoved((BNdioBoard)bValue);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.startKeepAlive();
        }
    }

    public void handleBoardChanged(BNdioBoard bNdioBoard) {
        log.trace("handle board changed for " + bNdioBoard.getName());
        if (this.checkInvalidBoard(bNdioBoard, bNdioBoard.getIoPort()) && this.checkDuplicateBoard(bNdioBoard, bNdioBoard.getIoPort())) {
            bNdioBoard.configOk();
            bNdioBoard.initDevice();
        }
    }

    public void handleBoardAdded(BNdioBoard bNdioBoard) {
        log.trace("handle board added for " + bNdioBoard.getName());
        if (this.checkInvalidBoard(bNdioBoard, bNdioBoard.getIoPort()) && this.checkDuplicateBoard(bNdioBoard, bNdioBoard.getIoPort())) {
            bNdioBoard.configOk();
            bNdioBoard.initDevice();
        }
    }

    public void handleBoardRemoved(BNdioBoard bNdioBoard) {
        log.trace("handle board removed for " + bNdioBoard.getName());
        this.checkDuplicateBoardCleared(bNdioBoard, bNdioBoard.getIoPort());
    }

    private final boolean checkInvalidBoard(BNdioBoard bNdioBoard, int n) {
        if (n > 4 || n < 1) {
            bNdioBoard.configFail("invalid ioPort provided (1 <= ioPort <= 4)");
            return false;
        }
        return true;
    }

    private final boolean checkDuplicateBoard(BNdioBoard bNdioBoard, int n) {
        boolean bl = false;
        this.checkDuplicateBoardCleared(bNdioBoard, bNdioBoard.getPreviousIoPort());
        BNdioBoard[] bNdioBoardArray = this.getBoards();
        int n2 = 0;
        while (n2 < bNdioBoardArray.length) {
            if (bNdioBoardArray[n2] != bNdioBoard && bNdioBoardArray[n2].getIoPort() == n) {
                bl = true;
                bNdioBoardArray[n2].configFail("duplicate ioPort: io ports must be unique/type");
            }
            ++n2;
        }
        if (bl) {
            bNdioBoard.configFail("duplicate ioPort: io ports must be unique/type");
            return false;
        }
        return true;
    }

    private final void checkDuplicateBoardCleared(BNdioBoard bNdioBoard, int n) {
        BNdioBoard[] bNdioBoardArray = this.getBoards();
        if (n != 0) {
            BNdioBoard bNdioBoard2;
            ArrayList<BNdioBoard> arrayList = new ArrayList<BNdioBoard>(bNdioBoardArray.length);
            int n2 = 0;
            while (n2 < bNdioBoardArray.length) {
                if (bNdioBoardArray[n2] != bNdioBoard && bNdioBoardArray[n2].getIoPort() == n) {
                    arrayList.add(bNdioBoardArray[n2]);
                }
                ++n2;
            }
            if (arrayList.size() == 1 && this.checkInvalidBoard(bNdioBoard2 = (BNdioBoard)arrayList.get(0), bNdioBoard2.getIoPort())) {
                bNdioBoard2.configOk();
                bNdioBoard2.initDevice();
                if (!bNdioBoard2.isConfigFault()) {
                    try {
                        bNdioBoard2.doPing();
                    }
                    catch (Exception exception) {
                        log.error("deviceChanged: " + exception.getMessage(), (Throwable)exception);
                    }
                }
            }
            arrayList = null;
        }
    }

    public synchronized void doPing() throws Exception {
        block12: {
            if (!Sys.atSteadyState()) {
                return;
            }
            try {
                log.trace("pinging network");
                if (BNdioNetwork.getPlatformService() != null) {
                    if (BNdioNetwork.getPlatformService().isDaemonOk()) {
                        this.pingOk();
                        this.pingState = PING_OK;
                    } else {
                        BNdioNetwork.getPlatformService().reset();
                        if (BNdioNetwork.getPlatformService().isDaemonOk()) {
                            this.pingOk();
                            this.pingState = PING_OK;
                        } else {
                            if (this.hadSuccessfulPing) {
                                this.setRebootConditionMet(true);
                            }
                            this.pingFail("network ping failed because it couldn't find ndio daemon");
                            if (this.pingState != PING_FAILED_DAEMON) {
                                log.error("network ping failed because it couldn't find ndio daemon");
                                this.pingState = PING_FAILED_DAEMON;
                            }
                        }
                    }
                } else {
                    this.pingFail("network ping failed because it couldn't find the platform service");
                    if (this.pingState != PING_FAILED_SERVICE) {
                        log.error("network ping failed because it couldn't find the platform service");
                        this.pingState = PING_FAILED_SERVICE;
                    }
                }
            }
            catch (Exception exception) {
                this.pingFail("network ping failed: " + exception.getMessage());
                if (this.pingState == PING_FAILED_EXCEPTION) break block12;
                log.error("network ping failed: " + exception.getMessage());
                this.pingState = PING_FAILED_EXCEPTION;
            }
        }
    }

    public BOrd doSubmitDiscoveryJob(Context context) {
        return new BNdioBoardDiscoveryJob(this).submit(context);
    }

    public synchronized void startKeepAlive() {
        if (!Sys.atSteadyState()) {
            return;
        }
        if (this.ticket == null && this.getEnabled()) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)NDIOD_KEEP_ALIVE_INTERVAL), (Action)keepAlive, null);
            this.doKeepAlive();
        }
    }

    public synchronized void updateKeepAliveTimeout(long l) {
        if (!this.keepAliveStarted || !this.getEnabled()) {
            return;
        }
        try {
            BNdioNetwork.getPlatformService().setKeepAliveInterval(l);
        }
        catch (Exception exception) {}
        log.trace("Setting ndiod keep alive interval to " + l);
    }

    public synchronized void doKeepAlive() {
        long l;
        if (!this.keepAliveStarted) {
            if (!this.getEnabled()) {
                return;
            }
            this.keepAliveStarted = true;
            l = ((BNdioPingMonitor)this.getMonitor()).getKeepAliveTimeout().getMillis();
            this.updateKeepAliveTimeout(l);
        }
        try {
            log.trace("Sending ndiod keep alive");
            BNdioNetwork.getPlatformService().keepAlive();
            this.setTotalKeepAlives(this.keepAliveCount);
            l = Clock.ticks();
            if (this.startKeepAliveTicks != 0L) {
                ++this.keepAliveCount;
                long l2 = l - this.lastKeepAliveTicks;
                if (l2 > this.keepAlivePeakTicks) {
                    this.keepAlivePeakTicks = l2;
                    this.setKeepAlivePeak(BRelTime.make((long)this.keepAlivePeakTicks));
                }
                if (l2 > 10000L) {
                    this.setTotalKeepAliveLateStarts(this.getTotalKeepAliveLateStarts() + 1L);
                }
                long l3 = (l - this.startKeepAliveTicks) / this.keepAliveCount;
                this.setAverageKeepAliveLifetime(BRelTime.make((long)l3));
                this.recentKeepAliveTicks += l2;
                this.keepAliveDeltas[this.deltaIndex] = l2;
                ++this.deltaIndex;
                if (this.deltaIndex >= 5) {
                    this.deltaIndex = 0;
                }
                if (this.keepAliveCount < (long)5) {
                    l3 = this.recentKeepAliveTicks / this.keepAliveCount;
                } else {
                    l3 = this.recentKeepAliveTicks / (long)5;
                    this.recentKeepAliveTicks -= this.keepAliveDeltas[this.deltaIndex];
                }
                this.setAverageKeepAliveRecent(BRelTime.make((long)l3));
            } else {
                this.startKeepAliveTicks = Clock.ticks();
            }
            this.lastKeepAliveTicks = l;
        }
        catch (Exception exception) {}
    }

    public boolean isKeepAliveStarted() {
        return this.keepAliveStarted;
    }

    public boolean hadSuccessfulPing() {
        return this.hadSuccessfulPing;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        if (platSvc != null) {
            if (platSvc.isDaemonOk()) {
                BNdioBoard[] bNdioBoardArray;
                spyWriter.startProps();
                spyWriter.trTitle((Object)"Ndio Network Extra Properties", 2);
                spyWriter.prop((Object)"daemonOk", (Object)"true");
                spyWriter.prop((Object)"initTicks", (Object)String.valueOf(platSvc.getInitTicks()));
                spyWriter.prop((Object)"heartbeatTicks", (Object)String.valueOf(platSvc.getHeartbeatTicks()));
                spyWriter.endProps();
                BNdioBoardEntry[] bNdioBoardEntryArray = new BNdioBoardEntry[4];
                int n = 0;
                while (n < 8) {
                    try {
                        int n2 = platSvc.readIoType(n);
                        int n3 = platSvc.readIoConfigState(n);
                        if (n2 != 0 && n3 != 0 && n3 != 1) {
                            int n4 = platSvc.readConfigCode(n);
                            bNdioBoardArray = NdioProperties.make(n4);
                            if (bNdioBoardArray.getMultipleProcessors()) {
                                n2 = platSvc.readIoType(n + 1);
                                n3 = platSvc.readIoConfigState(n + 1);
                                if (n2 != 0 && n3 != 0 && n3 != 1) {
                                    bNdioBoardEntryArray[NdioConstants.PROC_TO_IO_PORT[n] - 1] = new BNdioBoardEntry(NdioConstants.PROC_TO_IO_PORT[n]);
                                }
                            } else {
                                bNdioBoardEntryArray[NdioConstants.PROC_TO_IO_PORT[n] - 1] = new BNdioBoardEntry(NdioConstants.PROC_TO_IO_PORT[n]);
                            }
                        }
                    }
                    catch (Exception exception) {}
                    n += 2;
                }
                spyWriter.startTable(true);
                spyWriter.trTitle((Object)"Ndio Boards", 9);
                spyWriter.w((Object)"<tr>");
                spyWriter.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>ioPort</th>");
                spyWriter.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>calibrated</th>");
                spyWriter.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>multiProcessor</th>");
                spyWriter.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>firmwareVersion</th>");
                spyWriter.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>configCode</th>");
                spyWriter.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>uiCount</th>");
                spyWriter.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>boCount</th>");
                spyWriter.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>aoCount</th>");
                spyWriter.w((Object)"<th align='center' nowrap='true' bgcolor='#d0d0d0'>totalCount</th>");
                spyWriter.w((Object)"</tr>");
                n = 0;
                while (n < bNdioBoardEntryArray.length) {
                    if (bNdioBoardEntryArray[n] == null) {
                        spyWriter.w((Object)"<tr>");
                        spyWriter.w((Object)("<td nowrap='true' align='center'><i>board " + (n + 1) + "</i></td>"));
                        spyWriter.w((Object)"<td nowrap='true' colspan='8' align='center'><i>not found</i></td>");
                        spyWriter.w((Object)"</tr>\n");
                    } else {
                        spyWriter.w((Object)"<tr>");
                        Class clazz = class$com$tridium$ndio$BNdioBoard;
                        if (clazz == null) {
                            clazz = BNdioNetwork.class("[Lcom.tridium.ndio.BNdioBoard;", false);
                        }
                        bNdioBoardArray = (BNdioBoard[])this.getChildren(clazz);
                        String string = null;
                        int n5 = -1;
                        int n6 = 0;
                        while (n6 < bNdioBoardArray.length) {
                            if (bNdioBoardArray[n6].getIoPort() == n + 1) {
                                string = bNdioBoardArray[n6].getName();
                                break;
                            }
                            ++n6;
                        }
                        if (string == null) {
                            spyWriter.w((Object)("<td align='center' nowrap='true'><b>board " + (n + 1) + "</b></td>"));
                        } else {
                            spyWriter.w((Object)("<td align='center' nowrap='true'><b><a href='" + string + "'>board " + (n + 1) + "</a></b></td>"));
                        }
                        spyWriter.w((Object)("<td align='center' nowrap='true'>" + (platSvc.isProcessorCalibrated(NdioConstants.IO_PORT_TO_PROC_0[n + 1]) ? "true" : "false") + "</td>"));
                        spyWriter.w((Object)("<td align='center' nowrap='true'>" + (bNdioBoardEntryArray[n].getMultipleProcessors() ? "true" : "false") + "</td>"));
                        spyWriter.w((Object)("<td align='center' nowrap='true'>" + bNdioBoardEntryArray[n].getFirmwareVersion() + "</td>"));
                        spyWriter.w((Object)("<td align='center' nowrap='true'>" + bNdioBoardEntryArray[n].getConfigCode() + "</td>"));
                        spyWriter.w((Object)("<td align='center' nowrap='true'>" + bNdioBoardEntryArray[n].getUiCount() + "</td>"));
                        spyWriter.w((Object)("<td align='center' nowrap='true'>" + bNdioBoardEntryArray[n].getBoCount() + "</td>"));
                        spyWriter.w((Object)("<td align='center' nowrap='true'>" + bNdioBoardEntryArray[n].getAoCount() + "</td>"));
                        n6 = bNdioBoardEntryArray[n].getUiCount() + bNdioBoardEntryArray[n].getBoCount() + bNdioBoardEntryArray[n].getAoCount();
                        spyWriter.w((Object)("<td align='center' nowrap='true'><b>" + n6 + "</b></td>"));
                        spyWriter.w((Object)"</tr>");
                    }
                    ++n;
                }
                spyWriter.endTable();
            } else {
                spyWriter.startProps();
                spyWriter.trTitle((Object)"Ndio Network", 2);
                spyWriter.prop((Object)"daemonOk", (Object)"false");
                spyWriter.endProps();
            }
        }
        super.spy(spyWriter);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "ndio");
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final void serviceStarted() {
    }

    public final void serviceStopped() {
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ticket = null;
        this.keepAliveStarted = false;
        this.lastKeepAliveTicks = 0L;
        this.startKeepAliveTicks = 0L;
        this.recentKeepAliveTicks = 0L;
        this.keepAliveCount = 0L;
        this.lastDeltaKeepAliveTicks = 0L;
        this.keepAliveDeltas = new long[5];
        this.deltaIndex = 0;
        this.keepAlivePeakTicks = 0L;
        this.pingState = PING_OK;
        this.hadSuccessfulPing = false;
    }

    public BNdioNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ndio$BNdioNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$ndio$BNdioNetwork = BNdioNetwork.class("[Lcom.tridium.ndio.BNdioNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        serviceTypes = new Type[]{TYPE};
        log = Log.getLog((String)"ndio");
        platSvc = null;
        NDIOD_KEEP_ALIVE_INTERVAL = 5000;
        NDIOD_KEEP_ALIVE_WINDOW = 30000L;
        PING_OK = 0;
        PING_FAILED_DAEMON = 1;
        PING_FAILED_SERVICE = 2;
        PING_FAILED_EXCEPTION = 3;
    }
}

