/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.pciCards;

import com.tridium.platHwScan.BHardwareScanService;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPciCard
extends BComponent {
    public static final Property description = BPciCard.newProperty((int)1, (String)"", null);
    public static final Property locator = BPciCard.newProperty((int)1, (String)"", null);
    public static final Property sideViewImage = BPciCard.newProperty((int)1, (String)"", null);
    public static final Property topViewImage = BPciCard.newProperty((int)1, (String)"", null);
    public static final Type TYPE;
    private static Hashtable cardCatalog;
    private static String[] cardFiles;
    static /* synthetic */ Class class$com$tridium$platHwScan$pciCards$BPciCard;

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public String getLocator() {
        return this.getString(locator);
    }

    public void setLocator(String string) {
        this.setString(locator, string, null);
    }

    public String getSideViewImage() {
        return this.getString(sideViewImage);
    }

    public void setSideViewImage(String string) {
        this.setString(sideViewImage, string, null);
    }

    public String getTopViewImage() {
        return this.getString(topViewImage);
    }

    public void setTopViewImage(String string) {
        this.setString(topViewImage, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static String[] getCardFiles() {
        return cardFiles;
    }

    protected String getCardKey() {
        return this.getLocator();
    }

    public static void addPciCardReference(BPciCard bPciCard) throws Exception {
        if (!bPciCard.getLocator().equals("")) {
            cardCatalog.put(bPciCard.getLocator(), bPciCard);
        }
    }

    public static void buildCardCatalog() {
        cardCatalog = new Hashtable();
        int n = 0;
        while (n < cardFiles.length) {
            try {
                Hashtable hashtable = BPciCard.parseCardFile(cardFiles[n]);
                if (hashtable != null) {
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (cardCatalog.get(string) != null) {
                            BHardwareScanService.log.warning(BHardwareScanService.lex.getText("PciCard.duplicateLocator", new Object[]{string}));
                        }
                        cardCatalog.put(string, hashtable.get(string));
                    }
                }
            }
            catch (Exception exception) {
                BHardwareScanService.log.error(BHardwareScanService.lex.getText("parsingError", new Object[]{exception.getClass().getName(), cardFiles[n]}));
            }
            ++n;
        }
    }

    public static Hashtable getCardCatalog() {
        if (cardCatalog == null) {
            BPciCard.buildCardCatalog();
        }
        return cardCatalog;
    }

    protected static Hashtable parseCardFile(String string) throws Exception {
        XElem xElem;
        XElem[] xElemArray;
        Object object;
        BHardwareScanService.log.trace(BHardwareScanService.lex.getText("parsingNotification", new Object[]{string}));
        try {
            object = BOrd.make((String)string);
            xElemArray = (XElem[])object.get();
            xElem = XParser.make((InputStream)xElemArray.getInputStream()).parse();
            XParser xParser = XParser.make((InputStream)xElemArray.getInputStream());
            xElem = xParser.parse();
        }
        catch (Exception exception) {
            if (exception instanceof UnresolvedException) {
                BHardwareScanService.log.trace(BHardwareScanService.lex.getText("fileDoesNotExist", new Object[]{string}));
                return null;
            }
            if (exception instanceof EOFException) {
                BHardwareScanService.log.error(BHardwareScanService.lex.getText("unexpectedEof", new Object[]{string}));
                return null;
            }
            throw exception;
        }
        if (!xElem.name().equalsIgnoreCase("pciCards")) {
            BHardwareScanService.log.error(BHardwareScanService.lex.getText("fileFormatError", new Object[]{string, xElem.name(), "pciCards"}));
            return null;
        }
        object = new Hashtable();
        xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            XElem xElem2 = xElemArray[n];
            String string2 = xElem2.name();
            if (string2.equalsIgnoreCase("pciCard")) {
                try {
                    BPciCard bPciCard = new BPciCard();
                    bPciCard.setDescription(BHardwareScanService.lex.getText(xElem2.get("description")));
                    bPciCard.setLocator(xElem2.get("locator"));
                    bPciCard.setSideViewImage(xElem2.get("sideViewImage", new String()));
                    bPciCard.setTopViewImage(xElem2.get("topViewImage", new String()));
                    ((Hashtable)object).put(bPciCard.getLocator(), bPciCard);
                }
                catch (Exception exception) {
                    BHardwareScanService.log.error(BHardwareScanService.lex.getText("parsingError", new Object[]{exception.getClass().getName(), xElem2.toString()}));
                }
            }
            ++n;
        }
        return object;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BPciCard() {
    }

    public BPciCard(String string) {
        this.setDescription(string);
    }

    public BPciCard(String string, String string2) {
        this.setDescription(string);
        this.setLocator(string2);
    }

    static {
        Class clazz = class$com$tridium$platHwScan$pciCards$BPciCard;
        if (clazz == null) {
            clazz = class$com$tridium$platHwScan$pciCards$BPciCard = BPciCard.class("[Lcom.tridium.platHwScan.pciCards.BPciCard;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        cardCatalog = null;
        cardFiles = new String[]{"module://platHwScan/rc/platHwScanPciCards.xml", "file:!lib/platHwScanPciCards.xml"};
    }
}

