/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.optionCards;

import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionModule;
import com.tridium.platHwScan.ports.BPort;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BOptionCard
extends BComponent {
    public static final Property description = BOptionCard.newProperty((int)1, (String)"", null);
    public static final Property optionCodes = BOptionCard.newProperty((int)1, (String)"FF FF", null);
    public static final Property usesCom = BOptionCard.newProperty((int)1, (boolean)false, null);
    public static final Property unknownCardType = BOptionCard.newProperty((int)5, (boolean)true, null);
    public static final Property portCount = BOptionCard.newProperty((int)5, (int)0, null);
    public static final Property connectors = BOptionCard.newProperty((int)5, (int)0, null);
    public static final Property sideViewImage = BOptionCard.newProperty((int)1, (String)"", null);
    public static final Property topViewImage = BOptionCard.newProperty((int)1, (String)"", null);
    public static final Type TYPE;
    private static Hashtable cardCatalog;
    private static String[] cardFiles;
    static /* synthetic */ Class class$com$tridium$platHwScan$optionCards$BOptionCard;
    static /* synthetic */ Class class$com$tridium$platHwScan$ports$BPort;

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public String getOptionCodes() {
        return this.getString(optionCodes);
    }

    public void setOptionCodes(String string) {
        this.setString(optionCodes, string, null);
    }

    public boolean getUsesCom() {
        return this.getBoolean(usesCom);
    }

    public void setUsesCom(boolean bl) {
        this.setBoolean(usesCom, bl, null);
    }

    public boolean getUnknownCardType() {
        return this.getBoolean(unknownCardType);
    }

    public void setUnknownCardType(boolean bl) {
        this.setBoolean(unknownCardType, bl, null);
    }

    public int getPortCount() {
        return this.getInt(portCount);
    }

    public void setPortCount(int n) {
        this.setInt(portCount, n, null);
    }

    public int getConnectors() {
        return this.getInt(connectors);
    }

    public void setConnectors(int n) {
        this.setInt(connectors, n, null);
    }

    public String getSideViewImage() {
        return this.getString(sideViewImage);
    }

    public void setSideViewImage(String string) {
        this.setString(sideViewImage, string, null);
    }

    public String getTopViewImage() {
        return this.getString(topViewImage);
    }

    public void setTopViewImage(String string) {
        this.setString(topViewImage, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static String[] getCardFiles() {
        return cardFiles;
    }

    protected String getCardKey() {
        return this.getOptionCodes();
    }

    public static void addOptionCardReference(BOptionCard bOptionCard) throws Exception {
        if (!bOptionCard.getOptionCodes().equals("")) {
            cardCatalog.put(bOptionCard.getOptionCodes(), bOptionCard);
        }
    }

    public static void buildCardCatalog() {
        cardCatalog = new Hashtable();
        int n = 0;
        while (n < cardFiles.length) {
            try {
                Hashtable hashtable = BOptionCard.parseCardFile(cardFiles[n]);
                if (hashtable != null) {
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (cardCatalog.get(string) != null) {
                            BHardwareScanService.log.warning(BHardwareScanService.lex.getText("OptionCard.duplicateOptCode", new Object[]{string}));
                        }
                        cardCatalog.put(string, hashtable.get(string));
                    }
                }
            }
            catch (Exception exception) {
                BHardwareScanService.log.trace(BHardwareScanService.lex.getText("parsingError", new Object[]{exception.getClass().getName(), cardFiles[n]}));
            }
            ++n;
        }
    }

    public static Hashtable getCardCatalog() {
        if (cardCatalog == null) {
            BOptionCard.buildCardCatalog();
        }
        return cardCatalog;
    }

    public static BOptionCard lookup(String string) {
        Object v;
        if (cardCatalog == null) {
            BOptionCard.buildCardCatalog();
        }
        if ((v = cardCatalog.get(string)) == null) {
            return null;
        }
        return (BOptionCard)((Object)v);
    }

    protected static Hashtable parseCardFile(String string) throws Exception {
        XElem xElem;
        XElem[] xElemArray;
        Object object;
        BHardwareScanService.log.trace(BHardwareScanService.lex.getText("parsingNotification", new Object[]{string}));
        try {
            object = BOrd.make((String)string);
            xElemArray = (XElem[])object.get();
            xElem = XParser.make((InputStream)xElemArray.getInputStream()).parse();
        }
        catch (Exception exception) {
            if (exception instanceof UnresolvedException) {
                BHardwareScanService.log.trace(BHardwareScanService.lex.getText("fileDoesNotExist", new Object[]{string}));
                return null;
            }
            if (exception instanceof EOFException) {
                BHardwareScanService.log.error(BHardwareScanService.lex.getText("unexpectedEof", new Object[]{string}));
                return null;
            }
            throw exception;
        }
        if (!xElem.name().equalsIgnoreCase("optionCards")) {
            BHardwareScanService.log.error(BHardwareScanService.lex.getText("fileFormatError", new Object[]{string, xElem.name(), "optionCards"}));
            return null;
        }
        object = new Hashtable();
        xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            XElem xElem2 = xElemArray[n];
            String string2 = xElem2.name();
            if (string2.equalsIgnoreCase("optionCard") || string2.equalsIgnoreCase("optionModule")) {
                try {
                    BOptionCard bOptionCard = string2.equalsIgnoreCase("optionModule") ? new BOptionModule() : new BOptionCard();
                    bOptionCard.setDescription(BHardwareScanService.lex.getText(xElem2.get("description")));
                    bOptionCard.setOptionCodes(xElem2.get("optionCodes"));
                    bOptionCard.setUsesCom(xElem2.getb("usesCom", false));
                    bOptionCard.setUnknownCardType(false);
                    int n2 = 0;
                    int n3 = 0;
                    XElem[] xElemArray2 = xElem2.elems();
                    int n4 = 0;
                    while (n4 < xElemArray2.length) {
                        XElem xElem3 = xElemArray2[n4];
                        String string3 = xElem3.name();
                        if (string3.equalsIgnoreCase("port")) {
                            BPort bPort = new BPort();
                            bPort.setPortType(BPortTypeEnum.make(xElem3.get("portType", BPortTypeEnum.noPort.getTag())));
                            bPort.setHasConnector(xElem3.get("hasConnector", "true").equalsIgnoreCase("true"));
                            if (bPort.getHasConnector()) {
                                ++n3;
                            }
                            if (!bPort.getPortType().equals((Object)BPortTypeEnum.future) && !bPort.getPortType().equals((Object)BPortTypeEnum.noPort)) {
                                bPort.setRequiredFeatures(xElem3.get("requiredFeatures"));
                                bPort.setPrefix(xElem3.get("prefix"));
                                bPort.setStatus(BHwScanStatusEnum.make(xElem3.get("status", BHwScanStatusEnum.available.getTag())));
                                bOptionCard.setSideViewImage(xElem2.get("sideViewImage", new String()));
                                bOptionCard.setTopViewImage(xElem2.get("topViewImage", new String()));
                                bPort.checkLicense();
                                bPort.add("portIndex", (BValue)BInteger.make((String)xElem3.get("index")), 5);
                                bOptionCard.add("Port" + xElem3.get("index"), (BValue)bPort);
                                ++n2;
                            }
                        }
                        ++n4;
                    }
                    bOptionCard.setPortCount(n2);
                    bOptionCard.setConnectors(n3);
                    ((Hashtable)object).put(bOptionCard.getOptionCodes(), bOptionCard);
                }
                catch (Exception exception) {
                    BHardwareScanService.log.error(BHardwareScanService.lex.getText("parsingError", new Object[]{exception.getClass().getName(), xElem2.toString()}));
                }
            }
            ++n;
        }
        return object;
    }

    public BPort[] getPorts() {
        Class clazz = class$com$tridium$platHwScan$ports$BPort;
        if (clazz == null) {
            clazz = class$com$tridium$platHwScan$ports$BPort = BOptionCard.class("[Lcom.tridium.platHwScan.ports.BPort;", false);
        }
        return (BPort[])this.getChildren(clazz);
    }

    public BPort getPort(int n) {
        BPort[] bPortArray = this.getPorts();
        int n2 = 0;
        while (n2 < bPortArray.length) {
            BValue bValue = bPortArray[n2].get("portIndex");
            if (bValue != null && ((BInteger)bValue).getInt() == n) {
                return bPortArray[n2];
            }
            ++n2;
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BOptionCard() {
    }

    public BOptionCard(String string) {
        this.setDescription(string);
    }

    public BOptionCard(String string, String string2) {
        this.setDescription(string);
        this.setOptionCodes(string2);
    }

    static {
        Class clazz = class$com$tridium$platHwScan$optionCards$BOptionCard;
        if (clazz == null) {
            clazz = class$com$tridium$platHwScan$optionCards$BOptionCard = BOptionCard.class("[Lcom.tridium.platHwScan.optionCards.BOptionCard;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        cardCatalog = null;
        cardFiles = new String[]{"module://platHwScan/rc/platHwScanOptionCards.xml", "file:!lib/platHwScanOptionCards.xml"};
    }
}

