/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv.cache;

import com.tridium.data.BDataTable;
import com.tridium.nv.BNiagaraVirtualPolicies;
import com.tridium.nv.BSlotInfo;
import com.tridium.nv.BSlotType;
import com.tridium.nv.NiagaraVirtualUtil;
import com.tridium.nv.VirtualSlotNameParser;
import com.tridium.nv.cache.BNiagaraVirtualCachePolicy;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.virtual.VirtualPath;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BNiagaraVirtualCache
extends BComponent {
    public static final Action clear = BNiagaraVirtualCache.newAction((int)144, null);
    public static final Action removeFromCache = BNiagaraVirtualCache.newAction((int)4, (BValue)new BComponent(), null);
    public static final Action getStationNames = BNiagaraVirtualCache.newAction((int)4, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$com$tridium$nv$cache$BNiagaraVirtualCache;

    public void clear() {
        this.invoke(clear, null, null);
    }

    public void removeFromCache(BComponent bComponent) {
        this.invoke(removeFromCache, (BValue)bComponent, null);
    }

    public BString getStationNames() {
        return (BString)this.invoke(getStationNames, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BNiagaraVirtualCachePolicy;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == clear) {
            this.getVirtualPolicies().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
            return null;
        }
        return super.post(action, bValue, context);
    }

    protected final BNiagaraVirtualPolicies getVirtualPolicies() {
        return ((BNiagaraVirtualCachePolicy)this.getParent()).getVirtualPolicies();
    }

    public final void doRemoveFromCache(BComponent bComponent) throws Exception {
        BString bString = (BString)bComponent.get("stationName");
        BOrdList bOrdList = (BOrdList)bComponent.get("vOrds");
        if (bString == null || bOrdList == null) {
            throw new Exception("Invalid Remove From Cache Action Call!");
        }
        this.remove(bString.getString(), bOrdList.toArray());
    }

    public final BString doGetStationNames() {
        return BString.make((String)TextUtil.join((String[])this.getVirtualPolicies().getStationNames(), (char)','));
    }

    public static final BITable queryCacheInfo(OrdTarget ordTarget, BString bString) {
        BNiagaraVirtualCache bNiagaraVirtualCache = (BNiagaraVirtualCache)ordTarget.get();
        CachedSlotInfo[] cachedSlotInfoArray = bNiagaraVirtualCache.lookup(bString.getString());
        BDataTable bDataTable = new BDataTable();
        bDataTable.addColumn("path", BString.TYPE, 0, BFacets.NULL);
        BSlotInfo bSlotInfo = new BSlotInfo();
        SlotCursor slotCursor = bSlotInfo.getProperties();
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            bDataTable.addColumn(property.getName(), BString.TYPE, property.getDefaultFlags(), property.getFacets());
        }
        bDataTable.startRows();
        int n = 0;
        while (n < cachedSlotInfoArray.length) {
            bDataTable.startRow();
            bDataTable.set(cachedSlotInfoArray[n].vOrd.toString(), BFacets.NULL);
            SlotCursor slotCursor2 = cachedSlotInfoArray[n].info.getProperties();
            while (slotCursor2.next()) {
                BString bString2 = slotCursor2.property() == BSlotInfo.slotFlags ? BString.make((String)Flags.toDisplayString((int)slotCursor2.getInt(), null)) : BString.make((String)slotCursor2.get().toString());
                bDataTable.set((BIDataValue)bString2, BFacets.NULL);
            }
            bDataTable.endRow();
            ++n;
        }
        return bDataTable;
    }

    public final BSlotInfo lookup(String string, BOrd bOrd) throws Exception {
        BSlotInfo bSlotInfo = this.doLookup(string, bOrd);
        if (bSlotInfo == null) {
            VirtualPath virtualPath = NiagaraVirtualUtil.toVirtualPath(bOrd);
            if (virtualPath == null) {
                throw new Exception("Invalid ORD. Could not decode for Virtual Cache Lookup!");
            }
            String string2 = NiagaraVirtualUtil.getPathNameFromVirtualPath(virtualPath);
            try {
                VirtualSlotNameParser virtualSlotNameParser = VirtualSlotNameParser.make(string2).parse();
                bSlotInfo = new BSlotInfo();
                bSlotInfo.setSlotName(virtualSlotNameParser.getSlotName());
                bSlotInfo.setIsFrozen(virtualSlotNameParser.isFrozen());
                bSlotInfo.setIsComponent(virtualSlotNameParser.isComponent());
                if (!bSlotInfo.getIsComponent()) {
                    bSlotInfo.setIsWritable(virtualSlotNameParser.getFacets().getb("nVirtualW", false));
                }
                bSlotInfo.setSlotType(virtualSlotNameParser.isAction() ? BSlotType.action : BSlotType.property);
                bSlotInfo.setTypeSpec(virtualSlotNameParser.getTypeSpec());
                bSlotInfo.setFacets(virtualSlotNameParser.getFacets());
                bSlotInfo.setSlotFlags(bSlotInfo.getSlotFlags() | virtualSlotNameParser.getFlags());
                bSlotInfo.setReturnTypeSpec(virtualSlotNameParser.getReturnTypeSpec());
            }
            catch (Exception exception) {}
        }
        return bSlotInfo;
    }

    public abstract BSlotInfo doLookup(String var1, BOrd var2) throws Exception;

    protected abstract CachedSlotInfo[] lookup(String var1);

    public abstract void update(String var1, BOrd var2, BSlotInfo var3);

    public abstract void remove(String var1, BOrd[] var2);

    public abstract void doClear() throws Exception;

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$nv$cache$BNiagaraVirtualCache;
        if (clazz == null) {
            clazz = class$com$tridium$nv$cache$BNiagaraVirtualCache = BNiagaraVirtualCache.class("[Lcom.tridium.nv.cache.BNiagaraVirtualCache;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"database.png");
    }

    protected static final class CachedSlotInfo {
        BOrd vOrd;
        BSlotInfo info;

        protected CachedSlotInfo(BOrd bOrd, BSlotInfo bSlotInfo) {
            this.vOrd = bOrd;
            this.info = bSlotInfo;
        }
    }
}

